/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.tcpip;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.util.SystemPropertiesUtil;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.LinkCfgUtil;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

@NiagaraType
@NiagaraProperty(name="settings", type="BTcpIpHostSettings", defaultValue="new BTcpIpHostSettings()", flags=3)
public class BTcpIpPlatformService
extends BPlatformService {
    @Generated
    public static final Property settings = BTcpIpPlatformService.newProperty((int)3, (BValue)new BTcpIpHostSettings(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTcpIpPlatformService.class);
    private static final BIcon icon = BIcon.std((String)"deviceNetwork.png");
    private static final Logger log = Logger.getLogger("platform.tcpip.service");

    @Generated
    public BTcpIpHostSettings getSettings() {
        return (BTcpIpHostSettings)this.get(settings);
    }

    @Generated
    public void setSettings(BTcpIpHostSettings v) {
        this.set(settings, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTcpIpPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("TcpIpPlatformService.description"));
    }

    @Override
    public boolean isValidPlatform() {
        return true;
    }

    @Override
    public int getSlotFlags() {
        return 0;
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        this.refreshProperties();
    }

    protected synchronized void refreshProperties() {
        try {
            XElem hostSettingsElem;
            try {
                hostSettingsElem = AccessController.doPrivileged(() -> {
                    String networkSettingsXml = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getNetworkSettingsXML();
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Loading network settings from XML string:\n" + networkSettingsXml);
                    }
                    return XParser.make((String)networkSettingsXml).parse();
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            if (hostSettingsElem.attrIndex("niagaraUsesIpv6") == -1) {
                String systemProperty = AccessController.doPrivileged(() -> System.getProperty("niagara.ipv6Enabled", "false"));
                hostSettingsElem.addAttr("niagaraUsesIpv6", String.valueOf(systemProperty));
            }
            TcpUtil.updateFields(this.getSettings(), hostSettingsElem);
            if (AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue()) {
                BDaemonSession session = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
                if (session.getHostProperties().supportsServlet("dhcpd")) {
                    BDhcpdHostSettings dhcpdHostSettings = new BDhcpdHostSettings();
                    DhcpdUtil.loadFromSession(dhcpdHostSettings, session);
                    DhcpdUtil.loadDhcpdConfFile(dhcpdHostSettings, session);
                    DhcpdUtil.setReadOnly(dhcpdHostSettings, true);
                    DhcpdUtil.copyDhcpdSlotToAdapters(dhcpdHostSettings, this.getSettings(), true);
                }
                if (session.getHostProperties().supportsServlet("linkcfg")) {
                    BLinkCfgHostSettings linkCfgHostSettings = new BLinkCfgHostSettings();
                    LinkCfgUtil.loadFromSession(linkCfgHostSettings, session);
                    LinkCfgUtil.loadLinkCfgFile(linkCfgHostSettings, session);
                    LinkCfgUtil.setReadOnly(linkCfgHostSettings, true);
                    LinkCfgUtil.copyLinkCfgSlotToHost(linkCfgHostSettings, this.getSettings());
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load network settings", e);
            throw new BajaRuntimeException("Failed to load network settings", (Throwable)e);
        }
        try {
            try {
                AccessController.doPrivileged(() -> {
                    this.getSettings().loadHostFileContents(Files.newInputStream(Paths.get(PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getHostFileName(), new String[0]), new OpenOption[0]));
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getSettings().setHostFileContents("");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load network settings", e);
            throw new BajaRuntimeException("Failed to load network settings (host file)", (Throwable)e);
        }
    }

    @Override
    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(cx);
        this.refreshProperties();
    }

    @Override
    public void doSavePlatformServiceProperties() throws Exception {
        BTcpIpAdapterSettings adapter;
        SlotCursor c;
        boolean allowMultipleOverride;
        if (!this.isRunning()) {
            return;
        }
        if (this.getSettings().getIsReadonly()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        if (this.getSettings().getHostName().length() > 15 && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows)) {
            log.severe("Failed to save network settings, invalid length for host name'" + this.getSettings().getHostName() + "'");
            throw new BajaRuntimeException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.invalidHostName"));
        }
        boolean bl = allowMultipleOverride = PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
        if (!this.getSettings().getAllowMultipleAutoIPv4Adapters() || allowMultipleOverride) {
            int dhcpCount = 0;
            c = this.getSettings().getAdapters().getProperties();
            while (c.next(BTcpIpAdapterSettings.class)) {
                adapter = (BTcpIpAdapterSettings)c.get();
                if (!adapter.getIsAdapterEnabled() || !adapter.getIsDhcpEnabled()) continue;
                ++dhcpCount;
            }
            if (dhcpCount > 1) {
                log.severe("Failed to save network settings, invalid adapter DHCPv4 count '" + dhcpCount + "'");
                throw new BajaRuntimeException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.multipleDhcpAdapters"));
            }
        }
        if (!this.getSettings().getAllowMultipleAutoIPv6Adapters() || allowMultipleOverride) {
            int autoIpv6Count = 0;
            c = this.getSettings().getAdapters().getProperties();
            while (c.next(BTcpIpAdapterSettings.class)) {
                adapter = (BTcpIpAdapterSettings)c.get();
                if (!adapter.getIsAdapterEnabled() || !adapter.getIsIpv6Enabled() || !adapter.getIsIpv6DhcpEnabled()) continue;
                ++autoIpv6Count;
            }
            if (autoIpv6Count > 1) {
                log.severe("Failed to save network settings, invalid adapter IPv6 Auto-configuration count '" + autoIpv6Count + "'");
                throw new BajaRuntimeException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.multipleAutoIPv6Adapters"));
            }
        }
        try {
            AccessController.doPrivileged(() -> {
                String hostFileName = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getHostFileName();
                try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(hostFileName, new String[0]), new OpenOption[0]));){
                    out.write(this.getSettings().getHostFileContents().getBytes(StandardCharsets.UTF_8));
                    out.flush();
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            log.log(Level.SEVERE, "Failed to save network settings", pae.getException());
            throw new BajaRuntimeException("Failed to save network settings", (Throwable)pae.getException());
        }
        catch (AccessControlException ace) {
            log.log(Level.SEVERE, "Failed to save network settings", ace);
            throw new BajaRuntimeException("Failed to save network settings", (Throwable)ace);
        }
        XElem hostSettings = TcpUtil.getHostSettingsXml(this.getSettings());
        XElem adaptersXElem = hostSettings.elem("adapters");
        if (adaptersXElem != null) {
            XElem[] adapterXElems;
            for (XElem adapterXElem : adapterXElems = adaptersXElem.elems("adapter")) {
                if (!adapterXElem.getb("isReadonly", false)) continue;
                adaptersXElem.removeContent((XContent)adaptersXElem);
            }
        }
        ByteBuffer buffer = new ByteBuffer();
        XWriter writer = new XWriter(buffer.getOutputStream());
        hostSettings.write(writer);
        writer.flush();
        writer.close();
        boolean result = AccessController.doPrivileged(() -> SystemPropertiesUtil.setSystemProperty((String)"niagara.ipv6Enabled", (String)String.valueOf(this.getSettings().getNiagaraUsesIpv6())));
        try {
            int rc = AccessController.doPrivileged(() -> PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.setNetworkSettingsXML(new String(buffer.toByteArray(), StandardCharsets.UTF_8)));
            if (!result || rc != 0) {
                throw new Exception("Failed return code, result = '" + result + "', rc = '" + rc + "'");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to save network settings", e);
            throw new BajaRuntimeException("Failed to save network settings", (Throwable)e);
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public boolean hasNavChildren() {
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static final class PlatformProviderHolder {
        private static final IPlatformProvider PLATFORM_PROVIDER_INSTANCE = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);

        private PlatformProviderHolder() {
        }
    }
}

