/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.syslog;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.syslog.BSyslogPlatformService;
import com.tridium.platform.syslog.BSyslogSettings;
import com.tridium.platform.syslog.BSyslogTransportProtocolEnum;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"platform:SyslogPlatformService"})})
public class BSyslogPlatformServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSyslogPlatformServiceSecurityDashboardProviderAgent.class);
    private BSyslogPlatformService syslogPlatformService;
    private SecurityDashboardItemBuilder builder;
    private BDaemonSession daemonSession;
    private static final Logger LOG = Logger.getLogger("platform");
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    private static final String SECTION_HEADER = "securityDashboard.syslogPlatformService.sectionHeader";
    private static final String NO_PLATFORM_DAEMON_SUMMARY = "securityDashboard.systemPlatformService.noPlatformDaemon.summary";
    private static final String NO_PLATFORM_DAEMON_DESCRIPTION = "securityDashboard.systemPlatformService.noPlatformDaemon.description";
    private static final String TLS_ENABLED_SUMMARY = "securityDashboard.syslogPlatformService.transport.tls.summary";
    private static final String TLS_DESCRIPTION = "securityDashboard.syslogPlatformService.transport.tls.description";
    private static final String TCP_ENABLED_SUMMARY = "securityDashboard.syslogPlatformService.transport.tcp.summary";
    private static final String TCP_DESCRIPTION = "securityDashboard.syslogPlatformService.transport.tcp.description";
    private static final String UDP_ENABLED_SUMMARY = "securityDashboard.syslogPlatformService.transport.udp.summary";
    private static final String UDP_DESCRIPTION = "securityDashboard.syslogPlatformService.transport.udp.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.syslogPlatformService = (BSyslogPlatformService)object;
        this.daemonSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public boolean isItemProviderEnabled() {
        block3: {
            if (this.daemonSession == null) {
                return true;
            }
            try {
                this.daemonSession.reloadHostProperties();
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.log(Level.FINE, "Exception occurred reloading syslog dashboard host properties, item states may be stale", exception);
            }
        }
        BHostProperties hostProperties = this.daemonSession.getHostProperties();
        return hostProperties.getSyslogSupported() && hostProperties.getSyslogSettings().getEnabled();
    }

    public String getItemProviderName(Context cx) {
        return this.syslogPlatformService.getDisplayName(cx);
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (this.daemonSession != null) {
            BHostProperties hostProperties = this.daemonSession.getHostProperties();
            items.addAll(this.getSyslogTLSStatus(hostProperties));
        } else {
            items.add(this.builder.makeInfo(NO_PLATFORM_DAEMON_SUMMARY, NO_PLATFORM_DAEMON_DESCRIPTION));
        }
        return Collections.unmodifiableList(items);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.syslogPlatformService.getNavOrd().relativizeToSession();
    }

    private List<SecurityDashboardItem> getSyslogTLSStatus(BHostProperties hostProperties) {
        ArrayList items;
        block7: {
            items = null;
            try {
                if (hostProperties.getSyslogSupported()) {
                    items = new ArrayList();
                    BSyslogSettings syslogSettings = hostProperties.getSyslogSettings();
                    if (syslogSettings.getTransportProtocol() == BSyslogTransportProtocolEnum.tls) {
                        items.add(this.builder.makeOk().withSummary(TLS_ENABLED_SUMMARY, new Object[0]).withDescription(TLS_DESCRIPTION, new Object[0]));
                    } else if (syslogSettings.getTransportProtocol() == BSyslogTransportProtocolEnum.tcp) {
                        items.add(this.builder.makeWarning().withSummary(TCP_ENABLED_SUMMARY, new Object[0]).withDescription(TCP_DESCRIPTION, new Object[0]));
                    } else {
                        items.add(this.builder.makeAlert().withSummary(UDP_ENABLED_SUMMARY, new Object[0]).withDescription(UDP_DESCRIPTION, new Object[0]));
                    }
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Syslog TLS dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }
}

