/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.syslog;

import com.tridium.nre.security.Aes256PasswordEncoderUtil;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.syslog.FaultCauseType;
import com.tridium.nre.syslog.ISyslogStatusListener;
import com.tridium.nre.syslog.SyslogManager;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SyslogStatusMessage;
import com.tridium.platform.syslog.BSyslogFacilityEnum;
import com.tridium.platform.syslog.BSyslogFaultCauseEnum;
import com.tridium.platform.syslog.BSyslogLevelEnum;
import com.tridium.platform.syslog.BSyslogMessageTypeEnum;
import com.tridium.platform.syslog.BSyslogSettings;
import com.tridium.platform.syslog.BSyslogTransportProtocolEnum;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="syslogSettings", type="BSyslogSettings", defaultValue="new BSyslogSettings()", flags=3), @NiagaraProperty(name="stationServerStatus", type="BStatus", defaultValue="BStatus.down", flags=3), @NiagaraProperty(name="stationServerFaultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="queueFullPercentStation", type="int", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="platformServerStatus", type="BStatus", defaultValue="BStatus.down", flags=3), @NiagaraProperty(name="platformServerFaultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="queueFullPercentPlatform", type="int", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="syslogServerConnectionAlarmEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="syslogServerConnectionAlarmSupport", type="BPlatformAlarmSupport", defaultValue="initSyslogServerConnectionAlarmSupport()"), @NiagaraProperty(name="syslogServerConnectionAlarmProxy", type="BPlatformAlarmProxy", defaultValue="new BPlatformAlarmProxy()", flags=6), @NiagaraProperty(name="syslogMessageQueueAlarmEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="syslogMessageQueueAlarmSupport", type="BPlatformAlarmSupport", defaultValue="initSyslogMessageQueueAlarmSupport()"), @NiagaraProperty(name="syslogMessageQueueAlarmProxy", type="BPlatformAlarmProxy", defaultValue="new BPlatformAlarmProxy()", flags=6)})
public final class BSyslogPlatformService
extends BPlatformService
implements BIAlarmablePlatformService,
ISyslogStatusListener {
    @Generated
    public static final Property syslogSettings = BSyslogPlatformService.newProperty((int)3, (BValue)new BSyslogSettings(), null);
    @Generated
    public static final Property stationServerStatus = BSyslogPlatformService.newProperty((int)3, (BValue)BStatus.down, null);
    @Generated
    public static final Property stationServerFaultCause = BSyslogPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property queueFullPercentStation = BSyslogPlatformService.newProperty((int)3, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Property platformServerStatus = BSyslogPlatformService.newProperty((int)3, (BValue)BStatus.down, null);
    @Generated
    public static final Property platformServerFaultCause = BSyslogPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property queueFullPercentPlatform = BSyslogPlatformService.newProperty((int)3, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Property syslogServerConnectionAlarmEnabled = BSyslogPlatformService.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property syslogServerConnectionAlarmSupport = BSyslogPlatformService.newProperty((int)0, (BValue)BSyslogPlatformService.initSyslogServerConnectionAlarmSupport(), null);
    @Generated
    public static final Property syslogServerConnectionAlarmProxy = BSyslogPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    @Generated
    public static final Property syslogMessageQueueAlarmEnabled = BSyslogPlatformService.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property syslogMessageQueueAlarmSupport = BSyslogPlatformService.newProperty((int)0, (BValue)BSyslogPlatformService.initSyslogMessageQueueAlarmSupport(), null);
    @Generated
    public static final Property syslogMessageQueueAlarmProxy = BSyslogPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSyslogPlatformService.class);
    private static final String MSG_TEXT = "msgText";
    private static final BIcon ICON = BIcon.std((String)"log.png");
    private static final Lexicon LEX = Lexicon.make((String)"platform");
    private String faultCauseExceptionDetails = "";
    private static final String UDP_STATUS_LABEL = SlotPath.escape((String)LEX.getText("SyslogPlatformService.serverStatus.nullStatusReason.label"));
    private static final BStatus UDP_NULL_STATUS = BStatus.make((BStatus)BStatus.nullStatus, (String)UDP_STATUS_LABEL, (BIDataValue)BString.make((String)LEX.getText("SyslogPlatformService.serverStatus.nullStatusReason.text")));
    private boolean lastConnectedState = true;
    private boolean lastQueueSizeUpdateCausedAlarm;
    private Timer syslogPlatformTimer;
    private SyslogStatusPlatformTask syslogStatusPlatformTask;
    private static final long SYSLOG_STATUS_PLATFORM_TASK_INTERVAL = 30000L;
    private static boolean startedWarningPrinted;

    @Generated
    public BSyslogSettings getSyslogSettings() {
        return (BSyslogSettings)this.get(syslogSettings);
    }

    @Generated
    public void setSyslogSettings(BSyslogSettings v) {
        this.set(syslogSettings, (BValue)v, null);
    }

    @Generated
    public BStatus getStationServerStatus() {
        return (BStatus)this.get(stationServerStatus);
    }

    @Generated
    public void setStationServerStatus(BStatus v) {
        this.set(stationServerStatus, (BValue)v, null);
    }

    @Generated
    public String getStationServerFaultCause() {
        return this.getString(stationServerFaultCause);
    }

    @Generated
    public void setStationServerFaultCause(String v) {
        this.setString(stationServerFaultCause, v, null);
    }

    @Generated
    public int getQueueFullPercentStation() {
        return this.getInt(queueFullPercentStation);
    }

    @Generated
    public void setQueueFullPercentStation(int v) {
        this.setInt(queueFullPercentStation, v, null);
    }

    @Generated
    public BStatus getPlatformServerStatus() {
        return (BStatus)this.get(platformServerStatus);
    }

    @Generated
    public void setPlatformServerStatus(BStatus v) {
        this.set(platformServerStatus, (BValue)v, null);
    }

    @Generated
    public String getPlatformServerFaultCause() {
        return this.getString(platformServerFaultCause);
    }

    @Generated
    public void setPlatformServerFaultCause(String v) {
        this.setString(platformServerFaultCause, v, null);
    }

    @Generated
    public int getQueueFullPercentPlatform() {
        return this.getInt(queueFullPercentPlatform);
    }

    @Generated
    public void setQueueFullPercentPlatform(int v) {
        this.setInt(queueFullPercentPlatform, v, null);
    }

    @Generated
    public boolean getSyslogServerConnectionAlarmEnabled() {
        return this.getBoolean(syslogServerConnectionAlarmEnabled);
    }

    @Generated
    public void setSyslogServerConnectionAlarmEnabled(boolean v) {
        this.setBoolean(syslogServerConnectionAlarmEnabled, v, null);
    }

    @Generated
    public BPlatformAlarmSupport getSyslogServerConnectionAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(syslogServerConnectionAlarmSupport);
    }

    @Generated
    public void setSyslogServerConnectionAlarmSupport(BPlatformAlarmSupport v) {
        this.set(syslogServerConnectionAlarmSupport, (BValue)v, null);
    }

    @Generated
    public BPlatformAlarmProxy getSyslogServerConnectionAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(syslogServerConnectionAlarmProxy);
    }

    @Generated
    public void setSyslogServerConnectionAlarmProxy(BPlatformAlarmProxy v) {
        this.set(syslogServerConnectionAlarmProxy, (BValue)v, null);
    }

    @Generated
    public boolean getSyslogMessageQueueAlarmEnabled() {
        return this.getBoolean(syslogMessageQueueAlarmEnabled);
    }

    @Generated
    public void setSyslogMessageQueueAlarmEnabled(boolean v) {
        this.setBoolean(syslogMessageQueueAlarmEnabled, v, null);
    }

    @Generated
    public BPlatformAlarmSupport getSyslogMessageQueueAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(syslogMessageQueueAlarmSupport);
    }

    @Generated
    public void setSyslogMessageQueueAlarmSupport(BPlatformAlarmSupport v) {
        this.set(syslogMessageQueueAlarmSupport, (BValue)v, null);
    }

    @Generated
    public BPlatformAlarmProxy getSyslogMessageQueueAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(syslogMessageQueueAlarmProxy);
    }

    @Generated
    public void setSyslogMessageQueueAlarmProxy(BPlatformAlarmProxy v) {
        this.set(syslogMessageQueueAlarmProxy, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSyslogPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("SyslogPlatformService.description"));
    }

    public BIcon getIcon() {
        return ICON;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public boolean isValidPlatform() {
        return true;
    }

    @Override
    public String getLicenseFeature() {
        return null;
    }

    @Override
    public int getSlotFlags() {
        return 0;
    }

    @Override
    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.reloadSyslogSettingProperties();
        SyslogManager.getInstance().addSyslogStatusListener((ISyslogStatusListener)this);
        this.getSyslogServerConnectionAlarmProxy().setAlarmSupport(this.getSyslogServerConnectionAlarmSupport());
        this.getSyslogMessageQueueAlarmProxy().setAlarmSupport(this.getSyslogMessageQueueAlarmSupport());
        if (AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue()) {
            this.syslogPlatformTimer = new Timer();
            this.syslogStatusPlatformTask = new SyslogStatusPlatformTask(this);
            this.syslogPlatformTimer.scheduleAtFixedRate((TimerTask)this.syslogStatusPlatformTask, 0L, 30000L);
        } else if (!startedWarningPrinted) {
            SyslogManager.LOG.warning("Local daemon session not available, skipping niagara daemon syslog monitor initialization");
            startedWarningPrinted = true;
        }
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        this.reloadSyslogSettingProperties();
    }

    @Override
    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(cx);
        this.reloadSyslogSettingProperties();
    }

    @Override
    protected boolean startPollTimerOnSubscribe() {
        return true;
    }

    @Override
    public BRelTime getPollFrequency() {
        return BRelTime.makeSeconds((int)5);
    }

    @Override
    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        this.saveSyslogSettingProperties();
    }

    private synchronized void saveSyslogSettingProperties() throws Exception {
        BSyslogSettings syslogSettings = this.getSyslogSettings();
        AccessController.doPrivileged(() -> {
            String encodedClientPassword = null;
            try (SecretChars password = syslogSettings.getClientAliasAndPassword().getPassword().isDefault() ? null : syslogSettings.getClientAliasAndPassword().getPassword().getSecretChars();){
                KeyRing keyRing = SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing();
                if (password != null) {
                    encodedClientPassword = Aes256PasswordEncoderUtil.encodePassword((KeyRing)keyRing, (String)"com.tridium.syslog.clientPassword", (SecretChars)password);
                }
            }
            SyslogManager.getInstance().writeSyslogConfig(String.valueOf(syslogSettings.getEnabled()), syslogSettings.getServerHost(), String.valueOf(syslogSettings.getServerPort()), syslogSettings.getMessageType().getTag(), syslogSettings.getTransportProtocol().getTag(), syslogSettings.getClientAliasAndPassword().getAlias(), encodedClientPassword, String.valueOf(syslogSettings.getPlatformLogEnabled()), String.valueOf(syslogSettings.getStationLogEnabled()), syslogSettings.getLogLevelFilter().getTag().toUpperCase(Locale.ENGLISH), String.valueOf(syslogSettings.getStationAuditEnabled()), String.valueOf(syslogSettings.getSecurityAuditEnabled()), syslogSettings.getFacility().getTag(), String.valueOf(syslogSettings.getQueueSize()));
            return null;
        });
    }

    private synchronized void reloadSyslogSettingProperties() {
        try {
            AccessController.doPrivileged(() -> {
                BSyslogSettings syslogSettings = this.getSyslogSettings();
                SyslogManager syslogManager = SyslogManager.getInstance();
                syslogSettings.setIsReadonly(syslogManager.getIsReadonly());
                syslogSettings.setEnabled(syslogManager.getEnabled());
                syslogSettings.setServerHost(syslogManager.getServerHost());
                syslogSettings.setServerPort(syslogManager.getServerPort());
                syslogSettings.setMessageType(BSyslogMessageTypeEnum.make(syslogManager.getMessageType().name()));
                syslogSettings.setTransportProtocol(BSyslogTransportProtocolEnum.make(syslogManager.getTransportProtocol().name()));
                syslogSettings.getClientAliasAndPassword().setAlias(syslogManager.getClientAlias());
                if (syslogManager.getClientPassword() == null) {
                    syslogSettings.getClientAliasAndPassword().setPassword(BPassword.DEFAULT);
                } else {
                    KeyRing keyRing = SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing();
                    try (SecretChars passwordChars = Aes256PasswordEncoderUtil.decodePassword((KeyRing)keyRing, (String)"com.tridium.syslog.clientPassword", (String)syslogManager.getClientPassword());){
                        syslogSettings.getClientAliasAndPassword().setPassword(BPassword.make((char[])passwordChars.get()));
                    }
                    catch (Exception e) {
                        SyslogManager.LOG.log(Level.WARNING, "Error decoding client password", e);
                        syslogSettings.getClientAliasAndPassword().setPassword(BPassword.DEFAULT);
                    }
                }
                syslogSettings.setPlatformLogEnabled(syslogManager.getPlatformLogEnabled());
                syslogSettings.setStationLogEnabled(syslogManager.getStationLogEnabled());
                syslogSettings.setLogLevelFilter(BSyslogLevelEnum.make(syslogManager.getLogLevelFilter().getName().toLowerCase(Locale.ENGLISH)));
                syslogSettings.setStationAuditEnabled(syslogManager.getStationAuditEnabled());
                syslogSettings.setSecurityAuditEnabled(syslogManager.getSecurityAuditEnabled());
                syslogSettings.setFacility(BSyslogFacilityEnum.make(syslogManager.getFacility().name()));
                syslogSettings.setQueueSize(syslogManager.getQueueSize());
                this.setStationServerStatus(this.getStationSyslogServerStatus());
                this.setStationServerFaultCause(this.getFormattedFaultCause(syslogManager.getSyslogServerFaultCause()));
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            SyslogManager.LOG.log(Level.WARNING, "Error reloading properties", e);
        }
    }

    @Override
    public void serviceStopped() throws Exception {
        super.serviceStopped();
        if (this.syslogStatusPlatformTask != null) {
            this.syslogStatusPlatformTask.cancel();
            this.syslogStatusPlatformTask = null;
        }
        if (this.syslogPlatformTimer != null) {
            this.syslogPlatformTimer.cancel();
            this.syslogPlatformTimer = null;
        }
        SyslogManager.getInstance().removeSyslogStatusListener((ISyslogStatusListener)this);
    }

    @Override
    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getSyslogServerConnectionAlarmProxy().addPlatformServiceAlarmListener(listener);
        this.getSyslogMessageQueueAlarmProxy().addPlatformServiceAlarmListener(listener);
    }

    @Override
    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getSyslogServerConnectionAlarmProxy().removePlatformServiceAlarmListener(listener);
        this.getSyslogMessageQueueAlarmProxy().removePlatformServiceAlarmListener(listener);
    }

    @Override
    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord alarm) {
        throw new IllegalStateException();
    }

    @Override
    public BBoolean ackAlarm(BPlatformServiceAlarmRecord record) {
        throw new IllegalStateException();
    }

    public void onSyslogServerConnectionStatusChanged(boolean isConnected, String details) {
        if (SyslogManager.LOG.isLoggable(Level.FINE)) {
            SyslogManager.LOG.fine("Server Connection Status Changed: " + isConnected + ", " + details);
        }
        this.faultCauseExceptionDetails = details;
        this.setStationServerStatus(this.getStationSyslogServerStatus());
        if (!SyslogManager.getInstance().getEnabled()) {
            return;
        }
        this.checkServerStatusAndTriggerAlarm("station", isConnected);
    }

    public void onSyslogMessageQueueChanged(int queueFullPercentage) {
        if (SyslogManager.LOG.isLoggable(Level.FINE)) {
            SyslogManager.LOG.fine("Message Queue Changed: " + queueFullPercentage);
        }
        this.setQueueFullPercentStation(queueFullPercentage);
        if (!SyslogManager.getInstance().getEnabled()) {
            return;
        }
        this.checkQueueSizeAndTriggerAlarm("station", queueFullPercentage);
    }

    private static BPlatformAlarmSupport initSyslogServerConnectionAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setSourceName(BFormat.make((String)"%parent.displayName%"));
        pas.setToOffnormalText(BFormat.make((String)"%lexicon(platform:syslogServerConnectionFailure)%"));
        pas.setToNormalText(BFormat.make((String)"%lexicon(platform:syslogServerConnectionSuccessful)%"));
        pas.setFlags((Slot)BPlatformAlarmSupport.toOffnormalText, 4);
        pas.setFlags((Slot)BPlatformAlarmSupport.toFaultText, 4);
        pas.setFlags((Slot)BPlatformAlarmSupport.toNormalText, 4);
        return pas;
    }

    private static BPlatformAlarmSupport initSyslogMessageQueueAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setSourceName(BFormat.make((String)"%parent.displayName%"));
        pas.setToOffnormalText(BFormat.make((String)"%lexicon(platform:syslogMessageQueueOverflow)%"));
        pas.setToNormalText(BFormat.make((String)"%lexicon(platform:syslogMessageQueueNormal)%"));
        pas.setFlags((Slot)BPlatformAlarmSupport.toOffnormalText, 4);
        pas.setFlags((Slot)BPlatformAlarmSupport.toFaultText, 4);
        pas.setFlags((Slot)BPlatformAlarmSupport.toNormalText, 4);
        return pas;
    }

    public BStatus getStationSyslogServerStatus() {
        SyslogManager syslogManager = SyslogManager.getInstance();
        if (syslogManager.isStationSyslogDisabled()) {
            return BStatus.disabled;
        }
        if (BSyslogTransportProtocolEnum.udp.equals((Object)this.getSyslogSettings().getTransportProtocol())) {
            if (SyslogManager.LOG.isLoggable(Level.FINE)) {
                SyslogManager.LOG.fine("Station syslog server status not available for UDP");
            }
            return UDP_NULL_STATUS;
        }
        return syslogManager.isSyslogServerConnected() ? BStatus.ok : BStatus.down;
    }

    public void checkPlatformStatus() {
        BDaemonSession daemonSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
        if (daemonSession != null) {
            try {
                XElem syslogElem = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new SyslogStatusMessage(), "text/xml")).parse();
                int queueFullPercentage = syslogElem.geti("queueFullPercentage", 0);
                boolean syslogDisabled = syslogElem.getb("platformSyslogDisabled");
                boolean syslogServerConnected = syslogElem.getb("platformSyslogServerConnected");
                FaultCauseType serverFaultCause = FaultCauseType.valueOf((String)syslogElem.get("platformSyslogServerFaultCause", ""));
                this.setQueueFullPercentPlatform(queueFullPercentage);
                this.setPlatformServerStatus(this.getPlatformSyslogServerStatus(syslogDisabled, syslogServerConnected));
                this.setPlatformServerFaultCause(this.getFormattedFaultCause(serverFaultCause));
                if (syslogDisabled) {
                    return;
                }
                this.checkQueueSizeAndTriggerAlarm("platform", queueFullPercentage);
                this.checkServerStatusAndTriggerAlarm("platform", syslogServerConnected);
            }
            catch (Exception e) {
                SyslogManager.LOG.log(Level.WARNING, "Failed to check Niagara Daemon Syslog status: " + e);
            }
        }
    }

    private String getFormattedFaultCause(FaultCauseType faultCauseType) {
        String faultCause = BSyslogFaultCauseEnum.getFaultCauseType(faultCauseType).getDisplayTag(null);
        if (faultCauseType == FaultCauseType.disconnected && this.faultCauseExceptionDetails != null) {
            faultCause = String.format("%s: %s", faultCause != null ? faultCause : "", this.faultCauseExceptionDetails);
        }
        return faultCause;
    }

    public BStatus getPlatformSyslogServerStatus(boolean syslogServerDisabled, boolean syslogServerConnected) {
        if (syslogServerDisabled) {
            return BStatus.disabled;
        }
        if (BSyslogTransportProtocolEnum.udp.equals((Object)this.getSyslogSettings().getTransportProtocol())) {
            if (SyslogManager.LOG.isLoggable(Level.FINE)) {
                SyslogManager.LOG.fine("Platform server status not available for UDP");
            }
            return UDP_NULL_STATUS;
        }
        return syslogServerConnected ? BStatus.ok : BStatus.down;
    }

    private void checkServerStatusAndTriggerAlarm(String environmentTag, boolean isConnected) {
        if (!this.getSyslogServerConnectionAlarmEnabled()) {
            return;
        }
        if (Sys.isStation() && !Sys.isStationStarted()) {
            if (SyslogManager.LOG.isLoggable(Level.FINE)) {
                SyslogManager.LOG.fine(environmentTag + ": Station not started, deferring connection status alarm check");
            }
            return;
        }
        if (isConnected != this.lastConnectedState) {
            this.lastConnectedState = isConnected;
            try {
                BPlatformServiceAlarmRecord alarm = !isConnected ? this.getSyslogServerConnectionAlarmSupport().makeNewOffnormalAlarm(BFacets.make((String)MSG_TEXT, (String)(environmentTag + ": " + LEX.getText("syslogServerConnectionFailure")))) : this.getSyslogServerConnectionAlarmSupport().makeToNormal(BFacets.make((String)MSG_TEXT, (String)(environmentTag + ": " + LEX.getText("syslogServerConnectionSuccessful"))));
                if (alarm != null) {
                    this.getSyslogServerConnectionAlarmProxy().firePlatformServiceAlarmEvent(alarm);
                }
            }
            catch (NotRunningException e) {
                SyslogManager.LOG.warning(environmentTag + ": Alarm Service is not running, delaying connection status alarm generation");
            }
        }
    }

    private void checkQueueSizeAndTriggerAlarm(String environmentTag, int queueFullPercentage) {
        if (!this.getSyslogMessageQueueAlarmEnabled()) {
            return;
        }
        if (Sys.isStation() && !Sys.isStationStarted()) {
            if (SyslogManager.LOG.isLoggable(Level.FINE)) {
                SyslogManager.LOG.fine(environmentTag + ": Station not started, deferring queue size alarm check");
            }
            return;
        }
        try {
            BPlatformServiceAlarmRecord alarm;
            if (queueFullPercentage >= 90) {
                BPlatformServiceAlarmRecord alarm2;
                if (!this.lastQueueSizeUpdateCausedAlarm && (alarm2 = this.getSyslogMessageQueueAlarmSupport().makeNewOffnormalAlarm(BFacets.make((String)MSG_TEXT, (String)(environmentTag + ": " + LEX.getText("syslogMessageQueueOverflow", new Object[]{queueFullPercentage}))))) != null) {
                    this.lastQueueSizeUpdateCausedAlarm = true;
                    this.getSyslogMessageQueueAlarmProxy().firePlatformServiceAlarmEvent(alarm2);
                }
            } else if (this.lastQueueSizeUpdateCausedAlarm && (alarm = this.getSyslogMessageQueueAlarmSupport().makeToNormal(BFacets.make((String)MSG_TEXT, (String)(environmentTag + ": " + LEX.getText("syslogMessageQueueNormal"))))) != null) {
                this.lastQueueSizeUpdateCausedAlarm = false;
                this.getSyslogMessageQueueAlarmProxy().firePlatformServiceAlarmEvent(alarm);
            }
        }
        catch (NotRunningException e) {
            SyslogManager.LOG.warning(environmentTag + ": Alarm Service is not running, delaying queue size alarm generation");
        }
    }

    private static class SyslogStatusPlatformTask
    extends TimerTask {
        private final BSyslogPlatformService syslogPlatformService;

        public SyslogStatusPlatformTask(BSyslogPlatformService syslogPlatformService) {
            this.syslogPlatformService = syslogPlatformService;
        }

        @Override
        public void run() {
            this.syslogPlatformService.checkPlatformStatus();
        }
    }
}

