/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.qnx;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServerVector;
import com.tridium.platform.posix.BNtpHostMode;
import com.tridium.platform.posix.NtpConfUtil;
import com.tridium.platform.qnx.BNtpServerQnx;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.sys.station.Station;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.file.BajaFileUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timeServers", type="BNtpServerVector", defaultValue="new BNtpServerVector()", flags=3, facets={@Facet(value="BFacets.make(BNtpServerVector.ELEMENT_TYPE_FACET, \"platform:NtpServerQnx\")")}, override=true), @NiagaraProperty(name="statistics", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="ntp", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="localBackup", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="panic", type="int", defaultValue="0", flags=7), @NiagaraProperty(name="syncAtBoot", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="hostMode", type="BNtpHostMode", defaultValue="BNtpHostMode.server", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="syncRTC", returnType="BInteger", flags=4), @NiagaraAction(name="syncNow", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BInteger")})
public final class BNtpPlatformServiceQnx
extends BNtpPlatformService {
    @Generated
    public static final Property timeServers = BNtpPlatformServiceQnx.newProperty((int)3, (BValue)new BNtpServerVector(), (BFacets)BFacets.make((String)"elementType", (String)"platform:NtpServerQnx"));
    @Generated
    public static final Property statistics = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property ntp = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)true, null);
    @Generated
    public static final Property localBackup = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)true, null);
    @Generated
    public static final Property panic = BNtpPlatformServiceQnx.newProperty((int)7, (int)0, null);
    @Generated
    public static final Property syncAtBoot = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property hostMode = BNtpPlatformServiceQnx.newProperty((int)3, (BValue)BNtpHostMode.server, null);
    @Generated
    public static final Action syncRTC = BNtpPlatformServiceQnx.newAction((int)4, null);
    @Generated
    public static final Action syncNow = BNtpPlatformServiceQnx.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNtpPlatformServiceQnx.class);
    public static final String NTP_CONF_PATH = Sys.getNiagaraUserHome() + "/etc/ntp.conf";
    public static final String NTP_DRIFT_PATH = "/var/run/ntp.drift";
    public static final String NTP_STATS_PATH = "/var/run/ntpdstats";
    public static final String PERSISTENT_NTP_DRIFT_PATH = "/var/cookies/ntp.drift";
    private final NtpServiceSaveListener saveListener = new NtpServiceSaveListener();

    @Generated
    public boolean getStatistics() {
        return this.getBoolean(statistics);
    }

    @Generated
    public void setStatistics(boolean v) {
        this.setBoolean(statistics, v, null);
    }

    @Generated
    public boolean getNtp() {
        return this.getBoolean(ntp);
    }

    @Generated
    public void setNtp(boolean v) {
        this.setBoolean(ntp, v, null);
    }

    @Generated
    public boolean getLocalBackup() {
        return this.getBoolean(localBackup);
    }

    @Generated
    public void setLocalBackup(boolean v) {
        this.setBoolean(localBackup, v, null);
    }

    @Generated
    public int getPanic() {
        return this.getInt(panic);
    }

    @Generated
    public void setPanic(int v) {
        this.setInt(panic, v, null);
    }

    @Generated
    public boolean getSyncAtBoot() {
        return this.getBoolean(syncAtBoot);
    }

    @Generated
    public void setSyncAtBoot(boolean v) {
        this.setBoolean(syncAtBoot, v, null);
    }

    @Generated
    public BNtpHostMode getHostMode() {
        return (BNtpHostMode)this.get(hostMode);
    }

    @Generated
    public void setHostMode(BNtpHostMode v) {
        this.set(hostMode, (BValue)v, null);
    }

    @Generated
    public BInteger syncRTC() {
        return (BInteger)this.invoke(syncRTC, null, null);
    }

    @Generated
    public BInteger syncNow(BString parameter) {
        return (BInteger)this.invoke(syncNow, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void stationStarted() throws Exception {
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        if (this.isServiceStarted()) {
            Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeHours((int)6), (Action)syncRTC, null);
        }
    }

    @Override
    public final void serviceStopped() throws Exception {
        super.serviceStopped();
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
    }

    @Override
    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    @Override
    public int getSlotFlags() {
        return 0;
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        this.refreshProperties();
    }

    @Override
    public void doPoll(Context cx) {
        super.doPoll(cx);
        if (!this.isRunning()) {
            return;
        }
        this.checkPropertiesLoaded();
    }

    private synchronized void refreshProperties() {
        NtpConfUtil.loadFromFile(this, LOG);
    }

    @Override
    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        NtpConfUtil.saveToFile(this, LOG);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        NtpConfUtil.spyHelper(this, this.getStatistics(), out, LOG);
    }

    public BInteger doSyncNow(BString defaultServer) {
        String targetServer;
        String preferredServer = null;
        String firstServerOrPeer = null;
        if (defaultServer != null && defaultServer.toString().trim().length() > 0) {
            targetServer = defaultServer.toString().trim();
        } else {
            SlotCursor c = this.getTimeServers().getProperties();
            while (c.next()) {
                if (!((BNtpServerQnx)c.get()).getServerPreferred()) continue;
                preferredServer = ((BNtpServerQnx)c.get()).getAddress().trim();
                break;
            }
            if (preferredServer == null) {
                c = this.getTimeServers().getProperties();
                while (c.next()) {
                    if (((BNtpServerQnx)c.get()).getPeerMode().getOrdinal() != 2 && ((BNtpServerQnx)c.get()).getPeerMode().getOrdinal() != 1) continue;
                    firstServerOrPeer = ((BNtpServerQnx)c.get()).getAddress().trim();
                    break;
                }
            }
            if (preferredServer != null) {
                targetServer = preferredServer;
            } else if (firstServerOrPeer != null) {
                targetServer = firstServerOrPeer;
            } else {
                return BInteger.make((int)1);
            }
        }
        if (!IPAddressUtil.isNumericAddr((String)targetServer) && !IPAddressUtil.isHostname((String)targetServer)) {
            throw new LocalizableRuntimeException("platform", "NtpServerFE.invalidHost", new Object[]{targetServer});
        }
        DoSyncThread doSyncThread = new DoSyncThread();
        DoSyncThread.targetServer = targetServer;
        doSyncThread.setDaemon(true);
        doSyncThread.start();
        return BInteger.make((int)0);
    }

    public BInteger doSyncRTC() {
        if (this.getEnabled()) {
            try {
                BSystemPlatformServiceQnx service = (BSystemPlatformServiceQnx)Sys.getService((Type)BSystemPlatformService.TYPE);
                if (!service.getIsSystemTimeReadonly()) {
                    service.setPlatformSystemTime(0L);
                }
            }
            catch (ServiceNotFoundException e) {
                LOG.log(Level.WARNING, "Exception occurred during NTP Platform Service QNX sync RTC action", e);
                return BInteger.make((int)-1);
            }
        }
        return BInteger.make((int)0);
    }

    private final class NtpServiceSaveListener
    implements Station.SaveListener {
        private NtpServiceSaveListener() {
        }

        public void stationSave() {
            AccessController.doPrivileged(() -> {
                try {
                    File etcNtpDrift = new File(BNtpPlatformServiceQnx.PERSISTENT_NTP_DRIFT_PATH);
                    File ntpDriftTEMP = new File("/var/run/ntp.drift.TEMP");
                    File ntpDrift = new File(BNtpPlatformServiceQnx.NTP_DRIFT_PATH);
                    if (etcNtpDrift.exists()) {
                        BajaFileUtil.delete((File)etcNtpDrift);
                    }
                    if (ntpDriftTEMP.exists()) {
                        BajaFileUtil.copy((File)ntpDriftTEMP, (File)etcNtpDrift);
                    } else if (ntpDrift.exists()) {
                        BajaFileUtil.copy((File)ntpDrift, (File)etcNtpDrift);
                    }
                    BNtpPlatformServiceQnx.this.syncRTC();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception occurred during NTP Platform Service QNX save listener", e);
                }
                return null;
            });
        }

        public void stationSaveOk() {
        }

        public void stationSaveFail(String cause) {
        }

        public String toString() {
            return "NtpServiceSaveListener " + BNtpPlatformServiceQnx.this.getNavOrd();
        }
    }

    private static class DoSyncThread
    extends Thread {
        private static String targetServer;

        private DoSyncThread() {
            super("NtpPlatformService:DoSyncThread");
        }

        @Override
        public void run() {
            if (!IPAddressUtil.isNumericAddr((String)targetServer) && !IPAddressUtil.isHostname((String)targetServer)) {
                throw new LocalizableRuntimeException("platform", "NtpServerFE.invalidHost", new Object[]{targetServer});
            }
            AccessController.doPrivileged(() -> {
                try {
                    new ProcessBuilder("/proc/boot/ntpdate", "-u", "-s", targetServer).start();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Exception occurred during NTP Platform Service QNX sync now action", e);
                }
                return null;
            });
        }
    }
}

