/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.npsdk;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platform.BPlatform;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.logging.Level;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public class NpsdkCmdPage
extends SpyDir {
    private final String name;
    private final String cmd;
    private final int index;

    NpsdkCmdPage(String name, String cmd, int index) {
        this.name = name;
        this.cmd = cmd;
        this.index = index;
    }

    public void write(SpyWriter out) throws Exception {
        try {
            AccessController.doPrivileged(() -> {
                if (this.cmd.equalsIgnoreCase("jmxinfo")) {
                    NpsdkCmdPage.dumpJmxInfo(out);
                } else {
                    String commandOutput = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.executeNativeDiagnosticsCommand(this.index);
                    if (commandOutput == null) {
                        commandOutput = "(Error launching command)";
                    } else if (commandOutput.trim().isEmpty()) {
                        commandOutput = "(Command output empty)";
                    }
                    try (BufferedReader br = new BufferedReader(new StringReader(commandOutput));){
                        out.startTable(false);
                        out.trTitle((Object)this.name, 1);
                        out.endTable();
                        out.w((Object)"<pre>\n");
                        String line = br.readLine();
                        while (line != null) {
                            out.safe((Object)NpsdkCmdPage.convertBogusChars(line)).w((Object)"\n");
                            line = br.readLine();
                        }
                        out.w((Object)"</pre>\n");
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            BPlatform.log.log(Level.SEVERE, "Error launching diagnostic command", e);
        }
    }

    public String getCommand() {
        return this.cmd;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    private static void dumpJmxInfo(SpyWriter out) {
        out.startTable(false);
        out.trTitle((Object)"JMX Thread Info", 1);
        out.endTable();
        out.w((Object)"<pre>\n");
        out.write("\nJMX Thread Info\n");
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        out.write("\tpeak thread count    " + threadBean.getPeakThreadCount() + "\n");
        out.write("\tcurrent thread count " + threadBean.getThreadCount() + "\n");
        out.write("\ttotal started count  " + threadBean.getTotalStartedThreadCount() + "\n");
        out.write("\nJMX Class Loading Info\n");
        ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
        out.write("\tloaded class  " + classLoadingBean.getLoadedClassCount() + "\n");
        out.write("\ttotal loaded  " + classLoadingBean.getTotalLoadedClassCount() + "\n");
        out.write("\tunloaded      " + classLoadingBean.getUnloadedClassCount() + "\n");
        out.write("\nJMX Memory Pool Info\n\n");
        List<MemoryPoolMXBean> poolList = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean pool : poolList) {
            MemoryUsage currentUsage = pool.getUsage();
            MemoryUsage peakUsage = pool.getPeakUsage();
            out.write(pool.getName() + "\n");
            out.write("\tcurrent " + currentUsage + "\n");
            out.write("\tpeak    " + peakUsage + "\n\n");
        }
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory() / 1024L;
        long max = runtime.maxMemory() / 1024L;
        long free = runtime.freeMemory() / 1024L;
        long used = total - free;
        out.write("\nHeap Information\n\n");
        out.write("\ttotal memory " + total + "K\n");
        out.write("\tmax memory   " + max + "K\n");
        out.write("\tused memory  " + used + "K\n");
        out.write("\tfree memory  " + free + "K\n");
        out.w((Object)"</pre>\n");
        out.flush();
    }

    private static String convertBogusChars(String src) {
        char[] characters;
        StringBuilder builder = new StringBuilder();
        for (char character : characters = src.toCharArray()) {
            if (character == '\t') {
                builder.append("        ");
                continue;
            }
            if (character == '\u0000') continue;
            builder.append(character);
        }
        return builder.toString();
    }

    private static final class PlatformProviderHolder {
        private static final IPlatformProvider PLATFORM_PROVIDER_INSTANCE = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);

        private PlatformProviderHolder() {
        }
    }
}

