/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.npsdk;

import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServerVector;
import com.tridium.platform.posix.BNtpHostMode;
import com.tridium.platform.posix.NtpConfUtil;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timeServers", type="BNtpServerVector", defaultValue="new BNtpServerVector()", flags=3, facets={@Facet(value="BFacets.make(BNtpServerVector.ELEMENT_TYPE_FACET, \"platform:NtpServerNpsdk\")")}, override=true), @NiagaraProperty(name="statistics", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="ntp", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="localBackup", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="panic", type="int", defaultValue="1000", flags=7), @NiagaraProperty(name="syncAtBoot", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="hostMode", type="BNtpHostMode", defaultValue="BNtpHostMode.server", flags=3)})
public final class BNtpPlatformServiceNpsdk
extends BNtpPlatformService {
    @Generated
    public static final Property timeServers;
    @Generated
    public static final Property statistics;
    @Generated
    public static final Property ntp;
    @Generated
    public static final Property localBackup;
    @Generated
    public static final Property panic;
    @Generated
    public static final Property syncAtBoot;
    @Generated
    public static final Property hostMode;
    @Generated
    public static final Type TYPE;
    public static final String NTP_CONF_PATH;
    public static final String NTP_DRIFT_PATH;
    public static final String NTP_STATS_PATH;
    private static final String NTP_CONF_PATH_PROPERTY = "niagara.platNtp.configurationFilePath";
    private static final String NTP_DRIFT_PATH_PROPERTY = "niagara.platNtp.driftFilePath";
    private static final String NTP_STATS_PATH_PROPERTY = "niagara.platNtp.statisticsDirectoryPath";
    private static final String NTP_CONF_PATH_DEFAULT;
    private static final String NTP_DRIFT_PATH_DEFAULT = "/var/lib/ntp/drift";
    private static final String NTP_STATS_PATH_DEFAULT = "/var/log/ntpstats";

    @Generated
    public boolean getStatistics() {
        return this.getBoolean(statistics);
    }

    @Generated
    public void setStatistics(boolean v) {
        this.setBoolean(statistics, v, null);
    }

    @Generated
    public boolean getNtp() {
        return this.getBoolean(ntp);
    }

    @Generated
    public void setNtp(boolean v) {
        this.setBoolean(ntp, v, null);
    }

    @Generated
    public boolean getLocalBackup() {
        return this.getBoolean(localBackup);
    }

    @Generated
    public void setLocalBackup(boolean v) {
        this.setBoolean(localBackup, v, null);
    }

    @Generated
    public int getPanic() {
        return this.getInt(panic);
    }

    @Generated
    public void setPanic(int v) {
        this.setInt(panic, v, null);
    }

    @Generated
    public boolean getSyncAtBoot() {
        return this.getBoolean(syncAtBoot);
    }

    @Generated
    public void setSyncAtBoot(boolean v) {
        this.setBoolean(syncAtBoot, v, null);
    }

    @Generated
    public BNtpHostMode getHostMode() {
        return (BNtpHostMode)this.get(hostMode);
    }

    @Generated
    public void setHostMode(BNtpHostMode v) {
        this.set(hostMode, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isValidPlatform() {
        return false;
    }

    @Override
    public int getSlotFlags() {
        return 0;
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        this.refreshProperties();
    }

    @Override
    public void doPoll(Context cx) {
        super.doPoll(cx);
        if (!this.isRunning()) {
            return;
        }
        this.checkPropertiesLoaded();
    }

    private synchronized void refreshProperties() {
        NtpConfUtil.loadFromFile(this, LOG);
    }

    @Override
    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        NtpConfUtil.saveToFile(this, LOG);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        NtpConfUtil.spyHelper(this, this.getStatistics(), out, LOG);
    }

    static {
        String temporaryNtpStatsPath;
        String temporaryNtpDriftPath;
        String temporaryNtpConfPath;
        timeServers = BNtpPlatformServiceNpsdk.newProperty((int)3, (BValue)new BNtpServerVector(), (BFacets)BFacets.make((String)"elementType", (String)"platform:NtpServerNpsdk"));
        statistics = BNtpPlatformServiceNpsdk.newProperty((int)3, (boolean)true, null);
        ntp = BNtpPlatformServiceNpsdk.newProperty((int)3, (boolean)true, null);
        localBackup = BNtpPlatformServiceNpsdk.newProperty((int)3, (boolean)true, null);
        panic = BNtpPlatformServiceNpsdk.newProperty((int)7, (int)1000, null);
        syncAtBoot = BNtpPlatformServiceNpsdk.newProperty((int)3, (boolean)false, null);
        hostMode = BNtpPlatformServiceNpsdk.newProperty((int)3, (BValue)BNtpHostMode.server, null);
        TYPE = Sys.loadType(BNtpPlatformServiceNpsdk.class);
        NTP_CONF_PATH_DEFAULT = Sys.getNiagaraUserHome() + "/etc/ntp.conf";
        try {
            temporaryNtpConfPath = AccessController.doPrivileged(() -> System.getProperty(NTP_CONF_PATH_PROPERTY, NTP_CONF_PATH_DEFAULT));
            temporaryNtpDriftPath = AccessController.doPrivileged(() -> System.getProperty(NTP_DRIFT_PATH_PROPERTY, NTP_DRIFT_PATH_DEFAULT));
            temporaryNtpStatsPath = AccessController.doPrivileged(() -> System.getProperty(NTP_STATS_PATH_PROPERTY, NTP_STATS_PATH_DEFAULT));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load NTP configuration property, falling back to default configuration", e);
            temporaryNtpConfPath = NTP_CONF_PATH_DEFAULT;
            temporaryNtpDriftPath = NTP_DRIFT_PATH_DEFAULT;
            temporaryNtpStatsPath = NTP_STATS_PATH_DEFAULT;
        }
        NTP_CONF_PATH = temporaryNtpConfPath;
        NTP_DRIFT_PATH = temporaryNtpDriftPath;
        NTP_STATS_PATH = temporaryNtpStatsPath;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("BNtpPlatformServiceNpsdk Using NTP configuration properties:");
            LOG.fine("niagara.platNtp.configurationFilePath = " + NTP_CONF_PATH);
            LOG.fine("niagara.platNtp.driftFilePath = " + NTP_DRIFT_PATH);
            LOG.fine("niagara.platNtp.statisticsDirectoryPath = " + NTP_STATS_PATH);
        }
    }
}

