/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.linux;

import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServer;
import com.tridium.platform.posix.BNtpModePosix;
import java.util.StringTokenizer;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="useBurst", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="serverPreferred", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="minPollInterval", type="int", defaultValue="6", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH, BFacets.UNITS }, new BIDataValue[] { BInteger.make(4), BInteger.make(16), BInteger.make(3), BNtpPlatformService.LOG_2_SEC_UNIT })")}), @NiagaraProperty(name="maxPollInterval", type="int", defaultValue="10", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH, BFacets.UNITS }, new BIDataValue[] { BInteger.make(5), BInteger.make(17), BInteger.make(3), BNtpPlatformService.LOG_2_SEC_UNIT })")}), @NiagaraProperty(name="useAutokey", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="useKey", type="int", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH, BFacets.UNITS }, new BIDataValue[] { BInteger.make(0), BInteger.make(65536), BInteger.make(6), BUnit.getUnit(\"second\") })")}), @NiagaraProperty(name="peerMode", type="BNtpModePosix", defaultValue="BNtpModePosix.server", flags=3, facets={@Facet(value="BFacets.make(BFacets.RANGE, BEnumRange.make(null, new int[] { BNtpModePosix.SERVER, BNtpModePosix.PEER, BNtpModePosix.BROADCAST, BNtpModePosix.MANYCASTCLIENT }, new String[] { BNtpModePosix.server.getTag(), BNtpModePosix.peer.getTag(), BNtpModePosix.broadcast.getTag(), BNtpModePosix.manycastclient.getTag() }))")}), @NiagaraProperty(name="additionalArgs", type="String", defaultValue="", flags=3)})
public class BNtpServerLinux
extends BNtpServer {
    @Generated
    public static final Property useBurst = BNtpServerLinux.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property serverPreferred = BNtpServerLinux.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property minPollInterval = BNtpServerLinux.newProperty((int)3, (int)6, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)4), BInteger.make((int)16), BInteger.make((int)3), BNtpPlatformService.LOG_2_SEC_UNIT}));
    @Generated
    public static final Property maxPollInterval = BNtpServerLinux.newProperty((int)3, (int)10, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)5), BInteger.make((int)17), BInteger.make((int)3), BNtpPlatformService.LOG_2_SEC_UNIT}));
    @Generated
    public static final Property useAutokey = BNtpServerLinux.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property useKey = BNtpServerLinux.newProperty((int)3, (int)0, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)65536), BInteger.make((int)6), BUnit.getUnit((String)"second")}));
    @Generated
    public static final Property peerMode = BNtpServerLinux.newProperty((int)3, (BValue)BNtpModePosix.server, (BFacets)BFacets.make((String)"range", (BIDataValue)BEnumRange.make(null, (int[])new int[]{2, 1, 3, 4}, (String[])new String[]{BNtpModePosix.server.getTag(), BNtpModePosix.peer.getTag(), BNtpModePosix.broadcast.getTag(), BNtpModePosix.manycastclient.getTag()})));
    @Generated
    public static final Property additionalArgs = BNtpServerLinux.newProperty((int)3, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNtpServerLinux.class);
    protected String serverString = null;

    @Generated
    public boolean getUseBurst() {
        return this.getBoolean(useBurst);
    }

    @Generated
    public void setUseBurst(boolean v) {
        this.setBoolean(useBurst, v, null);
    }

    @Generated
    public boolean getServerPreferred() {
        return this.getBoolean(serverPreferred);
    }

    @Generated
    public void setServerPreferred(boolean v) {
        this.setBoolean(serverPreferred, v, null);
    }

    @Generated
    public int getMinPollInterval() {
        return this.getInt(minPollInterval);
    }

    @Generated
    public void setMinPollInterval(int v) {
        this.setInt(minPollInterval, v, null);
    }

    @Generated
    public int getMaxPollInterval() {
        return this.getInt(maxPollInterval);
    }

    @Generated
    public void setMaxPollInterval(int v) {
        this.setInt(maxPollInterval, v, null);
    }

    @Generated
    public boolean getUseAutokey() {
        return this.getBoolean(useAutokey);
    }

    @Generated
    public void setUseAutokey(boolean v) {
        this.setBoolean(useAutokey, v, null);
    }

    @Generated
    public int getUseKey() {
        return this.getInt(useKey);
    }

    @Generated
    public void setUseKey(int v) {
        this.setInt(useKey, v, null);
    }

    @Generated
    public BNtpModePosix getPeerMode() {
        return (BNtpModePosix)this.get(peerMode);
    }

    @Generated
    public void setPeerMode(BNtpModePosix v) {
        this.set(peerMode, (BValue)v, null);
    }

    @Generated
    public String getAdditionalArgs() {
        return this.getString(additionalArgs);
    }

    @Generated
    public void setAdditionalArgs(String v) {
        this.setString(additionalArgs, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNtpServerLinux() {
    }

    public BNtpServerLinux(String serverString) {
        this.updateServerString(serverString);
    }

    @Override
    public BNtpServer makeServer(String serverString) {
        return new BNtpServerLinux(serverString);
    }

    @Override
    public void updateServerString(String serverString) {
        this.serverString = serverString;
        StringTokenizer tokenizer = new StringTokenizer(serverString);
        String buf = tokenizer.nextToken();
        if (buf.equals("server")) {
            this.setPeerMode(BNtpModePosix.server);
        } else if (buf.equals("peer")) {
            this.setPeerMode(BNtpModePosix.peer);
        } else if (buf.equals("broadcast")) {
            this.setPeerMode(BNtpModePosix.broadcast);
        } else if (buf.equals("manycastclient")) {
            this.setPeerMode(BNtpModePosix.manycastclient);
        } else {
            throw new UnsupportedOperationException("Unknown host mode: " + buf);
        }
        String token = tokenizer.nextToken();
        if ("-6".equals(token)) {
            token = tokenizer.nextToken();
        }
        this.setAddress(token);
        this.setUseAutokey(false);
        this.setUseBurst(false);
        this.setUseKey(0);
        this.setMaxPollInterval(10);
        this.setMinPollInterval(6);
        this.setServerPreferred(false);
        this.setAdditionalArgs("");
        block7: while (tokenizer.hasMoreTokens()) {
            buf = tokenizer.nextToken();
            switch (buf.charAt(0)) {
                case 'a': {
                    if (!buf.equals("autokey")) continue block7;
                    this.setUseAutokey(true);
                    continue block7;
                }
                case 'b': {
                    if (!buf.equals("burst")) continue block7;
                    this.setUseBurst(true);
                    continue block7;
                }
                case 'm': {
                    if (buf.equals("minpoll")) {
                        this.setMinPollInterval(Integer.parseInt(tokenizer.nextToken()));
                        continue block7;
                    }
                    if (!buf.equals("maxpoll")) continue block7;
                    this.setMaxPollInterval(Integer.parseInt(tokenizer.nextToken()));
                    continue block7;
                }
                case 'k': {
                    if (!buf.equals("key")) continue block7;
                    this.setUseKey(Integer.parseInt(tokenizer.nextToken()));
                    continue block7;
                }
                case 'p': {
                    if (!buf.equals("prefer")) continue block7;
                    this.setServerPreferred(true);
                    continue block7;
                }
            }
            this.setAdditionalArgs(this.getAdditionalArgs().concat(" " + buf));
        }
    }

    @Override
    public String getServerString() {
        if (this.serverString == null) {
            this.serverString = this.getServerString(this.getPeerMode(), this.getAddress(), this.getUseAutokey(), this.getUseKey(), this.getUseBurst(), this.getServerPreferred(), this.getMinPollInterval(), this.getMaxPollInterval(), this.getAdditionalArgs());
        }
        return this.serverString;
    }

    public String getServerString(BNtpModePosix peerMode, String address, boolean useAutoKey, int useKey, boolean useBurst, boolean serverPreferred, int minPollInterval, int maxPollInterval, String additionalArgs) {
        StringBuilder result;
        if (peerMode == BNtpModePosix.server) {
            result = new StringBuilder("server");
        } else if (peerMode == BNtpModePosix.peer) {
            result = new StringBuilder("peer");
        } else if (peerMode == BNtpModePosix.manycastclient) {
            result = new StringBuilder("manycastclient");
        } else if (peerMode == BNtpModePosix.broadcast) {
            result = new StringBuilder("broadcast");
        } else {
            throw new UnsupportedOperationException("Unknown host mode: " + (Object)((Object)peerMode));
        }
        result.append(" ").append(address);
        if (useAutoKey) {
            result.append(" autokey");
        }
        if (useKey != 0 && !useAutoKey) {
            result.append(" key ").append(useKey);
        }
        if (useBurst) {
            result.append(" burst");
        }
        if (serverPreferred && peerMode != BNtpModePosix.manycastclient && peerMode != BNtpModePosix.broadcast) {
            result.append(" prefer");
        }
        if (minPollInterval != 6 && minPollInterval >= 4 && minPollInterval < 17 && minPollInterval < maxPollInterval) {
            result.append(" minpoll ").append(minPollInterval);
        }
        if (maxPollInterval != 10 && maxPollInterval <= 17 && maxPollInterval > 4 && maxPollInterval > minPollInterval) {
            result.append(" maxpoll ").append(maxPollInterval);
        }
        if (additionalArgs != null && additionalArgs.length() > 0) {
            result.append(" ").append(additionalArgs.trim());
        }
        return result.toString().trim();
    }

    @Override
    public String getPropertyName(String serverString) {
        return SlotPath.escape((String)serverString);
    }

    public synchronized boolean equivalent(Object o) {
        if (o instanceof String) {
            return this.getServerString().equals(o);
        }
        if (o instanceof BNtpServerLinux) {
            return ((BNtpServerLinux)((Object)o)).getServerString().equals(this.getServerString());
        }
        return false;
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == address || prop == useBurst || prop == useAutokey || prop == useKey || prop == maxPollInterval || prop == minPollInterval || prop == additionalArgs || prop == serverPreferred || prop == peerMode) {
            this.serverString = null;
        }
    }
}

