/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.platform.license.LicenseInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.baja.sys.Context;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

public class LicenseModel {
    private final XElem licenseFileElem;
    private final List<LicenseInfo> licenseInfos;

    public static List<LicenseModel> make(XElem[] licenseFileElems) throws Exception {
        if (licenseFileElems == null) {
            return Collections.emptyList();
        }
        ArrayList<LicenseModel> mutable = new ArrayList<LicenseModel>();
        for (XElem elem : licenseFileElems) {
            mutable.add(new LicenseModel(elem));
        }
        return Collections.unmodifiableList(mutable);
    }

    public LicenseModel(XElem licenseFileElem) throws Exception {
        this.licenseFileElem = licenseFileElem;
        ArrayList mutable = new ArrayList();
        Collections.addAll(mutable, LicenseInfo.make(this.licenseFileElem.elems("license")));
        this.licenseInfos = Collections.unmodifiableList(mutable);
    }

    public List<LicenseInfo> getLicenseInfos() {
        return this.licenseInfos;
    }

    public XElem[] getLicenseElements() {
        return this.licenseFileElem.elems("license");
    }

    public Optional<String> getModelNumber() {
        return this.optionalAttrValue("modelName");
    }

    public Optional<String> getModelDisplayName() {
        return this.optionalAttrValue("modelDisplayName");
    }

    public Optional<String> getBrandId() {
        return this.optionalAttrValue("brand");
    }

    public Optional<String> getBrandDisplayName() {
        return this.optionalAttrValue("brandDisplayName");
    }

    public Optional<Version> getVersion() {
        for (LicenseInfo info : this.getLicenseInfos()) {
            if (!info.vendorLicense.getVendor().equalsIgnoreCase("tridium")) continue;
            return Optional.of(info.vendorLicense.getVersion());
        }
        Optional<String> stringVersion = this.optionalAttrValue("version");
        return stringVersion.isPresent() ? Optional.of(new Version(stringVersion.get())) : Optional.empty();
    }

    public boolean hasDescription() {
        return this.getModelDisplayName().isPresent() || this.getModelNumber().isPresent() || this.getBrandId().isPresent() || this.getBrandDisplayName().isPresent() || this.getVersion().isPresent();
    }

    private Optional<String> optionalAttrValue(String attrName) {
        String result = this.licenseFileElem.get(attrName, null);
        return result == null ? Optional.empty() : Optional.of(result.replaceAll("\n", "").replaceAll("\r", ""));
    }

    public String toString(Context cx) {
        boolean useParen;
        StringBuilder result = new StringBuilder();
        if (this.getModelDisplayName().isPresent()) {
            result.append(this.getModelDisplayName().get());
        } else if (this.getModelNumber().isPresent()) {
            result.append(this.getModelNumber().get());
        }
        boolean bl = useParen = result.length() > 0;
        if (this.getBrandDisplayName().isPresent()) {
            if (useParen) {
                result.append(" (");
            }
            result.append(this.getBrandDisplayName().get());
            if (this.getVersion().isPresent()) {
                result.append(" ").append(this.getVersion().get());
            }
            if (useParen) {
                result.append(")");
            }
        } else if (this.getBrandId().isPresent()) {
            if (useParen) {
                result.append(" (");
            }
            result.append(this.getBrandId().get());
            if (this.getVersion().isPresent()) {
                result.append(" ").append(this.getVersion().get());
            }
            if (useParen) {
                result.append(")");
            }
        } else if (this.getVersion().isPresent()) {
            if (useParen) {
                result.append(" (");
            }
            result.append(" ").append(this.getVersion().get());
            if (useParen) {
                result.append(")");
            }
        } else if (result.length() == 0) {
            return "LicenseModel";
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

