/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import javax.baja.sys.BAbsTime;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;

public class UpdateTimeMessage
extends XmlResponseMessage {
    private final StringBuilder message = new StringBuilder("time?update=true");

    public UpdateTimeMessage(BAbsTime time, String bajaTimeZoneId, BTimeZone osTz, boolean sendFull) {
        if (time != null) {
            this.message.append("&time=").append(time.getMillis());
        }
        if (sendFull && bajaTimeZoneId != null) {
            this.message.append("&bajaTzId=");
            this.message.append(HttpUtil.encodeUrl((String)bajaTimeZoneId));
        }
        if (osTz != null) {
            this.message.append("&tzId=");
            this.message.append(HttpUtil.encodeUrl((String)osTz.getId()));
            if (sendFull) {
                DstRule endRule;
                this.message.append("&tzUtcOffset=");
                this.message.append(osTz.getUtcOffset() / 60000);
                this.message.append("&dstOffset=");
                this.message.append(osTz.getDaylightAdjustment() / 60000);
                DstRule startRule = DstRule.getWallTimeRule((DstRule)osTz.getDaylightStartRule(), (int)0, (BTimeZone)osTz);
                if (startRule != null) {
                    this.message.append("&dstStartHour=");
                    this.message.append(startRule.getTime().getHour());
                    this.message.append("&dstStartMinute=");
                    this.message.append(startRule.getTime().getMinute());
                    this.message.append("&dstStartMonth=");
                    this.message.append(startRule.getMonth().getOrdinal());
                    this.message.append("&dstStartDay=");
                    this.message.append(startRule.getDay());
                    this.message.append("&dstStartDayMode=");
                    this.message.append(startRule.getDayMode());
                    this.message.append("&dstStartWeek=");
                    this.message.append(startRule.getWeek());
                    if (startRule.getWeekday() != null) {
                        this.message.append("&dstStartWeekDay=");
                        this.message.append(startRule.getWeekday().getOrdinal());
                    }
                }
                if ((endRule = DstRule.getWallTimeRule((DstRule)osTz.getDaylightEndRule(), (int)1, (BTimeZone)osTz)) != null) {
                    this.message.append("&dstEndHour=");
                    this.message.append(endRule.getTime().getHour());
                    this.message.append("&dstEndMinute=");
                    this.message.append(endRule.getTime().getMinute());
                    this.message.append("&dstEndMonth=");
                    this.message.append(endRule.getMonth().getOrdinal());
                    this.message.append("&dstEndDay=");
                    this.message.append(endRule.getDay());
                    this.message.append("&dstEndDayMode=");
                    this.message.append(endRule.getDayMode());
                    this.message.append("&dstEndWeek=");
                    this.message.append(endRule.getWeek());
                    if (endRule.getWeekday() != null) {
                        this.message.append("&dstEndWeekDay=");
                        this.message.append(endRule.getWeekday().getOrdinal());
                    }
                }
            }
        }
    }

    @Override
    public String getMessageString() {
        return this.message.toString();
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }
}

