/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.platform.daemon.message.EncryptableXmlResponseMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import java.util.Objects;

public final class StartPBETransactionMessage
extends EncryptableXmlResponseMessage
implements AutoCloseable {
    private final PBEEncodingKey encodingKey;

    public StartPBETransactionMessage(PBEEncodingKey encodingKey, boolean closeKey) {
        Objects.requireNonNull(encodingKey);
        this.encodingKey = (PBEEncodingKey)encodingKey.newCopy();
        if (closeKey) {
            encodingKey.close();
        }
    }

    public void initializeMessage(FileTransferMessage fileTransferMessage) {
        Objects.requireNonNull(fileTransferMessage);
        if (this.encodingKey.isClosed()) {
            throw new IllegalStateException("Cannot use closed encoding key");
        }
        fileTransferMessage.setTransactionId(this.getResponse().get("transactionId"));
        fileTransferMessage.setPBEEncodingInfo((PBEEncodingInfo)((PBEEncodingKey)this.encodingKey.newCopy()));
        this.close();
    }

    @Override
    public String getMessageString() {
        return "/niagara?transactioninfo=true&transaction=new&encodingValidator=" + this.encodingKey.getEncodedValidator() + "&encodingIterationCount=" + this.encodingKey.getEncodingIterationCount() + "&encodingSalt=" + this.encodingKey.getEncodingSaltHex() + "&encodingPassPhrase=" + this.prepareMessage(this.encodingKey.getPassPhrase()) + "&" + "sharedKeyName" + "=" + this.sharedSecretKey.getName();
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    @Override
    public void close() {
        this.encodingKey.close();
    }
}

