/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileFileTransferElement;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BMemoryFileStore;
import javax.baja.file.FilePath;
import javax.baja.security.BPassword;
import javax.baja.util.Version;

public class BogFileFileTransferElement
extends FileFileTransferElement {
    private static final Version USER_PASSWORD_ENCRYPTION_VERSION = new Version("4.15");

    public BogFileFileTransferElement(FilePath pPath, BBogFile pFile, BDaemonFileSpace space) {
        super(pPath, (BIFile)pFile, space);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePasswords(PBEEncodingInfo encodingInfo) throws Exception {
        block6: {
            BBogFile bogFile = (BBogFile)this.file;
            Version remoteVersion = new Version(this.getDaemonFileSpace().getDaemonSession().getHostProperties().getDaemonVersion());
            if (remoteVersion.compareTo(USER_PASSWORD_ENCRYPTION_VERSION) < 0 && bogFile.usesReversibleEncryptionPassPhrase() && bogFile.hasEncryptedHashedPasswords()) {
                if (bogFile.isOpen()) {
                    bogFile.close();
                }
                try {
                    bogFile.open();
                    if (encodingInfo instanceof PBEEncodingKey && ((PBEEncodingKey)encodingInfo).getPassPhrase().get() != null) {
                        bogFile.setReversibleEncryptionPassPhrase(BPassword.make((char[])((PBEEncodingKey)encodingInfo).getPassPhrase().get()));
                        bogFile.removeEncryptionFromUserPasswords();
                        BMemoryFileStore store = new BMemoryFileStore(bogFile.getFileSpace(), bogFile.getFilePath());
                        bogFile.setStore((BIFileStore)store);
                        bogFile.save();
                        break block6;
                    }
                    throw new IllegalStateException("Passphrase for station is needed but was not provided");
                }
                finally {
                    bogFile.close();
                }
            }
        }
    }
}

