/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.net.HttpConnection;
import javax.baja.platform.ICancelHint;

class PostOutputStream
extends OutputStream {
    private HttpConnection conn;
    private OutputStream out;
    private ICancelHint cancelHint;

    public PostOutputStream(HttpConnection conn, ICancelHint cancelHint) throws IOException {
        if (PostOutputStream.canceled(cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        this.conn = conn;
        this.out = conn.getOutputStream();
        this.cancelHint = cancelHint;
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        BDaemonSession.readFully(this.conn);
        this.out.close();
        this.conn.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (PostOutputStream.canceled(this.cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (PostOutputStream.canceled(this.cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (PostOutputStream.canceled(this.cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        this.out.write(b, off, len);
    }

    public static boolean canceled(ICancelHint i) {
        return i != null && i.isCanceled();
    }
}

