/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.nre.security.SecretChars;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.RemotePlatformStation;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import java.net.ConnectException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.RemoteStation;
import javax.baja.platform.StationManager;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.Lexicon;

public class PlatformStationManager
implements StationManager {
    private BDaemonSession daemonSession;
    private static final Lexicon lex = Lexicon.make((String)"platform");

    private PlatformStationManager(BDaemonSession daemonSession) {
        this.daemonSession = daemonSession;
    }

    public static PlatformStationManager make(BDaemonSession daemonSession) {
        return new PlatformStationManager(daemonSession);
    }

    @Override
    public RemoteStation createStation(BDirectory localSourceDirectory, String targetName, IPlatformOperationListener listener, Supplier<char[]> passPhraseSupplier) throws Exception {
        PlatformOperationListener l = new PlatformOperationListener(listener);
        RemoteStation[] allStations = this.getAllStations();
        int newNumStations = allStations.length + 1;
        RemoteStation result = null;
        for (RemoteStation allStation : allStations) {
            if (!TextUtil.toLowerCase((String)allStation.getName()).equals(TextUtil.toLowerCase((String)targetName))) continue;
            result = allStation;
            --newNumStations;
            break;
        }
        if (newNumStations > this.daemonSession.getHostProperties().getMaxStations()) {
            throw new BajaRuntimeException("Maximum number of stations exceeded");
        }
        if (result != null) {
            result.stop(listener);
        }
        FileTransferMessage message = new FileTransferMessage(this.daemonSession.getFileSpace());
        BBogFile configBog = (BBogFile)localSourceDirectory.getNavChild("config.bog");
        if (configBog.getBogVersion().compareTo(ValueDocEncoder.BOG_VERSION_4) < 0) {
            if (this.daemonSession.getHostProperties().isNiagara4()) {
                throw new IllegalArgumentException("Cannot transfer AX station to Niagara 4 host");
            }
        } else if (this.daemonSession.getHostProperties().isNiagara4()) {
            if (configBog.usesKeyRingEncryption()) {
                throw new IllegalArgumentException("Cannot transfer Keyring-encoded bog");
            }
            if (configBog.usesReversibleEncryptionPassPhrase()) {
                if (passPhraseSupplier == null) {
                    throw new IllegalArgumentException("Cannot transfer passphrase-protected config.bog without a passphrase");
                }
                try (SecretChars pwChars = new SecretChars(passPhraseSupplier.get(), false);){
                    DaemonClientEncodingInfo.makeMessageInitializer(this.daemonSession, Optional.of(configBog.getPBEEncodingInfo()), Optional.of(pwChars)).accept(message);
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot transfer Niagara 4 station to AX host");
        }
        this.addDir(message, localSourceDirectory, new FilePath("~stations/" + targetName));
        DaemonFileUtil.transfer(this.daemonSession, message, l, l);
        if (result == null) {
            this.daemonSession.sendMessage(new UpdateStationMessage());
            this.daemonSession.sendMessage(new UpdateStationMessage(targetName, false, true, true, true));
            result = this.getStation(targetName);
        } else {
            result.poll();
        }
        return result;
    }

    @Override
    public RemoteStation[] getAllStations() throws Exception {
        return RemotePlatformStation.getAllStations(this.daemonSession);
    }

    @Override
    public RemoteStation getStation(String stationName) throws Exception {
        return RemotePlatformStation.getStation(this.daemonSession, stationName);
    }

    @Override
    public RemoteStation[] stopAllStations(IPlatformOperationListener listener) throws Exception {
        return RemotePlatformStation.stopAllStations(this.daemonSession, listener);
    }

    @Override
    public void rebootAsync() throws ConnectException, AuthenticationException {
        this.daemonSession.sendRebootRequest(false);
    }

    @Override
    public void rebootSync(IPlatformOperationListener listener) throws Exception {
        String sessionTimestamp = this.daemonSession.getHostProperties().getSessionTimestamp();
        String hostName = this.daemonSession.getHost().getNavDisplayName(null);
        listener.notifyStatus(lex.getText("RemotePlatformStation.reboot", new Object[]{hostName}));
        this.daemonSession.sendRebootRequest(false);
        listener.notifyStatus(lex.getText("RemotePlatformStation.reconnecting", new Object[]{hostName}));
        if (this.daemonSession.reconnect(sessionTimestamp, listener)) {
            listener.notifyStatus(lex.getText("RemotePlatformStation.reconnected", new Object[]{hostName}));
        }
    }

    private void addDir(FileTransferMessage message, BDirectory sourceDir, FilePath destFilePath) throws Exception {
        for (BIFile kid : sourceDir.listFiles()) {
            if (kid instanceof BDirectory) {
                this.addDir(message, (BDirectory)kid, destFilePath.merge(kid.getFileName()));
                continue;
            }
            if (this.ignoreStationFile(kid)) continue;
            message.addFile(kid, destFilePath.merge(kid.getFileName()));
        }
    }

    private boolean ignoreStationFile(BIFile file) {
        return this.ignoreStationFile(file.getFileName());
    }

    private boolean ignoreStationFile(String fileName) {
        return fileName.endsWith(".lock") || fileName.startsWith("console.") || fileName.startsWith("config.bog.b") || fileName.startsWith("config_backup");
    }
}

