/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.nre.util.Array;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.PlatformLicenseManager;
import javax.baja.sys.LocalizableRuntimeException;

public class NiagaraLicenseManager
implements PlatformLicenseManager {
    private BDaemonSession session;

    private NiagaraLicenseManager(BDaemonSession session) {
        this.session = session;
    }

    public static NiagaraLicenseManager make(BDaemonSession session) {
        return new NiagaraLicenseManager(session);
    }

    @Override
    public String getHostId() throws Exception {
        return this.session.getHostProperties().getHostId();
    }

    @Override
    public BIFile[] getLicenses() throws Exception {
        BDirectory licenseDir = (BDirectory)this.session.getFileSpace().findFile(SystemFilePaths.getLicensesDirPath(this.session.getHostProperties().isNiagara4(), this.session.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual(), this.session.getHostProperties().getIsNiagaraHomeReadonly()));
        if (licenseDir == null) {
            return new BIFile[0];
        }
        Array result = new Array((Object[])licenseDir.listFiles());
        result = result.filter(obj -> obj instanceof BLicenseFile);
        return (BIFile[])result.trim();
    }

    @Override
    public boolean getIsLicenseReadonly() throws Exception {
        return this.session.getHostProperties().getIsLicenseReadonly();
    }

    @Override
    public void installLicenses(BIFile[] newLicenses, IPlatformOperationListener listener) throws Exception {
        LicenseInfo info;
        int i;
        LicenseInfo[] current;
        if (this.session.getHostProperties().getIsLicenseReadonly()) {
            throw new LocalizableRuntimeException("platform", "PlatformLicenseManager.licensesReadonly");
        }
        FileTransferMessage message = new FileTransferMessage(this.session.getFileSpace());
        LicenseInfo[] toInstall = LicenseInfo.make(newLicenses);
        BDirectory licenseDir = (BDirectory)this.session.getFileSpace().findFile(SystemFilePaths.getLicensesDirPath(this.session.getHostProperties().isNiagara4(), this.session.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual(), this.session.getHostProperties().getIsNiagaraHomeReadonly()));
        if (licenseDir == null) {
            current = new LicenseInfo[]{};
        } else {
            BIFile[] kids = licenseDir.listFiles();
            Array currentArray = new Array(LicenseInfo.class);
            for (BIFile kid : kids) {
                if (!(kid instanceof BLicenseFile)) continue;
                try {
                    currentArray.add((Object)new LicenseInfo(kid));
                }
                catch (Exception e) {
                    message.addDelete(kid.getFilePath());
                }
            }
            current = (LicenseInfo[])currentArray.trim();
        }
        LicenseSync<LicenseInfo> sync = PortalLicenseUtil.syncLicenses(this.getHostId(), null, current, toInstall);
        for (i = 0; i < sync.toAdd.size(); ++i) {
            info = (LicenseInfo)sync.toAdd.get(i);
            message.addFile(info.file, info.getInstalledFilePath(this.session.getHostProperties().isNiagara4(), this.session.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual(), this.session.getHostProperties().getIsNiagaraHomeReadonly()));
        }
        for (i = 0; i < sync.toUpdate.size(); ++i) {
            info = (LicenseInfo)sync.toUpdate.get(i);
            message.addFile(info.file, info.getInstalledFilePath(this.session.getHostProperties().isNiagara4(), this.session.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual(), this.session.getHostProperties().getIsNiagaraHomeReadonly()));
        }
        for (i = 0; i < sync.toRemove.size(); ++i) {
            info = (LicenseInfo)sync.toRemove.get(i);
            message.addDelete(info.file.getFilePath());
        }
        PlatformOperationListener opListener = new PlatformOperationListener(listener);
        DaemonFileUtil.transfer(this.session, message, opListener, opListener);
    }
}

