/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.net.HttpUtil;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonText;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FilesystemAttributesMessage;
import com.tridium.platform.daemon.message.GetJarContentMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.net.HttpConnection;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class DaemonFileUtil {
    public static final int _PIPE_BUFFER_SIZE = 8192;
    public static final Lexicon LEXICON = Lexicon.make((String)"platform");
    public static final Logger LOGGER = Logger.getLogger("platform.daemonSession");
    public static final ThreadLocal<DecimalFormat> BYTE_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat(LEXICON.getText("Formats.bytes")));
    public static final ThreadLocal<DecimalFormat> KB_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat(LEXICON.getText("Formats.kb")));
    public static final ThreadLocal<DecimalFormat> MB_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat(LEXICON.getText("Formats.mb")));

    private DaemonFileUtil() {
    }

    public static void deleteFile(BIFile file) throws Exception {
        BFileSpace space = (BFileSpace)file.getSpace();
        if (space instanceof BDaemonFileSpace) {
            BDaemonFileSpace daemonFileSpace = (BDaemonFileSpace)space;
            DaemonFileUtil.transfer(daemonFileSpace.getDaemonSession(), FileTransferMessage.makeDelete(file.getFilePath(), daemonFileSpace), null);
        } else {
            file.delete();
        }
    }

    public static String fileSize(long size) {
        if (size < 0L) {
            return "";
        }
        if (size < 1024L) {
            return BYTE_FORMAT.get().format(size);
        }
        return KB_FORMAT.get().format((double)size / 1024.0);
    }

    public static void pipe(InputStream in, OutputStream out, TransferStatus status) throws IOException {
        int len = 8192;
        byte[] buf = new byte[len];
        long transferred = 0L;
        while (true) {
            if (status.isCanceled()) {
                throw new ICancelHint.CanceledException();
            }
            int n = in.read(buf, 0, len);
            if (n < 0) break;
            out.write(buf, 0, n);
            status.updateBytesWritten(transferred += (long)n);
        }
    }

    public static BIFile findFile(BFileSpace space, FilePath path, FileCache cache) {
        if (cache == null) {
            return space.findFile(path);
        }
        switch (cache.getCacheStatus(path)) {
            case 0: {
                return cache.getFile(path);
            }
            case 1: {
                return null;
            }
        }
        BIFile result = space.findFile(path);
        if (result == null) {
            cache.cacheNotFound(path);
        } else {
            cache.cacheResult(result);
        }
        return result;
    }

    public static long getCrc(BIFile file) {
        try {
            if (file instanceof BAbstractFile) {
                return ((BAbstractFile)file).getCrc();
            }
            return -1L;
        }
        catch (IOException ioException) {
            throw new LocalizableRuntimeException("platform", "FileUtilities.exception.readCrc", (Throwable)ioException);
        }
    }

    public static FileHeaderInfo getFileHeaderInfo(BDaemonSession session, FileHeaderMessage message) throws ConnectException, AuthenticationException {
        String crc;
        long lastModified;
        String contentLengthString;
        String messageURI = session.prepareMessageUri(message);
        HttpConnection conn = session.getConnection(messageURI, "HEAD", BDaemonSession.DEFAULT_TIMEOUT);
        if (conn == null) {
            return null;
        }
        FileHeaderInfo result = new FileHeaderInfo();
        String contentType = conn.getResponseHeader("Content-Type");
        if (contentType != null) {
            result.setContentType(contentType);
        }
        if ((contentLengthString = conn.getResponseHeader("Content-Length")) != null) {
            result.setContentLength(Long.parseLong(contentLengthString));
        }
        if ((lastModified = conn.getResponseHeaderDate("Last-Modified")) > 0L) {
            result.setLastModified(BAbsTime.make((long)lastModified));
        }
        if ((crc = conn.getResponseHeader("File-CRC")) != null) {
            result.setCrc(Long.parseLong(crc));
        }
        conn.close();
        return result;
    }

    public static BFilesystemAttributes getFilesystemAttributes(BDaemonSession session, FilePath path) throws Exception {
        InputStream in = session.getInputStream(new FilesystemAttributesMessage(session.getFileSpace(), path));
        XElem elem = XParser.make((InputStream)in).parse();
        return new BFilesystemAttributes(elem.getl("totalKb", -1L), elem.getl("freeKb", -1L), elem.getl("maxFileCount", -1L), elem.getl("currentFileCount", -1L));
    }

    public static FilePath getNormalizedFilePath(BIFileStore store) {
        if (store.getFilePath().isLocalAbsolute()) {
            return store.getFilePath();
        }
        if (store.getFileSpace() instanceof BDaemonFileSpace) {
            FilePath result = ((BDaemonFileSpace)store.getFileSpace()).getAltPath(store.getFilePath());
            if (result != null) {
                return result;
            }
        } else if (store instanceof BLocalFileStore) {
            return BFileSystem.INSTANCE.localFileToPath(((BLocalFileStore)store).getLocalFile());
        }
        return store.getFilePath();
    }

    public static InputStream getZipStream(BIFile file, FilePath entryPath) throws IOException {
        ZipEntry entry;
        if (file.getStore() instanceof BLocalFileStore) {
            BZipFile zipFile = file instanceof BZipFile ? (BZipFile)file : new BZipFile(file.getStore());
            BZipSpace space = (BZipSpace)zipFile.open();
            BIFile zipEntry = space.findFile(entryPath);
            if (zipEntry == null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            return new ZipEntryInputStream(zipFile, zipEntry);
        }
        if (file.getStore() instanceof BDaemonFileStore) {
            BDaemonFileStore store = (BDaemonFileStore)file.getStore();
            return store.getDaemonSession().getInputStream(new GetJarContentMessage(file.getFilePath(), entryPath));
        }
        ZipInputStream in = new ZipInputStream(file.getInputStream());
        while ((entry = in.getNextEntry()) != null) {
            if (!entry.getName().equalsIgnoreCase(entryPath.getBody())) continue;
            return in;
        }
        in.close();
        return null;
    }

    public static boolean isSubPath(FilePath p1, FilePath p2) {
        return DaemonFileUtil.pathsMatch(p1, p2, p2.depth());
    }

    public static BIFile[] listFiles(BDirectory dir, FileCache cache) {
        BIFile[] result = dir.listFiles();
        if (cache != null) {
            for (BIFile file : result) {
                cache.cacheResult(file);
            }
        }
        return result;
    }

    public static String addSessionCSRFToken(String uri, BDaemonSession daemonSession) {
        StringBuilder uriBuilder = new StringBuilder(uri);
        if (daemonSession.getSessionCSRFToken() != null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Adding CSRF token to File Transfer Message '" + TextUtil.truncate((String)uri, (int)64) + "...'");
            }
            if (!uri.contains("?")) {
                uriBuilder.append("?");
            } else {
                uriBuilder.append("&");
            }
            uriBuilder.append("csrfToken").append("=").append(HttpUtil.encodeUrl((String)daemonSession.getSessionCSRFToken()));
        } else if (daemonSession.getHostProperties().isNiagara4() && new Version(daemonSession.getHostProperties().getDaemonVersion()).compareTo(new Version("4.4.62.0")) >= 0) {
            LOGGER.severe("Sending Daemon Message '" + TextUtil.truncate((String)uri, (int)64) + "...' that changes state without CSRF token, failure likely!");
            if (LOGGER.isLoggable(Level.ALL)) {
                Thread.dumpStack();
            }
        }
        return uriBuilder.toString();
    }

    public static boolean pathsMatch(FilePath p1, FilePath p2, int comparisonDepth) {
        if (comparisonDepth < 0) {
            return false;
        }
        if (p1.getAbsoluteMode() != p2.getAbsoluteMode()) {
            return false;
        }
        if (p1.depth() < comparisonDepth) {
            return false;
        }
        if (p2.depth() < comparisonDepth) {
            return false;
        }
        for (int i = 0; i < comparisonDepth; ++i) {
            if (p1.nameAt(i).equals(p2.nameAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean transfer(BDaemonSession session, FileTransferMessage message, ICancelHint cancelHint) throws ConnectException, AuthenticationException {
        return DaemonFileUtil.transfer(session, message, cancelHint, DaemonSessionTaskListener.NULL_TASK_LISTENER);
    }

    /*
     * Exception decompiling
     */
    public static synchronized boolean transfer(BDaemonSession session, FileTransferMessage message, ICancelHint cancelHint, DaemonSessionTaskListener taskListener) throws ConnectException, AuthenticationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 32[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean canceled(ICancelHint i) {
        return i != null && i.isCanceled();
    }

    private static boolean sendAbort(BDaemonSession session, FileTransferMessage message, HttpConnection connection, CancelableDaemonSessionTask task, DaemonSessionTaskListener taskListener) throws ConnectException, AuthenticationException {
        String uri = message.getAbortUri();
        if (uri == null) {
            return true;
        }
        try {
            uri = DaemonFileUtil.addSessionCSRFToken(uri, session);
            connection = session.getConnection(uri, "GET", -1L, BDaemonSession.DEFAULT_TIMEOUT, connection);
        }
        catch (IOException ioException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("sendAbort closes connection (" + ioException + ")");
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LocalizableRuntimeException("platform", "DaemonSession.exception.write", new Object[]{session.getAddressString(), "GET", uri}, (Throwable)ioException);
        }
        return true;
    }

    private static boolean sendCommit(BDaemonSession session, FileTransferMessage message, HttpConnection connection, CancelableDaemonSessionTask task, DaemonSessionTaskListener taskListener) throws AuthenticationException {
        InputStream in = null;
        String uri = message.getCommitUri();
        if (uri == null) {
            if (message.getTransactionId() == null) {
                LOGGER.warning("attempt to commit file transfer that is not transacted");
            } else {
                LOGGER.warning("attempt to commit file transfer that is autocommit");
            }
            return false;
        }
        try {
            uri = DaemonFileUtil.addSessionCSRFToken(uri, session);
            in = session.getInputStream(uri, 0, "text/xml", connection);
            if (in == null) {
                return true;
            }
            XParser parser = XParser.make((InputStream)in);
            while (parser.next() != -1) {
                if (parser.type() == 1) {
                    XElem logEntry = null;
                    switch (parser.elem().name()) {
                        case "message": 
                        case "warning": 
                        case "trace": {
                            logEntry = parser.parseCurrent(false);
                            break;
                        }
                        case "error": {
                            logEntry = parser.parseCurrent(false);
                            int code = logEntry.geti("code", 500);
                            DaemonText daemonText = new DaemonText(logEntry);
                            if (daemonText.lexModule == null) {
                                String text = daemonText.message;
                                if (text == null) {
                                    text = session.getAddressString() + " " + "GET" + " " + uri;
                                }
                                if (code < 400) break;
                                throw new LocalizableRuntimeException("platform", "DaemonSession.exception.commit", new Object[]{text});
                            }
                            if (code < 300) break;
                            throw new LocalizableRuntimeException(daemonText.lexModule, daemonText.lexKey, daemonText.lexArgs);
                        }
                    }
                    if (logEntry == null) continue;
                    DaemonText daemonText = new DaemonText(logEntry);
                    task.setMessage(daemonText.message);
                    taskListener.taskUpdated(task);
                    continue;
                }
                if (parser.type() != 2 || parser.depth() > 1) continue;
                break;
            }
        }
        catch (IOException ioException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("sendCommit closes connection (" + ioException + ")");
            }
            try {
                if (in != null) {
                    in.close();
                } else if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LocalizableRuntimeException("platform", "DaemonSession.exception.commit", new Object[]{session.getAddressString(), "GET", uri}, (Throwable)ioException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        return true;
    }

    public static interface TransferStatus
    extends ICancelHint {
        public void updateBytesWritten(long var1);
    }

    public static class ZipEntryInputStream
    extends InputStream {
        private final InputStream stream;
        private final BZipFile zipFile;

        public ZipEntryInputStream(BZipFile pZipFile, BIFile pZipEntryFile) throws IOException {
            this.zipFile = pZipFile;
            this.stream = pZipEntryFile.getInputStream();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int offset, int len) throws IOException {
            return this.stream.read(b, offset, len);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.zipFile.close();
        }
    }
}

