/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonDebugMessage;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Properties;
import javax.baja.security.AuthenticationException;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class DaemonDebugUtil {
    public static boolean isDebuggingSupported(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        return daemonSession.getHostProperties().supportsServlet("debug");
    }

    public static boolean isDebuggingEnabled(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        if (DaemonDebugUtil.isDebuggingSupported(daemonSession)) {
            try {
                XElem debugElem = XParser.make((InputStream)daemonSession.getInputStream(new DaemonDebugMessage())).parse();
                return debugElem.getb("daemonDebug", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean enableDebugging(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        if (DaemonDebugUtil.isDebuggingSupported(daemonSession)) {
            return daemonSession.sendMessage(new DaemonDebugMessage(true));
        }
        return false;
    }

    public static boolean disableDebugging(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        if (DaemonDebugUtil.isDebuggingSupported(daemonSession)) {
            return daemonSession.sendMessage(new DaemonDebugMessage(false));
        }
        return false;
    }

    public static Properties getSystemProperties(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        Properties props = new Properties();
        if (!DaemonDebugUtil.isDebuggingSupported(daemonSession)) {
            return props;
        }
        try {
            XElem debugElem = XParser.make((InputStream)daemonSession.getInputStream(new DaemonDebugMessage())).parse();
            if (!debugElem.getb("daemonDebug", false)) {
                return props;
            }
            XElem daemonPropertiesElem = debugElem.elem("properties");
            if (daemonPropertiesElem != null) {
                XElem[] daemonProperties;
                for (XElem elem : daemonProperties = daemonPropertiesElem.elems("property")) {
                    props.setProperty(elem.get("name"), elem.get("value"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    public static NiagaraDaemonTimes getTimes(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        NiagaraDaemonTimes times = new NiagaraDaemonTimes(0L, 0L, 0L);
        if (!DaemonDebugUtil.isDebuggingSupported(daemonSession)) {
            return times;
        }
        try {
            XElem debugElem = XParser.make((InputStream)daemonSession.getInputStream(new DaemonDebugMessage())).parse();
            if (!debugElem.getb("daemonDebug", false)) {
                return times;
            }
            XElem daemonTimes = debugElem.elem("times");
            if (daemonTimes != null) {
                times.setTimeAtBoot(daemonTimes.getl("millisAtBootstrap", 0L));
                times.setTimeAtServiceStart(daemonTimes.getl("millisAtServiceStart", 0L));
                times.setUptime(daemonTimes.getl("uptime", 0L));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return times;
    }

    public static class NiagaraDaemonTimes {
        private long timeAtBoot = 0L;
        private long timeAtServiceStart = 0L;
        private long uptime = 0L;

        NiagaraDaemonTimes(long timeAtBoot, long timeAtServiceStart, long uptime) {
            this.timeAtBoot = timeAtBoot;
            this.timeAtServiceStart = timeAtServiceStart;
            this.uptime = uptime;
        }

        public long getTimeAtBoot() {
            return this.timeAtBoot;
        }

        public long getTimeAtServiceStart() {
            return this.timeAtServiceStart;
        }

        public long getUptime() {
            return this.uptime;
        }

        void setTimeAtBoot(long timeAtBoot) {
            this.timeAtBoot = timeAtBoot;
        }

        void setTimeAtServiceStart(long timeAtServiceStart) {
            this.timeAtServiceStart = timeAtServiceStart;
        }

        void setUptime(long uptime) {
            this.uptime = uptime;
        }
    }
}

