/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.SimpleAuthenticationClient;
import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.net.HttpUtil;
import com.tridium.niagarad.io.OutputSocket;
import com.tridium.niagarad.servlet.OutputServlet;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.PasswordStrength;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SessionKey;
import com.tridium.nre.security.UserLoginEntry;
import com.tridium.nre.security.UserLoginHistory;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.nre.util.PrivilegedNamedThreadFactory;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.BSessionNavNode;
import com.tridium.platform.BSessionNavNodeFactory;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.Authenticator;
import com.tridium.platform.daemon.BDaemonScheme;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.DaemonAuthenticationException;
import com.tridium.platform.daemon.DaemonResponseException;
import com.tridium.platform.daemon.DaemonSSLRequiredException;
import com.tridium.platform.daemon.DaemonSessionListener;
import com.tridium.platform.daemon.DaemonText;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.PostOutputStream;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.EncryptableDaemonMessage;
import com.tridium.platform.daemon.message.EncryptionAlgorithmBundleMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.message.GetOutputMessage;
import com.tridium.platform.daemon.message.GetPasswordStrengthMessage;
import com.tridium.platform.daemon.message.GetUserLoginHistoryMessage;
import com.tridium.platform.daemon.message.InitializeSharedSecretKeyMessage;
import com.tridium.platform.daemon.message.RebootMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.util.BSessionInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.net.Http;
import javax.baja.net.HttpConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.ICancelHint;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.CancelledAuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.net.ssl.SSLException;
import org.bouncycastle.tls.TlsException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@NiagaraType
public class BDaemonSession
extends BSession
implements AuthenticationClient {
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonSession.class);
    private static final BIcon iconConnected = BIcon.std((String)"platform.png");
    private static final BIcon iconDisconnected = BIcon.std((String)"platformDisconnected.png");
    private static final BIcon fipsBadge = BIcon.std((String)"badges/fips.png");
    private AgentList agentList = null;
    public static boolean debug = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.daemonsession.debug"));
    public static final int INFINITE_TIMEOUT = 0;
    public static int DEFAULT_TIMEOUT = debug ? 0 : AccessController.doPrivileged(() -> Integer.getInteger("niagara.daemonsession.timeout", 60000));
    private static final long FIVE_MINUTES = 300000L;
    public static final int STATION_OVERRIDE_NONE = 0;
    public static final int STATION_OVERRIDE_START = 1;
    public static final int STATION_OVERRIDE_STOP = 2;
    public static final int PORT_UNKNOWN = -1;
    public static final int UNKNOWN_CONTENT_LENGTH = -1;
    private static final Version minimumRequiredMajorVersion = new Version("3");
    private static final Version maximumAllowedMajorVersion = new Version("4");
    private static final RebootMessage rebootMessage = new RebootMessage(false);
    private static final RebootMessage forceRebootMessage = new RebootMessage(true);
    private static String[] brandIdHolder = null;
    public static final int FLAGS_NONE = 0;
    public static final int FLAGS_NO_CONNECTED_NOTIFY = 1;
    public static final int FLAGS_NO_AUTH_NOTIFY = 2;
    public static final int FLAGS_DISCONNECT = 4;
    public static final int FLAGS_CLOSE = 8;
    public static final int FLAGS_CLEAR_CREDENTIALS = 16;
    public static final int FLAGS_EXPECT_CONTINUE = 32;
    private static final int MAX_REDIRECT_PAYLOAD = 75;
    private boolean useAuthenticationClient = true;
    private BICredentials manualAuthenticationClientCredentials = null;
    private Properties cachedAuthorizationHeader;
    private final BHost host;
    private final int port;
    private final BOrd ordInHost;
    private final BOrd absOrd;
    private Authenticator authenticator;
    private AuthenticationClient authenticationClient = this;
    private final BHostProperties hostProperties;
    private long lastConnectTicks;
    private long lastConnectedTime;
    protected BSessionNavNodeFactory[] navFactories = null;
    private boolean connected = false;
    public static Logger log = Logger.getLogger("platform.daemonSession");
    public static Logger socketLog = Logger.getLogger("platform.daemonSession.webSocket");
    private final Set<DaemonSessionListener> listeners = new HashSet<DaemonSessionListener>();
    private volatile boolean inInit = false;
    private final Object initializing = new Object();
    private boolean localNiagaraHome = false;
    private boolean localNiagaraUserHome = false;
    private boolean reuseSession = true;
    private String sessionId = null;
    SessionKey sessionKey = null;
    String sessionCSRFToken = null;
    public static final String CSRF_TOKEN_KEY = "csrfToken";
    boolean allowTokenRotation = true;
    private boolean inReconnect = false;
    private static final int RECONNECT_AUTH_FAILURE_LIMIT = 3;
    private static final ExecutorService wsExecutorService;
    private PasswordStrength platformPasswordStrength = null;
    private volatile BDefaultDaemonFileSpace bootstrapFileSpace;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BDaemonSession make(BHost host, int port) {
        BDaemonSession session;
        StringBuilder nameBuilder = new StringBuilder("platform");
        if (port != 3011) {
            nameBuilder.append(":").append(port);
        }
        if ((session = (BDaemonSession)host.getNavChild(nameBuilder.toString())) == null) {
            session = new BDaemonSession(nameBuilder.toString(), host, port);
            host.addNavChild((BINavNode)session);
        }
        return session;
    }

    public static BDaemonSession makeIgnoringCache(BHost host, int port) {
        StringBuilder nameBuilder = new StringBuilder("noCache:platform");
        if (port != 3011) {
            nameBuilder.append(":").append(port);
        }
        return new BDaemonSession(nameBuilder.toString(), host, port);
    }

    public BDaemonSession newSession(int newPort) {
        BDaemonSession newSession = this.makeNewSession(this.getHost(), newPort);
        newSession.authenticationClient = this.authenticationClient;
        newSession.authenticator = this.authenticator;
        return newSession;
    }

    protected BDaemonSession makeNewSession(BHost host, int port) {
        return BDaemonSession.make(host, port);
    }

    protected BDaemonSession(String name, BHost host, int port) {
        super(name, LexiconText.make((String)"platform", (String)"daemon.session"));
        this.host = host;
        this.port = port;
        this.ordInHost = BOrd.make((OrdQuery)new BDaemonScheme.DaemonQuery(port));
        this.absOrd = BOrd.make((BOrd)host.getAbsoluteOrd(), (BOrd)this.ordInHost);
        this.hostProperties = new BHostProperties();
    }

    protected BDaemonSession(String name, BHost host, int port, BOrd ordInHost, LexiconText lexText) {
        super(name, lexText);
        this.host = host;
        this.port = port;
        this.ordInHost = ordInHost;
        this.absOrd = BOrd.make((BOrd)host.getAbsoluteOrd(), (BOrd)this.ordInHost);
        this.hostProperties = new BHostProperties();
    }

    public void close() {
        this.disconnect(true);
        if (this.host.getNavChild(this.getNavName()) != null) {
            this.host.removeNavChild((BINavNode)this);
        }
    }

    public synchronized void connect() throws Exception {
        this.connect(DEFAULT_TIMEOUT);
    }

    public synchronized void connect(int timeout) throws Exception {
        if (!this.isConnected() || Clock.ticks() - this.lastConnectTicks > 300000L) {
            this.acquireCredentials();
            this.initHostProperties(true, timeout);
        }
        this.notifyConnected();
    }

    public synchronized void disconnect() {
        this.disconnect(true);
    }

    public synchronized void disconnect(boolean clearCredentials) {
        if (this.isConnected()) {
            BINavNode[] subs;
            this.lastConnectTicks = 0L;
            this.connected = false;
            this.agentList = null;
            if (clearCredentials && this.authenticator != null) {
                this.cachedAuthorizationHeader = null;
                this.authenticator.setCredentials(null);
            }
            this.hostProperties.reset();
            this.sessionId = null;
            this.sessionKey = null;
            this.sessionCSRFToken = null;
            for (BINavNode bINavNode : subs = super.getNavChildren()) {
                this.removeNavChild(bINavNode);
            }
            if (this.navFactories != null) {
                for (BSessionNavNodeFactory bSessionNavNodeFactory : this.navFactories) {
                    bSessionNavNodeFactory.disconnect();
                    Array<BINavNode> nodes = bSessionNavNodeFactory.getNavNodes();
                    for (int j = 0; j < nodes.size(); ++j) {
                        BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved((BOrd)this.getNavOrd(), (String)((BINavNode)nodes.get(j)).getNavName(), null));
                    }
                }
            }
            if (this.getNavParent() != null) {
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeReplaced((BINavNode)this.getNavParent(), (String)this.getNavName(), null));
            }
            this.notifyDisconnected();
        }
    }

    public BICredentials getCredentials() {
        return this.authenticator == null ? null : this.authenticator.getCredentials();
    }

    public int getPort() {
        return this.port;
    }

    public int getRemotePort() {
        return this.getPort();
    }

    public BHost getRemoteHost() {
        return this.getHost();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public BICredentials makeCredentials() throws ConnectException {
        return this.makeCredentials(DEFAULT_TIMEOUT);
    }

    private void acquireCredentials() {
        Authenticator authenticator = this.getAuthenticator();
        if (authenticator != null) {
            BICredentials credentials;
            if (this.useAuthenticationClient) {
                credentials = this.authenticationClient.requestInformation((AuthenticationRealm)authenticator, "digest", 0, null);
                if (credentials == null) {
                    throw new CancelledAuthenticationException();
                }
            } else {
                credentials = this.manualAuthenticationClientCredentials;
            }
            authenticator.setCredentials(credentials);
        }
    }

    public BICredentials makeCredentials(int timeout) throws ConnectException {
        Authenticator authenticator = this.getAuthenticator(true, timeout);
        if (authenticator != null) {
            return authenticator.makeCredentials();
        }
        return null;
    }

    public void setCredentials(BICredentials cred) {
        try {
            this.setCredentials(cred, false);
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public void setCredentials(BICredentials cred, boolean force) throws ConnectException {
        this.setCredentials(cred, force, DEFAULT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(BICredentials cred, boolean force, int timeout) throws ConnectException {
        BICredentials temp;
        if (cred instanceof BUsernameAndPassword) {
            BUsernameAndPassword uap = (BUsernameAndPassword)cred;
            if (uap.getUsername().trim().isEmpty()) {
                throw new AuthenticationException("No username provided");
            }
            if (uap.getPassword().isDefault()) {
                throw new AuthenticationException("No password provided");
            }
        }
        try {
            this.useAuthenticationClient = false;
            this.manualAuthenticationClientCredentials = cred;
            this.getAuthenticator(force, timeout);
        }
        finally {
            this.manualAuthenticationClientCredentials = null;
            this.useAuthenticationClient = true;
        }
        if (this.authenticator != null && cred != null && (temp = this.authenticator.makeCredentials()).getClass().isAssignableFrom(cred.getClass())) {
            this.authenticator.setCredentials(cred);
            this.clearSessionId();
            this.cachedAuthorizationHeader = null;
        }
    }

    public void setAuthenticationClient(AuthenticationClient client) {
        if (client instanceof SimpleAuthenticationClient && ((SimpleAuthenticationClient)client).usesDefaultPassword()) {
            throw new AuthenticationException("No password provided");
        }
        this.authenticationClient = client;
    }

    public BSessionInfo getSessionInfo() {
        BHost host = this.getHost();
        if (host != null) {
            UserLoginHistory loginHistory = this.getUserLoginHistory();
            if (loginHistory != null) {
                return BSessionInfo.make((String)host.getHostname(), (BAbsTime)this.getLastConnectedAbsTime(), null, (UserLoginHistory)loginHistory, (String)host.getHostname(), (boolean)this.hostProperties.isFips());
            }
            String userName = null;
            if (this.getCredentials() instanceof BIUserCredentials) {
                userName = ((BIUserCredentials)this.getCredentials()).getUsername();
            }
            return BSessionInfo.make((String)host.getHostname(), (BAbsTime)this.getLastConnectedAbsTime(), null, (String)userName, (String)host.getHostname(), (boolean)this.hostProperties.isFips());
        }
        return null;
    }

    protected BAbsTime getLastConnectedAbsTime() {
        return BAbsTime.make((long)this.lastConnectedTime);
    }

    protected UserLoginHistory getUserLoginHistory() {
        UserLoginHistory loginHistory = null;
        try (InputStream in = this.getInputStream((DaemonMessage)new GetUserLoginHistoryMessage(), "application/json");){
            JSONObject jsonHistory = new JSONObject(new JSONTokener(in));
            loginHistory = new UserLoginHistory(jsonHistory, 100);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "error retrieving login history", e);
        }
        if (loginHistory != null && loginHistory.getPreviousLoginEntry() != null) {
            UserLoginEntry entry = loginHistory.getPreviousLoginEntry();
            if (log.isLoggable(Level.FINE)) {
                log.fine("previous login for " + loginHistory.getUserName() + " was from " + entry.getLocation() + " at " + entry.getTimestamp() + " as " + entry.getFriendlyClient());
            }
        }
        return loginHistory;
    }

    public BOrd getAbsoluteOrd() {
        return this.absOrd;
    }

    public BHost getHost() {
        return this.host;
    }

    public BINavNode getNavChild(String navName) {
        if (!this.isConnected()) {
            return null;
        }
        BSessionNavNode result = this.getNavNode(navName);
        return result == null ? super.getNavChild(navName) : result;
    }

    public BINavNode[] getNavChildren() {
        if (!this.isConnected()) {
            return new BINavNode[0];
        }
        if (Sys.getStation() == null) {
            if (this.navFactories == null) {
                this.navFactories = BSessionNavNodeFactory.makeFor((BISession)this);
            }
            this.getFileSpace();
            Array result = new Array(BINavNode.class);
            for (BSessionNavNodeFactory navFactory : this.navFactories) {
                result.addAll(navFactory.getNavNodes());
            }
            result = result.sort(BSessionNavNodeFactory.NAV_NODE_COMPARATOR);
            result.addAll((Object[])super.getNavChildren());
            return (BINavNode[])result.trim();
        }
        this.getFileSpace();
        return super.getNavChildren();
    }

    public String getNavDisplayName(Context cx) {
        String displayName = null;
        if (cx != null) {
            try {
                BOrd tabOrd;
                OrdQuery[] query;
                String bodyOrd;
                BBoolean tabNameValue = (BBoolean)cx.getFacet("tabName");
                if (tabNameValue.getBoolean() && (bodyOrd = (query = (tabOrd = (BOrd)cx.getFacet("ord")).parse())[query.length - 1].getBody()) != null && bodyOrd.length() > 0) {
                    BTypeSpec specification = BTypeSpec.make((String)bodyOrd);
                    displayName = specification.getResolvedType().getDisplayName(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (displayName == null) {
            displayName = this.port == this.getDefaultPort() ? this.getLexiconValue("navDisplayName", new Object[]{super.getNavDisplayName(cx)}) : this.getLexiconValue("navDisplayNameWithPort", new Object[]{super.getNavDisplayName(cx), String.valueOf(this.port)});
        }
        return displayName;
    }

    protected String getLexiconPrefix() {
        return "DaemonSession.";
    }

    private String getLexiconValue(String property) {
        return this.getLexiconValue(property, null);
    }

    private String getLexiconValue(String property, Object[] params) {
        if (params == null) {
            return this.getLexicon().getText(this.getLexiconPrefix() + property);
        }
        return this.getLexicon().getText(this.getLexiconPrefix() + property, params);
    }

    public BSessionNavNode getNavNode(String targetNavName) {
        if (Sys.getStation() == null) {
            if (this.navFactories == null) {
                this.navFactories = BSessionNavNodeFactory.makeFor((BISession)this);
            }
            BSessionNavNode result = null;
            for (int i = 0; result == null && i < this.navFactories.length; ++i) {
                result = this.navFactories[i].getNavNode(targetNavName);
            }
            return result;
        }
        return null;
    }

    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public boolean hasNavChildren() {
        return this.isConnected();
    }

    public String getAddressString() {
        return this.getAddressString(this.getHost(), this.getPort());
    }

    public String getRemoteAddressString() {
        return this.getAddressString(this.getRemoteHost(), this.getRemotePort());
    }

    public String getAddressString(BHost host, int port) {
        if (port == -1 || port == this.getDefaultPort()) {
            return host.getHostname();
        }
        return host.getHostname() + ":" + port;
    }

    protected int getDefaultPort() {
        return 3011;
    }

    public static void processException(Throwable e) throws ConnectException {
        BDaemonSession.processException(e, (RuntimeException)new BajaRuntimeException(e));
    }

    public static void processException(Throwable e, RuntimeException defaultRuntime) throws ConnectException {
        if (!(e instanceof PrivilegedActionException)) {
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            if (e instanceof SocketException) {
                throw new DaemonConnectException(e, false);
            }
            if (e instanceof EOFException) {
                throw new DaemonConnectException(e, true);
            }
            if (e instanceof InterruptedIOException) {
                throw new DaemonConnectException(e, false);
            }
            if (e instanceof UnknownHostException) {
                throw new DaemonConnectException(e, true);
            }
            if (e instanceof SSLException || e instanceof TlsException) {
                Throwable summaryCause = e;
                while (summaryCause.getCause() != null && (summaryCause.getCause() instanceof SSLException || summaryCause.getCause() instanceof TlsException)) {
                    summaryCause = summaryCause.getCause();
                }
                if (summaryCause.getCause() != null && summaryCause.getCause() instanceof CertificateException) {
                    summaryCause = summaryCause.getCause();
                }
                throw new DaemonConnectException(e, summaryCause, true);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw defaultRuntime;
        }
        BDaemonSession.processException(e.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInit() {
        if (this.inInit) {
            Object object = this.initializing;
            synchronized (object) {
            }
        }
    }

    public boolean usesLocalNiagaraHome() {
        this.waitForInit();
        return this.localNiagaraHome;
    }

    public boolean usesLocalNiagaraUserHome() {
        this.waitForInit();
        return this.localNiagaraUserHome;
    }

    public synchronized BHostProperties getHostProperties() {
        return this.getHostProperties(DEFAULT_TIMEOUT);
    }

    public synchronized BHostProperties getHostProperties(int timeout) {
        if (this.isConnected()) {
            try {
                this.initHostProperties(false, timeout);
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
        }
        return this.hostProperties;
    }

    private void initHostProperties(boolean force) throws AuthenticationException, ConnectException {
        this.initHostProperties(force, DEFAULT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHostProperties(boolean force, int timeout) throws AuthenticationException, ConnectException {
        if (this.inInit) {
            return;
        }
        Object object = this.initializing;
        synchronized (object) {
            block35: {
                this.inInit = true;
                try {
                    if (!force && !this.hostProperties.getIsDirty()) break block35;
                    HttpConnection conn = this.getConnection("/platformInfo", "GET", -1L, timeout, null, 1);
                    this.hostProperties.setIsDirty(false);
                    try {
                        XElem platformInfoElem = XParser.make((InputStream)conn.getInputStream()).parse();
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.hostProperties.load(platformInfoElem);
                        try {
                            if (new Version(this.hostProperties.getDaemonVersion()).compareTo(new Version("4.3")) >= 0) {
                                this.cachedAuthorizationHeader = null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            conn = this.getConnection("/servlets", "GET", -1L, timeout, null, 1);
                            XElem servletsElem = XParser.make((InputStream)conn.getInputStream()).parse();
                            this.hostProperties.loadServletsInfo(servletsElem);
                        }
                        catch (Exception e) {
                            BDaemonSession.processException(e, (RuntimeException)new LocalizableRuntimeException("platform", "DaemonSession.exception.badServletInfo", new Object[]{this.getAddressString()}, (Throwable)e));
                        }
                        finally {
                            try {
                                conn.close();
                            }
                            catch (Exception e) {}
                        }
                        if (this.hostProperties.getHostId().equals(Nre.getHostId()) && this.hostProperties.isNiagara4()) {
                            if (Sys.getStation() != null && IPAddressUtil.isNumericAddr((String)conn.getRemoteHost()) && InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)conn.getRemoteHost())).isLoopbackAddress()) {
                                this.localNiagaraHome = true;
                                this.localNiagaraUserHome = true;
                            } else {
                                String localPath;
                                String remotePath;
                                XElem elem;
                                boolean isWin32 = OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows);
                                InputStream in = this.getInputStream((DaemonMessage)new GetDirectoryMessage("/niagara", false, false, true), timeout);
                                if (in == null) {
                                    throw new ConnectException("Cannot connect to remote host");
                                }
                                try {
                                    elem = XParser.make((InputStream)in).parse();
                                    remotePath = elem.get("path").replace('/', File.separatorChar);
                                    localPath = Nre.getNiagaraHome().getAbsolutePath().replace('/', File.separatorChar);
                                    this.localNiagaraHome = isWin32 ? localPath.equalsIgnoreCase(remotePath) : localPath.equals(remotePath);
                                }
                                catch (Exception e) {
                                    BDaemonSession.processException(e);
                                }
                                in = this.getInputStream((DaemonMessage)new GetDirectoryMessage("/niagara_user", false, false, true), timeout);
                                if (in == null) {
                                    throw new ConnectException("Cannot connect to remote host");
                                }
                                try {
                                    elem = XParser.make((InputStream)in).parse();
                                    remotePath = elem.get("path").replace('/', File.separatorChar);
                                    localPath = Sys.getNiagaraUserHome().getAbsolutePath().replace('/', File.separatorChar);
                                    this.localNiagaraUserHome = isWin32 ? localPath.equalsIgnoreCase(remotePath) : localPath.equals(remotePath);
                                }
                                catch (Exception e) {
                                    BDaemonSession.processException(e);
                                }
                            }
                        } else {
                            this.localNiagaraHome = false;
                            this.localNiagaraUserHome = false;
                        }
                        this.doConnected();
                    }
                    catch (Exception e) {
                        this.hostProperties.reset();
                        BDaemonSession.processException(e, (RuntimeException)new LocalizableRuntimeException("platform", "DaemonSession.exception.badHostInfo", new Object[]{this.getAddressString()}, (Throwable)e));
                    }
                }
                finally {
                    this.inInit = false;
                }
            }
        }
    }

    public void reloadHostProperties(int timeout) throws AuthenticationException, ConnectException {
        this.hostProperties.reset();
        this.initHostProperties(true, timeout);
    }

    public void reloadHostProperties() throws AuthenticationException, ConnectException {
        this.reloadHostProperties(DEFAULT_TIMEOUT);
    }

    public BHostProperties updateHostProperties() {
        return this.updateHostProperties(DEFAULT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BHostProperties updateHostProperties(int timeout) {
        block18: {
            try {
                boolean mustLoad = !this.hostProperties.getIsDirty();
                this.initHostProperties(false);
                if (!mustLoad) break block18;
                HttpConnection conn = this.getConnection("/platformInfo", "GET", -1L, DEFAULT_TIMEOUT, null, 1);
                try {
                    XElem platformInfoElem = XParser.make((InputStream)conn.getInputStream()).parse();
                    this.getHostProperties().update(platformInfoElem);
                    try {
                        if (new Version(this.getHostProperties().getDaemonVersion()).compareTo(new Version("4.3")) >= 0) {
                            this.cachedAuthorizationHeader = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                    try {
                        BDaemonSession.processException(e);
                    }
                    catch (ConnectException connectException) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
        }
        return this.hostProperties;
    }

    public BDefaultDaemonFileSpace getFileSpace() {
        if (this.bootstrapFileSpace != null) {
            log.fine("getFileSpace using bootstrap file space");
            return this.bootstrapFileSpace;
        }
        BDefaultDaemonFileSpace result = (BDefaultDaemonFileSpace)this.getNavChild("file");
        if (result == null) {
            if (this == AccessController.doPrivileged(LocalSessionUtil::getLocalSession)) {
                result = new BDefaultDaemonFileSpace();
                this.addNavChild((BINavNode)result);
                return result;
            }
            return (BDefaultDaemonFileSpace)BOrd.make((String)"file:").get((BObject)this);
        }
        return result;
    }

    @Deprecated
    public void setBootstrapFileSpace(BDefaultDaemonFileSpace bootstrapFileSpace) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setBootstrapFileSpace called with file space: " + (Object)((Object)bootstrapFileSpace));
        }
        this.bootstrapFileSpace = bootstrapFileSpace;
    }

    public String getErrorText(XmlResponseMessage msg) throws Exception {
        this.sendMessages(new XmlResponseMessage[]{msg}, DEFAULT_TIMEOUT);
        return msg.getErrorMessage();
    }

    public boolean sendMessage(Consumer<Localizable> messageConsumer, XmlResponseMessage msg) throws Exception {
        return this.sendMessage(messageConsumer, msg, DEFAULT_TIMEOUT);
    }

    public boolean sendMessage(Consumer<Localizable> messageConsumer, XmlResponseMessage msg, int timeout) throws Exception {
        try {
            Stream in = (Stream)this.getInputStream((DaemonMessage)msg, timeout);
            if (in.getContentType() != null && in.getContentType().equals("text/xml")) {
                msg.setResponse(XParser.make((InputStream)in).parse());
            } else {
                msg.setResponse(new XElem("success"));
                in.close();
            }
        }
        catch (DaemonResponseException dre) {
            msg.setErrorMessage(dre.getMessage());
        }
        String text = msg.getErrorMessage();
        if (text == null) {
            return true;
        }
        if (messageConsumer != null) {
            messageConsumer.accept(Localizable.fromLiteral((String)text));
        }
        return false;
    }

    public InputStream getInputStream(DaemonMessage message) throws ConnectException, AuthenticationException {
        this.verifySharedSecretKey(message);
        String messageURI = this.prepareMessageUri(message);
        return this.getInputStream(messageURI, DEFAULT_TIMEOUT, null, null, message.getConnectionFlags());
    }

    public XElem post(DaemonMessage message) throws Exception {
        if (message != null && message.getMethod().equals("POST")) {
            this.verifySharedSecretKey(message);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            message.write(output);
            String messageURI = this.prepareMessageUri(message);
            HttpConnection conn = this.getConnection(messageURI, message.getMethod(), output.size(), DEFAULT_TIMEOUT, null, 32);
            if (conn != null) {
                OutputStream out = conn.getOutputStream();
                out.write(output.toByteArray());
                out.flush();
                int rc = conn.postComplete();
                if (rc == 500) {
                    return null;
                }
                String contentType = conn.getContentType();
                XElem root = "text/xml".equals(contentType) ? XParser.make((InputStream)conn.getInputStream()).parse() : new XElem("success");
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return root;
            }
        }
        return null;
    }

    public InputStream getInputStream(DaemonMessage message, int timeout) throws ConnectException, AuthenticationException {
        this.verifySharedSecretKey(message);
        String messageURI = this.prepareMessageUri(message);
        return this.getInputStream(messageURI, timeout, null, null, message.getConnectionFlags());
    }

    public InputStream getInputStream(DaemonMessage message, String requiredMime) throws ConnectException, AuthenticationException {
        this.verifySharedSecretKey(message);
        String messageURI = this.prepareMessageUri(message);
        return this.getInputStream(messageURI, DEFAULT_TIMEOUT, requiredMime, null, message.getConnectionFlags());
    }

    public InputStream getInputStream(DaemonMessage message, int timeout, String requiredMime) throws ConnectException, AuthenticationException {
        this.verifySharedSecretKey(message);
        String messageURI = this.prepareMessageUri(message);
        return this.getInputStream(messageURI, timeout, requiredMime, null, message.getConnectionFlags());
    }

    public InputStream getInputStream(DaemonMessage message, int timeout, String requiredMime, HttpConnection connection) throws ConnectException, AuthenticationException {
        this.verifySharedSecretKey(message);
        String messageURI = this.prepareMessageUri(message);
        return this.getInputStream(messageURI, timeout, requiredMime, connection, message.getConnectionFlags());
    }

    public InputStream getInputStream(String messageString, int timeout, String requiredMime, HttpConnection connection) throws ConnectException, AuthenticationException {
        return this.getInputStream(messageString, timeout, requiredMime, connection, 0);
    }

    public InputStream getInputStream(String messageString, int timeout, String requiredMime, HttpConnection connection, int connectionFlags) throws ConnectException, AuthenticationException {
        connection = this.getConnection(messageString, "GET", -1L, timeout, connection, connectionFlags);
        try {
            if (connection == null) {
                return null;
            }
            String contentType = connection.getResponseHeader("Content-Type");
            if (!(requiredMime == null || contentType != null && contentType.equals(requiredMime))) {
                connection.close();
                return null;
            }
            return new Stream(connection);
        }
        catch (Exception e) {
            if (connection != null) {
                connection.close();
            }
            log.log(Level.SEVERE, "error sending message to daemon", e);
            return null;
        }
    }

    protected SslContextFactory getWebSocketSslContextFactory() {
        return null;
    }

    protected boolean useTlsWebSockets() {
        return false;
    }

    public final InputStream getWebSocketInputStream(GetOutputMessage message, int connectTimeout, int readTimeout) {
        SslContextFactory factory = this.getWebSocketSslContextFactory();
        boolean tlsWebSockets = this.useTlsWebSockets();
        if (tlsWebSockets && factory == null || !tlsWebSockets && factory != null) {
            log.severe("Error creating websocket session");
            return null;
        }
        String host = this.getRemoteHost().getHostname();
        int port = this.getRemotePort();
        if (IPAddressUtil.isIpv6Address((String)host) || IPAddressUtil.isIpv4MappedAddress((String)host)) {
            host = "[" + host + "]";
        }
        String messageURI = tlsWebSockets ? message.getMessageString() : this.prepareMessageUri(message);
        WebSocketClient[] webSocketClient = new WebSocketClient[]{null};
        HttpClient[] httpClient = new HttpClient[]{null};
        try {
            Future fut;
            this.verifySharedSecretKey(message);
            HttpConnection connection = this.getConnection(messageURI, message.getMethod(), -1L, connectTimeout, null, message.getConnectionFlags());
            String authorizationHeader = connection.getRequestHeader("Authorization");
            String upgradeRequestToken = null;
            XElem upgradeRequestTokenElem = XParser.make((InputStream)connection.getInputStream()).parse();
            if (upgradeRequestTokenElem != null) {
                upgradeRequestToken = upgradeRequestTokenElem.get("token", null);
            }
            connection.close();
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            if (authorizationHeader != null && upgradeRequestToken == null) {
                request.setHeader("Authorization", authorizationHeader);
            } else if (upgradeRequestToken != null) {
                request.setHeader("UpgradeRequestToken", upgradeRequestToken);
            } else {
                return null;
            }
            String niagaraUserAgent = "Niagara/" + AccessController.doPrivileged(Nre::getModuleManager).getModuleForClass(HttpConnection.class).getVendorVersion();
            request.setHeader("User-Agent", niagaraUserAgent);
            try {
                webSocketClient[0] = AccessController.doPrivileged(() -> {
                    httpClient[0] = new HttpClient(factory);
                    httpClient[0].setUserAgentField(new HttpField(HttpHeader.USER_AGENT, niagaraUserAgent));
                    httpClient[0].setExecutor((Executor)wsExecutorService);
                    httpClient[0].setConnectTimeout((long)connectTimeout);
                    httpClient[0].setMaxConnectionsPerDestination(1);
                    httpClient[0].start();
                    return new WebSocketClient(httpClient[0]);
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            webSocketClient[0].setStopAtShutdown(true);
            OutputServlet.updatePolicy((boolean)false, (WebSocketPolicy)webSocketClient[0].getPolicy());
            webSocketClient[0].start();
            OutputSocket socket = new OutputSocket();
            socket.setLogger(socketLog);
            socket.setFollowed(message.getFollow());
            String authority = tlsWebSockets ? "wss://" : "ws://";
            URI uri = URI.create(authority + host + ":" + port + "/" + messageURI);
            try {
                fut = AccessController.doPrivileged(() -> webSocketClient[0].connect((Object)socket, uri, request));
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            fut.get();
            if (!message.getFollow()) {
                readTimeout = 5000;
            }
            return socket.getInputStream((long)readTimeout, webSocketClient[0]);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error creating websocket session", t);
            try {
                webSocketClient[0].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                httpClient[0].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public OutputStream getOutputStream(DaemonMessage message, long contentLength, ICancelHint cancelHint) throws ConnectException, AuthenticationException {
        return this.getOutputStream(message, contentLength, DEFAULT_TIMEOUT, cancelHint);
    }

    public OutputStream getOutputStream(DaemonMessage message, long contentLength, int timeout, ICancelHint cancelHint) throws ConnectException, AuthenticationException {
        if (BDaemonSession.canceled(cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        this.verifySharedSecretKey(message);
        String messageURI = this.prepareMessageUri(message);
        HttpConnection connection = this.getConnection(messageURI, "POST", contentLength, timeout, null, 32);
        try {
            return connection == null ? null : new PostOutputStream(connection, cancelHint);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error posting message to daemon", e);
            return null;
        }
    }

    public boolean sendMessage(DaemonMessage message) throws ConnectException, AuthenticationException {
        this.verifySharedSecretKey(message);
        String messageURI = this.prepareMessageUri(message);
        return this.sendMessage(messageURI, message.getMethod(), DEFAULT_TIMEOUT, message.getConnectionFlags());
    }

    public boolean sendMessage(DaemonMessage message, int timeout) throws ConnectException, AuthenticationException {
        this.verifySharedSecretKey(message);
        String messageURI = this.prepareMessageUri(message);
        return this.sendMessage(messageURI, message.getMethod(), timeout, message.getConnectionFlags());
    }

    public synchronized XmlResponseMessage[] sendMessages(XmlResponseMessage[] messages, int timeout) throws Exception {
        if (this.getHostProperties().supportsServlet("batch") && messages.length != 1) {
            StringBuilder contentBuilder = new StringBuilder();
            int flags = 32;
            for (XmlResponseMessage message : messages) {
                String messageURI = this.prepareMessageUri(message);
                contentBuilder.append("/");
                contentBuilder.append(messageURI);
                contentBuilder.append("\r\n");
                flags |= message.getConnectionFlags();
            }
            contentBuilder.append("\r\n");
            HttpConnection connection = this.getConnection("batch", "POST", contentBuilder.length(), timeout, null, flags);
            connection.getOutputStream().write(contentBuilder.toString().getBytes());
            connection.postComplete();
            XElem[] responseElements = XParser.make((InputStream)connection.getInputStream()).parse().elems();
            connection.close();
            for (int i = 0; i < responseElements.length; ++i) {
                messages[i].setResponse(responseElements[i]);
            }
        } else {
            for (XmlResponseMessage message : messages) {
                try {
                    Stream in = (Stream)this.getInputStream((DaemonMessage)message, timeout);
                    if (in.getContentType() != null && in.getContentType().equals("text/xml")) {
                        message.setResponse(XParser.make((InputStream)in).parse());
                        continue;
                    }
                    message.setResponse(new XElem("success"));
                    in.close();
                }
                catch (DaemonResponseException dre) {
                    message.setErrorMessage(dre.getMessage());
                }
            }
        }
        return messages;
    }

    public synchronized boolean sendRebootRequest() throws AuthenticationException {
        return this.sendRebootRequest(true);
    }

    public synchronized void sendForceRebootRequest() throws AuthenticationException {
        if (!this.getHostProperties().supportsServlet("reboot")) {
            return;
        }
        if (AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.daemonsession.bypassReboot")).booleanValue()) {
            this.disconnect(true);
        } else {
            try {
                String messageURI = this.prepareMessageUri(forceRebootMessage);
                this.sendMessage(messageURI, forceRebootMessage.getMethod(), 0, forceRebootMessage.getConnectionFlags());
                this.disconnect(true);
            }
            catch (SocketException se) {
                this.disconnect(true);
            }
        }
    }

    public synchronized boolean sendRebootRequest(boolean clearCredentials) throws AuthenticationException {
        if (!this.getHostProperties().supportsServlet("reboot")) {
            BPlatform.log.fine("sendRebootRequest returning false: reboot servlet not supported");
            return false;
        }
        if (AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.daemonsession.bypassReboot")).booleanValue()) {
            BPlatform.log.fine("sendRebootRequest returning true: bypassReboot property set");
            this.disconnect(clearCredentials);
            return true;
        }
        try {
            String messageURI = this.prepareMessageUri(rebootMessage);
            if (this.sendMessage(messageURI, rebootMessage.getMethod(), 0, rebootMessage.getConnectionFlags())) {
                BPlatform.log.fine("sendRebootRequest returning true: request succeeded");
                this.disconnect(clearCredentials);
                return true;
            }
            BPlatform.log.fine("sendRebootRequest returning false: request failed");
            return false;
        }
        catch (DaemonResponseException dre) {
            if (dre.responseCode == 409) {
                BPlatform.log.fine("sendRebootRequest returning false: received SC_CONFLICT response");
                return false;
            }
            throw dre;
        }
        catch (SocketException se) {
            BPlatform.log.fine("sendRebootRequest returning true: encountered SocketException");
            this.disconnect(clearCredentials);
            return true;
        }
    }

    public String getAuthenticationRealmName() {
        return this.authenticator == null ? null : this.authenticator.getAuthenticationRealmName();
    }

    private Authenticator getAuthenticator() {
        try {
            return this.getAuthenticator(false, DEFAULT_TIMEOUT);
        }
        catch (ConnectException ce) {
            return null;
        }
    }

    private Authenticator getAuthenticator(boolean force, int timeout) throws ConnectException {
        if (this.authenticator == null && force) {
            try {
                this.sendMessage("/", "GET", timeout, 2);
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
        }
        return this.authenticator;
    }

    private void initAuthenticator(HttpConnection conn) throws ConnectException {
        try {
            this.authenticator = Authenticator.make(this.getAuthenticator(), this.getHost(), this.getPort(), this.getAbsoluteOrd().toString(), conn);
        }
        catch (IllegalArgumentException iae) {
            throw new ConnectException(iae.getMessage());
        }
    }

    public boolean validateSystemPassPhrase(PBEValidator validator) throws ConnectException {
        HttpConnection conn = this.getConnection(this.getFileSpace().filePathToUri(new FilePath("!")) + "?transaction=validateEncoding&encodingValidator=" + validator.getEncodedValidator(), "HEAD", DEFAULT_TIMEOUT);
        return Boolean.parseBoolean(conn.getResponseHeader("Validation-Result"));
    }

    private static String getBrandId() {
        if (brandIdHolder == null) {
            try {
                Feature platformClientFeature = Sys.getLicenseManager().checkFeature("tridium", "platformClient");
                brandIdHolder = platformClientFeature.getb("useBrand", true) ? new String[]{Brand.getBrandId()} : new String[]{null};
            }
            catch (FeatureNotLicensedException featureNotLicensedException) {
                brandIdHolder = new String[]{Brand.getBrandId()};
            }
        }
        return brandIdHolder[0];
    }

    private static void addBrandHeader(HttpConnection conn) {
        String b = BDaemonSession.getBrandId();
        if (b != null) {
            if (Sys.getStation() == null) {
                conn.setRequestHeader("Baja-Wb-Brand", b);
            } else {
                conn.setRequestHeader("Baja-Station-Brand", b);
            }
        }
    }

    private static void checkServerBrand(HttpConnection conn) {
        String serverBrand;
        if (BDaemonSession.getBrandId() != null && (serverBrand = conn.getResponseHeader("Baja-Station-Brand")) != null && serverBrand.trim().length() > 0) {
            if (Sys.getStation() == null) {
                Brand.checkWbOut((String)serverBrand);
            } else {
                Brand.checkStationOut((String)serverBrand);
            }
        }
    }

    private void doConnected() {
        if (!this.isConnected()) {
            this.agentList = null;
            this.connected = true;
            this.lastConnectedTime = Clock.millis();
            if (this.navFactories != null) {
                Array nodes = new Array(BINavNode.class);
                for (BSessionNavNodeFactory navFactory : this.navFactories) {
                    navFactory.connect();
                    nodes.addAll(navFactory.getNavNodes());
                }
                nodes = nodes.sort(BSessionNavNodeFactory.NAV_NODE_COMPARATOR);
                for (int i = 0; i < nodes.size(); ++i) {
                    BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)this.getNavOrd(), (String)((BINavNode)nodes.get(i)).getNavName(), null));
                }
            }
        }
        this.lastConnectTicks = Clock.ticks();
    }

    boolean sendMessage(String path, int timeout) throws ConnectException, AuthenticationException {
        return this.sendMessage(path, "GET", timeout, 0);
    }

    boolean sendMessage(String path, String method, int timeout) throws ConnectException, AuthenticationException {
        return this.sendMessage(path, method, timeout, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendMessage(String path, String method, int timeout, int connectionFlags) throws ConnectException, AuthenticationException {
        HttpConnection connection = this.getConnection(path, method, -1L, timeout, null, connectionFlags);
        if (connection == null) {
            return false;
        }
        try {
            byte[] buf = new byte[1024];
            BufferedInputStream is = new BufferedInputStream(connection.getInputStream());
            while (is.read(buf, 0, 1024) > 0) {
            }
        }
        catch (Exception e) {
            BDaemonSession.processException(e);
        }
        finally {
            connection.close();
        }
        return true;
    }

    protected synchronized HttpConnection getConnection(String pPath, String pMethod, int timeout) throws ConnectException, AuthenticationException {
        return this.getConnection(pPath, pMethod, -1L, timeout, null, 0);
    }

    protected synchronized HttpConnection getConnection(String pPath, String pMethod, int timeout, HttpConnection conn) throws ConnectException, AuthenticationException {
        return this.getConnection(pPath, pMethod, -1L, timeout, conn, 0);
    }

    protected synchronized HttpConnection getConnection(String pPath, String pMethod, long contentLength, int timeout) throws ConnectException, AuthenticationException {
        return this.getConnection(pPath, pMethod, contentLength, timeout, null, 0);
    }

    protected synchronized HttpConnection getConnection(String pPath, String pMethod, long contentLength, int timeout, HttpConnection conn) throws ConnectException, AuthenticationException {
        return this.getConnection(pPath, pMethod, contentLength, timeout, conn, 0);
    }

    protected synchronized HttpConnection getConnection(String pPath, String pMethod, long contentLength, int timeout, HttpConnection conn, int connectionFlags) throws ConnectException, AuthenticationException {
        int rc = -1;
        String uri = pPath.charAt(0) == '/' ? pPath : '/' + pPath;
        boolean authSet = false;
        RequestRetryCriteria retryCriteria = RequestRetryCriteria.NO_RETRY_CONNECTION;
        int connectionRetries = 0;
        this.allowTokenRotation = true;
        long t0 = Clock.ticks();
        if (log.isLoggable(Level.FINE)) {
            log.fine("getConnection " + this.host + " " + this.port + " " + pMethod + " " + uri + " (" + timeout + ")");
        }
        if (uri.contains(CSRF_TOKEN_KEY) && !uri.contains(HttpUtil.encodeUrl((String)this.sessionCSRFToken))) {
            String oldTokenQuery = null;
            String query = uri.substring(uri.indexOf(63) + 1);
            String[] queryItems = TextUtil.split((String)query, (char)'&');
            for (int i = queryItems.length - 1; i >= 0; --i) {
                if (!queryItems[i].startsWith(CSRF_TOKEN_KEY)) continue;
                oldTokenQuery = queryItems[i];
                break;
            }
            if (oldTokenQuery != null) {
                uri = uri.replace(oldTokenQuery, "csrfToken=" + HttpUtil.encodeUrl((String)this.sessionCSRFToken));
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("getConnection " + this.host + " " + this.port + " " + pMethod + " request used old CSRF token, updated uri to " + uri);
                }
            }
        }
        while (true) {
            String sessionTimestamp;
            if (retryCriteria.retryUri != null) {
                uri = retryCriteria.retryUri;
            }
            try {
                if (conn == null || conn.shouldClose()) {
                    String previousAuthorizationHeader = null;
                    if (conn != null && conn.shouldClose() && retryCriteria.retryConnection) {
                        authSet = this.setAuthOnConnection(conn, uri);
                        Authenticator authenticator = this.getAuthenticator();
                        if (authenticator != null && authenticator.canReuseAuthorizationHeader()) {
                            previousAuthorizationHeader = conn.getRequestHeader("Authorization");
                        }
                    }
                    conn = this.createNewConnection(pMethod, contentLength, timeout, connectionFlags, uri);
                    if (this.reuseSession) {
                        this.updateSessionId(conn, uri);
                        if (this.sessionId != null) {
                            String sessionIdHeaderValue;
                            String string = sessionIdHeaderValue = this.sessionId.endsWith(";") ? this.sessionId.substring(0, this.sessionId.indexOf(";")) : this.sessionId;
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("getConnection " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " requesting session \"" + SecurityUtil.calculateSessionIdHash((String)sessionIdHeaderValue.substring(sessionIdHeaderValue.indexOf(61) + 1)) + "\"");
                            }
                            conn.setRequestHeader("Cookie", sessionIdHeaderValue);
                        } else {
                            conn.removeRequestHeader("Cookie");
                        }
                    } else {
                        conn.removeRequestHeader("Cookie");
                    }
                    this.reuseSession = true;
                    if (this.sessionId == null && this.cachedAuthorizationHeader != null) {
                        this.setAuthOnConnection(conn, uri);
                    } else if (this.sessionId == null && previousAuthorizationHeader != null) {
                        conn.setRequestHeader("Authorization", previousAuthorizationHeader);
                    }
                    rc = this.connect(conn);
                    if (rc == 302) {
                        this.redirect(pMethod, conn, rc, uri);
                    }
                } else {
                    authSet = this.setAuthOnConnection(conn, uri);
                    if (this.reuseSession) {
                        this.updateSessionId(conn, uri);
                        if (this.sessionId != null) {
                            String sessionIdHeaderValue;
                            String string = sessionIdHeaderValue = this.sessionId.endsWith(";") ? this.sessionId.substring(0, this.sessionId.indexOf(";")) : this.sessionId;
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("getConnection " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " requesting session \"" + SecurityUtil.calculateSessionIdHash((String)sessionIdHeaderValue.substring(sessionIdHeaderValue.indexOf(61) + 1)) + "\"");
                            }
                            conn.setRequestHeader("Cookie", sessionIdHeaderValue);
                        } else {
                            conn.removeRequestHeader("Cookie");
                        }
                    } else {
                        conn.removeRequestHeader("Cookie");
                    }
                    this.reuseSession = true;
                    this.addHeaders(pMethod, contentLength, timeout, conn, connectionFlags);
                    rc = this.sendNewRequest(conn, rc, uri);
                }
            }
            catch (SocketException se) {
                if (!(se instanceof DaemonConnectException) || !((DaemonConnectException)se).isFatal()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "socket exception", se);
                    }
                    if (connectionRetries < 1) {
                        String hostString = this.getHost().toString();
                        if (hostString.contains(":")) {
                            hostString = "[" + hostString + "]";
                        }
                        if (!this.inReconnect) {
                            log.warning("connection failed, retrying " + pMethod + " " + pPath + " at " + hostString + ":" + this.getPort() + " (" + timeout + " ms timeout)");
                        }
                        ++connectionRetries;
                        continue;
                    }
                }
                this.handleRetriesExceeded(conn, uri, t0, se);
            }
            catch (Exception e) {
                this.handleConnectionException(pMethod, conn, uri, t0, e);
            }
            boolean validateResponse = true;
            if ((connectionFlags & 0x20) != 0 && conn.getStatusCode() == 100) {
                validateResponse = false;
            }
            if (validateResponse) {
                this.validateResponse(conn, uri, t0);
            }
            if ((sessionTimestamp = conn.getResponseHeader("Niagara-Started")) != null) {
                this.hostProperties.checkTimestamp(sessionTimestamp);
            }
            if (this.isSuccessResponseCode(rc)) {
                this.handleSessionMetadata(conn, uri);
                this.handleConnectionFlags(pMethod, connectionFlags, uri, t0);
                return conn;
            }
            retryCriteria = this.handleErrorResponses(pMethod, conn, connectionFlags, rc, uri, authSet, t0);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("getConnection " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " initially failed, retry criteria [ " + retryCriteria.retryConnection + " / '" + BDaemonSession.truncateWithEllipsis(retryCriteria.retryUri) + "' ]");
            }
            if (!retryCriteria.retryConnection) break;
        }
        return null;
    }

    private void handleSessionMetadata(HttpConnection conn, String uri) {
        byte[] extractedSessionKey;
        Authenticator authenticator;
        String authHeader = conn.getRequestHeader("Authorization");
        if (authHeader != null && (authenticator = this.getAuthenticator()) != null && authenticator.canReuseAuthorizationHeader()) {
            this.cachedAuthorizationHeader = Authenticator.parseHeader(conn, authHeader);
        }
        this.updateSessionId(conn, uri);
        if (conn.getResponseHeader("DaemonCSRFToken") != null) {
            String csrfToken = conn.getResponseHeader("DaemonCSRFToken");
            this.sessionCSRFToken = null;
            this.updateSessionCsrfToken(csrfToken, conn, uri);
        }
        if ((authenticator = this.getAuthenticator()) != null && authenticator.supportsSecureKeyExchange() && (extractedSessionKey = authenticator.extractSessionKey()) != null) {
            try (SecretBytes secret = new SecretBytes(extractedSessionKey, true);){
                this.sessionKey = new SessionKey(secret, authenticator.getEncryptionAlgorithmBundle());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("handleSessionMetadata " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " created a new session key from metadata");
                }
            }
        }
        this.allowTokenRotation = true;
    }

    private void updateSessionId(HttpConnection conn, String uri) {
        boolean forceSessionKeyUpdate = false;
        Properties sessionCookie = Authenticator.parseHeader(conn, "Set-Cookie");
        if (sessionCookie != null) {
            String cookieValue = sessionCookie.getProperty("NIAGARA_DAEMON_SESSION_ID");
            if (cookieValue != null) {
                String newSessionId = "NIAGARA_DAEMON_SESSION_ID=" + cookieValue;
                if (!newSessionId.equals(this.sessionId)) {
                    if (this.sessionId != null && log.isLoggable(Level.FINEST)) {
                        log.finest("updateSessionId " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " replacing session cookie \"" + SecurityUtil.calculateSessionIdHash((String)this.sessionId) + "\"...");
                    }
                    this.sessionId = newSessionId;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("updateSessionId " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " now using session cookie \"" + SecurityUtil.calculateSessionIdHash((String)this.sessionId) + "\"");
                    }
                }
            } else {
                String newSessionId;
                cookieValue = sessionCookie.getProperty("JSESSIONID");
                if (cookieValue != null && !(newSessionId = "JSESSIONID=" + cookieValue).equals(this.sessionId)) {
                    if (this.sessionId != null && log.isLoggable(Level.FINEST)) {
                        log.finest("updateSessionId " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " replacing session cookie \"" + SecurityUtil.calculateSessionIdHash((String)this.sessionId) + "\"...");
                    }
                    this.sessionId = newSessionId;
                    forceSessionKeyUpdate = true;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("updateSessionId " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " now using session cookie \"" + SecurityUtil.calculateSessionIdHash((String)this.sessionId) + "\"");
                    }
                }
            }
        }
        if (conn.getResponseHeader("RefreshDaemonSessionKey") != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("updateSessionId " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " server indicated sessionKey refresh, forcing client refresh");
            }
            this.sessionKey = null;
        }
        this.updateSessionKeyFromSessionId(forceSessionKeyUpdate, conn, uri);
    }

    private void clearSessionId() {
        this.sessionId = null;
        this.sessionKey = null;
        this.reuseSession = false;
        this.sessionCSRFToken = null;
    }

    protected String redirect(String pMethod, HttpConnection conn, int rc, String uri) throws IOException {
        byte[] buf = new byte[Math.min(conn.getContentLength(), 75)];
        conn.getInputStream().read(buf, 0, buf.length);
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String newLocation = conn.getResponseHeader("location");
        throw new DaemonSSLRequiredException(rc, this.getHost().getHostname(), pMethod, uri, newLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestRetryCriteria handleErrorResponses(String pMethod, HttpConnection conn, int connectionFlags, int rc, String uri, boolean authSet, long t0) throws ConnectException {
        RequestRetryCriteria retryCriteria = RequestRetryCriteria.NO_RETRY_CONNECTION;
        if (rc == 401) {
            BDaemonSession.readFully(conn);
            retryCriteria = this.handleUnauthorizedResponse(conn, connectionFlags, uri, authSet, t0) ? RequestRetryCriteria.RETRY_CONNECTION : RequestRetryCriteria.NO_RETRY_CONNECTION;
        } else if (rc == 403 && conn.getResponseHeader("DaemonCSRFToken") != null && uri.contains(CSRF_TOKEN_KEY) && this.allowTokenRotation) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("handleErrorResponses " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " CSRF error occurred, rotating stale token '" + this.sessionCSRFToken + "'...");
            }
            this.allowTokenRotation = false;
            BDaemonSession.readFully(conn);
            String csrfToken = conn.getResponseHeader("DaemonCSRFToken");
            String oldCSRFToken = this.sessionCSRFToken;
            this.sessionCSRFToken = null;
            this.updateSessionCsrfToken(csrfToken, conn, uri);
            String replaceTarget = "csrfToken=" + HttpUtil.encodeUrl((String)oldCSRFToken);
            String replaceWith = "csrfToken=" + HttpUtil.encodeUrl((String)csrfToken);
            uri = uri.replace(replaceTarget, replaceWith);
            this.updateSessionId(conn, uri);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("handleErrorResponses " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " CSRF token rotated to '" + this.sessionCSRFToken + "'");
            }
            retryCriteria = new RequestRetryCriteria(true, uri);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("handleErrorResponses " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " encountered error code " + Http.getReasonPhrase((int)rc));
            }
            if ((connectionFlags & 1) == 0) {
                BDaemonSession bDaemonSession = this;
                synchronized (bDaemonSession) {
                    this.doConnected();
                }
            }
            if (rc == 404) {
                BDaemonSession.readFully(conn);
                this.handleSessionMetadata(conn, uri);
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("handleErrorResponses " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms");
                }
            } else if (conn != null && conn.getContentType() != null && conn.getContentType().equals("text/xml")) {
                this.handleXMLResponse(pMethod, conn, rc, uri, t0);
            } else {
                this.handleInvalidResponse(pMethod, conn, rc, uri, t0);
            }
        }
        return retryCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reconnect(String daemonSessionTimestamp, ICancelHint listener) throws Exception {
        boolean bl;
        log.info("reconnect requested to " + this.getHost() + ":" + this.getPort() + "...");
        if (log.isLoggable(Level.FINEST)) {
            log.finest("entered Daemon Session reconnect to " + this.getHost() + ": " + this.getPort() + ", daemonSessionTimestamp: " + daemonSessionTimestamp);
        }
        long entryMillis = System.currentTimeMillis();
        this.inReconnect = true;
        boolean reconnected = false;
        int authenticationFailures = 0;
        try {
            while (!(listener != null && listener.isCanceled() || reconnected)) {
                try {
                    this.reloadHostProperties(15000);
                    String candidateTimestamp = this.getHostProperties().getSessionTimestamp();
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("reconnect timestamp hint: '" + daemonSessionTimestamp + "', candidate time stamp: '" + candidateTimestamp + "'");
                    }
                    if (candidateTimestamp == null || candidateTimestamp.isEmpty() || candidateTimestamp.equals(daemonSessionTimestamp)) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("reconnect timestamp unchanged or uninitialized, retrying");
                        }
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    reconnected = true;
                }
                catch (SecurityException | AuthenticationException e) {
                    if (++authenticationFailures > 3) {
                        log.log(Level.SEVERE, "Fatal authentication failure in reconnect (" + e + "), re-throwing...", e);
                        throw e;
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Transient authentication failure in reconnect (" + e + "),  retrying...");
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (SocketException se) {
                    this.handleReconnectSocketException(se);
                }
                catch (LocalizableRuntimeException lre) {
                    Object interiorException;
                    if (lre.getCause() instanceof SecurityException || lre.getCause() instanceof AuthenticationException) {
                        if (++authenticationFailures > 3) {
                            log.log(Level.SEVERE, "Fatal authentication failure in reconnect (" + lre.getCause() + "), re-throwing...", lre.getCause());
                            throw lre;
                        }
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Transient authentication failure in reconnect (" + lre.getCause() + "),  retrying...");
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {}
                    } else if (lre.getCause() instanceof BajaRuntimeException && ((Throwable)(interiorException = (BajaRuntimeException)lre.getCause())).getCause() instanceof IOException && ((Throwable)(interiorException = (IOException)((Throwable)interiorException).getCause())).getCause() instanceof SocketException) {
                        SocketException socketException = (SocketException)((Throwable)interiorException).getCause();
                        this.handleReconnectSocketException(socketException);
                        continue;
                    }
                    log.log(Level.SEVERE, "unrecoverable LocalizableRuntimeException in reconnect, re-throwing...", lre);
                    throw lre;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "unhandled Exception occurred in reconnect, re-throwing...", e);
                    throw e;
                }
            }
            bl = listener != null && listener.isCanceled();
        }
        catch (Throwable throwable) {
            boolean wasCanceled = listener != null && listener.isCanceled();
            log.info("reconnect attempt to " + this.getHost() + ":" + this.getPort() + " complete, success = " + reconnected + ", canceled = " + wasCanceled);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("leaving reconnect, time = " + (System.currentTimeMillis() - entryMillis));
            }
            this.inReconnect = false;
            throw throwable;
        }
        boolean wasCanceled = bl;
        log.info("reconnect attempt to " + this.getHost() + ":" + this.getPort() + " complete, success = " + reconnected + ", canceled = " + wasCanceled);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("leaving reconnect, time = " + (System.currentTimeMillis() - entryMillis));
        }
        this.inReconnect = false;
        return reconnected;
    }

    private void handleReconnectSocketException(SocketException se) throws SocketException {
        DaemonConnectException dce;
        boolean retry = true;
        if (se instanceof DaemonConnectException && ((dce = (DaemonConnectException)se).getCause() instanceof SSLException || dce.getCause() instanceof TlsException)) {
            retry = false;
        }
        if (retry) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "SocketException in reconnect (" + se + "), retrying...");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
        } else {
            log.log(Level.SEVERE, "Unrecoverable SocketException in reconnect, re-throwing...", se);
            throw se;
        }
    }

    private boolean handleUnauthorizedResponse(HttpConnection conn, int connectionFlags, String uri, boolean authSet, long t0) throws ConnectException {
        Authenticator authenticator;
        if (conn.getResponseHeader("StationNotAdmin") != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("getConnection " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " had " + "StationNotAdmin" + " header set, preventing standard unauthorized response handling");
            }
            return false;
        }
        if (this.cachedAuthorizationHeader == null) {
            if (authSet) {
                authenticator = this.getAuthenticator();
                if (authenticator == null || authenticator.finalAuthorizationSet()) {
                    Properties sessionCookie;
                    boolean useNewSession = false;
                    if (authenticator != null && (sessionCookie = Authenticator.parseHeader(conn, "Set-Cookie")) != null) {
                        String cookieValue = sessionCookie.getProperty("NIAGARA_DAEMON_SESSION_ID");
                        if (cookieValue != null) {
                            if (!("NIAGARA_DAEMON_SESSION_ID=" + cookieValue).equalsIgnoreCase(this.sessionId)) {
                                useNewSession = true;
                            }
                        } else {
                            cookieValue = sessionCookie.getProperty("JSESSIONID");
                            if (cookieValue != null && !("JSESSIONID=" + cookieValue).equalsIgnoreCase(this.sessionId)) {
                                useNewSession = true;
                            }
                        }
                    }
                    this.initAuthenticator(conn);
                    if (!useNewSession) {
                        this.connectionFailed(conn, connectionFlags, uri, t0);
                    }
                }
            } else {
                this.initAuthenticator(conn);
                authenticator = this.getAuthenticator();
                if (authenticator == null || !authenticator.hasCredentials()) {
                    if (this.authenticationClient != null) {
                        this.acquireCredentials();
                    } else {
                        this.connectionFailed(conn, connectionFlags, uri, t0);
                    }
                }
            }
        }
        if ((authenticator = this.getAuthenticator()) != null && authenticator.canReuseAuthorizationHeader()) {
            this.cachedAuthorizationHeader = Authenticator.parseHeader(conn, "Authorization");
        }
        return true;
    }

    private void connectionFailed(HttpConnection conn, int connectionFlags, String uri, long t0) {
        this.sessionId = null;
        this.sessionKey = null;
        this.sessionCSRFToken = null;
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Authenticator authenticator = this.getAuthenticator();
        DaemonAuthenticationException cause = new DaemonAuthenticationException(authenticator != null ? authenticator.getAuthenticationFailureMessage() : null);
        AuthenticationException ae = new AuthenticationException(null, (Throwable)((Object)cause), (AuthenticationRealm)authenticator);
        if ((connectionFlags & 2) == 0) {
            this.notifyConnectionError(ae);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("getConnection " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (connectionFailed " + (Object)((Object)ae) + ")");
        }
        throw ae;
    }

    private void handleConnectionException(String pMethod, HttpConnection conn, String uri, long t0, Exception e) {
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hostProperties.reset();
        this.notifyConnectionError(e);
        this.disconnect(false);
        LocalizableRuntimeException re = e instanceof ICancelHint.CanceledException ? (ICancelHint.CanceledException)((Object)e) : (e instanceof DaemonSSLRequiredException ? (DaemonSSLRequiredException)((Object)e) : new LocalizableRuntimeException("platform", "DaemonSession.exception.connectError", new Object[]{this.getAddressString(), pMethod, uri}, (Throwable)e));
        if (log.isLoggable(Level.FINE)) {
            log.fine("getConnection " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (handleConnectionException " + (Object)((Object)re) + ")");
        }
        throw re;
    }

    private void handleRetriesExceeded(HttpConnection conn, String uri, long t0, SocketException se) throws ConnectException {
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hostProperties.reset();
        this.notifyConnectionError(se);
        this.disconnect(false);
        if (se instanceof ConnectException) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("getConnection " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (handleRetriesExceeded " + se + ")");
            }
            throw (ConnectException)se;
        }
        DaemonConnectException dce = new DaemonConnectException(se, true);
        if (log.isLoggable(Level.FINE)) {
            log.fine("getConnection " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (handleRetriesExceeded " + dce + ")");
        }
        throw dce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectionFlags(String method, int connectionFlags, String uri, long t0) throws ConnectException {
        if ((connectionFlags & 0x10) > 0) {
            this.authenticator = null;
            this.cachedAuthorizationHeader = null;
            this.clearSessionId();
        }
        if ((connectionFlags & 8) > 0) {
            this.close();
        } else if ((connectionFlags & 4) > 0) {
            this.disconnect(false);
        } else if ((connectionFlags & 0x10) == 0) {
            this.initHostProperties(false);
            if ((connectionFlags & 1) == 0) {
                BDaemonSession bDaemonSession = this;
                synchronized (bDaemonSession) {
                    this.doConnected();
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("getConnection " + this.host + " " + this.port + " " + method + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms");
            }
        }
    }

    private void handleInvalidResponse(String pMethod, HttpConnection conn, int rc, String uri, long t0) {
        BDaemonSession.readFully(conn);
        this.sessionId = null;
        this.sessionKey = null;
        boolean tokenWasNull = this.sessionCSRFToken == null;
        this.sessionCSRFToken = null;
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hostProperties.reset();
        LocalizableRuntimeException re = rc == 403 ? (tokenWasNull ? new LocalizableRuntimeException("platform", "DaemonSession.exception.badBrand", new Object[]{Brand.getBrandId()}) : new LocalizableRuntimeException("platform", "DaemonSession.exception.badToken")) : new DaemonResponseException(rc, this.getAddressString(), pMethod, uri);
        if (log.isLoggable(Level.FINE)) {
            log.fine("getConnection " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (handleInvalidResponse " + (Object)((Object)re) + ")");
        }
        throw re;
    }

    private void handleXMLResponse(String pMethod, HttpConnection conn, int rc, String uri, long t0) {
        try {
            XElem responseElem;
            if (debug) {
                int nRead;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                InputStream in = conn.getInputStream();
                byte[] buf = new byte[4096];
                while ((nRead = in.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, nRead);
                }
                if (debug) {
                    out.writeTo(System.out);
                }
                responseElem = XParser.make((InputStream)new ByteArrayInputStream(out.toByteArray())).parse();
            } else {
                responseElem = XParser.make((InputStream)conn.getInputStream()).parse();
            }
            DaemonText daemonText = new DaemonText(responseElem);
            try {
                conn.close();
            }
            catch (Exception in) {
                // empty catch block
            }
            this.hostProperties.reset();
            DaemonResponseException dre = new DaemonResponseException(rc, this.getAddressString(), daemonText.message);
            if (log.isLoggable(Level.FINE)) {
                log.fine("getConnection " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (handleXMLResponse " + (Object)((Object)dre) + ")");
            }
            throw dre;
        }
        catch (LocalizableRuntimeException lre) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("getConnection " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (handleXMLResponse " + (Object)((Object)lre) + ")");
            }
            throw lre;
        }
        catch (Exception e) {
            try {
                conn.close();
            }
            catch (Exception daemonText) {
                // empty catch block
            }
            this.hostProperties.reset();
            LocalizableRuntimeException lre = new LocalizableRuntimeException("platform", "DaemonSession.exception.badConnectResponse", new Object[]{rc, this.getAddressString(), pMethod, uri});
            if (log.isLoggable(Level.FINE)) {
                log.fine("getConnection " + this.host + " " + this.port + " " + pMethod + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (handleXMLResponse " + (Object)((Object)lre) + ")");
            }
            throw lre;
        }
    }

    private void validateResponse(HttpConnection conn, String uri, long t0) {
        BDaemonSession.checkServerBrand(conn);
        String serverHeader = conn.getResponseHeader("Server");
        if (serverHeader == null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LocalizableRuntimeException lre = new LocalizableRuntimeException("platform", "daemon.session.versionError", new Object[]{minimumRequiredMajorVersion, this.getAddressString(), "?"});
            this.notifyConnectionError(lre);
            this.disconnect(false);
            if (log.isLoggable(Level.FINE)) {
                log.fine("getConnection " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (validateResponse " + (Object)((Object)lre) + ")");
            }
            throw lre;
        }
        int ixSlash = serverHeader.lastIndexOf(47);
        Version serverVersion = new Version(serverHeader.substring(ixSlash + 1));
        if (serverVersion.compareTo(minimumRequiredMajorVersion) < 0 || serverVersion.major() > maximumAllowedMajorVersion.major()) {
            String supportedRange = minimumRequiredMajorVersion.major() == maximumAllowedMajorVersion.major() ? String.valueOf(maximumAllowedMajorVersion.major()) : "[" + minimumRequiredMajorVersion.major() + ", " + maximumAllowedMajorVersion.major() + "]";
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LocalizableRuntimeException lre = new LocalizableRuntimeException("platform", "daemon.session.versionRangeError", new Object[]{supportedRange, this.getAddressString(), serverVersion});
            this.notifyConnectionError(lre);
            this.disconnect(false);
            if (log.isLoggable(Level.FINE)) {
                log.fine("getConnection " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " completed in " + (Clock.ticks() - t0) + "ms (validateResponse " + (Object)((Object)lre) + ")");
            }
            throw lre;
        }
    }

    private boolean isSuccessResponseCode(int rc) {
        return rc > 99 && rc < 300;
    }

    private int sendNewRequest(HttpConnection conn, int rc, String uri) throws ConnectException {
        try {
            rc = conn.newRequest(uri);
        }
        catch (Exception e) {
            BDaemonSession.processException(e);
        }
        return rc;
    }

    protected void addHeaders(String pMethod, long contentLength, int timeout, HttpConnection conn, int connectionFlags) throws SocketException {
        if (contentLength >= 0L) {
            while (conn.getRequestHeader("Content-Length") != null) {
                conn.removeRequestHeader("Content-Length");
            }
            conn.setRequestHeader("Content-Length", contentLength);
        }
        BDaemonSession.addBrandHeader(conn);
        if ((connectionFlags & 0x20) != 0) {
            conn.removeRequestHeader("expect");
            conn.setRequestHeader("expect", "100-continue");
        }
        conn.setRequestMethod(pMethod);
        conn.setTimeout(timeout);
        conn.setConnectionTimeout(timeout);
    }

    protected boolean setAuthOnConnection(HttpConnection conn, String uri) throws IOException {
        Authenticator authenticator = this.getAuthenticator();
        boolean authSet = authenticator == null ? false : (this.cachedAuthorizationHeader != null ? authenticator.setAuthorization(conn, uri, this.cachedAuthorizationHeader) : authenticator.setAuthorization(conn, uri));
        return authSet;
    }

    protected int connect(HttpConnection conn) throws ConnectException {
        int rc = -1;
        try {
            if (conn != null) {
                rc = AccessController.doPrivileged(() -> ((HttpConnection)conn).connect());
            }
        }
        catch (Exception e) {
            BDaemonSession.processException(e);
        }
        return rc;
    }

    protected HttpConnection createNewConnection(String pMethod, long contentLength, int timeout, int connectionFlags, String uri) throws SocketException {
        HttpConnection conn = new HttpConnection(this.getHost(), this.getPort(), uri);
        return this.initConnection(conn, pMethod, contentLength, timeout, connectionFlags);
    }

    protected HttpConnection initConnection(HttpConnection conn, String pMethod, long contentLength, int timeout, int connectionFlags) throws SocketException {
        this.addHeaders(pMethod, contentLength, timeout, conn, connectionFlags);
        return conn;
    }

    static String readFully(HttpConnection conn) {
        try {
            int nBytes;
            byte[] buf = new byte[1024];
            BufferedInputStream is = new BufferedInputStream(conn.getInputStream());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((nBytes = is.read(buf, 0, 1024)) > 0) {
                os.write(buf, 0, nBytes);
            }
            return os.toString();
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static boolean canceled(ICancelHint i) {
        return i != null && i.isCanceled();
    }

    public static void checkCanceled(ICancelHint i) {
        if (BDaemonSession.canceled(i)) {
            throw new ICancelHint.CanceledException();
        }
    }

    public boolean isSecure() {
        return this.getHost() instanceof BLocalHost;
    }

    public BIUserCredentials requestUsername(AuthenticationRealm realm) {
        BICredentials credentials = this.getCredentials();
        if (credentials instanceof BIUserCredentials) {
            return (BIUserCredentials)credentials;
        }
        return null;
    }

    public BICredentials requestInformation(AuthenticationRealm realm, String schemeName, int step, BIObject seedInfo) {
        return this.getCredentials();
    }

    public void addListener(DaemonSessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DaemonSessionListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyConnected() {
        for (DaemonSessionListener listener : this.listeners) {
            listener.sessionConnected(this);
        }
    }

    protected void notifyDisconnected() {
        for (DaemonSessionListener listener : this.listeners) {
            listener.sessionDisconnected(this);
        }
    }

    protected void notifyConnectionError(Throwable reason) {
        for (DaemonSessionListener listener : this.listeners) {
            listener.sessionConnectionError(this, reason);
        }
    }

    public BIcon getIcon() {
        if (this.isConnected()) {
            if (this.hostProperties.isFips()) {
                return BIcon.make((BIcon)iconConnected, (BIcon)fipsBadge);
            }
            return iconConnected;
        }
        return iconDisconnected;
    }

    public AgentList getAgents(Context cx) {
        if (this.isConnected()) {
            if (this.agentList == null) {
                this.agentList = Sys.getRegistry().getAgents(this.getType().getTypeInfo());
                try {
                    AgentList allNavNodeList = this.getAgentList().filter(AgentFilter.is((String)"workbench:WbView"));
                    allNavNodeList.remove("workbench:NavContainerView");
                    allNavNodeList.remove("platDaemon:PlatformSessionListView");
                    AgentInfo[] allNavNodes = allNavNodeList.list();
                    this.filterNavNodes(allNavNodes);
                    AgentTypeComparator comp = new AgentTypeComparator(cx);
                    this.sortAgentList(comp);
                    this.setDefaultAgent();
                    this.agentList.toTop("workbench:NavContainerView");
                    this.agentList.toTop("platDaemon:PlatformSessionListView");
                }
                catch (TypeNotFoundException allNavNodeList) {}
            }
        } else if (this.agentList == null) {
            this.agentList = super.getAgents(cx);
            try {
                AgentList viewList = this.getAgentList().filter(AgentFilter.is((String)"workbench:WbView"));
                viewList.remove("workbench:NavContainerView");
                this.agentList.remove(viewList);
                AgentTypeComparator comp = new AgentTypeComparator(cx);
                this.sortAgentList(comp);
                this.setDefaultAgent();
            }
            catch (TypeNotFoundException typeNotFoundException) {
                // empty catch block
            }
        }
        return this.agentList;
    }

    private void filterNavNodes(AgentInfo[] allNavNodes) {
        for (AgentInfo navNode : allNavNodes) {
            if (navNode instanceof NAgentInfo) {
                TypeInfo ti = ((NAgentInfo)navNode).getTypeInfo();
                String navName = Lexicon.make((String)ti.getModuleName()).get(ti.getTypeName() + ".navName", ti.getTypeName());
                if (this.getNavNode(navName) != null) continue;
                this.agentList.remove(navNode);
                continue;
            }
            this.agentList.remove(navNode);
        }
    }

    private void sortAgentList(Comparator<AgentInfo> comp) {
        if (this.agentList.size() > 1) {
            for (int i = 0; i < this.agentList.size() - 1; ++i) {
                for (int j = i + 1; j < this.agentList.size(); ++j) {
                    if (comp.compare(this.agentList.get(i), this.agentList.get(j)) <= 0) continue;
                    this.agentList.swap(i, j);
                }
            }
        }
    }

    public boolean shouldDowngrade(BPlatformSSLSettings newSettings) {
        return false;
    }

    protected void setDefaultAgent() {
        this.getAgentList().toTop("platform:DaemonSessionAgent");
    }

    protected AgentList getAgentList() {
        return this.agentList;
    }

    public final SharedSecretKey generateSharedSecretKey(String name) throws ConnectException {
        if (this.sessionKey == null) {
            String errorMessage = Lexicon.make(BDaemonSession.class).get("DaemonSession.noSessionKey");
            throw new SecurityException(errorMessage);
        }
        this.sendMessage("sharedKey?ping=true", DEFAULT_TIMEOUT);
        if (this.sessionKey.getEncryptionAlgorithmBundle() == null) {
            String encryptionAlgorithmBundle;
            try {
                XElem elem = XParser.make((InputStream)this.getInputStream(new EncryptionAlgorithmBundleMessage())).parse();
                encryptionAlgorithmBundle = elem.get("name");
            }
            catch (Exception e) {
                encryptionAlgorithmBundle = "aes-256.1";
            }
            EncryptionAlgorithmBundle bundle = (EncryptionAlgorithmBundle)CryptographicAlgorithmBundle.getInstance((String)encryptionAlgorithmBundle);
            this.sessionKey.setEncryptionAlgorithmBundle(bundle);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("generateSharedSecretKey " + this.host + " " + this.port + " generating a new shared secret key \"" + name + "\" in session \"" + SecurityUtil.calculateSessionIdHash((String)this.sessionId) + "\"");
        }
        SharedSecretKey sharedKey = this.sessionKey.generateSharedSecret(name);
        this.sendMessage(new InitializeSharedSecretKeyMessage(sharedKey));
        return sharedKey;
    }

    protected final void verifySharedSecretKey(DaemonMessage message) throws ConnectException {
        EncryptableDaemonMessage encryptableMessage;
        if (message instanceof EncryptableDaemonMessage && (encryptableMessage = (EncryptableDaemonMessage)((Object)message)).requiresSharedKey()) {
            encryptableMessage.setSharedKey(this.generateSharedSecretKey("daemonSession_generic_" + message.hashCode()));
        }
    }

    private void updateSessionKeyFromSessionId(boolean forceUpdate, HttpConnection conn, String uri) {
        Authenticator authenticator;
        if (!(this.sessionId == null || (authenticator = this.getAuthenticator()) == null || authenticator.supportsSecureKeyExchange() && authenticator.keyExchangeEnabled() || this.sessionKey != null && !forceUpdate)) {
            String sessionIdNumber = this.sessionId.substring(this.sessionId.indexOf("=") + 1, this.sessionId.endsWith(";") ? this.sessionId.indexOf(";") : this.sessionId.length());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("updateSessionKeyFromSessionId " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " creating a new session key in session \"" + SecurityUtil.calculateSessionIdHash((String)sessionIdNumber) + "\"");
            }
            this.sessionKey = SessionKey.make((byte[])authenticator.getUserAndPwd().getUsername().getBytes(StandardCharsets.UTF_8), (byte[])ByteArrayUtil.hexStringToBytes((String)sessionIdNumber));
        }
    }

    private void updateSessionCsrfToken(String csrfToken, HttpConnection conn, String uri) {
        if (this.sessionCSRFToken == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("updateSessionCsrfToken " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " updating CSRF token to \"" + csrfToken + "\"");
            }
            this.sessionCSRFToken = csrfToken;
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("updateSessionCsrfToken " + this.host + " " + this.port + " " + conn.getRequestMethod() + " " + BDaemonSession.truncateWithEllipsis(uri) + " ignored new CSRF token \"" + csrfToken + "\", session already contains token '" + this.sessionCSRFToken + "'");
        }
    }

    private static String truncateWithEllipsis(String stringToTruncate) {
        if (stringToTruncate == null) {
            return "";
        }
        String truncated = TextUtil.truncate((String)stringToTruncate, (int)64);
        if (truncated.length() != stringToTruncate.length()) {
            truncated = truncated + "...";
        }
        return truncated;
    }

    public String getSessionCSRFToken() {
        return this.sessionCSRFToken;
    }

    public PasswordStrength getPlatformPasswordStrengthRequirements() {
        if (this.platformPasswordStrength == null) {
            try {
                XElem passwordStrengthElem = XParser.make((InputStream)this.getInputStream(new GetPasswordStrengthMessage())).parse();
                this.platformPasswordStrength = PasswordStrength.makeFromXElem((XElem)passwordStrengthElem);
            }
            catch (Exception e) {
                this.platformPasswordStrength = new PasswordStrength(10, 1, 1, 1, 0);
            }
        }
        return this.platformPasswordStrength;
    }

    public String prepareMessageUri(DaemonMessage message) {
        StringBuilder uriBuilder = new StringBuilder(message.getMessageString());
        if (message.isStateChangeMessage()) {
            if (this.sessionCSRFToken != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("prepareMessageUri " + this.host + " " + this.port + " " + message.getMethod() + " adding CSRF token to Daemon Message with URI '" + BDaemonSession.truncateWithEllipsis(message.getMessageString()) + "'");
                }
                if (!message.getMessageString().contains("?")) {
                    uriBuilder.append("?");
                } else {
                    uriBuilder.append("&");
                }
                uriBuilder.append(CSRF_TOKEN_KEY).append("=").append(HttpUtil.encodeUrl((String)this.sessionCSRFToken));
            } else if (this.getHostProperties().isNiagara4() && new Version(this.getHostProperties().getDaemonVersion()).compareTo(new Version("4.4.62.0")) >= 0) {
                log.severe("prepareMessageUri " + this.host + " " + this.port + " " + message.getMethod() + " sending Daemon Message '" + BDaemonSession.truncateWithEllipsis(message.getMessageString()) + "' that changes state without CSRF token, failure likely!");
                if (log.isLoggable(Level.ALL)) {
                    Thread.dumpStack();
                }
            }
        }
        return uriBuilder.toString();
    }

    public List<LicenseInfo> fetchLicenses() {
        ArrayList<LicenseInfo> licenses = new ArrayList<LicenseInfo>();
        String hostId = this.getHostProperties().getHostId();
        boolean isPerpetual = this.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual();
        boolean isNiagaraHomeReadonly = this.getHostProperties().getIsNiagaraHomeReadonly();
        BDirectory remoteLicDir = (BDirectory)this.getFileSpace().findFile(SystemFilePaths.getLicensesDirPath(true, isPerpetual, isNiagaraHomeReadonly));
        if (remoteLicDir == null) {
            return licenses;
        }
        BINavNode[] remoteLicenses = remoteLicDir.getNavChildren();
        if (remoteLicenses == null) {
            return licenses;
        }
        for (BINavNode remoteLicense : remoteLicenses) {
            BIFile remoteLicenseFile;
            if (!(remoteLicense instanceof BIFile) || !"license".equalsIgnoreCase((remoteLicenseFile = (BIFile)remoteLicense).getExtension())) continue;
            try {
                LicenseInfo info = new LicenseInfo(remoteLicenseFile);
                if (!hostId.equals(info.vendorLicense.getHostId())) continue;
                licenses.add(info);
            }
            catch (Exception e) {
                log.warning("Exception occurred while parsing remote license '" + remoteLicenseFile.getFileName() + "'" + e.getMessage());
                log.log(Level.FINE, "", e);
            }
        }
        return licenses;
    }

    static {
        SecurityManager securityManager = System.getSecurityManager();
        wsExecutorService = Executors.newCachedThreadPool((ThreadFactory)new PrivilegedNamedThreadFactory("DSWSClientThread", securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup(), AccessController.doPrivileged(AccessController::getContext), thread -> {
            thread.setDaemon(true);
            thread.setPriority(1);
        }));
        try {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().addShutdownHook(new Thread(wsExecutorService::shutdownNow, "DSWSClientShutdownHook"));
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            pae.printStackTrace();
        }
    }

    private static class RequestRetryCriteria {
        static RequestRetryCriteria RETRY_CONNECTION = new RequestRetryCriteria(true, null);
        static RequestRetryCriteria NO_RETRY_CONNECTION = new RequestRetryCriteria(false, null);
        String retryUri;
        boolean retryConnection;

        RequestRetryCriteria(boolean retryConnection, String retryUri) {
            this.retryConnection = retryConnection;
            this.retryUri = retryUri;
        }
    }

    private static class AgentTypeComparator
    implements Comparator<AgentInfo> {
        private final Context context;

        public AgentTypeComparator(Context cx) {
            this.context = cx;
        }

        @Override
        public int compare(AgentInfo ai1, AgentInfo ai2) {
            return ai1.getDisplayName(this.context).compareTo(ai2.getDisplayName(this.context));
        }
    }

    public static class DaemonConnectException
    extends ConnectException {
        private final Throwable outerCause;
        private final Throwable summaryCause;
        private final boolean fatal;

        public DaemonConnectException(Throwable cause, boolean fatal) {
            this(cause, cause, fatal);
        }

        public DaemonConnectException(Throwable outerCause, Throwable summaryCause, boolean fatal) {
            super(summaryCause.getMessage());
            this.outerCause = outerCause;
            this.summaryCause = summaryCause;
            this.fatal = fatal;
        }

        public boolean isFatal() {
            return this.fatal;
        }

        @Override
        public Throwable getCause() {
            return this.outerCause;
        }

        @Override
        public String toString() {
            return "DaemonConnectException: " + this.summaryCause.toString();
        }
    }

    public static class Stream
    extends FilterInputStream {
        private final HttpConnection conn;

        public Stream(HttpConnection pConn) throws IOException {
            super(pConn.getInputStream());
            this.conn = pConn;
        }

        public String getContentType() {
            return this.conn.getResponseHeader("Content-Type");
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                try {
                    this.conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

