/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.nre.jetty.log.NullLogger;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.ConsoleInputStream;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteAppMessage;
import com.tridium.platform.daemon.message.GetAppListMessage;
import com.tridium.platform.daemon.message.GetAppOutputMessage;
import com.tridium.platform.daemon.message.KillAppMessage;
import com.tridium.platform.daemon.message.RestartAppMessage;
import com.tridium.platform.daemon.message.StartAppMessage;
import com.tridium.platform.daemon.message.StopAppMessage;
import com.tridium.platform.daemon.message.UpdateAppMessage;
import com.tridium.platform.daemon.message.UpdateLogBufferSizeMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.ArrayUtil;
import com.tridium.util.ThrowableUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import org.eclipse.jetty.util.log.Log;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="isAutoStart", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isAutoRestart", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="appStatus", type="BStationStatus", defaultValue="BStationStatus.unknown", flags=3), @NiagaraProperty(name="appName", type="String", defaultValue="", flags=3), @NiagaraProperty(name="isDisabled", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isDirty", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isAcceptingMessages", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="logBufferSize", type="int", defaultValue="OutputBuffer._MAX_OUTPUT_BUFFER_SIZE", flags=3), @NiagaraProperty(name="logBufferFileSize", type="int", defaultValue="OutputBuffer._MAX_OUTPUT_BUFFER_SIZE", flags=3)})
public abstract class BAppSurrogate
extends BComponent {
    @Generated
    public static final Property isAutoStart = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isAutoRestart = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property appStatus = BAppSurrogate.newProperty((int)3, (BValue)BStationStatus.unknown, null);
    @Generated
    public static final Property appName = BAppSurrogate.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property isDisabled = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isDirty = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isAcceptingMessages = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property logBufferSize = BAppSurrogate.newProperty((int)3, (int)262144, null);
    @Generated
    public static final Property logBufferFileSize = BAppSurrogate.newProperty((int)3, (int)262144, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAppSurrogate.class);
    protected BDaemonSession session;
    private static final int STREAM_TIMEOUT_MILLIS;
    public static final int PORT_UNKNOWN = -1;
    protected static final BIcon connectedIcon;
    protected static final BIcon disconnectedIcon;
    protected static final Lexicon lex;
    protected static final Logger log;

    @Generated
    public boolean getIsAutoStart() {
        return this.getBoolean(isAutoStart);
    }

    @Generated
    public void setIsAutoStart(boolean v) {
        this.setBoolean(isAutoStart, v, null);
    }

    @Generated
    public boolean getIsAutoRestart() {
        return this.getBoolean(isAutoRestart);
    }

    @Generated
    public void setIsAutoRestart(boolean v) {
        this.setBoolean(isAutoRestart, v, null);
    }

    @Generated
    public BStationStatus getAppStatus() {
        return (BStationStatus)this.get(appStatus);
    }

    @Generated
    public void setAppStatus(BStationStatus v) {
        this.set(appStatus, (BValue)v, null);
    }

    @Generated
    public String getAppName() {
        return this.getString(appName);
    }

    @Generated
    public void setAppName(String v) {
        this.setString(appName, v, null);
    }

    @Generated
    public boolean getIsDisabled() {
        return this.getBoolean(isDisabled);
    }

    @Generated
    public void setIsDisabled(boolean v) {
        this.setBoolean(isDisabled, v, null);
    }

    @Generated
    public boolean getIsDirty() {
        return this.getBoolean(isDirty);
    }

    @Generated
    public void setIsDirty(boolean v) {
        this.setBoolean(isDirty, v, null);
    }

    @Generated
    public boolean getIsAcceptingMessages() {
        return this.getBoolean(isAcceptingMessages);
    }

    @Generated
    public void setIsAcceptingMessages(boolean v) {
        this.setBoolean(isAcceptingMessages, v, null);
    }

    @Generated
    public int getLogBufferSize() {
        return this.getInt(logBufferSize);
    }

    @Generated
    public void setLogBufferSize(int v) {
        this.setInt(logBufferSize, v, null);
    }

    @Generated
    public int getLogBufferFileSize() {
        return this.getInt(logBufferFileSize);
    }

    @Generated
    public void setLogBufferFileSize(int v) {
        this.setInt(logBufferFileSize, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAppSurrogate() {
    }

    protected BAppSurrogate(BDaemonSession session) {
        this.session = session;
    }

    protected BDaemonSession getDaemonSession() {
        return this.session;
    }

    protected static Map<Type, TreeMap<String, XElem>> getAppElementMap(BDaemonSession session) throws Exception {
        if (session.getHostProperties().supportsServlet("applist")) {
            XElem mainElem = XParser.make((InputStream)session.getInputStream(new GetAppListMessage())).parse();
            HashMap<Type, TreeMap<String, XElem>> appMapByAppType = new HashMap<Type, TreeMap<String, XElem>>();
            XElem[] appTypeElems = mainElem.elems("app");
            for (int ixAppType = 0; ixAppType < appTypeElems.length; ++ixAppType) {
                String appTypeString = appTypeElems[ixAppType].get("type");
                Type appType = BAppSurrogate.getAppType(appTypeString);
                if (appType == null) continue;
                TreeMap<String, XElem> appByAppName = new TreeMap<String, XElem>();
                appMapByAppType.put(appType, appByAppName);
                XElem[] appElems = appTypeElems[ixAppType].elems(appTypeString);
                for (int ixApp = 0; ixApp < appElems.length; ++ixApp) {
                    appByAppName.put(appElems[ixApp].get("name"), appElems[ixApp]);
                }
            }
            return appMapByAppType;
        }
        XElem mainElem = XParser.make((InputStream)session.getInputStream(new GetAppListMessage("station"))).parse();
        HashMap<Type, TreeMap<String, XElem>> appMapByAppType = new HashMap<Type, TreeMap<String, XElem>>();
        TreeMap<String, XElem> appByAppName = new TreeMap<String, XElem>();
        appMapByAppType.put(BStationSurrogate.TYPE, appByAppName);
        XElem[] appElems = mainElem.elems("station");
        for (int ixApp = 0; ixApp < appElems.length; ++ixApp) {
            appByAppName.put(appElems[ixApp].get("name"), appElems[ixApp]);
        }
        return appMapByAppType;
    }

    protected static Map<String, XElem> getAppElementMap(Type appType, BDaemonSession session) throws Exception {
        TreeMap appMap = BAppSurrogate.getAppElementMap(session).get(appType);
        if (appMap == null) {
            appMap = new TreeMap();
        }
        return appMap;
    }

    public void poll() throws Exception {
        XElem info = BAppSurrogate.getAppElementMap(this.getType(), this.getDaemonSession()).get(this.getAppName());
        if (info != null) {
            this.updateFields(info);
        }
    }

    public boolean isRestartEnabled() {
        return this.getDaemonSession().getHostProperties().getAllowStationRestart();
    }

    public void updateFields(XElem appElement) {
        this.setAppName(appElement.get("name"));
        XElem elem = appElement.elem("isdisabled");
        if (elem != null) {
            this.setIsDisabled(elem.getb("value"));
        }
        if ((elem = appElement.elem("isautostart")) != null) {
            this.setIsAutoStart(elem.getb("value"));
        }
        if ((elem = appElement.elem("isautorestart")) != null) {
            this.setIsAutoRestart(elem.getb("value"));
        }
        if ((elem = appElement.elem("isdirty")) != null) {
            this.setIsDirty(elem.getb("value"));
        }
        if ((elem = appElement.elem("isacceptingmessages")) != null) {
            this.setIsAcceptingMessages(elem.getb("value"));
        }
        if ((elem = appElement.elem("status")) != null) {
            this.setAppStatus(BStationStatus.make(elem.geti("value")));
        }
        if ((elem = appElement.elem("logbuffersize")) != null) {
            this.setLogBufferSize(elem.geti("value"));
        }
        if ((elem = appElement.elem("logbufferfilesize")) != null) {
            this.setLogBufferFileSize(elem.geti("value"));
        }
    }

    public InputStream getAppOutput() throws ConnectException, AuthenticationException {
        return this.getAppOutput(true, false);
    }

    public InputStream getAppOutput(boolean follow) throws ConnectException, AuthenticationException {
        return this.getAppOutput(follow, false);
    }

    public InputStream getAppOutput(boolean follow, boolean updatesOnly) throws ConnectException, AuthenticationException {
        GetAppOutputMessage applicationOutputMessage = new GetAppOutputMessage(this.getAppTypeString(), this.getAppName(), follow, updatesOnly);
        if (this.getDaemonSession().getHostProperties().isNiagara4()) {
            return ConsoleInputStream.make(this.getDaemonSession().getWebSocketInputStream(applicationOutputMessage, BDaemonSession.DEFAULT_TIMEOUT, STREAM_TIMEOUT_MILLIS), true);
        }
        return ConsoleInputStream.make(this.getDaemonSession().getInputStream((DaemonMessage)applicationOutputMessage, STREAM_TIMEOUT_MILLIS));
    }

    public void updateLogBufferSize(int pLogBufferSize, int pLogBufferFileSize) throws ConnectException, AuthenticationException {
        if (this.getDaemonSession().sendMessage(new UpdateLogBufferSizeMessage(this.getAppTypeString(), this.getAppName(), pLogBufferSize, pLogBufferFileSize, true))) {
            this.setLogBufferSize(pLogBufferSize);
            this.setLogBufferFileSize(pLogBufferFileSize);
        }
    }

    public void updateSettings(boolean pIsAutoStart, boolean pIsAutoRestart) throws ConnectException {
        this.getDaemonSession().sendMessage(new UpdateAppMessage(this.getAppTypeString(), this.getAppName(), this.getIsDisabled(), pIsAutoStart, pIsAutoRestart, true));
    }

    public void checkStart() {
        if (!(this.isAppRunning() || this.isRestartEnabled() || this.getAppStatus() != BStationStatus.halted && this.getAppStatus() != BStationStatus.failed)) {
            throw new LocalizableRuntimeException("platform", "AppSurrogate.error.startHaltedApp");
        }
    }

    public void startAppAsync() throws ConnectException, AuthenticationException {
        this.checkStart();
        if (!this.isAppRunning()) {
            this.setAppStatus(BStationStatus.starting);
            this.getDaemonSession().sendMessage(new StartAppMessage(this.getAppTypeString(), this.getAppName()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startApp(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        this.checkStart();
        CancelableDaemonSessionTask task = null;
        OutputWatcher w = null;
        if (listener != null) {
            task = this.isAppRunning() ? new CancelableDaemonSessionTask(lex, "AppSurrogate.waiting.title", "AppSurrogate.waiting.message", new Object[]{this.getAppName()}, cancelHint) : new CancelableDaemonSessionTask(lex, "AppSurrogate.starting.title", "AppSurrogate.starting.message", new Object[]{this.getAppName()}, cancelHint);
            cancelHint = task;
        }
        try {
            w = new OutputWatcher(this.getAppOutput(true, true), task, listener);
            w.start();
            if (listener != null) {
                listener.taskStarted(task);
            }
            this.startAppAsync();
            while (true) {
                if (BAppSurrogate.isCanceled(task)) {
                    throw new ICancelHint.CanceledException();
                }
                this.poll();
                if (this.getAppStatus() == BStationStatus.running) {
                    if (listener != null) {
                        if (w != null) {
                            w.stopWatcher();
                        }
                        listener.taskFinished(task);
                    }
                    return;
                }
                if (this.getAppStatus() == BStationStatus.failed) {
                    throw new Exception("Application failed to start");
                }
                Thread.sleep(1000L);
            }
        }
        catch (Throwable throwable) {
            if (listener != null) {
                if (w != null) {
                    w.stopWatcher();
                }
                listener.taskFinished(task);
            }
            throw throwable;
        }
    }

    public void stopAppAsync() throws ConnectException, AuthenticationException {
        try {
            if (!this.isAppStopped()) {
                this.setAppStatus(BStationStatus.stopping);
                this.getDaemonSession().sendMessage(new StopAppMessage(this.getAppTypeString(), this.getAppName()));
            }
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static BAppSurrogate[] stopAllApps(BDaemonSession session, Type appType, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        try {
            return BAppSurrogate.stopAllApps(session, appType, BAppSurrogate.makeAll(appType, session), cancelHint, listener);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public String getAppTypeString() {
        return BAppSurrogate.getAppTypeString(this.getType());
    }

    public static String getAppTypeString(Type type) {
        if (type == BStationSurrogate.TYPE) {
            return "station";
        }
        throw new IllegalArgumentException();
    }

    public static Type getAppType(String typeName) {
        if (typeName.equals("station")) {
            return BStationSurrogate.TYPE;
        }
        return null;
    }

    public static BAppSurrogate make(XElem elem, BDaemonSession session) throws Exception {
        BStationSurrogate result = null;
        if (!elem.name().equals("station")) {
            throw new IllegalArgumentException("invalid element for BAppSurrogate.make");
        }
        result = new BStationSurrogate(session);
        ((BAppSurrogate)result).updateFields(elem);
        return result;
    }

    public static BAppSurrogate[] makeAll(Type appType, BDaemonSession session) throws Exception {
        if (appType == null) {
            Array result = new Array(BAppSurrogate.class);
            Map<Type, TreeMap<String, XElem>> outerMap = BAppSurrogate.getAppElementMap(session);
            Iterator<TreeMap<String, XElem>> iOuter = outerMap.values().iterator();
            while (iOuter.hasNext()) {
                Iterator<XElem> iInner = iOuter.next().values().iterator();
                while (iInner.hasNext()) {
                    result.add((Object)BAppSurrogate.make(iInner.next(), session));
                }
            }
            return (BAppSurrogate[])result.trim();
        }
        Map<String, XElem> apps = BAppSurrogate.getAppElementMap(appType, session);
        BAppSurrogate[] result = (BAppSurrogate[])java.lang.reflect.Array.newInstance(appType.getTypeClass(), apps.size());
        int ix = 0;
        Iterator<XElem> i = apps.values().iterator();
        while (i.hasNext()) {
            result[ix] = BAppSurrogate.make(i.next(), session);
            ++ix;
        }
        return result;
    }

    public static boolean isAnyAppRunning(Type appType, BDaemonSession session) throws Exception {
        BAppSurrogate[] apps = BAppSurrogate.makeAll(appType, session);
        for (int i = 0; i < apps.length; ++i) {
            if (!apps[i].isAppRunning()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyAppStarting(Type appType, BDaemonSession session) throws Exception {
        BAppSurrogate[] apps = BAppSurrogate.makeAll(appType, session);
        for (int i = 0; i < apps.length; ++i) {
            if (!apps[i].isAppStarting()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyAppStopping(Type appType, BDaemonSession session) throws Exception {
        BAppSurrogate[] apps = BAppSurrogate.makeAll(appType, session);
        for (int i = 0; i < apps.length; ++i) {
            if (!apps[i].isAppStopping()) continue;
            return true;
        }
        return false;
    }

    protected static XElem getAppElem(BDaemonSession session, BAppSurrogate app) throws Exception {
        Map<String, XElem> fieldMap = BAppSurrogate.getAppElementMap(app.getType(), session);
        return fieldMap.get(app.getAppName());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BAppSurrogate[] stopAllApps(BDaemonSession session, Type appType, BAppSurrogate[] apps, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        ArrayList<BAppSurrogate> result = new ArrayList<BAppSurrogate>();
        if (apps == null) {
            apps = BAppSurrogate.makeAll(appType, session);
        }
        HashSet<Type> appTypes = new HashSet<Type>();
        CancelableDaemonSessionTask task = null;
        try {
            for (BAppSurrogate app : apps) {
                appTypes.add(app.getType());
                if (app.isAppStopped()) continue;
                app.setAppStatus(BStationStatus.stopping);
                result.add(app);
            }
            if (listener != null) {
                task = new CancelableDaemonSessionTask(lex, "AppSurrogate.stoppingAllApps.title", "AppSurrogate.stoppingAllApps.message", cancelHint);
                task.setCancelLabel(lex.getText("AppSurrogate.stopping.cancel"));
                listener.taskStarted(task);
            }
            for (Type appType1 : appTypes) {
                session.sendMessage(new StopAppMessage(BAppSurrogate.getAppTypeString(appType1), "all"));
            }
            while (!BAppSurrogate.isCanceled(task)) {
                boolean allIdle = true;
                Map<Type, TreeMap<String, XElem>> typeMap = BAppSurrogate.getAppElementMap(session);
                for (BAppSurrogate app : apps) {
                    Map fieldMap = typeMap.get(app.getType());
                    XElem info = (XElem)fieldMap.get(app.getAppName());
                    if (info != null) {
                        app.updateFields(info);
                    }
                    if (app.isAppStopped()) continue;
                    allIdle = false;
                }
                if (allIdle) {
                    BAppSurrogate[] bAppSurrogateArray = (BAppSurrogate[])ArrayUtil.arrayFromCollection(result, BAppSurrogate[]::new);
                    if (listener == null) return bAppSurrogateArray;
                    if (task == null) return bAppSurrogateArray;
                    listener.taskFinished(task);
                    return bAppSurrogateArray;
                }
                Thread.sleep(1000L);
            }
            if (listener == null) throw new ICancelHint.CanceledException();
            if (task == null) throw new ICancelHint.CanceledException();
            listener.taskFinished(task);
            throw new ICancelHint.CanceledException();
        }
        catch (ConnectException ce) {
            try {
                throw ce;
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (listener == null) throw throwable;
                if (task == null) throw throwable;
                listener.taskFinished(task);
                throw throwable;
            }
        }
    }

    public void stopApp(ICancelHint cancelHint) throws ConnectException, AuthenticationException {
        this.stopApp(cancelHint, null);
    }

    public void stopApp(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        if (!this.isAppStopped()) {
            CancelableDaemonSessionTask task = null;
            try {
                if (this.getAppStatus() != BStationStatus.stopping) {
                    if (listener != null) {
                        task = new CancelableDaemonSessionTask(lex, "AppSurrogate.stopping.title", "AppSurrogate.stopping.message", new Object[]{this.getAppName()}, cancelHint);
                        task.setCancelLabel(lex.getText("AppSurrogate.stopping.cancel"));
                        listener.taskStarted(task);
                    }
                    this.stopAppAsync();
                    this.poll();
                    while (!this.isAppStopped() && !BAppSurrogate.isCanceled(task)) {
                        Thread.sleep(1000L);
                        this.poll();
                    }
                }
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            finally {
                if (listener != null && task != null) {
                    listener.taskFinished(task);
                }
            }
            if (BAppSurrogate.isCanceled(task)) {
                throw new ICancelHint.CanceledException();
            }
        }
    }

    public void restartAppAsync() throws ConnectException, AuthenticationException {
        if (!this.isRestartEnabled()) {
            throw new LocalizableRuntimeException("platform", "AppSurrogate.error.restartNotPermitted");
        }
        this.restartAppAsync(false);
    }

    public void restartAppAsync(boolean kill) throws ConnectException, AuthenticationException {
        if (!this.isRestartEnabled() || this.isAppStopped()) {
            throw new LocalizableRuntimeException("platform", "AppSurrogate.error.restartNotPermitted");
        }
        this.setAppStatus(BStationStatus.stopping);
        this.getDaemonSession().sendMessage(new RestartAppMessage(this.getAppTypeString(), this.getAppName(), kill));
    }

    public void deleteApp(ICancelHint cancelHint) throws ConnectException, AuthenticationException {
        this.deleteApp(cancelHint, null);
    }

    public void deleteApp(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        this.stopApp(cancelHint, listener);
        this.getDaemonSession().sendMessage(new DeleteAppMessage(this.getAppTypeString(), this.getAppName()));
    }

    public void killAppAsync() throws ConnectException, AuthenticationException {
        if (!this.isAppStopped()) {
            this.setAppStatus(BStationStatus.stopping);
            this.getDaemonSession().sendMessage(new KillAppMessage(this.getAppTypeString(), this.getAppName()));
        }
    }

    public void killApp(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        if (!this.isAppStopped()) {
            CancelableDaemonSessionTask task = null;
            try {
                if (listener != null) {
                    task = new CancelableDaemonSessionTask(lex, "AppSurrogate.killing.title", "AppSurrogate.killing.message", new Object[]{this.getAppName()}, cancelHint);
                    listener.taskStarted(task);
                }
                this.killAppAsync();
                this.poll();
                while (!this.isAppStopped() && !BAppSurrogate.isCanceled(task)) {
                    Thread.sleep(1000L);
                    this.poll();
                }
            }
            catch (RuntimeException | ConnectException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            finally {
                if (listener != null && task != null) {
                    listener.taskFinished(task);
                }
            }
            if (BAppSurrogate.isCanceled(task)) {
                throw new ICancelHint.CanceledException();
            }
        }
    }

    public boolean isAppRunning() {
        return this.getAppStatus() == BStationStatus.running || this.getAppStatus() == BStationStatus.starting || this.getAppStatus() == BStationStatus.stopping;
    }

    public boolean isAppStarting() {
        return this.getAppStatus() == BStationStatus.starting;
    }

    public boolean isAppStopping() {
        return this.getAppStatus() == BStationStatus.stopping;
    }

    public boolean isAppStopped() {
        return this.getAppStatus() == BStationStatus.idle || this.getAppStatus() == BStationStatus.halted || this.getAppStatus() == BStationStatus.failed;
    }

    protected static boolean isCanceled(CancelableDaemonSessionTask task) {
        return task != null && task.isCanceled();
    }

    public String toString(Context cx) {
        return lex.getText("AppSurrogate." + this.getAppTypeString() + ".display", new Object[]{this.getAppName()});
    }

    public BIcon getIcon() {
        return this.isAppRunning() ? connectedIcon : disconnectedIcon;
    }

    private static int initStreamTimeout() {
        int timeout = 500;
        try {
            timeout = AccessController.doPrivileged(() -> Integer.parseInt(System.getProperty("niagara.daemonsession.streamtimeout", "500")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return timeout;
    }

    public static int getStreamTimeoutMillis() {
        return STREAM_TIMEOUT_MILLIS;
    }

    static {
        Log.setLog((org.eclipse.jetty.util.log.Logger)NullLogger.getInstance());
        STREAM_TIMEOUT_MILLIS = BAppSurrogate.initStreamTimeout();
        connectedIcon = BIcon.std((String)"database.png");
        disconnectedIcon = BIcon.std((String)"databaseDisconnected.png");
        lex = Lexicon.make((String)"platform");
        log = Logger.getLogger("platform.appSurrogate");
    }

    protected static class OutputWatcher
    extends Thread {
        private final InputStream in;
        private final CancelableDaemonSessionTask task;
        private final DaemonSessionTaskListener listener;
        private boolean stopped = true;
        private final StringBuffer buf = new StringBuffer();

        public OutputWatcher(InputStream in, CancelableDaemonSessionTask task, DaemonSessionTaskListener listener) {
            super("AppSurrogate:OutputWatcher");
            this.in = in;
            this.task = task;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.listener == null) {
                return;
            }
            this.stopped = false;
            byte[] buf = new byte[8192];
            try {
                this.checkCanceled();
                while (!this.stopped) {
                    int numRead;
                    try {
                        numRead = this.in.read(buf, 0, 8192);
                    }
                    catch (NullPointerException npe) {
                        throw new IOException();
                    }
                    catch (InterruptedIOException ste) {
                        this.checkCanceled();
                        continue;
                    }
                    this.checkCanceled();
                    if (this.stopped) continue;
                    if (numRead >= 0) {
                        this.append(new String(buf, 0, numRead, StandardCharsets.UTF_8));
                        continue;
                    }
                    this.stopWatcher(false);
                }
            }
            catch (EOFException eof) {
                String message = "\n" + lex.getText("InputStreamPane.eof");
                this.append(message.getBytes(), 0, message.length());
            }
            catch (IOException ioe) {
                if (!this.stopped) {
                    String message = "\n" + lex.getText("InputStreamPane.ioe", new Object[]{ThrowableUtil.dumpToString((Throwable)ioe)});
                    this.append(message.getBytes(), 0, message.length());
                    log.log(Level.SEVERE, "Error occurred reading output", ioe);
                }
            }
            finally {
                this.stopWatcher(false);
            }
        }

        public void append(Throwable t) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(out));
            this.append(out.toString());
        }

        public void append(byte[] bytes, int offset, int len) {
            this.append(new String(bytes, offset, len, StandardCharsets.UTF_8));
        }

        public synchronized void append(String text) {
            this.buf.append(text);
            int i = -1;
            while ((i = this.indexOf(this.buf, '\n')) >= 0) {
                this.task.setMessage(this.buf.substring(0, i));
                this.listener.taskUpdated(this.task);
                this.buf.delete(0, i + 1);
            }
        }

        private synchronized int indexOf(StringBuffer b, char c) {
            int length = b.length();
            for (int i = 0; i < length; ++i) {
                if (b.charAt(i) != c) continue;
                return i;
            }
            return -1;
        }

        public void stopWatcher() {
            this.stopWatcher(true);
        }

        public void stopWatcher(boolean waitForNotify) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            try {
                this.in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (waitForNotify) {
                try {
                    this.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void checkCanceled() {
            if (this.task != null && this.task.isCanceled()) {
                this.stopWatcher(false);
            }
        }
    }
}

