/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.archive;

import com.tridium.platform.archive.FileArchive;
import com.tridium.platform.archive.ZipArchiveReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BajaFileUtil;

public class ZipArchive
implements FileArchive {
    String archiveName;
    String archivePath;
    private File archiveFile;
    private File workingFile;
    private ZipOutputStream out;
    int maxBackups;
    public static Logger log = Logger.getLogger("platform.zipArchive");

    public ZipArchive(String archivePath, String archiveName, int maxBackups) {
        try {
            this.archivePath = archivePath;
            this.archiveName = archiveName;
            this.archiveFile = new File(archivePath, archiveName);
            this.workingFile = new File(this.archiveFile + ".working");
            this.maxBackups = maxBackups;
            if (this.archiveFile.isDirectory()) {
                throw new IllegalArgumentException("File is directory: " + this.archiveFile);
            }
            this.out = new ZipOutputStream(new FileOutputStream(this.workingFile));
            this.out.setMethod(8);
            String prefix = archiveName.substring(0, archiveName.indexOf(46));
            File[] backups = BajaFileUtil.getBackups((File)new File(archivePath), (String)prefix);
            if (backups != null && backups.length != 0) {
                for (int ndx = backups.length - 1; ndx > maxBackups; --ndx) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("deleting " + backups[ndx]);
                    }
                    if (backups[ndx].delete()) continue;
                    log.warning("failed to delete zip archive backup \"" + backups[ndx].getName() + "\"");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeFile(File f, String path) {
        try {
            if (!f.exists()) {
                log.warning(f + " does not exist!");
                return;
            }
            if (f.isDirectory()) {
                throw new IllegalArgumentException("File is directory: " + f);
            }
            if ((path = path.replace('\\', '/')).charAt(0) == '/') {
                path = path.substring(1);
            }
            ZipEntry entry = new ZipEntry(path);
            entry.setSize(f.length());
            entry.setTime(f.lastModified());
            try {
                this.out.putNextEntry(entry);
            }
            catch (ZipException ex) {
                log.log(Level.WARNING, "Archive " + this.archiveName + " unable to put zip entry ", ex);
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Adding " + path);
            }
            byte[] buf = new byte[4096];
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
                int thisRead;
                while ((thisRead = in.read(buf)) != -1) {
                    this.out.write(buf, 0, thisRead);
                }
            }
            this.out.closeEntry();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.out.flush();
            this.out.close();
            if (log.isLoggable(Level.FINE)) {
                log.fine("renaming archive file \"" + this.archiveFile + "\" to backup...");
            }
            BajaFileUtil.renameToBackup((File)this.archiveFile, (int)this.maxBackups);
            if (log.isLoggable(Level.FINE)) {
                log.fine("renaming working file \"" + this.workingFile + "\" to archive \"" + this.archiveFile + "\"...");
            }
            if (!this.workingFile.renameTo(this.archiveFile)) {
                log.severe("failed to rename working zip \"" + this.workingFile.getName() + "\" to \"" + this.archiveFile.getName() + "\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unzip(String zipPath, String zipName, String destPath) throws IOException {
        File zip;
        File[] kids;
        File destDir = new File(destPath);
        if (!destDir.exists()) {
            if (!destDir.mkdir()) {
                log.severe("Failed to create zip archive destination dir \"" + destDir.getPath() + "\"");
                throw new IOException("Failed to create zip archive destination dir \"" + destDir.getPath() + "\"");
            }
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("destDir <" + destDir + "> is not a directory");
        }
        if ((kids = destDir.listFiles()) != null) {
            for (File kid : kids) {
                BajaFileUtil.delete((File)kid);
            }
        }
        if (!(zip = new File(zipPath, zipName)).exists()) {
            File working = new File(zipPath, zipName + ".working");
            if (working.exists()) {
                if (!working.renameTo(zip)) {
                    log.severe("Failed to rename working zip archive \"" + working.getName() + "\" to \"" + zip.getName() + "\"");
                    throw new IOException("Failed to rename working zip archive \"" + working.getName() + "\" to \"" + zip.getName() + "\"");
                }
            } else {
                return;
            }
        }
        ZipArchiveReader zar = new ZipArchiveReader(zip, false);
        zar.extractAll(destDir);
    }
}

