/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.CertificateStatusEnum;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ServerCertificateHealth;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.CertHealthMessage;
import com.tridium.platform.daemon.message.CheckDefaultCredentialsMessage;
import com.tridium.platform.daemon.message.DaemonDebugMessage;
import com.tridium.platform.daemon.message.DaemonUsbBackupMessage;
import com.tridium.platform.daemon.message.SshdMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import java.io.InputStream;
import java.security.AccessController;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.security.auth.x500.X500Principal;

@NiagaraType(agent={@AgentOn(types={"platform:SystemPlatformService"})})
public final class BSystemPlatformServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemPlatformServiceSecurityDashboardProviderAgent.class);
    private BSystemPlatformService systemPlatformService;
    private SecurityDashboardItemBuilder builder;
    private BDaemonSession daemonSession;
    private static final Logger LOG = Logger.getLogger("platform");
    private static final double MILLIS_IN_NINETY_DAYS = BRelTime.makeDays((int)90).getMillis();
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 3;
    private static final String SECTION_HEADER = "securityDashboard.systemPlatformService.sectionHeader";
    private static final String NO_PLATFORM_DAEMON_SUMMARY = "securityDashboard.systemPlatformService.noPlatformDaemon.summary";
    private static final String NO_PLATFORM_DAEMON_DESCRIPTION = "securityDashboard.systemPlatformService.noPlatformDaemon.description";
    private static final String TLS_STATUS_TLS_ONLY_SUMMARY = "securityDashboard.systemPlatformService.tlsService.tlsStatus.tlsOnly.summary";
    private static final String TLS_STATUS_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.tlsService.tlsStatus.enabled.summary";
    private static final String TLS_STATUS_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.tlsService.tlsStatus.disabled.summary";
    private static final String TLS_STATUS_TLS_ONLY_DESCRIPTION = "securityDashboard.systemPlatformService.tlsService.tlsOnly.description";
    private static final String CIPHER_SUITE_SUMMARY = "securityDashboard.systemPlatformService.cipherSuites.cipherSuiteGroup.summary";
    private static final String CIPHER_SUITE_TLS_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.cipherSuites.platformTLSDisabled.summary";
    private static final String CIPHER_SUITE_DESCRIPTION = "securityDashboard.systemPlatformService.cipherSuites.description";
    private static final String TLS_MIN_PROTOCOL_TLS_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.tlsMinProtocol.tlsEnabled.summary";
    private static final String TLS_MIN_PROTOCOL_TLS_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.tlsMinProtocol.tlsDisabled.summary";
    private static final String TLS_MIN_PROTOCOL_DESCRIPTION = "securityDashboard.systemPlatformService.tlsMinProtocol.description";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_ENABLED_VALID = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsEnabled.certValid";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_ENABLED_EXPIRED = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsEnabled.certExpired";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_ENABLED_NEAR_EXPIRY = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsEnabled.certNearExpiry";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_ENABLED_NOT_YET_VALID = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsEnabled.certNotYetValid";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_DISABLED_VALID = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsDisabled.certValid";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_DISABLED_EXPIRED = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsDisabled.certExpired";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_DISABLED_NEAR_EXPIRY = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsDisabled.certNearExpiry";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_DISABLED_NOT_YET_VALID = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsDisabled.certNotYetValid";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_VALID = "securityDashboard.systemPlatformService.certificateExpiry.description.certValid";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_EXPIRED = "securityDashboard.systemPlatformService.certificateExpiry.description.certExpired";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_NEAR_EXPIRY = "securityDashboard.systemPlatformService.certificateExpiry.description.certNearExpiry";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_NOT_YET_VALID = "securityDashboard.systemPlatformService.certificateExpiry.description.certNotYetValid";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_DISABLED_EXPIRED = "securityDashboard.systemPlatformService.certificateExpiry.description.tlsDisabled.certExpired";
    private static final String CERTIFICATE_SIGNATURE_TLS_ENABLED_SIGNED_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsEnabled.signed.summary";
    private static final String CERTIFICATE_SIGNATURE_TLS_ENABLED_SELF_SIGNED_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsEnabled.selfSigned.summary";
    private static final String CERTIFICATE_SIGNATURE_TLS_ENABLED_DEFAULT_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsEnabled.default.summary";
    private static final String CERTIFICATE_SIGNATURE_TLS_DISABLED_SIGNED_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsDisabled.signed.summary";
    private static final String CERTIFICATE_SIGNATURE_TLS_DISABLED_SELF_SIGNED_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsDisabled.selfSigned.summary";
    private static final String CERTIFICATE_SIGNATURE_TLS_DISABLED_DEFAULT_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsDisabled.default.summary";
    private static final String CERTIFICATE_GLOBALLY_ENCRYPTED_SUMMARY = "securityDashboard.systemPlatformService.certificate.globallyEncrypted.summary";
    private static final String CERTIFICATE_UNIQUELY_ENCRYPTED_SUMMARY = "securityDashboard.systemPlatformService.certificate.uniquelyEncrypted.summary";
    private static final String CERTIFICATE_ENCRYPTED_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.encrypted.description";
    private static final String CERTIFICATE_SIGNATURE_SIGNED_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.signature.signed.description";
    private static final String CERTIFICATE_SIGNATURE_SELF_SIGNED_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.signature.selfSigned.description";
    private static final String CERTIFICATE_SIGNATURE_DEFAULT_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.signature.default.description";
    private static final String CERTIFICATE_NOT_FOUND_SUMMARY = "securityDashboard.systemPlatformService.certificate.notFound.summary";
    private static final String CERTIFICATE_NOT_FOUND_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.notFound.description";
    private static final String CERT_HEALTH_OK = "securityDashboard.systemPlatformService.certHealth.ok";
    private static final String CERT_HEALTH_BAD_PASSWORD = "securityDashboard.systemPlatformService.certHealth.badPassword";
    private static final String CERT_HEALTH_MISSING_KEY = "securityDashboard.systemPlatformService.certHealth.missingKey";
    private static final String CERT_HEALTH_BAD_KEY = "securityDashboard.systemPlatformService.certHealth.badKey";
    private static final String CERT_HEALTH_BAD_DEFAULT = "securityDashboard.systemPlatformService.certHealth.badDefault";
    private static final String CERT_HEALTH_DESCRIPTION = "securityDashboard.systemPlatformService.certHealth.description";
    private static final String DEFAULT_SYSTEM_PASSPHRASE_SUMMARY = "securityDashboard.systemPlatformService.defaultSystemPassphrase.summary";
    private static final String DEFAULT_SYSTEM_PASSPHRASE_DESCRIPTION = "securityDashboard.systemPlatformService.defaultSystemPassphrase.description";
    private static final String DEFAULT_SYSTEM_PLATFORM_ACCOUNT_SUMMARY = "securityDashboard.systemPlatformService.defaultPlatformAccount.summary";
    private static final String DEFAULT_SYSTEM_PLATFORM_ACCOUNT_DESCRIPTION = "securityDashboard.systemPlatformService.defaultPlatformAccount.description";
    private static final String EXTENDED_MASTER_SECRET_SUMMARY = "securityDashboard.systemPlatformService.extendedMasterSecret.summary";
    private static final String EXTENDED_MASTER_SECRET_DESCRIPTION = "securityDashboard.systemPlatformService.extendedMasterSecret.description";
    private static final String SSH_SFTP_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.sshSFTP.enabled.summary";
    private static final String SSH_SFTP_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.sshSFTP.disabled.summary";
    private static final String SSH_SFTP_DESCRIPTION = "securityDashboard.systemPlatformService.sshSFTP.description";
    private static final String DAEMON_DEBUG_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.daemonDebug.enabled.summary";
    private static final String DAEMON_DEBUG_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.daemonDebug.disabled.summary";
    private static final String DAEMON_DEBUG_DESCRIPTION = "securityDashboard.systemPlatformService.daemonDebug.description";
    private static final String USB_BACKUP_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.usbBackup.enabled.summary";
    private static final String USB_BACKUP_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.usbBackup.disabled.summary";
    private static final String USB_BACKUP_DESCRIPTION = "securityDashboard.systemPlatformService.usbBackup.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.systemPlatformService = (BSystemPlatformService)object;
        this.daemonSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public int getSecurityDashboardItemsVersion() {
        return 3;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (this.daemonSession != null) {
            block4: {
                try {
                    this.daemonSession.reloadHostProperties();
                }
                catch (Exception exception) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.log(Level.FINE, "Exception occurred reloading system platform service dashboard host properties, item states may be stale", exception);
                }
            }
            BHostProperties hostProperties = this.daemonSession.getHostProperties();
            items.addAll(this.getTLSStatusAlert(hostProperties));
            items.addAll(this.getCipherStatusAlert(hostProperties));
            items.addAll(this.getTlsMinProtocolAlert(hostProperties));
            items.addAll(this.getCertificateExpiryAlert(hostProperties));
            items.addAll(this.getCertificateSignatureAlert(hostProperties));
            items.addAll(this.getServerCertificateHealthAlert(hostProperties));
            items.addAll(this.getDefaultSystemPassphraseAlert());
            items.addAll(this.getDefaultPlatformAccountAlert());
            items.addAll(this.getExtendedMasterSecretAlert(hostProperties));
            items.addAll(this.getSshSftpAlert(hostProperties));
            items.addAll(this.getDaemonDebugAlert(hostProperties));
            items.addAll(this.getUSBBackupAlert(hostProperties));
        } else {
            items.add(this.builder.makeInfo(NO_PLATFORM_DAEMON_SUMMARY, NO_PLATFORM_DAEMON_DESCRIPTION));
        }
        return Collections.unmodifiableList(items);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return null;
    }

    private List<SecurityDashboardItem> getTLSStatusAlert(BHostProperties hostProperties) {
        ArrayList items;
        block7: {
            items = null;
            try {
                if (hostProperties.getSslSupported()) {
                    items = new ArrayList();
                    BPlatformSSLSettings sslSettings = hostProperties.getSslSettings();
                    if (sslSettings.getSslEnabled()) {
                        if (sslSettings.getSslOnly()) {
                            items.add(this.builder.makeOk().withSummary(TLS_STATUS_TLS_ONLY_SUMMARY, new Object[0]).withDescription(TLS_STATUS_TLS_ONLY_DESCRIPTION, new Object[0]));
                        } else {
                            items.add(this.builder.makeAlert().withSummary(TLS_STATUS_ENABLED_SUMMARY, new Object[0]).withDescription(TLS_STATUS_TLS_ONLY_DESCRIPTION, new Object[0]));
                        }
                    } else {
                        items.add(this.builder.makeAlert().withSummary(TLS_STATUS_DISABLED_SUMMARY, new Object[0]).withDescription(TLS_STATUS_TLS_ONLY_DESCRIPTION, new Object[0]));
                    }
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Platform TLS Only dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getCipherStatusAlert(BHostProperties hostProperties) {
        ArrayList items;
        block7: {
            items = null;
            try {
                if (hostProperties.getSslSupported()) {
                    items = new ArrayList();
                    BPlatformSSLSettings sslSettings = hostProperties.getSslSettings();
                    BTlsCipherSuiteGroup tlsCipherSuiteGroup = sslSettings.getTlsCipherSuiteGroup();
                    if (sslSettings.getSslEnabled()) {
                        if (tlsCipherSuiteGroup.equals((Object)BTlsCipherSuiteGroup.recommended)) {
                            items.add(this.builder.makeOk().withSummary(CIPHER_SUITE_SUMMARY, new Object[]{tlsCipherSuiteGroup}).withDescription(CIPHER_SUITE_DESCRIPTION, new Object[0]));
                        } else {
                            items.add(this.builder.makeWarning().withSummary(CIPHER_SUITE_SUMMARY, new Object[]{tlsCipherSuiteGroup}).withDescription(CIPHER_SUITE_DESCRIPTION, new Object[0]));
                        }
                    } else {
                        items.add(this.builder.makeInfo().withSummary(CIPHER_SUITE_TLS_DISABLED_SUMMARY, new Object[]{tlsCipherSuiteGroup}).withDescription(CIPHER_SUITE_DESCRIPTION, new Object[0]));
                    }
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Platform TLS Cipher Suite dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getTlsMinProtocolAlert(BHostProperties hostProperties) {
        ArrayList items;
        block7: {
            items = null;
            try {
                if (hostProperties.getSslSupported()) {
                    items = new ArrayList();
                    BPlatformSSLSettings sslSettings = hostProperties.getSslSettings();
                    BSslTlsEnum tlsMinProtocol = sslSettings.getSslAlgType();
                    if (sslSettings.getSslEnabled()) {
                        if (BSystemPlatformServiceSecurityDashboardProviderAgent.isTlsVersionStrong(tlsMinProtocol)) {
                            items.add(this.builder.makeOk().withSummary(TLS_MIN_PROTOCOL_TLS_ENABLED_SUMMARY, new Object[]{tlsMinProtocol}).withDescription(TLS_MIN_PROTOCOL_DESCRIPTION, new Object[]{BSslTlsEnum.tlsv1_2}));
                        } else {
                            items.add(this.builder.makeWarning().withSummary(TLS_MIN_PROTOCOL_TLS_ENABLED_SUMMARY, new Object[]{tlsMinProtocol}).withDescription(TLS_MIN_PROTOCOL_DESCRIPTION, new Object[]{BSslTlsEnum.tlsv1_2}));
                        }
                    } else {
                        items.add(this.builder.makeInfo().withSummary(TLS_MIN_PROTOCOL_TLS_DISABLED_SUMMARY, new Object[]{tlsMinProtocol}).withDescription(TLS_MIN_PROTOCOL_DESCRIPTION, new Object[]{BSslTlsEnum.tlsv1_2}));
                    }
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Platform Minimum TLS Protocol dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private static boolean isTlsVersionStrong(BSslTlsEnum tlsVersion) {
        return BSslTlsEnum.tlsv1_2.equals((Object)tlsVersion) || BSslTlsEnum.tlsv1_3.equals((Object)tlsVersion);
    }

    private List<SecurityDashboardItem> getCertificateExpiryAlert(BHostProperties hostProperties) {
        ArrayList items;
        block17: {
            items = null;
            try {
                if (!hostProperties.getSslSupported()) break block17;
                items = new ArrayList();
                BPlatformSSLSettings sslSettings = hostProperties.getSslSettings();
                String alias = sslSettings.getKeyAlias();
                ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                ICoreKeyStore keyStore = (ICoreKeyStore)cryptoManager.getKeyStore();
                try {
                    X509Certificate certificate = keyStore.getCertificate(alias);
                    if (certificate == null) {
                        throw new NullPointerException("Certificate '" + alias + "'not found");
                    }
                    try {
                        certificate.checkValidity();
                        Date date = new Date();
                        if ((double)(certificate.getNotAfter().getTime() - date.getTime()) < MILLIS_IN_NINETY_DAYS) {
                            BAbsTime notAfter = BAbsTime.make((long)certificate.getNotAfter().getTime());
                            if (sslSettings.getSslEnabled()) {
                                items.add(this.builder.makeWarning().withSummary(CERTIFICATE_EXPIRY_SUMMARY_ENABLED_NEAR_EXPIRY, new Object[]{alias, notAfter}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_NEAR_EXPIRY, new Object[0]));
                            } else {
                                items.add(this.builder.makeInfo().withSummary(CERTIFICATE_EXPIRY_SUMMARY_DISABLED_NEAR_EXPIRY, new Object[]{alias, notAfter}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_NEAR_EXPIRY, new Object[0]));
                            }
                        } else if (sslSettings.getSslEnabled()) {
                            items.add(this.builder.makeOk().withSummary(CERTIFICATE_EXPIRY_SUMMARY_ENABLED_VALID, new Object[]{alias}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_VALID, new Object[0]));
                        } else {
                            items.add(this.builder.makeInfo().withSummary(CERTIFICATE_EXPIRY_SUMMARY_DISABLED_VALID, new Object[]{alias}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_VALID, new Object[0]));
                        }
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        if (sslSettings.getSslEnabled()) {
                            items.add(this.builder.makeAlert().withSummary(CERTIFICATE_EXPIRY_SUMMARY_ENABLED_EXPIRED, new Object[]{alias}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_EXPIRED, new Object[0]));
                        } else {
                            items.add(this.builder.makeInfo().withSummary(CERTIFICATE_EXPIRY_SUMMARY_DISABLED_EXPIRED, new Object[]{alias}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_DISABLED_EXPIRED, new Object[0]));
                        }
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        BAbsTime notBefore = BAbsTime.make((long)certificate.getNotBefore().getTime());
                        if (sslSettings.getSslEnabled()) {
                            items.add(this.builder.makeAlert().withSummary(CERTIFICATE_EXPIRY_SUMMARY_ENABLED_NOT_YET_VALID, new Object[]{alias, notBefore}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_NOT_YET_VALID, new Object[0]));
                            break block17;
                        }
                        items.add(this.builder.makeInfo().withSummary(CERTIFICATE_EXPIRY_SUMMARY_DISABLED_NOT_YET_VALID, new Object[]{alias, notBefore}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_NOT_YET_VALID, new Object[0]));
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block17;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Platform Certificate Expiration dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getCertificateSignatureAlert(BHostProperties hostProperties) {
        ArrayList items;
        block16: {
            items = null;
            try {
                if (!hostProperties.getSslSupported()) break block16;
                items = new ArrayList();
                BPlatformSSLSettings sslSettings = hostProperties.getSslSettings();
                String alias = sslSettings.getKeyAlias();
                ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                ICoreKeyStore keyStore = (ICoreKeyStore)cryptoManager.getKeyStore();
                try {
                    X509Certificate certificate = keyStore.getCertificate(alias);
                    if (certificate == null) {
                        throw new NullPointerException("Certificate '" + alias + "'not found");
                    }
                    if (CertUtils.checkDnEquality((X500Principal)certificate.getSubjectX500Principal(), (X500Principal)certificate.getIssuerX500Principal())) {
                        if ("default".equalsIgnoreCase(alias)) {
                            if (sslSettings.getSslEnabled()) {
                                items.add(this.builder.makeWarning().withSummary(CERTIFICATE_SIGNATURE_TLS_ENABLED_DEFAULT_SUMMARY, new Object[0]).withDescription(CERTIFICATE_SIGNATURE_DEFAULT_DESCRIPTION, new Object[0]));
                            } else {
                                items.add(this.builder.makeInfo().withSummary(CERTIFICATE_SIGNATURE_TLS_DISABLED_DEFAULT_SUMMARY, new Object[0]).withDescription(CERTIFICATE_SIGNATURE_DEFAULT_DESCRIPTION, new Object[0]));
                            }
                        } else if (sslSettings.getSslEnabled()) {
                            items.add(this.builder.makeWarning().withSummary(CERTIFICATE_SIGNATURE_TLS_ENABLED_SELF_SIGNED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_SIGNATURE_SELF_SIGNED_DESCRIPTION, new Object[0]));
                        } else {
                            items.add(this.builder.makeInfo().withSummary(CERTIFICATE_SIGNATURE_TLS_DISABLED_SELF_SIGNED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_SIGNATURE_SELF_SIGNED_DESCRIPTION, new Object[0]));
                        }
                    } else if (sslSettings.getSslEnabled()) {
                        items.add(this.builder.makeOk().withSummary(CERTIFICATE_SIGNATURE_TLS_ENABLED_SIGNED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_SIGNATURE_SIGNED_DESCRIPTION, new Object[0]));
                    } else {
                        items.add(this.builder.makeInfo().withSummary(CERTIFICATE_SIGNATURE_TLS_DISABLED_SIGNED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_SIGNATURE_SIGNED_DESCRIPTION, new Object[0]));
                    }
                    if (CertUtils.isPrivateKeyGloballyEncrypted((String)alias, (ICoreKeyStore)keyStore)) {
                        items.add(this.builder.makeWarning().withSummary(CERTIFICATE_GLOBALLY_ENCRYPTED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_ENCRYPTED_DESCRIPTION, new Object[0]));
                        break block16;
                    }
                    items.add(this.builder.makeOk().withSummary(CERTIFICATE_UNIQUELY_ENCRYPTED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_ENCRYPTED_DESCRIPTION, new Object[0]));
                }
                catch (Exception exception) {
                    items.add((sslSettings.getSslEnabled() ? this.builder.makeWarning() : this.builder.makeInfo()).withSummary(CERTIFICATE_NOT_FOUND_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_NOT_FOUND_DESCRIPTION, new Object[0]));
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block16;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Platform Certificate Signature dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getServerCertificateHealthAlert(BHostProperties hostProperties) {
        ArrayList<SecurityDashboardItem> items;
        block10: {
            items = null;
            try {
                if (hostProperties.getSslSupported() && new Version(hostProperties.getDaemonVersion()).compareTo(new Version("4.13")) >= 0) {
                    items = new ArrayList<SecurityDashboardItem>();
                    XElem elem = XParser.make((InputStream)this.daemonSession.getInputStream(new CertHealthMessage())).parse();
                    ServerCertificateHealth health = new ServerCertificateHealth(elem.get("requestedCert"), elem.get("returnedCert"), CertificateStatusEnum.valueOf((String)elem.get("certStatus")));
                    switch (health.getCause()) {
                        case OK: 
                        case OK_INCOMPLETE_CHAIN: {
                            items.add(this.builder.makeOk().withSummary(CERT_HEALTH_OK, new Object[]{health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                            break;
                        }
                        case BAD_PASSWORD: {
                            items.add(this.builder.makeAlert().withSummary(CERT_HEALTH_BAD_PASSWORD, new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                            break;
                        }
                        case BAD_KEY: {
                            items.add(this.builder.makeAlert().withSummary(CERT_HEALTH_BAD_KEY, new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                            break;
                        }
                        case MISSING_KEY: {
                            items.add(this.builder.makeAlert().withSummary(CERT_HEALTH_MISSING_KEY, new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                            break;
                        }
                        case BAD_DEFAULT: {
                            items.add(this.builder.makeAlert().withSummary(CERT_HEALTH_BAD_DEFAULT, new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block10;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Platform Certificate Health dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getDefaultSystemPassphraseAlert() {
        ArrayList<SecurityDashboardItem> items;
        block3: {
            items = null;
            try {
                XElem systemPasswordElem = XParser.make((InputStream)this.daemonSession.getInputStream(new SystemPasswordMessage())).parse();
                boolean factoryDefaultSystemPasswordPresent = systemPasswordElem.getb("default", false);
                if (factoryDefaultSystemPasswordPresent) {
                    items = new ArrayList<SecurityDashboardItem>();
                    items.add(this.builder.makeAlert(DEFAULT_SYSTEM_PASSPHRASE_SUMMARY, DEFAULT_SYSTEM_PASSPHRASE_DESCRIPTION));
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Default System Passphrase dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getDefaultPlatformAccountAlert() {
        ArrayList<SecurityDashboardItem> items;
        block3: {
            items = null;
            try {
                boolean defaultCredentialsPresent;
                XElem userElem;
                XElem authInfoElem = XParser.make((InputStream)this.daemonSession.getInputStream(new CheckDefaultCredentialsMessage())).parse();
                XElem authElem = authInfoElem.elem("auth");
                if (authElem != null && (userElem = authElem.elem("user")) != null && (defaultCredentialsPresent = userElem.getb("default", false))) {
                    items = new ArrayList<SecurityDashboardItem>();
                    items.add(this.builder.makeAlert(DEFAULT_SYSTEM_PLATFORM_ACCOUNT_SUMMARY, DEFAULT_SYSTEM_PLATFORM_ACCOUNT_DESCRIPTION));
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Default Platform Credentials dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getExtendedMasterSecretAlert(BHostProperties hostProperties) {
        ArrayList items;
        block7: {
            items = null;
            try {
                if (hostProperties.getSslSupported()) {
                    items = new ArrayList();
                    BPlatformSSLSettings sslSettings = hostProperties.getSslSettings();
                    String useExtendedMasterSecret = sslSettings.getUseExtendedMasterSecret();
                    if (sslSettings.getSslEnabled()) {
                        if ("true".equals(useExtendedMasterSecret)) {
                            items.add(this.builder.makeOk().withSummary(EXTENDED_MASTER_SECRET_SUMMARY, new Object[]{useExtendedMasterSecret}).withDescription(EXTENDED_MASTER_SECRET_DESCRIPTION, new Object[0]));
                        } else {
                            items.add(this.builder.makeWarning().withSummary(EXTENDED_MASTER_SECRET_SUMMARY, new Object[]{useExtendedMasterSecret}).withDescription(EXTENDED_MASTER_SECRET_DESCRIPTION, new Object[0]));
                        }
                    } else {
                        items.add(this.builder.makeInfo().withSummary(EXTENDED_MASTER_SECRET_SUMMARY, new Object[]{useExtendedMasterSecret}).withDescription(EXTENDED_MASTER_SECRET_DESCRIPTION, new Object[0]));
                    }
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh TLS Use Extended Master Secret dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getSshSftpAlert(BHostProperties hostProperties) {
        ArrayList items;
        block5: {
            items = null;
            try {
                if (hostProperties.supportsServlet("sshd")) {
                    items = new ArrayList();
                    XElem elem = XParser.make((InputStream)this.daemonSession.getInputStream(new SshdMessage(false))).parse();
                    int sshdPort = elem.geti("port", -1);
                    if (sshdPort > 0) {
                        items.add(this.builder.makeAlert().withSummary(SSH_SFTP_ENABLED_SUMMARY, new Object[0]).withDescription(SSH_SFTP_DESCRIPTION, new Object[0]));
                    } else {
                        items.add(this.builder.makeOk().withSummary(SSH_SFTP_DISABLED_SUMMARY, new Object[0]).withDescription(SSH_SFTP_DESCRIPTION, new Object[0]));
                    }
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh SSHD dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getDaemonDebugAlert(BHostProperties hostProperties) {
        ArrayList items;
        block5: {
            items = null;
            try {
                if (hostProperties.supportsServlet("debug")) {
                    items = new ArrayList();
                    XElem debugElem = XParser.make((InputStream)this.daemonSession.getInputStream(new DaemonDebugMessage())).parse();
                    boolean daemonDebugFlag = debugElem.getb("daemonDebug", false);
                    if (daemonDebugFlag) {
                        items.add(this.builder.makeAlert().withSummary(DAEMON_DEBUG_ENABLED_SUMMARY, new Object[0]).withDescription(DAEMON_DEBUG_DESCRIPTION, new Object[0]));
                    } else {
                        items.add(this.builder.makeOk().withSummary(DAEMON_DEBUG_DISABLED_SUMMARY, new Object[0]).withDescription(DAEMON_DEBUG_DESCRIPTION, new Object[0]));
                    }
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh Daemon Debug dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getUSBBackupAlert(BHostProperties hostProperties) {
        ArrayList items;
        block5: {
            items = null;
            try {
                if (hostProperties.supportsServlet("usbbackup")) {
                    items = new ArrayList();
                    XElem usbElem = XParser.make((InputStream)this.daemonSession.getInputStream(new DaemonUsbBackupMessage())).parse();
                    boolean usbBackupEnabled = usbElem.getb("enabled", false);
                    if (usbBackupEnabled) {
                        items.add(this.builder.makeWarning().withSummary(USB_BACKUP_ENABLED_SUMMARY, new Object[0]).withDescription(USB_BACKUP_DESCRIPTION, new Object[0]));
                    } else {
                        items.add(this.builder.makeInfo().withSummary(USB_BACKUP_DISABLED_SUMMARY, new Object[0]).withDescription(USB_BACKUP_DESCRIPTION, new Object[0]));
                    }
                }
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.log(Level.FINE, "Exception occurred attempting to refresh USB Backup dashboard entry, item state may be stale", exception);
            }
        }
        return items == null ? Collections.emptyList() : items;
    }
}

