/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.subscription.SubscriptionLicenseUtil;
import com.tridium.nre.util.SystemPropertiesUtil;
import com.tridium.platform.BEngineWatchdogPolicy;
import com.tridium.platform.BHostIdStatus;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.platform.archive.FileArchive;
import com.tridium.platform.archive.NullFileArchive;
import com.tridium.platform.archive.ZipArchive;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import com.tridium.platform.daemon.message.ReloadTimeZoneMessage;
import com.tridium.platform.daemon.message.UpdateRequestStateMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.fox.BTimeChannel;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.engine.EngineManager;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import com.tridium.sys.station.Station;
import com.tridium.timezone.TzJarUtil;
import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.FileUtil;
import javax.baja.platform.RemoteStation;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.BStationNameValidator;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Version;
import javax.baja.web.BWebServer;
import javax.baja.web.BWebService;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="javaVmName", type="String", defaultValue="", flags=3), @NiagaraProperty(name="javaVmVendor", type="String", defaultValue="", flags=3), @NiagaraProperty(name="javaVmVersion", type="String", defaultValue="", flags=3), @NiagaraProperty(name="osArch", type="String", defaultValue="", flags=3), @NiagaraProperty(name="osName", type="String", defaultValue="", flags=3), @NiagaraProperty(name="osVersion", type="String", defaultValue="", flags=3), @NiagaraProperty(name="hostId", type="String", defaultValue="", flags=3), @NiagaraProperty(name="hostIdStatus", type="BHostIdStatus", defaultValue="BHostIdStatus.make(0)", flags=3), @NiagaraProperty(name="model", type="String", defaultValue="", flags=3), @NiagaraProperty(name="product", type="String", defaultValue="", flags=3), @NiagaraProperty(name="modelVersion", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="niagaraVersion", type="String", defaultValue="", flags=3), @NiagaraProperty(name="locale", type="String", defaultValue="", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.FIELD_WIDTH }, new BInteger[] { BInteger.make(2), BInteger.make(8) })")}), @NiagaraProperty(name="stationName", type="String", defaultValue="system", flags=3), @NiagaraProperty(name="systemTime", type="BAbsTime", defaultValue="Clock.time(1000)", flags=3), @NiagaraProperty(name="timeZone", type="BTimeZone", defaultValue="BTimeZone.DEFAULT", flags=3), @NiagaraProperty(name="isSystemTimeReadonly", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="currentCpuUsage", type="int", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="overallCpuUsage", type="int", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="numCpus", type="int", defaultValue="1", flags=3), @NiagaraProperty(name="totalPhysicalMemory", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="freePhysicalMemory", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="filesystemAttributes", type="BVector", defaultValue="new BVector()", flags=3), @NiagaraProperty(name="isStation", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="engineWatchdogPolicy", type="BEngineWatchdogPolicy", defaultValue="BEngineWatchdogPolicy.terminate", flags=1), @NiagaraProperty(name="engineWatchdogTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(3)", flags=1, facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS, BFacets.MIN, BFacets.SHOW_SECONDS }, new BIDataValue[] { BUnit.getUnit(\"minute\"), BRelTime.make(0), BBoolean.FALSE })")}), @NiagaraProperty(name="isStationAutoSaveEnabled", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="stationAutoSaveFrequency", type="BRelTime", defaultValue="BRelTime.HOUR", flags=1, facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS, BFacets.MIN, BFacets.SHOW_SECONDS }, new BIDataValue[] { BUnit.getUnit(\"minute\"), BRelTime.makeMinutes(1), BBoolean.FALSE })")}), @NiagaraProperty(name="stationSaveBackupCount", type="int", defaultValue="3", flags=1, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX }, new BInteger[] { BInteger.make(1), BInteger.make(10) })")}), @NiagaraProperty(name="timezoneDayModeSupport", type="BDstSupportLevel", defaultValue="BDstSupportLevel.none", flags=3), @NiagaraProperty(name="localDaemonAccess", type="BDaemonAccessLevel", defaultValue="BDaemonAccessLevel.none", flags=3), @NiagaraProperty(name="localDaemonPort", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="localDaemonSslPort", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="stationSaveAlarmSupport", type="BPlatformAlarmSupport", defaultValue="initStationSaveAlarmSupport()"), @NiagaraProperty(name="stationSaveAlarmProxy", type="BPlatformAlarmProxy", defaultValue="new BPlatformAlarmProxy()", flags=6), @NiagaraProperty(name="bajaHome", type="String", defaultValue="unknown", flags=6), @NiagaraProperty(name="niagaraUserHome", type="String", defaultValue="unknown", flags=6), @NiagaraProperty(name="allowStationRestart", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="fipsStatus", type="String", defaultValue="", flags=3), @NiagaraProperty(name="isServiceReadonly", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="allowBrandChange", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isLicenseReadonly", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isNiagaraHomeReadonly", type="boolean", defaultValue="false", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="getFilesystemForPath", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BString", flags=4), @NiagaraAction(name="getAllTimeZones", returnType="BVector", flags=4), @NiagaraAction(name="reboot", flags=4), @NiagaraAction(name="requestGarbageCollection"), @NiagaraAction(name="sendThreadDumpToConsole"), @NiagaraAction(name="getEngineWatchdogPolicyFacets", returnType="BFacets", flags=4), @NiagaraAction(name="restartStation", flags=128)})
public class BSystemPlatformService
extends BPlatformService
implements BIAlarmablePlatformService {
    @Generated
    public static final Property javaVmName = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property javaVmVendor = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property javaVmVersion = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property osArch = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property osName = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property osVersion = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property hostId = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property hostIdStatus = BSystemPlatformService.newProperty((int)3, (BValue)BHostIdStatus.make(0), null);
    @Generated
    public static final Property model = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property product = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property modelVersion = BSystemPlatformService.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property niagaraVersion = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property locale = BSystemPlatformService.newProperty((int)3, (String)"", (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth"}, (BIDataValue[])new BInteger[]{BInteger.make((int)2), BInteger.make((int)8)}));
    @Generated
    public static final Property stationName = BSystemPlatformService.newProperty((int)3, (String)"system", null);
    @Generated
    public static final Property systemTime = BSystemPlatformService.newProperty((int)3, (BValue)Clock.time((int)1000), null);
    @Generated
    public static final Property timeZone = BSystemPlatformService.newProperty((int)3, (BValue)BTimeZone.DEFAULT, null);
    @Generated
    public static final Property isSystemTimeReadonly = BSystemPlatformService.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property currentCpuUsage = BSystemPlatformService.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Property overallCpuUsage = BSystemPlatformService.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Property numCpus = BSystemPlatformService.newProperty((int)3, (int)1, null);
    @Generated
    public static final Property totalPhysicalMemory = BSystemPlatformService.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property freePhysicalMemory = BSystemPlatformService.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property filesystemAttributes = BSystemPlatformService.newProperty((int)3, (BValue)new BVector(), null);
    @Generated
    public static final Property isStation = BSystemPlatformService.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property engineWatchdogPolicy = BSystemPlatformService.newProperty((int)1, (BValue)BEngineWatchdogPolicy.terminate, null);
    @Generated
    public static final Property engineWatchdogTimeout = BSystemPlatformService.newProperty((int)1, (BValue)BRelTime.makeMinutes((int)3), (BFacets)BFacets.make((String[])new String[]{"units", "min", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"minute"), BRelTime.make((long)0L), BBoolean.FALSE}));
    @Generated
    public static final Property isStationAutoSaveEnabled = BSystemPlatformService.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property stationAutoSaveFrequency = BSystemPlatformService.newProperty((int)1, (BValue)BRelTime.HOUR, (BFacets)BFacets.make((String[])new String[]{"units", "min", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"minute"), BRelTime.makeMinutes((int)1), BBoolean.FALSE}));
    @Generated
    public static final Property stationSaveBackupCount = BSystemPlatformService.newProperty((int)1, (int)3, (BFacets)BFacets.make((String[])new String[]{"min", "max"}, (BIDataValue[])new BInteger[]{BInteger.make((int)1), BInteger.make((int)10)}));
    @Generated
    public static final Property timezoneDayModeSupport = BSystemPlatformService.newProperty((int)3, (BValue)BDstSupportLevel.none, null);
    @Generated
    public static final Property localDaemonAccess = BSystemPlatformService.newProperty((int)3, (BValue)BDaemonAccessLevel.none, null);
    @Generated
    public static final Property localDaemonPort = BSystemPlatformService.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property localDaemonSslPort = BSystemPlatformService.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property stationSaveAlarmSupport = BSystemPlatformService.newProperty((int)0, (BValue)BSystemPlatformService.initStationSaveAlarmSupport(), null);
    @Generated
    public static final Property stationSaveAlarmProxy = BSystemPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    @Generated
    public static final Property bajaHome = BSystemPlatformService.newProperty((int)6, (String)"unknown", null);
    @Generated
    public static final Property niagaraUserHome = BSystemPlatformService.newProperty((int)6, (String)"unknown", null);
    @Generated
    public static final Property allowStationRestart = BSystemPlatformService.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property fipsStatus = BSystemPlatformService.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property isServiceReadonly = BSystemPlatformService.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property allowBrandChange = BSystemPlatformService.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isLicenseReadonly = BSystemPlatformService.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isNiagaraHomeReadonly = BSystemPlatformService.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Action getFilesystemForPath = BSystemPlatformService.newAction((int)4, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action getAllTimeZones = BSystemPlatformService.newAction((int)4, null);
    @Generated
    public static final Action reboot = BSystemPlatformService.newAction((int)4, null);
    @Generated
    public static final Action requestGarbageCollection = BSystemPlatformService.newAction((int)0, null);
    @Generated
    public static final Action sendThreadDumpToConsole = BSystemPlatformService.newAction((int)0, null);
    @Generated
    public static final Action getEngineWatchdogPolicyFacets = BSystemPlatformService.newAction((int)4, null);
    @Generated
    public static final Action restartStation = BSystemPlatformService.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemPlatformService.class);
    private static final BIcon icon = BIcon.std((String)"platform.png");
    private static boolean alternativeArchiveInitialized;
    private volatile BVector allTimeZones = null;
    private boolean allowTimeUpdate = true;
    private boolean timeUpdated = false;
    private boolean timeZoneUpdated = false;
    private boolean localeUpdated = false;
    private boolean allowLocaleUpdate = true;
    private final SystemPlatformServiceSaveListener saveListener = new SystemPlatformServiceSaveListener();
    private static final BTypeSpec STATION_OUTPUT_SERVLET;
    private static final String ALARM_TYPE_STATION_SAVE = "station save failure";
    private volatile boolean stationSaveListenerActive = false;

    @Generated
    public String getJavaVmName() {
        return this.getString(javaVmName);
    }

    @Generated
    public void setJavaVmName(String v) {
        this.setString(javaVmName, v, null);
    }

    @Generated
    public String getJavaVmVendor() {
        return this.getString(javaVmVendor);
    }

    @Generated
    public void setJavaVmVendor(String v) {
        this.setString(javaVmVendor, v, null);
    }

    @Generated
    public String getJavaVmVersion() {
        return this.getString(javaVmVersion);
    }

    @Generated
    public void setJavaVmVersion(String v) {
        this.setString(javaVmVersion, v, null);
    }

    @Generated
    public String getOsArch() {
        return this.getString(osArch);
    }

    @Generated
    public void setOsArch(String v) {
        this.setString(osArch, v, null);
    }

    @Generated
    public String getOsName() {
        return this.getString(osName);
    }

    @Generated
    public void setOsName(String v) {
        this.setString(osName, v, null);
    }

    @Generated
    public String getOsVersion() {
        return this.getString(osVersion);
    }

    @Generated
    public void setOsVersion(String v) {
        this.setString(osVersion, v, null);
    }

    @Generated
    public String getHostId() {
        return this.getString(hostId);
    }

    @Generated
    public void setHostId(String v) {
        this.setString(hostId, v, null);
    }

    @Generated
    public BHostIdStatus getHostIdStatus() {
        return (BHostIdStatus)this.get(hostIdStatus);
    }

    @Generated
    public void setHostIdStatus(BHostIdStatus v) {
        this.set(hostIdStatus, (BValue)v, null);
    }

    @Generated
    public String getModel() {
        return this.getString(model);
    }

    @Generated
    public void setModel(String v) {
        this.setString(model, v, null);
    }

    @Generated
    public String getProduct() {
        return this.getString(product);
    }

    @Generated
    public void setProduct(String v) {
        this.setString(product, v, null);
    }

    @Generated
    public String getModelVersion() {
        return this.getString(modelVersion);
    }

    @Generated
    public void setModelVersion(String v) {
        this.setString(modelVersion, v, null);
    }

    @Generated
    public String getNiagaraVersion() {
        return this.getString(niagaraVersion);
    }

    @Generated
    public void setNiagaraVersion(String v) {
        this.setString(niagaraVersion, v, null);
    }

    @Generated
    public String getLocale() {
        return this.getString(locale);
    }

    @Generated
    public void setLocale(String v) {
        this.setString(locale, v, null);
    }

    @Generated
    public String getStationName() {
        return this.getString(stationName);
    }

    @Generated
    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    @Generated
    public BAbsTime getSystemTime() {
        return (BAbsTime)this.get(systemTime);
    }

    @Generated
    public void setSystemTime(BAbsTime v) {
        this.set(systemTime, (BValue)v, null);
    }

    @Generated
    public BTimeZone getTimeZone() {
        return (BTimeZone)this.get(timeZone);
    }

    @Generated
    public void setTimeZone(BTimeZone v) {
        this.set(timeZone, (BValue)v, null);
    }

    @Generated
    public boolean getIsSystemTimeReadonly() {
        return this.getBoolean(isSystemTimeReadonly);
    }

    @Generated
    public void setIsSystemTimeReadonly(boolean v) {
        this.setBoolean(isSystemTimeReadonly, v, null);
    }

    @Generated
    public int getCurrentCpuUsage() {
        return this.getInt(currentCpuUsage);
    }

    @Generated
    public void setCurrentCpuUsage(int v) {
        this.setInt(currentCpuUsage, v, null);
    }

    @Generated
    public int getOverallCpuUsage() {
        return this.getInt(overallCpuUsage);
    }

    @Generated
    public void setOverallCpuUsage(int v) {
        this.setInt(overallCpuUsage, v, null);
    }

    @Generated
    public int getNumCpus() {
        return this.getInt(numCpus);
    }

    @Generated
    public void setNumCpus(int v) {
        this.setInt(numCpus, v, null);
    }

    @Generated
    public int getTotalPhysicalMemory() {
        return this.getInt(totalPhysicalMemory);
    }

    @Generated
    public void setTotalPhysicalMemory(int v) {
        this.setInt(totalPhysicalMemory, v, null);
    }

    @Generated
    public int getFreePhysicalMemory() {
        return this.getInt(freePhysicalMemory);
    }

    @Generated
    public void setFreePhysicalMemory(int v) {
        this.setInt(freePhysicalMemory, v, null);
    }

    @Generated
    public BVector getFilesystemAttributes() {
        return (BVector)this.get(filesystemAttributes);
    }

    @Generated
    public void setFilesystemAttributes(BVector v) {
        this.set(filesystemAttributes, (BValue)v, null);
    }

    @Generated
    public boolean getIsStation() {
        return this.getBoolean(isStation);
    }

    @Generated
    public void setIsStation(boolean v) {
        this.setBoolean(isStation, v, null);
    }

    @Generated
    public BEngineWatchdogPolicy getEngineWatchdogPolicy() {
        return (BEngineWatchdogPolicy)this.get(engineWatchdogPolicy);
    }

    @Generated
    public void setEngineWatchdogPolicy(BEngineWatchdogPolicy v) {
        this.set(engineWatchdogPolicy, (BValue)v, null);
    }

    @Generated
    public BRelTime getEngineWatchdogTimeout() {
        return (BRelTime)this.get(engineWatchdogTimeout);
    }

    @Generated
    public void setEngineWatchdogTimeout(BRelTime v) {
        this.set(engineWatchdogTimeout, (BValue)v, null);
    }

    @Generated
    public boolean getIsStationAutoSaveEnabled() {
        return this.getBoolean(isStationAutoSaveEnabled);
    }

    @Generated
    public void setIsStationAutoSaveEnabled(boolean v) {
        this.setBoolean(isStationAutoSaveEnabled, v, null);
    }

    @Generated
    public BRelTime getStationAutoSaveFrequency() {
        return (BRelTime)this.get(stationAutoSaveFrequency);
    }

    @Generated
    public void setStationAutoSaveFrequency(BRelTime v) {
        this.set(stationAutoSaveFrequency, (BValue)v, null);
    }

    @Generated
    public int getStationSaveBackupCount() {
        return this.getInt(stationSaveBackupCount);
    }

    @Generated
    public void setStationSaveBackupCount(int v) {
        this.setInt(stationSaveBackupCount, v, null);
    }

    @Generated
    public BDstSupportLevel getTimezoneDayModeSupport() {
        return (BDstSupportLevel)this.get(timezoneDayModeSupport);
    }

    @Generated
    public void setTimezoneDayModeSupport(BDstSupportLevel v) {
        this.set(timezoneDayModeSupport, (BValue)v, null);
    }

    @Generated
    public BDaemonAccessLevel getLocalDaemonAccess() {
        return (BDaemonAccessLevel)this.get(localDaemonAccess);
    }

    @Generated
    public void setLocalDaemonAccess(BDaemonAccessLevel v) {
        this.set(localDaemonAccess, (BValue)v, null);
    }

    @Generated
    public int getLocalDaemonPort() {
        return this.getInt(localDaemonPort);
    }

    @Generated
    public void setLocalDaemonPort(int v) {
        this.setInt(localDaemonPort, v, null);
    }

    @Generated
    public int getLocalDaemonSslPort() {
        return this.getInt(localDaemonSslPort);
    }

    @Generated
    public void setLocalDaemonSslPort(int v) {
        this.setInt(localDaemonSslPort, v, null);
    }

    @Generated
    public BPlatformAlarmSupport getStationSaveAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(stationSaveAlarmSupport);
    }

    @Generated
    public void setStationSaveAlarmSupport(BPlatformAlarmSupport v) {
        this.set(stationSaveAlarmSupport, (BValue)v, null);
    }

    @Generated
    public BPlatformAlarmProxy getStationSaveAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(stationSaveAlarmProxy);
    }

    @Generated
    public void setStationSaveAlarmProxy(BPlatformAlarmProxy v) {
        this.set(stationSaveAlarmProxy, (BValue)v, null);
    }

    @Generated
    public String getBajaHome() {
        return this.getString(bajaHome);
    }

    @Generated
    public void setBajaHome(String v) {
        this.setString(bajaHome, v, null);
    }

    @Generated
    public String getNiagaraUserHome() {
        return this.getString(niagaraUserHome);
    }

    @Generated
    public void setNiagaraUserHome(String v) {
        this.setString(niagaraUserHome, v, null);
    }

    @Generated
    public boolean getAllowStationRestart() {
        return this.getBoolean(allowStationRestart);
    }

    @Generated
    public void setAllowStationRestart(boolean v) {
        this.setBoolean(allowStationRestart, v, null);
    }

    @Generated
    public String getFipsStatus() {
        return this.getString(fipsStatus);
    }

    @Generated
    public void setFipsStatus(String v) {
        this.setString(fipsStatus, v, null);
    }

    @Generated
    public boolean getIsServiceReadonly() {
        return this.getBoolean(isServiceReadonly);
    }

    @Generated
    public void setIsServiceReadonly(boolean v) {
        this.setBoolean(isServiceReadonly, v, null);
    }

    @Generated
    public boolean getAllowBrandChange() {
        return this.getBoolean(allowBrandChange);
    }

    @Generated
    public void setAllowBrandChange(boolean v) {
        this.setBoolean(allowBrandChange, v, null);
    }

    @Generated
    public boolean getIsLicenseReadonly() {
        return this.getBoolean(isLicenseReadonly);
    }

    @Generated
    public void setIsLicenseReadonly(boolean v) {
        this.setBoolean(isLicenseReadonly, v, null);
    }

    @Generated
    public boolean getIsNiagaraHomeReadonly() {
        return this.getBoolean(isNiagaraHomeReadonly);
    }

    @Generated
    public void setIsNiagaraHomeReadonly(boolean v) {
        this.setBoolean(isNiagaraHomeReadonly, v, null);
    }

    @Generated
    public BString getFilesystemForPath(BString parameter) {
        return (BString)this.invoke(getFilesystemForPath, (BValue)parameter, null);
    }

    @Generated
    public BVector getAllTimeZones() {
        return (BVector)this.invoke(getAllTimeZones, null, null);
    }

    @Generated
    public void reboot() {
        this.invoke(reboot, null, null);
    }

    @Generated
    public void requestGarbageCollection() {
        this.invoke(requestGarbageCollection, null, null);
    }

    @Generated
    public void sendThreadDumpToConsole() {
        this.invoke(sendThreadDumpToConsole, null, null);
    }

    @Generated
    public BFacets getEngineWatchdogPolicyFacets() {
        return (BFacets)this.invoke(getEngineWatchdogPolicyFacets, null, null);
    }

    @Generated
    public void restartStation() {
        this.invoke(restartStation, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSystemPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("SystemPlatformService.description"));
    }

    @Override
    public void serviceStarted() throws Exception {
        super.serviceStarted();
        AccessController.doPrivileged(() -> {
            this.setJavaVmName(System.getProperty("java.vm.name"));
            this.setJavaVmVendor(System.getProperty("java.vm.vendor"));
            this.setJavaVmVersion(System.getProperty("java.vm.version"));
            this.setOsArch(System.getProperty("os.arch"));
            this.setOsName(System.getProperty("os.name"));
            this.setOsVersion(System.getProperty("os.version"));
            return null;
        });
        this.setHostId(Nre.getHostId());
        this.setHostIdStatus(BHostIdStatus.make(SubscriptionLicenseUtil.getHostIdStatus()));
        this.setModel(Nre.getHostModel());
        this.setModelVersion(Nre.getHostModelVersion());
        this.setProduct(Nre.getHostProduct());
        this.setBajaHome(Nre.getNiagaraHome().getAbsolutePath());
        this.setNiagaraUserHome(Sys.getNiagaraUserHome().getAbsolutePath());
        this.setNiagaraVersion(Sys.getBajaVersion().toString());
        BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
        if (registry.get("time") == null) {
            registry.add("time", (BValue)new BTimeChannel());
        }
    }

    @Override
    public void serviceStopped() throws Exception {
        super.serviceStopped();
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
        BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
        if (registry.get("time") != null) {
            registry.remove("time");
        }
    }

    @Override
    public void doStationStarted(BStation station) {
        this.setIsStation(true);
        this.setStationName(station.getStationName());
        new StationStartupWorker().start();
    }

    public boolean isChildLegal(BComponent bc) {
        return bc.getType().getTypeSpec().equals((Object)STATION_OUTPUT_SERVLET);
    }

    public boolean isOnLocalHost() {
        return Nre.getHostId().equals(this.getHostId());
    }

    @Override
    public boolean isValidPlatform() {
        return false;
    }

    @Override
    public int getSlotFlags() {
        return 0;
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        this.getStationSaveAlarmProxy().setAlarmSupport(this.getStationSaveAlarmSupport());
        AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
        boolean stationPlatformReadonly = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.isStationPlatformReadonly();
        this.setIsServiceReadonly(stationPlatformReadonly);
        boolean isNiagaraHomeReadonly = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.isNiagaraHomeReadonly();
        this.setIsNiagaraHomeReadonly(isNiagaraHomeReadonly);
        this.initAlternativeArchive();
        this.allowTimeUpdate = false;
        this.setSystemTime(Clock.time((int)1000));
        this.setTimeZone(BTimeZone.getLocal());
        this.allowTimeUpdate = true;
        this.allowLocaleUpdate = false;
        this.setLocale(Locale.getDefault().toString());
        this.allowLocaleUpdate = true;
        this.assertValidEngineWatchdogPolicy();
        boolean fipsLicensed = false;
        try {
            Sys.getLicenseManager().checkFeature("tridium", "fips140-2");
            fipsLicensed = true;
        }
        catch (FeatureNotLicensedException featureNotLicensedException) {
            // empty catch block
        }
        boolean fipsEnabled = SecurityInitializer.getInstance().isFips();
        if (fipsLicensed && fipsEnabled) {
            this.setFipsStatus(this.getLexicon().getText("labels.system.fipsEnabled"));
        }
        if (fipsLicensed && !fipsEnabled) {
            this.setFipsStatus(this.getLexicon().getText("labels.system.fipsLicensedNotEnabled"));
        }
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.allowTimeUpdate && this.platformServicePropertiesLoaded) {
            if (prop == systemTime) {
                this.timeUpdated = true;
            }
            if (prop == timeZone) {
                this.timeZoneUpdated = true;
            }
        }
        if (this.allowLocaleUpdate && this.platformServicePropertiesLoaded && prop == locale) {
            this.localeUpdated = true;
        }
        if (this.platformServicePropertiesLoaded && prop == engineWatchdogPolicy) {
            this.assertValidEngineWatchdogPolicy();
        }
    }

    @Override
    protected boolean startPollTimerOnSubscribe() {
        return true;
    }

    @Override
    public BRelTime getPollFrequency() {
        return BRelTime.makeSeconds((int)5);
    }

    @Override
    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(cx);
        if (!this.timeUpdated) {
            this.allowTimeUpdate = false;
            this.setSystemTime(Clock.time((int)1000));
            this.allowTimeUpdate = true;
        }
    }

    @Override
    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        this.checkPropertiesLoaded();
        if (this.localeUpdated) {
            if (!this.setBajaLocaleId(this.getLocale())) {
                if (this.stationSaveListenerActive) {
                    BPlatform.log.warning("Failed to setBajaLocaleId(" + this.getLocale() + ") during station save");
                } else {
                    throw new BajaRuntimeException("Failed to setBajaLocaleId(" + this.getLocale() + ")");
                }
            }
            this.localeUpdated = false;
        }
        if (this.timeZoneUpdated || this.timeUpdated) {
            BTimeZone tz = this.getTimeZone();
            if (!this.getIsServiceReadonly() && !this.getIsSystemTimeReadonly()) {
                BDaemonSession session;
                boolean timeZoneSuccess;
                long rightNow = this.getSystemTime().getMillis();
                if (!TimeZoneUtil.isSupported(rightNow, tz, this.getTimezoneDayModeSupport())) {
                    BPlatform.log.warning("Time zone '" + tz + "' is not supported by the operating system, using UTC as the OS time zone");
                    tz = BTimeZone.UTC;
                }
                if (!(timeZoneSuccess = this.setPlatformTimeZone(tz.getId()))) {
                    if (this.stationSaveListenerActive) {
                        BPlatform.log.warning("Failed to setPlatformTimeZone(" + tz.getId() + ") during station save");
                    } else {
                        throw new BajaRuntimeException("Failed to setPlatformTimeZone(" + tz.getId() + ")");
                    }
                }
                if ((session = AccessController.doPrivileged(LocalSessionUtil::getLocalSession)) != null && timeZoneSuccess) {
                    try {
                        session.sendMessage(new ReloadTimeZoneMessage());
                    }
                    catch (Exception e) {
                        BPlatform.log.log(Level.WARNING, "Failed to send Niagara Daemon reloadTz message, reboot is required to apply change to the Niagara Daemon", e);
                    }
                }
            }
            this.timeZoneUpdated = false;
        }
        if (this.timeUpdated) {
            if (!(this.getIsServiceReadonly() || this.getIsSystemTimeReadonly() || this.setPlatformSystemTime(this.getSystemTime().getMillis()))) {
                if (this.stationSaveListenerActive) {
                    BPlatform.log.warning("Failed to setPlatformSystemTime(" + this.getSystemTime().getMillis() + ") during station save");
                } else {
                    throw new BajaRuntimeException("Failed to setPlatformSystemTime(" + this.getSystemTime().getMillis() + ")");
                }
            }
            this.timeUpdated = false;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    public boolean hasNavChildren() {
        return false;
    }

    public void doReboot() throws Exception {
        throw new LocalizableRuntimeException("platform", "system.error.rebootNotSupported");
    }

    public void doSendThreadDumpToConsole() {
        NreLib.dumpThreads();
    }

    public void doRestartStation() throws Exception {
        if (Sys.getStation() == null) {
            throw new LocalizableRuntimeException("platform", "system.error.notStation");
        }
        if (!AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue()) {
            throw new LocalizableRuntimeException("platform", "system.error.localDaemonUnavailable");
        }
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                this.sendRestartRequest(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, "BSystemPlatformService::doRestartStation").start();
    }

    public BString doGetFilesystemForPath(BString filePathBody) throws Exception {
        File localFile = BFileSystem.INSTANCE.pathToLocalFile(new FilePath(filePathBody.toString()));
        FilePath canonicalFilePath = BFileSystem.INSTANCE.localFileToPath(new File(localFile.getCanonicalPath()));
        return BString.make((String)this.makeRootName(canonicalFilePath.nameAt(0)));
    }

    public void doRequestGarbageCollection() {
        System.gc();
    }

    public BVector doGetAllTimeZones() {
        return this.getStationTimeZones(false);
    }

    public void renameAndRestartStation(String newStationName) {
        NiagaraBasicPermission initPlatformPermission = new NiagaraBasicPermission("RENAME_AND_RESTART");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)initPlatformPermission);
        }
        if (Sys.getStation() == null) {
            BPlatform.log.log(Level.SEVERE, "No Station running in this environment to rename.");
            throw new BajaRuntimeException("No Station running in this environment to rename.");
        }
        String oldStationName = Sys.getStation().getStationName();
        if (oldStationName == null || newStationName == null) {
            BPlatform.log.log(Level.SEVERE, "Invalid Station name provided (null).");
            throw new BajaRuntimeException("Invalid Station name provided (null).");
        }
        try {
            BStationNameValidator.INSTANCE.validate((BObject)BString.make((String)newStationName), null);
        }
        catch (CannotValidateException e) {
            BPlatform.log.log(Level.SEVERE, "Cannot rename Station, invalid new Station name '" + newStationName + "'", e);
            throw new BajaRuntimeException("Cannot rename Station, invalid new Station name '" + newStationName + "'", (Throwable)e);
        }
        if (oldStationName.equals(newStationName)) {
            return;
        }
        try {
            int maxAppLimit;
            BDaemonSession daemon = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
            if (daemon == null) {
                BPlatform.log.log(Level.SEVERE, "No Local Daemon Session available. Please ensure Station is running from the Platform for Station rename.");
                throw new BajaRuntimeException("No Local Daemon Session available. Please ensure Station is running from the Platform for Station rename.");
            }
            NiagaraPlatformDaemon niagaraDaemon = NiagaraPlatformDaemon.make(daemon, DaemonSessionTaskListener.NULL_TASK_LISTENER);
            RemoteStation[] stations = niagaraDaemon.getStationManager().getAllStations();
            if (stations.length > (maxAppLimit = daemon.getHostProperties().getMaxStations())) {
                BPlatform.log.log(Level.SEVERE, "Cannot rename Station, max app limit reached. There cannot be more than " + maxAppLimit + " Station(s) in Niagara's 'stations' directory.");
                throw new BajaRuntimeException("Cannot rename Station, max app limit reached. There cannot be more than " + maxAppLimit + " Station(s) in Niagara's 'stations' directory.");
            }
            for (RemoteStation station : stations) {
                if (!station.getName().equals(newStationName)) continue;
                BPlatform.log.log(Level.SEVERE, "Cannot rename Station to " + newStationName + ", Station already exists.");
                throw new BajaRuntimeException("Cannot rename Station to " + newStationName + ", Station already exists.");
            }
            RemoteStation oldStation = null;
            for (RemoteStation station : stations) {
                if (!station.getName().equals(oldStationName)) continue;
                oldStation = station;
                break;
            }
            if (oldStation == null) {
                BPlatform.log.log(Level.SEVERE, "Cannot find Station to rename: " + oldStationName);
                throw new BajaRuntimeException("Cannot find Station to rename: " + oldStationName);
            }
            if (BPlatform.log.isLoggable(Level.FINE)) {
                BPlatform.log.fine("Renaming Station " + oldStationName + " to " + newStationName);
            }
            new Thread(() -> {
                try {
                    this.doRenameAndRestart(daemon, oldStationName, newStationName);
                }
                catch (Exception e) {
                    BPlatform.log.log(Level.FINE, "Failure to rename Station " + oldStationName + " to " + newStationName, e);
                    throw new BajaRuntimeException("Failure to rename Station " + oldStationName + " to " + newStationName, (Throwable)e);
                }
            }, "RenameAndRestartStationThread").start();
        }
        catch (Exception ex) {
            BPlatform.log.log(Level.SEVERE, "Could not commit platform changes for Station rename", ex);
        }
    }

    protected void doRenameAndRestart(BDaemonSession daemon, String oldStationName, String newStationName) throws Exception {
        throw new UnsupportedOperationException("Action not implemented");
    }

    public boolean archiveEnabled(String archiveId) {
        String alternativeArchivePath = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getAltArchivePath();
        if (alternativeArchivePath != null) {
            if (ZipArchive.log.isLoggable(Level.FINEST)) {
                ZipArchive.log.finest("Archiving enabled for archive identifier \"" + archiveId + "\", archive runtime directory is \"" + alternativeArchivePath + "\"");
            }
            return true;
        }
        if (ZipArchive.log.isLoggable(Level.FINEST)) {
            ZipArchive.log.finest("Archiving not enabled for archive identifier \"" + archiveId + "\"");
        }
        return false;
    }

    public FileArchive createFileArchive(String archiveId) {
        try {
            return AccessController.doPrivileged(() -> {
                File altArchiveZipPathFile;
                String altArchiveZipPath = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getAltArchiveZipPath();
                String archiveZipName = archiveId + ".zip";
                if (altArchiveZipPath != null) {
                    if (ZipArchive.log.isLoggable(Level.FINEST)) {
                        ZipArchive.log.finest("Archive identifier \"" + archiveId + "\" uses custom alternative archive zip path \"" + altArchiveZipPath + "\"");
                    }
                } else {
                    altArchiveZipPath = Sys.getProtectedStationHome().getPath();
                    if (ZipArchive.log.isLoggable(Level.FINEST)) {
                        ZipArchive.log.finest("Archive identifier \"" + archiveId + "\" uses standard alternative archive zip path \"" + altArchiveZipPath + "\"");
                    }
                }
                if (!(altArchiveZipPathFile = new File(altArchiveZipPath)).exists()) {
                    ZipArchive.log.log(Level.SEVERE, "Failed to create zip archive for identifier \"" + archiveId + "\", alternative archive zip path \"" + altArchiveZipPath + "\" does not exist", new Throwable("Alternative archive zip path does not exist"));
                    return new NullFileArchive();
                }
                if (!altArchiveZipPathFile.isDirectory()) {
                    ZipArchive.log.log(Level.SEVERE, "Failed to create zip archive for identifier \"" + archiveId + "\", alternative archive zip path \"" + altArchiveZipPath + "\" is not a directory", new Throwable("Alternative archive zip path is not a directory"));
                    return new NullFileArchive();
                }
                String fullAltArchiveZipDirectoryPath = altArchiveZipPath.endsWith(File.separator) ? altArchiveZipPath + archiveId : altArchiveZipPath + File.separator + archiveId;
                File dir = new File(fullAltArchiveZipDirectoryPath);
                if (!dir.exists() && !dir.mkdir()) {
                    ZipArchive.log.log(Level.SEVERE, "Failed to create zip archive for identifier \"" + archiveId + "\", could not create alternative archive zip directory \"" + dir + "\"", new Throwable("Could not create archive zip directory"));
                    return new NullFileArchive();
                }
                if (dir.exists() && !dir.isDirectory()) {
                    ZipArchive.log.log(Level.SEVERE, "Failed to create zip archive for identifier \"" + archiveId + "\", alternative archive zip directory \"" + fullAltArchiveZipDirectoryPath + "\" is not a directory", new Throwable("Could not create archive zip directory"));
                    return new NullFileArchive();
                }
                if (ZipArchive.log.isLoggable(Level.FINEST)) {
                    ZipArchive.log.finest("Archive identifier \"" + archiveId + "\" uses alternative archive zip directory \"" + fullAltArchiveZipDirectoryPath + "\", creating archive...");
                }
                return new ZipArchive(fullAltArchiveZipDirectoryPath, archiveZipName, this.getArchiveBackupCount());
            });
        }
        catch (PrivilegedActionException pae) {
            ZipArchive.log.log(Level.SEVERE, "Failed to create zip archive for identifier \"" + archiveId + "\"", pae);
            return new NullFileArchive();
        }
    }

    public synchronized void extractArchive(String archiveId) {
        try {
            AccessController.doPrivileged(() -> {
                File altArchiveZipPathFile;
                String altArchiveZipPath;
                String fullAltArchivePath;
                File altArchivePathFile;
                this.initAlternativeArchive();
                IPlatformProvider platformProvider = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE;
                String altArchivePath = platformProvider.getAltArchivePath();
                String archiveName = archiveId + ".zip";
                if (altArchivePath == null) {
                    if (ZipArchive.log.isLoggable(Level.FINEST)) {
                        ZipArchive.log.finest("Archive identifier \"" + archiveId + "\" does not use an alternative archive path, skipping archive extraction");
                    }
                    return null;
                }
                if (ZipArchive.log.isLoggable(Level.FINEST)) {
                    ZipArchive.log.finest("Archive identifier \"" + archiveId + "\" uses alternative archive runtime path \"" + altArchivePath + "\"");
                }
                if (!(altArchivePathFile = new File(altArchivePath)).exists()) {
                    ZipArchive.log.log(Level.SEVERE, "Failed to extract archive for identifier \"" + archiveId + "\", alternative archive runtime path \"" + altArchivePath + "\" does not exist", new Throwable("Alternative archive runtime path does not exist"));
                    return null;
                }
                if (!altArchivePathFile.isDirectory()) {
                    ZipArchive.log.log(Level.SEVERE, "Failed to extract archive for identifier \"" + archiveId + "\", alternative archive runtime path \"" + altArchivePath + "\" is not a directory", new Throwable("Alternative archive runtime path is not a directory"));
                    return null;
                }
                String string = fullAltArchivePath = altArchivePath.endsWith(File.separator) ? altArchivePath + archiveId : altArchivePath + File.separator + archiveId;
                if (ZipArchive.log.isLoggable(Level.FINEST)) {
                    ZipArchive.log.finest("Archive identifier \"" + archiveId + "\" uses alternative archive runtime directory \"" + fullAltArchivePath + "\"");
                }
                if ((altArchiveZipPath = platformProvider.getAltArchiveZipPath()) != null) {
                    if (ZipArchive.log.isLoggable(Level.FINEST)) {
                        ZipArchive.log.finest("Archive identifier \"" + archiveId + "\" uses custom alternative archive zip path \"" + altArchiveZipPath + "\"");
                    }
                } else {
                    altArchiveZipPath = Sys.getProtectedStationHome().getPath();
                    if (ZipArchive.log.isLoggable(Level.FINEST)) {
                        ZipArchive.log.finest("Archive identifier \"" + archiveId + "\" uses standard alternative archive zip path \"" + altArchiveZipPath + "\"");
                    }
                }
                if (!(altArchiveZipPathFile = new File(altArchiveZipPath)).exists()) {
                    ZipArchive.log.log(Level.WARNING, "Failed to extract archive for identifier \"" + archiveId + "\", alternative archive zip path \"" + altArchiveZipPath + "\" does not exist");
                    return null;
                }
                if (!altArchiveZipPathFile.isDirectory()) {
                    ZipArchive.log.log(Level.SEVERE, "Failed to extract archive for identifier  \"" + archiveId + "\", alternative archive zip path \"" + altArchiveZipPath + "\" is not a directory", new Throwable("Alternative archive zip path is not a directory"));
                    return null;
                }
                String fullAltArchiveZipDirectoryPath = altArchiveZipPath.endsWith(File.separator) ? altArchiveZipPath + archiveId : altArchiveZipPath + File.separator + archiveId;
                File dir = new File(fullAltArchiveZipDirectoryPath);
                if (dir.exists() && !dir.isDirectory()) {
                    ZipArchive.log.log(Level.SEVERE, "Failed to extract archive for identifier  \"" + archiveId + "\", alternative archive zip path \"" + altArchiveZipPath + "\" is not a directory", new Throwable("Alternative archive zip path is not a directory"));
                    return null;
                }
                if (ZipArchive.log.isLoggable(Level.FINEST)) {
                    ZipArchive.log.finest("Archive identifier \"" + archiveId + "\" uses alternative archive zip directory \"" + fullAltArchiveZipDirectoryPath + "\", unzipping...");
                }
                ZipArchive.unzip(fullAltArchiveZipDirectoryPath, archiveName, fullAltArchivePath);
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            ZipArchive.log.log(Level.SEVERE, "Failed to extract archive for identifier \"" + archiveId + "\"", pae);
        }
    }

    public String getRuntimeDirectory(String archiveId) {
        IPlatformProvider platformProvider = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE;
        if (platformProvider.getAltArchivePath() != null) {
            String archiveRuntimeDirectory;
            if (BPlatform.log.isLoggable(Level.FINE)) {
                BPlatform.log.fine("Archive '" + archiveId + "' uses alternative archive runtime directory");
            }
            if (!(archiveRuntimeDirectory = platformProvider.getAltArchivePath()).endsWith(File.separator)) {
                archiveRuntimeDirectory = archiveRuntimeDirectory + File.separator;
            }
            if (archiveRuntimeDirectory.indexOf(92) != -1) {
                archiveRuntimeDirectory = archiveRuntimeDirectory.replace('\\', '/');
                archiveRuntimeDirectory = '/' + archiveRuntimeDirectory;
            }
            String assembledRuntimeDirectory = archiveRuntimeDirectory + archiveId;
            if (BPlatform.log.isLoggable(Level.FINE)) {
                BPlatform.log.fine("Using alternative path '" + assembledRuntimeDirectory + "' for '" + archiveId + "' archive runtime directory");
            }
            return assembledRuntimeDirectory;
        }
        if (platformProvider.getAltDatabasePath() != null) {
            String databaseRuntimeDirectory;
            if (BPlatform.log.isLoggable(Level.FINE)) {
                BPlatform.log.fine("Archive '" + archiveId + "' uses alternative database directory");
            }
            if (!(databaseRuntimeDirectory = platformProvider.getAltDatabasePath()).endsWith(File.separator)) {
                databaseRuntimeDirectory = databaseRuntimeDirectory + File.separator;
            }
            if (databaseRuntimeDirectory.indexOf(92) != -1) {
                databaseRuntimeDirectory = databaseRuntimeDirectory.replace('\\', '/');
                databaseRuntimeDirectory = '/' + databaseRuntimeDirectory;
            }
            String assembledRuntimeDirectory = databaseRuntimeDirectory + archiveId;
            if (BPlatform.log.isLoggable(Level.FINE)) {
                BPlatform.log.fine("Using alternative path '" + assembledRuntimeDirectory + "' for '" + archiveId + "' database directory");
            }
            return assembledRuntimeDirectory;
        }
        String assembledRuntimeDirectory = "^^" + archiveId;
        if (BPlatform.log.isLoggable(Level.FINE)) {
            BPlatform.log.fine("Using default path '" + assembledRuntimeDirectory + "' for '" + archiveId + "' database directory");
        }
        return assembledRuntimeDirectory;
    }

    public int getArchiveBackupCount() {
        int count = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getArchiveBackupCount();
        if (count <= 0) {
            return 1;
        }
        return count;
    }

    protected synchronized void initAlternativeArchive() {
        if (!alternativeArchiveInitialized) {
            try {
                AccessController.doPrivileged(() -> {
                    File alarmArchiveFile;
                    File historyArchiveFile;
                    String alternativeAlarmArchivePath = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getAltArchivePath();
                    if (alternativeAlarmArchivePath == null) {
                        if (ZipArchive.log.isLoggable(Level.FINEST)) {
                            ZipArchive.log.finest("Alternative runtime archive is not defined, no initialization required");
                        }
                        alternativeArchiveInitialized = true;
                        return null;
                    }
                    if (ZipArchive.log.isLoggable(Level.FINEST)) {
                        ZipArchive.log.finest("Initializing alternative runtime archive at '" + alternativeAlarmArchivePath + "'...");
                    }
                    if ((historyArchiveFile = new File(alternativeAlarmArchivePath + File.separator + "history" + File.separator + "station")).exists()) {
                        if (ZipArchive.log.isLoggable(Level.FINEST)) {
                            ZipArchive.log.finest("Removing previous history runtime archive at '" + historyArchiveFile + "'...");
                        }
                        FileUtil.delete((File)historyArchiveFile);
                    }
                    if ((alarmArchiveFile = new File(alternativeAlarmArchivePath + File.separator + "alarm" + File.separator + "alarm.adb")).exists()) {
                        if (ZipArchive.log.isLoggable(Level.FINEST)) {
                            ZipArchive.log.finest("Removing previous alarm runtime archive at '" + alarmArchiveFile + "'...");
                        }
                        FileUtil.delete((File)alarmArchiveFile);
                    }
                    if (ZipArchive.log.isLoggable(Level.FINEST)) {
                        ZipArchive.log.finest("Alternative archive initialization complete");
                    }
                    alternativeArchiveInitialized = true;
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                ZipArchive.log.log(Level.SEVERE, "Unable to initialize alternative archive", pae.getException());
            }
        }
    }

    public void startEngineWatchdog() {
        if (AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue()) {
            new EngineMonitor().start();
        }
    }

    @Override
    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getStationSaveAlarmProxy().addPlatformServiceAlarmListener(listener);
    }

    @Override
    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getStationSaveAlarmProxy().removePlatformServiceAlarmListener(listener);
    }

    @Override
    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord alarmData) {
        throw new IllegalStateException();
    }

    @Override
    public BBoolean ackAlarm(BPlatformServiceAlarmRecord alarmData) {
        throw new IllegalStateException();
    }

    protected static BPlatformAlarmSupport initStationSaveAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setSourceName(BFormat.make((String)"%parent.displayName%"));
        pas.setToFaultText(BFormat.make((String)"%lexicon(platform:SystemPlatformService.stationSaveFailure)%"));
        pas.setToNormalText(BFormat.make((String)"%lexicon(platform:SystemPlatformService.stationSaveSuccess)%"));
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmType", BString.make((String)ALARM_TYPE_STATION_SAVE));
        pas.setMetaData(BFacets.make(map));
        return pas;
    }

    private void assertValidEngineWatchdogPolicy() {
        if (this.getEngineWatchdogPolicy() == BEngineWatchdogPolicy.reboot && !BSystemPlatformService.isRebootSupported()) {
            BPlatform.log.warning("Engine Watchdog Policy configured to 'reboot' on service that does not support 'reboot', resetting policy to 'terminate'");
            this.setEngineWatchdogPolicy(BEngineWatchdogPolicy.terminate);
        }
    }

    protected static boolean isRebootSupported() {
        return PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.isEmbedded() && !PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.isStationPlatformReadonly();
    }

    public BFacets doGetEngineWatchdogPolicyFacets() {
        BFacets policyFacets = BFacets.NULL;
        policyFacets = BSystemPlatformService.isRebootSupported() ? BFacets.make((String)"range", (BIDataValue)BEnumRange.make(null, (int[])new int[]{1, 2, 3}, (String[])new String[]{SlotPath.escape((String)BEngineWatchdogPolicy.logOnly.getDisplayTag(null)), SlotPath.escape((String)BEngineWatchdogPolicy.terminate.getDisplayTag(null)), SlotPath.escape((String)BEngineWatchdogPolicy.reboot.getDisplayTag(null))})) : BFacets.make((String)"range", (BIDataValue)BEnumRange.make(null, (int[])new int[]{1, 2}, (String[])new String[]{SlotPath.escape((String)BEngineWatchdogPolicy.logOnly.getDisplayTag(null)), SlotPath.escape((String)BEngineWatchdogPolicy.terminate.getDisplayTag(null))}));
        return policyFacets;
    }

    public BVector getStationTimeZones() {
        return this.getStationTimeZones(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BVector getStationTimeZones(boolean considerTimezonesXml) {
        if (this.allTimeZones == null) {
            Array results;
            block66: {
                results = null;
                boolean useLocalDefinitions = false;
                BISession session = this.getSession();
                if (session instanceof BLocalHost) {
                    useLocalDefinitions = true;
                } else if (session != null) {
                    Version remoteBajaVersion = (Version)((BFoxSession)session).fw(404, (Object)"baja", (Object)"rt", null, null);
                    if (remoteBajaVersion != null && remoteBajaVersion.compareTo(new Version("4.0")) >= 0) {
                        useLocalDefinitions = true;
                    }
                } else {
                    useLocalDefinitions = true;
                }
                if (useLocalDefinitions) {
                    Object[] zones = TimeZoneDatabase.get().getTimeZones();
                    results = new Array(BTimeZone.class);
                    results.addAll(zones);
                } else {
                    BTimeChannel channel = null;
                    try {
                        Version remoteVersion = (Version)((BFoxSession)this.getSession()).fw(404, (Object)"platform", (Object)"rt", null, null);
                        if (remoteVersion != null && remoteVersion.compareTo(new Version("3.7.201")) >= 0) {
                            channel = (BTimeChannel)((BFoxSession)this.getSession()).getConnection().getChannels().get("time", BTimeChannel.TYPE);
                        }
                    }
                    catch (Exception remoteVersion) {
                        // empty catch block
                    }
                    if (channel != null) {
                        try (InputStream in = channel.gettimezones();){
                            results = TzJarUtil.getTimeZones((InputStream)in);
                        }
                        catch (Exception e) {
                            results = null;
                        }
                    }
                    if (results == null) {
                        try {
                            try {
                                BIFile tzJar = (BIFile)BOrd.make((String)"file:!lib/timezones.jar").get((BObject)this);
                                try (InputStream in = tzJar.getInputStream();){
                                    results = TzJarUtil.getTimeZones((InputStream)in);
                                }
                            }
                            catch (UnresolvedException tzJarUnresolved) {
                                if (!considerTimezonesXml) break block66;
                                try {
                                    BIFile tzXml = (BIFile)BOrd.make((String)"file:!lib/timezones.xml").get((BObject)this);
                                    try (InputStream in = tzXml.getInputStream();){
                                        XElem[] zoneElems;
                                        results = new Array(BTimeZone.class);
                                        for (XElem zoneElem : zoneElems = XParser.make((InputStream)in).parse().elems("zone")) {
                                            String zoneId = zoneElem.get("id");
                                            if (TimeZoneDatabase.isZoneIdSupported((String)zoneId)) {
                                                results.add((Object)BTimeZone.getTimeZone((String)zoneId));
                                                continue;
                                            }
                                            BPlatform.log.log(Level.WARNING, "remote time zone \"" + zoneId + "\" is not supported locally, ignoring");
                                        }
                                    }
                                }
                                catch (UnresolvedException tzXml) {}
                            }
                        }
                        catch (RuntimeException re) {
                            throw re;
                        }
                        catch (Exception e) {
                            throw new BajaRuntimeException((Throwable)e);
                        }
                    }
                }
            }
            BSystemPlatformService bSystemPlatformService = this;
            synchronized (bSystemPlatformService) {
                this.allTimeZones = new BVector();
                if (results != null) {
                    results = results.sort(BTimeZone.OFFSET_COMPARATOR);
                    for (int i = 0; i < results.size(); ++i) {
                        BTimeZone tz = (BTimeZone)results.get(i);
                        this.allTimeZones.add(SlotPath.escape((String)tz.getId()), (BValue)tz);
                    }
                }
            }
        }
        return this.allTimeZones;
    }

    public void sendRestartRequest(boolean kill) throws Exception {
        if (Sys.getStation() == null) {
            throw new LocalizableRuntimeException("platform", "system.error.notStation");
        }
        if (!AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue()) {
            throw new LocalizableRuntimeException("platform", "system.error.localDaemonUnavailable");
        }
        BDaemonSession daemonSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
        BStationSurrogate stationProxy = BStationSurrogate.make(daemonSession, this.getStationName());
        stationProxy.restartStationAsync(kill);
    }

    public void systemLog(int logLevel, String message) throws Exception {
        try {
            AccessController.doPrivileged(() -> {
                if (PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.enableSystemLogging()) {
                    PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.log(logLevel, message);
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public boolean setPlatformSystemTime(long millis) {
        return AccessController.doPrivileged(() -> PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.setSystemTime(millis) == 0);
    }

    public boolean setBajaLocaleId(String localeId) {
        return AccessController.doPrivileged(() -> SystemPropertiesUtil.setSystemProperty((String)"niagara.lang", (String)localeId));
    }

    public boolean setPlatformTimeZone(String tzId) {
        return AccessController.doPrivileged(() -> {
            if (BPlatform.log.isLoggable(Level.FINEST)) {
                BPlatform.log.finest("Setting system time zone to '" + tzId + "' [defaultTimeZone='" + TimeZone.getDefault().getID() + "']");
            }
            int rc = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.setNativeTimeZone(tzId);
            if (BPlatform.log.isLoggable(Level.FINEST) && rc == 0) {
                BPlatform.log.finest("System time zone set to '" + tzId + "' [defaultTimeZone='" + TimeZone.getDefault().getID() + "']");
            }
            return rc == 0;
        });
    }

    public String makeRootName(String rootDirName) {
        throw new UnsupportedOperationException();
    }

    public String checkForStationFault() {
        return null;
    }

    public void queryResources(ResourceReport rr) {
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"SystemPlatformService", 2);
        out.prop((Object)"onLocalHost", this.isOnLocalHost());
        AccessController.doPrivileged(() -> {
            if (this.isProxy() || PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE != null) {
                out.prop((Object)"processId", (Object)"remote");
            } else {
                out.prop((Object)"processId", (double)PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getProcessId());
            }
            return null;
        });
        out.endProps();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    static {
        STATION_OUTPUT_SERVLET = BTypeSpec.make((String)"platform", (String)"StationOutputServlet");
    }

    private class StationStartupWorker
    extends Thread {
        public StationStartupWorker() {
            super("SystemPlatformService:StationStartupWorker");
        }

        @Override
        public void run() {
            if (AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue()) {
                try {
                    try {
                        BSystemPlatformService.this.add("stationOutput", (BValue)Sys.getType((String)"platform:StationOutputServlet").getInstance(), 7);
                    }
                    catch (TypeNotFoundException typeNotFoundException) {
                        // empty catch block
                    }
                    long processId = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getProcessId();
                    if (processId != -1L) {
                        Nre.getPlatform().reportSummaryFields(new String[]{"process"}, new String[]{String.valueOf(processId)});
                    }
                    Station.addSaveListener((Station.SaveListener)BSystemPlatformService.this.saveListener);
                }
                catch (Exception e) {
                    BPlatform.log.log(Level.SEVERE, "Error reporting status to platform daemon", e);
                }
            } else {
                BPlatform.log.warning("Local daemon session not available, skipping engine monitor initialization");
                Station.addSaveListener((Station.SaveListener)BSystemPlatformService.this.saveListener);
            }
        }
    }

    private class EngineMonitor
    extends Thread
    implements ServiceListener {
        private final Logger log;
        private final EngineManager engineManager;
        private final String watchdogName;
        private volatile BWebServer webServer;

        public EngineMonitor() {
            super("Plat:EngineMonitor");
            this.log = Logger.getLogger("platform.engineMonitor");
            this.engineManager = AccessController.doPrivileged(Nre::getEngineManager);
            this.watchdogName = Sys.getProtectedStationHome().getName();
            try {
                BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
                this.webServer = webService.getWebServer();
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
            AccessController.doPrivileged(Nre::getServiceManager).addServiceListener((ServiceListener)this);
            this.setPriority(Nre.getEngineManager().getPriority() + 1);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int completedCycles = 0;
            int lastCompletedCycles = 0;
            int consecutiveCyclePauses = 0;
            boolean enginePanic = false;
            boolean lastEnginePanic = false;
            boolean engineFault = false;
            long ticksAtLastUpdate = 0L;
            BWebServer currentWebServer = null;
            try {
                try {
                    while (true) {
                        int rc;
                        int timeoutSecs = BSystemPlatformService.this.getEngineWatchdogTimeout().getSeconds();
                        int policyOrdinal = BSystemPlatformService.this.getEngineWatchdogPolicy().getOrdinal();
                        currentWebServer = this.webServer;
                        boolean enforcing = timeoutSecs > 0;
                        int refreshRate = 8;
                        long targetSleepDuration = enforcing ? (long)(timeoutSecs * (1000 / refreshRate)) : 60000L;
                        int enginePanicThreshold = refreshRate / 2;
                        int engineFaultThreshold = refreshRate + 4;
                        long ticksSinceLastUpdate = Clock.ticks() - ticksAtLastUpdate;
                        long actualSleepDuration = Math.min(targetSleepDuration - ticksSinceLastUpdate, targetSleepDuration);
                        if (actualSleepDuration > 0L) {
                            try {
                                Thread.sleep(actualSleepDuration);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        completedCycles = this.engineManager.getCycles();
                        if (timeoutSecs >= 0 && this.log.isLoggable(Level.FINEST)) {
                            this.log.finest("Updating engine watchdog shared memory with cycles " + completedCycles);
                        }
                        if ((rc = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.updateWatchdog(this.watchdogName, completedCycles, policyOrdinal, timeoutSecs)) != 0) {
                            throw new BajaRuntimeException("Failed to update engine watchdog, timeout may occur");
                        }
                        ticksAtLastUpdate = Clock.ticks();
                        if (!enforcing || engineFault) continue;
                        if (lastCompletedCycles != completedCycles) {
                            consecutiveCyclePauses = 0;
                            enginePanic = false;
                        } else if (++consecutiveCyclePauses < enginePanicThreshold) {
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Engine monitor detected no engine activity in last " + targetSleepDuration * (long)consecutiveCyclePauses + "ms, engine watchdog timeout will occur if condition continues");
                            }
                        } else if (consecutiveCyclePauses < engineFaultThreshold) {
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Engine monitor detected no engine activity in last " + targetSleepDuration * (long)consecutiveCyclePauses + "ms, engine watchdog timeout is imminent");
                            }
                            enginePanic = true;
                        } else {
                            this.log.severe("Engine watchdog timeout elapsed, engine monitor entering fault state");
                            enginePanic = false;
                            engineFault = true;
                        }
                        if (enginePanic != lastEnginePanic && currentWebServer != null) {
                            if (enginePanic) {
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine("Engine monitor panic state entered, applying throttled operating conditions");
                                }
                            } else if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Engine monitor panic state cleared, restoring normal operating conditions");
                            }
                            currentWebServer.fw(1003, (Object)enginePanic, null, null, null);
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Engine monitor panic state update complete");
                            }
                        }
                        lastEnginePanic = enginePanic;
                        lastCompletedCycles = completedCycles;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Error updating engine watchdog, timeout my occur", e);
                    if (enginePanic && currentWebServer != null) {
                        currentWebServer.fw(1003, (Object)false, null, null, null);
                    }
                }
            }
            catch (Throwable throwable) {
                if (enginePanic && currentWebServer != null) {
                    currentWebServer.fw(1003, (Object)false, null, null, null);
                }
                throw throwable;
            }
        }

        public void serviceEvent(BServiceEvent event) {
            if (event.getServiceType().is(BWebService.TYPE)) {
                if (event.getId() == 0) {
                    this.webServer = ((BWebService)event.getService()).getWebServer();
                } else if (event.getId() == 1) {
                    this.webServer = null;
                }
            }
        }
    }

    private static class UpdateJobState
    extends Thread {
        private final String requestId;
        private final String stateTag;

        public UpdateJobState(String pRequestId, String pStateTag) {
            super("SystemPlatformService::UpdateJobState");
            this.requestId = pRequestId;
            this.stateTag = pStateTag;
        }

        @Override
        public void run() {
            try {
                BDaemonSession daemonSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
                daemonSession.sendMessage(new UpdateRequestStateMessage(this.requestId, this.stateTag));
            }
            catch (Exception e) {
                BPlatform.log.log(Level.SEVERE, "Failed to update job state '" + this.requestId + ":" + this.stateTag + "'", e);
            }
        }
    }

    private class SystemPlatformServiceSaveListener
    implements Station.SaveListener {
        private Boolean lastSaveSuccessful = null;

        private SystemPlatformServiceSaveListener() {
        }

        public void stationSave() {
            AccessController.doPrivileged(new StationSavePrivilegedAction());
        }

        public void stationSaveOk() {
            if (this.lastSaveSuccessful == null || !this.lastSaveSuccessful.booleanValue()) {
                BPlatformServiceAlarmRecord alarm = BSystemPlatformService.this.getStationSaveAlarmSupport().makeToNormal();
                BSystemPlatformService.this.getStationSaveAlarmProxy().firePlatformServiceAlarmEvent(alarm);
                this.lastSaveSuccessful = Boolean.TRUE;
            }
            if (AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue()) {
                new UpdateJobState("baja:StationSaveJob@" + BSystemPlatformService.this.getStationName(), BJobState.success.getTag() + "@" + Clock.millis()).start();
            }
        }

        public void stationSaveFail(String cause) {
            if (this.lastSaveSuccessful == null || this.lastSaveSuccessful.booleanValue()) {
                BPlatformServiceAlarmRecord alarm = BSystemPlatformService.this.getStationSaveAlarmSupport().makeNewOffnormalAlarm();
                BSystemPlatformService.this.getStationSaveAlarmProxy().firePlatformServiceAlarmEvent(alarm);
                this.lastSaveSuccessful = Boolean.FALSE;
            }
            if (AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue()) {
                new UpdateJobState("baja:StationSaveJob@" + BSystemPlatformService.this.getStationName(), BJobState.failed.getTag() + "@" + Clock.millis()).start();
            }
        }

        public String toString() {
            return "SystemPlatformService " + BSystemPlatformService.this.getNavOrd();
        }

        private class StationSavePrivilegedAction
        implements PrivilegedAction<Void> {
            private StationSavePrivilegedAction() {
            }

            @Override
            public Void run() {
                if (BSystemPlatformService.this.stationSaveListenerActive) {
                    return null;
                }
                BSystemPlatformService.this.stationSaveListenerActive = true;
                try {
                    BSystemPlatformService.this.savePlatformServiceProperties();
                }
                catch (Exception e) {
                    BPlatform.log.log(Level.WARNING, "Error occurred in SystemPlatformService::savePlatformServiceProperties() during station save:", e);
                }
                BSystemPlatformService.this.stationSaveListenerActive = false;
                return null;
            }
        }
    }

    private static final class PlatformProviderHolder {
        private static final IPlatformProvider PLATFORM_PROVIDER_INSTANCE = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);

        private PlatformProviderHolder() {
        }
    }
}

