/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.ReportStatusMessage;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.tridium.sys.BIPlatform;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.sys.resource.ResourceReport;
import java.io.File;
import java.net.ConnectException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.io.ValueDocDecoder;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.DefaultFileCopy;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BServiceContainer;
import javax.baja.xml.XException;

@NiagaraType
public class BPlatform
extends BObject
implements BIPlatform {
    @Generated
    public static final Type TYPE = Sys.loadType(BPlatform.class);
    private static final PlatformTypeResolver typeResolver = new PlatformTypeResolver();
    static final BFacets sysFacets = BFacets.make((String[])new String[]{"resourceOnly"}, (BIDataValue[])new BBoolean[]{BBoolean.TRUE});
    private int memoryUsage = 0;
    private int totalMemory = 0;
    private int cpuUsage = 0;
    private BSystemPlatformService sys;
    public static final Logger log = Logger.getLogger("platform");
    public static final String ENGINE_MONITOR_LOG_NAME = "platform.engineMonitor";
    private static final ObsoletePlatformTypeSpec PLAT_JENNIC_TYPE_SPEC = new ObsoletePlatformTypeSpec("platJennic=platJennic", "platJennic", "com.tridium.platJennic.BJennicPlatformService", true, true, Level.WARNING);
    private static final ObsoletePlatformTypeSpec PLAT_WIFI_TYPE_SPEC = new ObsoletePlatformTypeSpec("platwf=platWifi", "platWifi", "com.tridium.platwifi.BWifiPlatformService", false, true, Level.FINE);
    private static final ObsoletePlatformTypeSpec PLAT_NTP_WIN32_TYPE_SPEC = new ObsoletePlatformTypeSpec("plat=platform", "platform", "com.tridium.platform.win32.BNtpPlatformServiceWin32", false, true, Level.FINE);
    private static final ObsoletePlatformTypeSpec PLAT_NTP_LINUX_TYPE_SPEC = new ObsoletePlatformTypeSpec("plat=platform", "platform", "com.tridium.platform.linux.BNtpPlatformServiceLinux", false, true, Level.FINE);
    private static final ObsoletePlatformTypeSpec PLAT_CCN_WIN32_TYPE_SPEC = new ObsoletePlatformTypeSpec("platccn=platCcn", "platCcn", "com.tridium.platCcn.BCcnPlatformServiceWin32", false, true, Level.FINE);
    private static final Map<String, ObsoletePlatformTypeSpec> OBSOLETE_MODULE_TYPES_BY_SYMBOL = BPlatform.createObsoleteModuleMapBySymbol();
    private static final Map<String, ObsoletePlatformTypeSpec> OBSOLETE_MODULE_TYPES_BY_CLASS = BPlatform.createObsoleteModuleMapByClass();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void initPlatform() throws Exception {
        TypeInfo[] typeInfos;
        BServiceContainer container;
        BPlatformServiceContainer platformContainer;
        File platformFile;
        NiagaraBasicPermission initPlatformPermission = new NiagaraBasicPermission("INIT_PLATFORM");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)initPlatformPermission);
        }
        if ((platformFile = AccessController.doPrivileged(new LoadPlatformBogPrivilegedAction())).length() == 0L) {
            throw new BajaRuntimeException("platform.bog file is empty, cannot load platform");
        }
        long timeAtStart = 0L;
        if (log.isLoggable(Level.FINE)) {
            timeAtStart = Clock.ticks();
            log.fine("Loading \"" + platformFile + "\"...");
        }
        try (ValueDocDecoder bogDecoder = new ValueDocDecoder(platformFile);){
            bogDecoder.setTypeResolver((ValueDocDecoder.ITypeResolver)typeResolver);
            platformContainer = (BPlatformServiceContainer)bogDecoder.decodeDocument(false);
            platformContainer.clearHandles();
        }
        try {
            container = (BServiceContainer)Sys.getService((Type)BServiceContainer.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            container = Sys.getStation().getServices();
        }
        container.add("PlatformServices", (BValue)platformContainer, 3);
        BPlatformService[] services = (BPlatformService[])platformContainer.getChildren(BPlatformService.class);
        if (log.isLoggable(Level.FINEST)) {
            for (BPlatformService service : services) {
                log.finest("Found Platform Service '" + (Object)((Object)service) + "' during Platform Service container bootstrap");
            }
        }
        for (TypeInfo typeInfo : typeInfos = Sys.getRegistry().getConcreteTypes(BPlatformService.TYPE.getTypeInfo())) {
            boolean exists = false;
            for (BPlatformService service : services) {
                if (!service.getType().getTypeInfo().equals(typeInfo)) continue;
                exists = true;
                break;
            }
            if (exists) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Ignoring Platform Service specification type '" + typeInfo + "', it has already been loaded");
                continue;
            }
            BPlatformService service = (BPlatformService)typeInfo.getInstance();
            if (!service.isValidPlatform()) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Platform Service '" + (Object)((Object)service) + "' will not be added, service not valid for this platform");
                continue;
            }
            String feature = service.getLicenseFeature();
            String vendor = service.getLicenseVendor();
            if (feature != null) {
                try {
                    Sys.getLicenseManager().checkFeature(vendor, feature);
                }
                catch (FeatureNotLicensedException noLicExp) {
                    if (!LocalMetaDataHolder.IS_EMBEDDED && !log.isLoggable(Level.FINEST)) continue;
                    log.warning("Platform Service '" + (Object)((Object)service) + "' will not be added, required feature '" + feature + "' is not licensed");
                    continue;
                }
                catch (LicenseDatabaseException dbExp) {
                    continue;
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Adding Platform Service '" + (Object)((Object)service) + "' to Platform Service Container");
            }
            platformContainer.add(typeInfo.getTypeName(), (BValue)service, service.getSlotFlags());
        }
        for (BPlatformService bPlatformService : services = (BPlatformService[])platformContainer.getChildren(BPlatformService.class)) {
            ObsoletePlatformTypeSpec obsoletePlatformTypeSpec;
            String canonicalClassName = ((Object)((Object)bPlatformService)).getClass().getCanonicalName();
            if (canonicalClassName == null || (obsoletePlatformTypeSpec = OBSOLETE_MODULE_TYPES_BY_CLASS.get(((Object)((Object)bPlatformService)).getClass().getCanonicalName())) == null || !obsoletePlatformTypeSpec.removePlatformService) continue;
            try {
                BModule module = Sys.loadModule((String)obsoletePlatformTypeSpec.moduleName);
                Class obsoleteService = module.loadClass(obsoletePlatformTypeSpec.platformServiceClassName);
                if (!obsoleteService.isInstance((Object)bPlatformService)) continue;
                log.log(obsoletePlatformTypeSpec.logLevel, "Removing platform service '" + (Object)((Object)bPlatformService) + "', service is obsolete");
                platformContainer.remove((BComplex)bPlatformService);
            }
            catch (ClassNotFoundException | ModuleNotFoundException | TypeNotFoundException throwable) {
                // empty catch block
            }
        }
        for (BPlatformService bPlatformService : services = (BPlatformService[])platformContainer.getChildren(BPlatformService.class)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Initializing Platform Service '" + (Object)((Object)bPlatformService) + "'");
            }
            bPlatformService.fw(1001, container, null, null, null);
        }
        this.sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loaded (" + (Clock.ticks() - timeAtStart) + "ms)");
        }
    }

    public BSystemPlatformService sys() {
        if (this.sys == null || this.sys.getParent() == null) {
            this.sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        }
        return this.sys;
    }

    public void stationStarted() {
        BPlatformService[] services;
        BPlatformServiceContainer container = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
        for (BPlatformService service : services = (BPlatformService[])container.getChildren(BPlatformService.class)) {
            Property prop;
            try {
                service.doStationStarted(Sys.getStation());
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Failed to invoke station started callback on service '" + (Object)((Object)service) + "'", t);
            }
            if (service instanceof BTcpIpPlatformService) {
                prop = service.getPropertyInParent();
                container.setFlags((Slot)prop, container.getFlags((Slot)prop) & 0xFFFFFFFB);
                continue;
            }
            if (!(service instanceof BSystemPlatformService)) continue;
            prop = service.getPropertyInParent();
            container.setFlags((Slot)prop, container.getFlags((Slot)prop) & 0xFFFFFFFB);
        }
    }

    public boolean isStationAutoSaveEnabled() {
        try {
            BSystemPlatformService sys = this.sys();
            return sys.getIsStationAutoSaveEnabled();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return true;
        }
    }

    public long getStationAutoSaveFrequency() {
        try {
            BSystemPlatformService sys = this.sys();
            return sys.getStationAutoSaveFrequency().getMillis();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return 3600000L;
        }
    }

    public int getStationSaveBackupCount() {
        try {
            BSystemPlatformService sys = this.sys();
            return sys.getStationSaveBackupCount();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return 3;
        }
    }

    public void poll() {
        try {
            BSystemPlatformService service = this.sys();
            service.checkPropertiesLoaded();
            service.invoke(BSystemPlatformService.poll, null, (Context)sysFacets);
            int usage = service.getCurrentCpuUsage();
            this.cpuUsage = Math.max(usage, 0);
            int tot = service.getTotalPhysicalMemory();
            if (tot > 0) {
                this.totalMemory = tot;
                int free = service.getFreePhysicalMemory();
                this.memoryUsage = free >= 0 ? tot - free : 0;
            } else {
                this.totalMemory = 0;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.memoryUsage = 0;
            this.totalMemory = 0;
            this.cpuUsage = 0;
        }
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public int getTotalMemory() {
        return this.totalMemory;
    }

    public int getCpuUsage() {
        return this.cpuUsage;
    }

    public String checkForStationFault() {
        try {
            String drsFault;
            String stationFault = this.sys().checkForStationFault();
            if (stationFault != null) {
                return stationFault;
            }
            if (AccessController.doPrivileged(Nre::getServiceManager).getActiveDataRecoveryService() != null && (drsFault = AccessController.doPrivileged(Nre::getServiceManager).getActiveDataRecoveryService().checkForStationFault()) != null) {
                return drsFault;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public void queryResources(ResourceReport rr) {
        try {
            this.sys().queryResources(rr);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public void reportSummaryFields(String[] keys, String[] values) {
        if (AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue()) {
            try {
                BDaemonSession daemon = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
                daemon.sendMessage(new ReportStatusMessage(keys, values));
            }
            catch (ConnectException | AuthenticationException throwable) {
                // empty catch block
            }
        }
    }

    public void resetLocalDaemonSession() {
        LocalSessionUtil.resetLocalSession();
    }

    public void startEngineWatchdog() {
        try {
            this.sys().startEngineWatchdog();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    private static Map<String, ObsoletePlatformTypeSpec> createObsoleteModuleMapBySymbol() {
        HashMap<String, ObsoletePlatformTypeSpec> obsoleteModuleMap = new HashMap<String, ObsoletePlatformTypeSpec>();
        obsoleteModuleMap.put(BPlatform.PLAT_JENNIC_TYPE_SPEC.modulePreferredSymbolMap, PLAT_JENNIC_TYPE_SPEC);
        obsoleteModuleMap.put(BPlatform.PLAT_WIFI_TYPE_SPEC.modulePreferredSymbolMap, PLAT_WIFI_TYPE_SPEC);
        obsoleteModuleMap.put(BPlatform.PLAT_NTP_LINUX_TYPE_SPEC.modulePreferredSymbolMap, PLAT_NTP_LINUX_TYPE_SPEC);
        obsoleteModuleMap.put(BPlatform.PLAT_NTP_WIN32_TYPE_SPEC.modulePreferredSymbolMap, PLAT_NTP_WIN32_TYPE_SPEC);
        obsoleteModuleMap.put(BPlatform.PLAT_CCN_WIN32_TYPE_SPEC.modulePreferredSymbolMap, PLAT_CCN_WIN32_TYPE_SPEC);
        return Collections.unmodifiableMap(obsoleteModuleMap);
    }

    private static Map<String, ObsoletePlatformTypeSpec> createObsoleteModuleMapByClass() {
        HashMap<String, ObsoletePlatformTypeSpec> obsoleteModuleMap = new HashMap<String, ObsoletePlatformTypeSpec>();
        obsoleteModuleMap.put(BPlatform.PLAT_JENNIC_TYPE_SPEC.platformServiceClassName, PLAT_JENNIC_TYPE_SPEC);
        obsoleteModuleMap.put(BPlatform.PLAT_WIFI_TYPE_SPEC.platformServiceClassName, PLAT_WIFI_TYPE_SPEC);
        obsoleteModuleMap.put(BPlatform.PLAT_NTP_LINUX_TYPE_SPEC.platformServiceClassName, PLAT_NTP_LINUX_TYPE_SPEC);
        obsoleteModuleMap.put(BPlatform.PLAT_NTP_WIN32_TYPE_SPEC.platformServiceClassName, PLAT_NTP_WIN32_TYPE_SPEC);
        obsoleteModuleMap.put(BPlatform.PLAT_CCN_WIN32_TYPE_SPEC.platformServiceClassName, PLAT_CCN_WIN32_TYPE_SPEC);
        return Collections.unmodifiableMap(obsoleteModuleMap);
    }

    private static final class LocalMetaDataHolder {
        private static final boolean IS_EMBEDDED = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().isEmbedded());

        private LocalMetaDataHolder() {
        }
    }

    private static class ObsoletePlatformTypeSpec {
        String modulePreferredSymbolMap;
        String moduleName;
        String platformServiceClassName;
        boolean ignoreAllTypes;
        boolean removePlatformService;
        Level logLevel;

        ObsoletePlatformTypeSpec(String modulePreferredSymbolMap, String moduleName, String platformServiceClassName, boolean ignoreAllTypes, boolean removePlatformService, Level logLevel) {
            this.modulePreferredSymbolMap = modulePreferredSymbolMap;
            this.moduleName = moduleName;
            this.platformServiceClassName = platformServiceClassName;
            this.ignoreAllTypes = ignoreAllTypes;
            this.removePlatformService = removePlatformService;
            this.logLevel = logLevel;
        }
    }

    private static final class PlatformTypeResolver
    extends ValueDocDecoder.BogTypeResolver {
        private PlatformTypeResolver() {
        }

        public BModule loadModule(ValueDocDecoder decoder, BComplex parent, String propName, String moduleStr, String typeStr) {
            try {
                ObsoletePlatformTypeSpec obsoletePlatformTypeSpec = (ObsoletePlatformTypeSpec)OBSOLETE_MODULE_TYPES_BY_SYMBOL.get(moduleStr);
                if (obsoletePlatformTypeSpec != null && obsoletePlatformTypeSpec.ignoreAllTypes) {
                    log.log(obsoletePlatformTypeSpec.logLevel, "Ignoring module '" + obsoletePlatformTypeSpec.moduleName + "' based type '" + typeStr + "' in platform.bog, it is obsolete");
                    return null;
                }
                int equals = moduleStr.indexOf(61);
                String key = moduleStr.substring(0, equals).trim();
                String name = moduleStr.substring(equals + 1).trim();
                NModule[] modules = AccessController.doPrivileged(Nre::getModuleManager).loadModuleParts(name);
                if (modules.length > 0) {
                    this.updateModuleMap(decoder, modules);
                    this.getModuleNameMap(decoder).put(key, modules[0].getModuleName());
                    return modules[0].bmodule();
                }
                return null;
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                log.warning("Ignoring platform service '" + typeStr + "' in platform.bog, required module not found!");
                return null;
            }
            catch (Exception e) {
                throw new XException("Invalid module attribute '" + moduleStr + "'");
            }
        }

        public BValue newInstance(ValueDocDecoder decoder, BComplex parent, String propName, Property prop, String typeStr) {
            if (typeStr == null) {
                if (prop != null) {
                    return prop.getDefaultValue();
                }
                log.warning("Missing frozen property '" + propName + "'");
                return null;
            }
            try {
                int x = typeStr.indexOf(58);
                if (x <= 0) {
                    log.warning("Invalid typespec '" + typeStr + "'");
                    return null;
                }
                String typeKey = typeStr.substring(0, x);
                String typeName = typeStr.substring(x + 1);
                String moduleName = (String)this.getModuleNameMap(decoder).get(typeKey);
                if (moduleName == null) {
                    return null;
                }
                Map runtimeProfileNModuleMap = (Map)this.getModuleMap(decoder).get(moduleName);
                if (runtimeProfileNModuleMap == null) {
                    return null;
                }
                for (NModule module : runtimeProfileNModuleMap.values()) {
                    if (!module.hasType(typeName)) continue;
                    return (BValue)module.getType(typeName).getInstance();
                }
                return null;
            }
            catch (XException xException) {
                throw xException;
            }
            catch (TypeNotFoundException typeNotFoundException) {
                log.log(Level.WARNING, "Type for property '" + propName + "' not found (typespec='" + typeStr + "'), skipping element");
                return null;
            }
            catch (Throwable throwable) {
                log.log(Level.WARNING, "Cannot instantiate typespec '" + typeStr + "'", throwable);
                return null;
            }
        }
    }

    private static class LoadPlatformBogPrivilegedAction
    implements PrivilegedExceptionAction<File> {
        private LoadPlatformBogPrivilegedAction() {
        }

        @Override
        public File run() {
            File platformFile = NiagaraFiles.getPlatformBogPath();
            if (!platformFile.exists()) {
                File working = BPlatformService.getWorkingCopyPath(platformFile);
                if (working.exists()) {
                    if (!working.renameTo(platformFile)) {
                        throw new BajaRuntimeException("Failed to rename working platform.bog, can not load platform");
                    }
                } else if (!platformFile.equals(NiagaraFiles.getPlatformBogDefaultsPath())) {
                    try {
                        DefaultFileCopy.copyFile((String)"platform.bog");
                    }
                    catch (Exception e) {
                        throw new BajaRuntimeException("platform.bog file does not exist, can not load platform");
                    }
                }
            }
            return platformFile;
        }
    }
}

