/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BPart;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
public class BApplicationPart
extends BPart {
    @Generated
    public static final Type TYPE = Sys.loadType(BApplicationPart.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BApplicationPart() {
    }

    public BApplicationPart(String partName, String versionString) {
        this.setPartName(partName);
        this.setVersion(new BVersion(versionString));
    }

    public BApplicationPart(String partName, BVersion version) {
        this.setPartName(partName);
        this.setVersion(version);
    }

    public BApplicationPart(String partName, BVersion version, BInstallable pInstallable) {
        this(partName, version);
        this.setInstallable(pInstallable);
    }

    @Override
    public boolean meets(BDependency depend) {
        return depend.getPartType().is(TYPE) && this.getVersion().meets(depend) && this.matchesName(depend.getPartName());
    }

    public static BPart make(XElem elem) {
        return BApplicationPart.make(elem, null);
    }

    public static BPart make(XElem elem, BInstallable installable) {
        if (elem == null) {
            return null;
        }
        if (elem.name().equals("app")) {
            System.out.println("make BApplicationPart: " + elem.get("name") + " " + BApplicationPart.getVendorVersion(elem));
            return new BApplicationPart(elem.get("name"), new BVersion("", BApplicationPart.getVendorVersion(elem)), installable);
        }
        return null;
    }

    @Override
    public XElem getXml() {
        XElem result = new XElem("app");
        result.setAttr("name", this.getPartName());
        if (this.getVersion().getVendor().trim().length() > 0) {
            result.setAttr("vendor", this.getVersion().getVendor());
        }
        if (this.getVersion().getVendorVersionString().trim().length() > 0) {
            result.setAttr("version", this.getVersion().getVendorVersionString());
        }
        if (this.getDescription().trim().length() > 0) {
            result.setAttr("description", this.getDescription());
        }
        return result;
    }

    public String toString(Context context) {
        return "App Part: " + this.getPartName() + " " + (Object)((Object)this.getVersion());
    }
}

