/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.installable.BInstallable;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.BogFileFileTransferElement;
import com.tridium.platform.daemon.message.FileFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.MkDirFileTransferMessageElement;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.util.ArrayList;
import java.util.List;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.ICancelHint;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="destinationFileName", type="String", defaultValue=""), @NiagaraProperty(name="destinationDirPathBody", type="String", defaultValue="!")})
public class BFileInstallable
extends BInstallable {
    @Generated
    public static final Property destinationFileName = BFileInstallable.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property destinationDirPathBody = BFileInstallable.newProperty((int)0, (String)"!", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFileInstallable.class);
    private BIFile file;
    private boolean localInstance = false;
    private boolean isMkDir = false;
    private static final BIcon icon = BIcon.std((String)"file.png");

    @Generated
    public String getDestinationFileName() {
        return this.getString(destinationFileName);
    }

    @Generated
    public void setDestinationFileName(String v) {
        this.setString(destinationFileName, v, null);
    }

    @Generated
    public String getDestinationDirPathBody() {
        return this.getString(destinationDirPathBody);
    }

    @Generated
    public void setDestinationDirPathBody(String v) {
        this.setString(destinationDirPathBody, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFileInstallable() {
    }

    public BFileInstallable(BIFile pFile, FilePath destDirPath) {
        this(pFile);
        this.setDestinationDirPathBody(destDirPath.getBody());
        this.setInstallableName(destDirPath.merge(pFile.getFileName()).getBody());
    }

    public BFileInstallable(BDirectory dir, FilePath destDirPath, boolean isMkDir) {
        this((BIFile)dir);
        this.setDestinationDirPathBody(destDirPath.getBody());
        this.setInstallableName(destDirPath.merge(dir.getFileName()).getBody());
        this.isMkDir = isMkDir;
    }

    public BFileInstallable(BIFile pFile, String destFileName, FilePath destDirPath) {
        this(pFile);
        this.setDestinationDirPathBody(destDirPath.getBody());
        this.setDestinationFileName(destFileName);
        this.setInstallableName(destDirPath.merge(destFileName).getBody());
    }

    public BFileInstallable(BIFile pFile) {
        this.setDestinationFileName(pFile.getFileName());
        this.setInstallableName(pFile.getFileName());
        this.setDescription(pFile.getFileName());
        this.setInstallableFileProperties(pFile);
        if (pFile.isDirectory()) {
            this.setDestinationDirPathBody(pFile.getFilePath().getBody());
        } else {
            this.setDestinationDirPathBody(pFile.getFilePath().getParent().getBody());
        }
        this.file = pFile;
        this.localInstance = true;
    }

    @Override
    public void close() {
    }

    @Override
    public FileTransferMessageElement[] getTransferElements(BDaemonPlatform target, StoreCache cache, ICancelHint cancelHint, DaemonSessionTaskListener taskListener) {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BFileInstallable");
        }
        ArrayList<FileTransferMessageElement> resultList = new ArrayList<FileTransferMessageElement>();
        String newFileName = this.getDestinationFileName();
        if (newFileName.length() == 0) {
            newFileName = this.file.getFileName();
        }
        this.addFiles(resultList, this.file, newFileName, new FilePath(this.getDestinationDirPathBody()), target.getDaemonSession().getFileSpace(), cancelHint);
        return resultList.toArray(new FileTransferMessageElement[0]);
    }

    @Override
    public long getProcessingFlags(BDaemonPlatform targetPlatform, DaemonSessionTaskListener taskListener) {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BFileInstallable");
        }
        return 0L;
    }

    @Override
    public BInstallable makeLocalInstance() {
        if (this.localInstance) {
            return this;
        }
        try {
            return new BFileInstallable((BIFile)this.getInstallableFileOrd().get(), this.getDestinationFileName(), new FilePath(this.getDestinationDirPathBody()));
        }
        catch (UnresolvedException ue) {
            return null;
        }
        catch (RuntimeException re) {
            System.out.println("ord: " + this.getInstallableFileOrd());
            throw re;
        }
    }

    @Override
    public boolean equivalent(Object obj) {
        if (obj instanceof BFileInstallable) {
            BFileInstallable inst = (BFileInstallable)obj;
            return super.equivalent(inst) && inst.getDestinationDirPathBody().equals(this.getDestinationDirPathBody()) && inst.getDestinationFileName().equals(this.getDestinationFileName());
        }
        return false;
    }

    private void addFiles(List<FileTransferMessageElement> fileList, BIFile toAdd, String name, FilePath trgDirPath, BDaemonFileSpace space, ICancelHint cancelHint) {
        if (toAdd instanceof BDirectory) {
            if (this.isMkDir) {
                fileList.add(new MkDirFileTransferMessageElement(trgDirPath.merge(name), space));
            } else {
                for (BIFile content : ((BDirectory)toAdd).listFiles()) {
                    if (cancelHint != null && cancelHint.isCanceled()) {
                        throw new ICancelHint.CanceledException();
                    }
                    this.addFiles(fileList, content, content.getFileName(), trgDirPath.merge(name), space, cancelHint);
                }
            }
        } else if (toAdd instanceof BBogFile) {
            fileList.add(new BogFileFileTransferElement(trgDirPath.merge(name), (BBogFile)toAdd, space));
        } else {
            fileList.add(new FileFileTransferElement(trgDirPath.merge(name), toAdd, space));
        }
    }

    public BIcon getIcon() {
        try {
            String ext = BajaFileUtil.getExtension((String)this.getInstallableFileName());
            if (ext != null && ext.length() > 0) {
                TypeInfo type = Sys.getRegistry().getFileTypeForExtension(ext);
                BObject file = type.getInstance();
                return file.getIcon();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    @Override
    public String toString(Context cx) {
        return this.getInstallableName();
    }
}

