/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BundleManifest;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.platform.daemon.file.DirectoryCursor;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.GetBogFileMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.security.AccessController;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.file.zip.ZipPath;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.install.BFileReconciler;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.PatternFilter;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="buildDate", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="buildHost", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="reboot", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="requiredModuleContent", type="BModuleContent", defaultValue="BModuleContent.doc", flags=1), @NiagaraProperty(name="noRunningApp", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="noRunningStation", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="daemonUpdate", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="updateOsTz", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="absoluteElementPaths", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="osInstall", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="hostId", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="licenseMode", type="String", defaultValue="Perpetual", flags=1)})
public class BDistribution
extends BInstallable {
    @Generated
    public static final Property buildDate = BDistribution.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property buildHost = BDistribution.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property reboot = BDistribution.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property requiredModuleContent = BDistribution.newProperty((int)1, (BValue)BModuleContent.doc, null);
    @Generated
    public static final Property noRunningApp = BDistribution.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property noRunningStation = BDistribution.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property daemonUpdate = BDistribution.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property updateOsTz = BDistribution.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property absoluteElementPaths = BDistribution.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property osInstall = BDistribution.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property hostId = BDistribution.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property licenseMode = BDistribution.newProperty((int)1, (String)"Perpetual", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDistribution.class);
    private static final BIcon ICON = BIcon.std((String)"modules.png");
    public static final Logger LOG = Logger.getLogger("platform.dist");
    private final BZipFile zipFile;
    private XElem distFilePlatformElement;
    private boolean alwaysReplace = false;
    private final TreeSet<FilePath> pathsToRemove = new TreeSet();
    private final TreeSet<FilePath> dirPathsToClean = new TreeSet();
    private final TreeMap<FilePath, MessageElementTransform> fileTransformsByPath = new TreeMap();
    private final TreeMap<FilePath, MessageElementTransform> dirTransformsByPath = new TreeMap();
    private boolean localInstance = false;
    private BTcpIpHostSettings tcpIpChanges = null;
    private DistributionManifest manifest = null;
    private final MessageElementTransform ALWAYS_REPLACE = (newFile, destPath, targetPlatform, cache) -> new FileFileTransferElement(destPath, newFile, targetPlatform.getDaemonSession().getFileSpace());
    private final MessageElementTransform NEVER_REPLACE = (newFile, destPath, targetPlatform, cache) -> {
        BDaemonFileStore currentFile = this.getCurrentStore(destPath, targetPlatform, cache);
        if (currentFile == null) {
            return this.ALWAYS_REPLACE.getElement(newFile, destPath, targetPlatform, cache);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("FTMECursor.nextZipEntry skipping " + destPath.getBody() + " rule=never");
        }
        return null;
    };
    private final MessageElementTransform DO_NOT_COPY = (newFile, destPath, targetPlatform, cache) -> {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("FTMECursor.nextZipEntry skipping " + destPath.getBody() + " rule=nocopy");
        }
        return null;
    };
    private final MessageElementTransform CRC_REPLACE = (newFile, destPath, targetPlatform, cache) -> {
        long currentFileCrc;
        BDaemonFileStore currentFile = this.getCurrentStore(destPath, targetPlatform, cache);
        if (currentFile == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("not found " + destPath.getBody());
            }
            return this.ALWAYS_REPLACE.getElement(newFile, destPath, targetPlatform, cache);
        }
        long newFileCrc = DaemonFileUtil.getCrc(newFile);
        try {
            currentFileCrc = currentFile.getCrc();
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Error calculating CRC for " + destPath.getBody(), ioe);
            return this.ALWAYS_REPLACE.getElement(newFile, destPath, targetPlatform, cache);
        }
        if (currentFileCrc != newFileCrc) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("CRC mismatch for " + destPath.getBody() + " " + currentFileCrc + " != " + newFileCrc);
            }
            return this.ALWAYS_REPLACE.getElement(newFile, destPath, targetPlatform, cache);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("FTMECursor.nextZipEntry skipping " + destPath.getBody() + " rule=crc current crc is " + currentFileCrc + ", entry crc is " + newFileCrc);
        }
        return null;
    };
    private final MessageElementTransform REPLACE_HOSTID = (newFile, destPath, targetPlatform, cache) -> {
        String targetHostId = targetPlatform.getHostId();
        if (targetHostId == null) {
            return null;
        }
        if (targetHostId.equalsIgnoreCase(this.getHostId())) {
            return this.ALWAYS_REPLACE.getElement(newFile, destPath, targetPlatform, cache);
        }
        return null;
    };
    private final MessageElementTransform DEFAULT_REPLACE = new MessageElementTransform(){

        @Override
        public FileTransferMessageElement getElement(BIFile newFile, FilePath destPath, BDaemonPlatform targetPlatform, StoreCache cache) {
            return BDistribution.this.defaultReplaceTransform.getElement(newFile, destPath, targetPlatform, cache);
        }
    };
    private MessageElementTransform defaultReplaceTransform = this.CRC_REPLACE;
    public static final DistributionPartSummaryComparator DIST_SUMMARY_COMPARATOR = new DistributionPartSummaryComparator();
    public static final InstallablePartSummaryComparator INSTALLABLE_SUMMARY_COMPARATOR = new InstallablePartSummaryComparator();
    public static final DependencyPartSummaryComparator DEPENDENCY_SUMMARY_COMPARATOR = new DependencyPartSummaryComparator();
    public static final PartSummaryComparator PART_SUMMARY_COMPARATOR = new PartSummaryComparator();

    @Generated
    public String getBuildDate() {
        return this.getString(buildDate);
    }

    @Generated
    public void setBuildDate(String v) {
        this.setString(buildDate, v, null);
    }

    @Generated
    public String getBuildHost() {
        return this.getString(buildHost);
    }

    @Generated
    public void setBuildHost(String v) {
        this.setString(buildHost, v, null);
    }

    @Generated
    public boolean getReboot() {
        return this.getBoolean(reboot);
    }

    @Generated
    public void setReboot(boolean v) {
        this.setBoolean(reboot, v, null);
    }

    @Generated
    public BModuleContent getRequiredModuleContent() {
        return (BModuleContent)this.get(requiredModuleContent);
    }

    @Generated
    public void setRequiredModuleContent(BModuleContent v) {
        this.set(requiredModuleContent, (BValue)v, null);
    }

    @Generated
    public boolean getNoRunningApp() {
        return this.getBoolean(noRunningApp);
    }

    @Generated
    public void setNoRunningApp(boolean v) {
        this.setBoolean(noRunningApp, v, null);
    }

    @Generated
    public boolean getNoRunningStation() {
        return this.getBoolean(noRunningStation);
    }

    @Generated
    public void setNoRunningStation(boolean v) {
        this.setBoolean(noRunningStation, v, null);
    }

    @Generated
    public boolean getDaemonUpdate() {
        return this.getBoolean(daemonUpdate);
    }

    @Generated
    public void setDaemonUpdate(boolean v) {
        this.setBoolean(daemonUpdate, v, null);
    }

    @Generated
    public boolean getUpdateOsTz() {
        return this.getBoolean(updateOsTz);
    }

    @Generated
    public void setUpdateOsTz(boolean v) {
        this.setBoolean(updateOsTz, v, null);
    }

    @Generated
    public boolean getAbsoluteElementPaths() {
        return this.getBoolean(absoluteElementPaths);
    }

    @Generated
    public void setAbsoluteElementPaths(boolean v) {
        this.setBoolean(absoluteElementPaths, v, null);
    }

    @Generated
    public boolean getOsInstall() {
        return this.getBoolean(osInstall);
    }

    @Generated
    public void setOsInstall(boolean v) {
        this.setBoolean(osInstall, v, null);
    }

    @Generated
    public String getHostId() {
        return this.getString(hostId);
    }

    @Generated
    public void setHostId(String v) {
        this.setString(hostId, v, null);
    }

    @Generated
    public String getLicenseMode() {
        return this.getString(licenseMode);
    }

    @Generated
    public void setLicenseMode(String v) {
        this.setString(licenseMode, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDistribution() {
        this.zipFile = null;
    }

    public BDistribution(BIFile pFile) {
        this(pFile, null, true);
    }

    public BDistribution(BIFile pFile, boolean pCloseFile) {
        this(pFile, null, pCloseFile);
    }

    public BDistribution(BIFile pFile, ICancelHint cancelHint) {
        this(pFile, cancelHint, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDistribution(BIFile pFile, ICancelHint cancelHint, boolean pCloseFile) {
        this.checkCanceled(cancelHint);
        this.zipFile = new BZipFile(pFile.getStore());
        this.localInstance = pFile.getStore() instanceof BLocalFileStore;
        this.checkCanceled(cancelHint);
        BZipFile bZipFile = this.zipFile;
        synchronized (bZipFile) {
            this.setInstallableFileProperties(pFile);
            try {
                if (this.localInstance) {
                    BZipSpace space = (BZipSpace)this.zipFile.open();
                    BIFile manifestFile = space.findFile((FilePath)new ZipPath("META-INF/dist.xml"));
                    if (manifestFile == null) {
                        manifestFile = space.findFile((FilePath)new ZipPath("meta-inf/dist.xml"));
                    }
                    this.checkCanceled(cancelHint);
                    if (manifestFile != null) {
                        this.manifest = DistributionManifest.make(manifestFile.getInputStream(), pCloseFile);
                    }
                } else {
                    ZipEntry entry;
                    ZipInputStream in = new ZipInputStream(pFile.getInputStream());
                    while ((entry = in.getNextEntry()) != null) {
                        if (this.canceled(cancelHint)) {
                            if (pCloseFile) {
                                in.close();
                            }
                            throw new ICancelHint.CanceledException();
                        }
                        if (!entry.getName().equalsIgnoreCase("meta-inf/dist.xml")) continue;
                        this.manifest = DistributionManifest.make(XParser.make((InputStream)in).parse(false));
                    }
                    if (pCloseFile) {
                        in.close();
                    }
                }
                if (this.manifest == null) {
                    this.setIsValid(false);
                } else {
                    this.loadDistManifest(this.manifest, cancelHint);
                }
                if (pCloseFile) {
                    this.zipFile.close();
                }
            }
            catch (ICancelHint.CanceledException ce) {
                throw ce;
            }
            catch (Exception e) {
                this.setIsValid(false);
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.zipFile != null) {
            AccessController.doPrivileged(() -> {
                this.zipFile.close();
                return null;
            });
        }
    }

    @Override
    public BInstallable makeLocalInstance() {
        if (this.localInstance) {
            return this;
        }
        try {
            return AccessController.doPrivileged(() -> new BDistribution((BIFile)this.getInstallableFileOrd().get()));
        }
        catch (UnresolvedException ue) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileTransferMessageElement[] getTransferElements(BDaemonPlatform target, StoreCache cache, ICancelHint cancelHint, DaemonSessionTaskListener taskListener) throws Exception {
        if (!this.getIsValid()) {
            throw new IllegalStateException("can't get transfer elements for an invalid distribution file");
        }
        BZipFile bZipFile = this.zipFile;
        synchronized (bZipFile) {
            Array resultList = new Array(FileTransferMessageElement.class);
            FTMECursor c = new FTMECursor(target, cache, cancelHint, taskListener);
            while (c.next()) {
                resultList.add((Object)c.get());
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("FileTransferMessageElement result array:");
                for (int i = 0; i < resultList.size(); ++i) {
                    LOG.fine("[" + i + "]" + resultList.get(i));
                }
            }
            return (FileTransferMessageElement[])resultList.trim();
        }
    }

    @Override
    public BTcpIpHostSettings getTcpIpChanges() {
        if (!this.getIsValid()) {
            throw new IllegalStateException("can't get tcp/ip changes for an invalid distribution file");
        }
        return this.tcpIpChanges;
    }

    @Override
    public boolean meets(BDependency depend, DaemonSessionTaskListener listener) {
        if (!this.getIsValid()) {
            return false;
        }
        if (depend.getPartType().is(TYPE)) {
            return new PatternFilter(depend.getPartName()).accept(this.getInstallableName()) && this.getVersion().meets(depend);
        }
        return super.meets(depend, listener);
    }

    @Override
    public long getProcessingFlags(BDaemonPlatform targetPlatform, DaemonSessionTaskListener taskListener) {
        if (!this.getIsValid()) {
            throw new IllegalStateException("can't get processing flags for an invalid distribution file");
        }
        long result = 0L;
        if (this.getReboot()) {
            result |= 0x10000L;
        }
        if (this.getOsInstall()) {
            result |= 0x20000L;
        }
        if (this.getDaemonUpdate()) {
            result |= 0x40000L;
        }
        if (this.getNoRunningApp()) {
            result |= 1L;
        }
        if (this.getNoRunningStation()) {
            result |= 2L;
        }
        if (this.getUpdateOsTz()) {
            result |= 0x200000L;
        }
        if (this.getTcpIpChanges() != null && !this.getTcpIpChanges().getIsReadonly()) {
            result |= 0x80000L;
        }
        if (this.getUpdateModuleContent()) {
            result |= 0x100000L;
        }
        if (this.getUpdateRuntimeProfilesEnabled()) {
            result |= 0x400000L;
        }
        return result;
    }

    @Override
    public boolean meetsLicenseCriteria(VendorLicense vendorLicense) {
        if (vendorLicense.getVendor().equalsIgnoreCase("tridium") && this.getVersion().getVendor().equalsIgnoreCase("tridium") && this.getInstallableName().toLowerCase().startsWith("nre")) {
            if (this.getReleaseDate().isPresent()) {
                if (vendorLicense.getMaintenanceExpiration().isPresent()) {
                    return (Long)vendorLicense.getMaintenanceExpiration().get() >= this.getReleaseDate().get();
                }
                return vendorLicense.getVersion().compareTo(this.getVersion().getVendorVersion().toMinorVersion()) >= 0;
            }
            return vendorLicense.getUnreleasedSwAccessExpiration().isPresent() && (Long)vendorLicense.getUnreleasedSwAccessExpiration().get() >= BAbsTime.now().getMillis() && vendorLicense.getVersion().compareTo(this.getVersion().getVendorVersion().toMinorVersion()) >= 0;
        }
        return true;
    }

    public void addDirPathToClean(FilePath path) {
        this.dirPathsToClean.add(path);
    }

    public XElem getUpdatedPlatformBog(BDaemonPlatform target) throws ConnectException, AuthenticationException {
        if (this.distFilePlatformElement == null) {
            return null;
        }
        GetBogFileMessage msg = new GetBogFileMessage(SystemFilePaths.getPlatformBogPath(target.getIsNiagara4(), target.getIsNiagaraHomeReadonly()), target.getDaemonSession().getFileSpace(), false);
        InputStream platformBogStream = target.getDaemonSession().getInputStream((DaemonMessage)msg, msg.getMessageTimeout());
        try {
            XElem platElement;
            XElem rootElement;
            HashSet<String> existingPlatformServiceNames = new HashSet<String>();
            if (platformBogStream == null) {
                rootElement = this.getDefaultPlatformXML();
            } else if (this.distFilePlatformElement.getb("merge", true)) {
                rootElement = XParser.make((InputStream)platformBogStream).parse();
                platElement = rootElement.elem(0);
                if (!platElement.get("t").endsWith(":PlatformServiceContainer")) {
                    rootElement = this.getDefaultPlatformXML();
                } else {
                    for (XElem service : platElement.elems("p")) {
                        existingPlatformServiceNames.add(service.get("n"));
                    }
                }
            } else {
                platformBogStream.close();
                rootElement = this.getDefaultPlatformXML();
            }
            platElement = rootElement.elem(0);
            for (XElem mergeService : this.distFilePlatformElement.elems("p")) {
                if (existingPlatformServiceNames.contains(mergeService.get("n"))) continue;
                platElement.addContent((XContent)mergeService.copy());
            }
            return rootElement;
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("platform", "Distribution.exception.platformBog", (Throwable)e);
        }
    }

    private XElem getDefaultPlatformXML() {
        XElem rootElement = new XElem("bajaObjectGraph");
        rootElement.addAttr("version", "1.0");
        XElem platElement = new XElem("p");
        platElement.addAttr("n", "platform");
        platElement.addAttr("m", "platform=platform");
        platElement.addAttr("t", "platform:PlatformServiceContainer");
        rootElement.addContent((XContent)platElement);
        return rootElement;
    }

    public DistributionManifest getManifest() {
        return this.manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFileUpdates(BDaemonPlatform target, StoreCache cache, ICancelHint cancelHint, DaemonSessionTaskListener taskListener) throws Exception {
        if (!this.getIsValid()) {
            throw new IllegalStateException("can't check file updates with an invalid distribution file");
        }
        if (this.getUpdateModuleContent() && !this.getNewModuleContent().equals((Object)target.getModuleContent())) {
            LOG.fine("hasFileUpdates returning true - module content change");
            return true;
        }
        boolean hasCheckedParts = false;
        SlotCursor c = this.getParts().getProperties();
        while (c.next(BPart.class)) {
            hasCheckedParts = true;
            BPart dp = (BPart)c.get();
            BPart pp = target.getPart(dp.getPartName(), dp.getType().getTypeSpec(), taskListener);
            if (pp == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("hasFileUpdates returning true - part not installed: " + dp.getPartName());
                }
                return true;
            }
            if (dp.getVersion().equivalent((Object)pp.getVersion())) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("hasFileUpdates returning true - part " + dp.getPartName() + " " + (Object)((Object)dp.getVersion()) + " != " + (Object)((Object)pp.getVersion()));
            }
            return true;
        }
        if (hasCheckedParts) {
            return false;
        }
        BDefaultDaemonFileSpace daemonFileSpace = target.getDaemonSession().getFileSpace();
        String npsdkUpdatesPath = daemonFileSpace.filePathToUri(SystemFilePaths.getNpsdkUpdatesBasePath(target.getIsNiagaraHomeReadonly()));
        BZipFile bZipFile = this.zipFile;
        synchronized (bZipFile) {
            FTMECursor c2 = new FTMECursor(target, cache, cancelHint, taskListener);
            while (c2.next()) {
                this.checkCanceled(cancelHint);
                FilePath entryPath = c2.get().getFilePath();
                if (entryPath.getBody().startsWith(npsdkUpdatesPath)) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("hasFileUpdates skipping consideration of entry " + entryPath.getBody() + ", target install directory is a stage");
                    continue;
                }
                if (entryPath.getName().equals("platform.bog")) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("hasFileUpdates skipping consideration of entry " + entryPath.getBody() + ", file is platform.bog template");
                    continue;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("hasFileUpdates returning true - " + entryPath.getBody() + " not present or out of date on remote host");
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInstallableResources(DaemonSessionTaskListener listener) throws Exception {
        if (!this.localInstance) {
            throw new IllegalStateException("Cannot call registerInstallableResources() on proxy instance");
        }
        BZipFile bZipFile = this.zipFile;
        synchronized (bZipFile) {
            BZipSpace space = null;
            for (BundleManifest.InstallableResourceMetadata resourceMetadata : this.manifest.getInstallableResources()) {
                BInstallable inst = LocalInstallableRegistry.getInstance().findInstallable(BDependency.make(resourceMetadata.makeDependencyElem()), listener);
                if (inst != null) continue;
                if (space == null) {
                    space = (BZipSpace)this.zipFile.open();
                }
                BIFile resourceFile = space.findFile((FilePath)new ZipPath(resourceMetadata.getContentEntryPath()));
                try (InputStream in = resourceFile.getInputStream();){
                    LocalInstallableRegistry.getInstance().register(resourceMetadata.getInstallableName(), resourceFile.getFileName(), resourceMetadata.getVersion(), in, listener);
                }
            }
        }
    }

    public void setAlwaysReplace(boolean value) {
        this.alwaysReplace = value;
    }

    private void checkCanceled(ICancelHint cancelHint) {
        if (this.canceled(cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
    }

    private boolean canceled(ICancelHint cancelHint) {
        return cancelHint != null && cancelHint.isCanceled();
    }

    private BDaemonFileStore getCurrentStore(FilePath path, BDaemonPlatform platform, StoreCache cache) {
        BDaemonDirectoryStore dir;
        try {
            dir = BDaemonDirectoryStore.make(platform.getDaemonSession().getFileSpace(), path.getParent(), false, true, false, cache);
        }
        catch (IOException ioe) {
            throw new LocalizableRuntimeException("platform", "Distribution.exception.readContents", new Object[]{this.zipFile.getFilePath().getBody()}, (Throwable)ioe);
        }
        return dir == null ? null : (BDaemonFileStore)dir.getChild(path.getName(), BCacheAccessPolicy.lazyFetch);
    }

    private FilePath getEntryDestPath(FilePath entryPath) {
        if (this.getAbsoluteElementPaths()) {
            return entryPath;
        }
        String entryPathBody = entryPath.getBody();
        if (entryPath.isLocalAbsolute()) {
            entryPathBody = entryPathBody.substring(1);
        }
        int firstSep = entryPathBody.indexOf(47);
        String relativeLocation = null;
        if (firstSep > 0) {
            relativeLocation = entryPathBody.substring(0, firstSep);
            entryPathBody = entryPathBody.substring(firstSep + 1);
        }
        char prefix = '!';
        if ("niagara_user_home".equals(relativeLocation)) {
            prefix = '~';
        } else if ("niagara_home".equals(relativeLocation)) {
            prefix = '!';
        } else {
            entryPathBody = entryPath.isLocalAbsolute() ? entryPath.getBody().substring(1) : entryPath.getBody();
        }
        return new FilePath(prefix + entryPathBody);
    }

    private FilePath getEntryDestPath(String entryName) {
        if (this.getAbsoluteElementPaths()) {
            if (entryName.charAt(0) == '/') {
                return new FilePath(entryName);
            }
            return new FilePath("/" + entryName);
        }
        String entryPath = entryName;
        if (entryName.charAt(0) == '/') {
            entryPath = entryName.substring(1);
        }
        int firstSep = entryPath.indexOf(47);
        String relativeLocation = null;
        if (firstSep > 0) {
            relativeLocation = entryPath.substring(0, firstSep);
            entryPath = entryPath.substring(firstSep + 1);
        }
        char prefix = '~';
        if ("niagara_user_home".equals(relativeLocation)) {
            prefix = '~';
        } else if ("niagara_home".equals(relativeLocation)) {
            prefix = '!';
        } else {
            entryPath = entryName.charAt(0) == '/' ? entryName.substring(1) : entryName;
        }
        return new FilePath(prefix + entryPath);
    }

    private MessageElementTransform getTransformForReplaceRule(int manifestReplaceRule) {
        switch (manifestReplaceRule) {
            case -1: {
                return this.DEFAULT_REPLACE;
            }
            case 0: {
                return this.NEVER_REPLACE;
            }
            case 1: {
                return this.ALWAYS_REPLACE;
            }
            case 2: {
                return this.CRC_REPLACE;
            }
            case 3: {
                return this.DO_NOT_COPY;
            }
            case 4: {
                return this.REPLACE_HOSTID;
            }
        }
        throw new IllegalStateException("Unrecognized replacement rule");
    }

    private MessageElementTransform getTransformForReplaceRule(BundleManifest.FileHandlingRule manifestRule) {
        if (manifestRule.reconciler != null) {
            return new Reconcile(manifestRule.reconciler);
        }
        return this.getTransformForReplaceRule(manifestRule.replaceRule);
    }

    private void loadDistManifest(DistributionManifest manifest, ICancelHint cancelHint) {
        if (manifest.getInstallableName().equals("backup")) {
            this.setInstallableName("backupdist");
        } else {
            this.setInstallableName(manifest.getInstallableName());
        }
        this.setDescription(manifest.getDescription());
        this.setBuildDate(manifest.getBuildDate());
        this.setBuildHost(manifest.getBuildHost());
        this.setReboot(manifest.isRebootRequired());
        this.setIsStandalone(manifest.isStandalone());
        this.setNewOsTimeZone(manifest.getNewOsTimeZone());
        this.setUpdateOsTz(!this.getNewOsTimeZone().isNull());
        this.setNoRunningApp(manifest.noRunningApp());
        this.setNoRunningStation(manifest.noRunningStation());
        this.setAbsoluteElementPaths(manifest.useAbsoluteElementPaths());
        this.setOsInstall(manifest.isOsUpdateRequired());
        this.setDaemonUpdate(manifest.isDaemonBinaryUpdateRequired());
        this.setReleaseDate(manifest.getReleaseDate());
        if (manifest.getHostId() != null) {
            this.setHostId(manifest.getHostId());
        }
        if (manifest.getLicenseMode() != null) {
            this.setLicenseMode(manifest.getLicenseMode());
        }
        this.setVersion(manifest.getInstallableVersion());
        this.distFilePlatformElement = manifest.getPlatformXml();
        this.defaultReplaceTransform = this.getTransformForReplaceRule(manifest.getDefaultReplaceRule());
        for (BundleManifest.FileHandlingRule fileHandlingRule : manifest.getFileHandlingRules()) {
            if (fileHandlingRule instanceof BundleManifest.RemoveRule) {
                this.pathsToRemove.add(this.getEntryDestPath(fileHandlingRule.entryPath));
                continue;
            }
            if (fileHandlingRule instanceof BundleManifest.DirHandlingRule) {
                BundleManifest.DirHandlingRule dirHandlingRule = (BundleManifest.DirHandlingRule)fileHandlingRule;
                this.dirTransformsByPath.put(this.getEntryDestPath(dirHandlingRule.entryPath), this.getTransformForReplaceRule(dirHandlingRule));
                if (!dirHandlingRule.clean) continue;
                this.dirPathsToClean.add(this.getEntryDestPath(dirHandlingRule.entryPath));
                continue;
            }
            this.fileTransformsByPath.put(this.getEntryDestPath(fileHandlingRule.entryPath), this.getTransformForReplaceRule(fileHandlingRule));
        }
        for (BDependency bDependency : manifest.getDependencies()) {
            this.getDependencies().add("dep?", (BValue)bDependency);
        }
        for (BDependency bDependency : manifest.getExclusions()) {
            this.getExclusions().add("excl?", (BValue)bDependency);
        }
        for (BPart bPart : manifest.getProvidedParts(this)) {
            this.getParts().add(SlotPath.escape((String)bPart.getPartName()), (BValue)bPart);
        }
        this.tcpIpChanges = manifest.getTcpIpSettings();
        BModuleContent bModuleContent = manifest.getUpdateModuleContent();
        if (bModuleContent == null) {
            this.setUpdateModuleContent(false);
        } else {
            this.setUpdateModuleContent(true);
            this.setNewModuleContent(bModuleContent);
        }
        String newEnabledProfiles = manifest.getUpdatedRuntimeProfilesEnabled();
        if (newEnabledProfiles == null) {
            this.setUpdateRuntimeProfilesEnabled(false);
        } else {
            this.setUpdateRuntimeProfilesEnabled(true);
            this.setEnabledRuntimeProfileNames(newEnabledProfiles);
        }
    }

    private void updateUrisToKeep(BDaemonPlatform target, Set<FilePath> urisToKeep, FilePath fileURI) {
        for (FilePath dirPathToClean : this.dirPathsToClean) {
            FilePath dirURIToClean = target.getDaemonSession().getFileSpace().toDaemonUriPath(dirPathToClean);
            if (!DaemonFileUtil.isSubPath(fileURI, dirURIToClean)) continue;
            FilePath subURI = fileURI;
            while (subURI.depth() > 0) {
                urisToKeep.add(subURI);
                subURI = subURI.getParent();
            }
            return;
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    private static int comparePart(Type lhsPart, Type rhsPart) {
        if (lhsPart.equals(BNrePart.TYPE)) {
            return -1;
        }
        if (rhsPart.equals(BNrePart.TYPE)) {
            return 1;
        }
        if (lhsPart.equals(BVmPart.TYPE)) {
            return -1;
        }
        if (rhsPart.equals(BVmPart.TYPE)) {
            return 1;
        }
        if (lhsPart.equals(BOsPart.TYPE)) {
            return -1;
        }
        if (rhsPart.equals(BOsPart.TYPE)) {
            return 1;
        }
        if (lhsPart.equals(BArchPart.TYPE)) {
            return -1;
        }
        if (rhsPart.equals(BArchPart.TYPE)) {
            return 1;
        }
        if (lhsPart.equals(BModelPart.TYPE)) {
            return -1;
        }
        if (rhsPart.equals(BModelPart.TYPE)) {
            return 1;
        }
        if (lhsPart.equals(BBrandPart.TYPE)) {
            return -1;
        }
        if (rhsPart.equals(BBrandPart.TYPE)) {
            return 1;
        }
        if (lhsPart.equals(BGenericPart.TYPE)) {
            return -1;
        }
        if (rhsPart.equals(BGenericPart.TYPE)) {
            return 1;
        }
        return 0;
    }

    public static class PartSummaryComparator
    implements Comparator<BPart> {
        @Override
        public int compare(BPart lhs, BPart rhs) {
            int partNameCompare = lhs.getPartName().compareTo(rhs.getPartName());
            Type lhsPart = lhs.getType();
            Type rhsPart = rhs.getType();
            if (lhsPart.getTypeClass() == rhsPart.getTypeClass()) {
                return partNameCompare;
            }
            int partCompare = BDistribution.comparePart(lhsPart, rhsPart);
            if (partCompare != 0) {
                return partCompare;
            }
            return partNameCompare;
        }
    }

    public static class DependencyPartSummaryComparator
    implements Comparator<BDependency> {
        @Override
        public int compare(BDependency lhs, BDependency rhs) {
            int installableCompare = lhs.getPartName().compareTo(rhs.getPartName());
            Type lhsPart = lhs.getPartType();
            Type rhsPart = rhs.getPartType();
            if (lhsPart.getTypeClass() == rhsPart.getTypeClass()) {
                return installableCompare;
            }
            int partCompare = BDistribution.comparePart(lhsPart, rhsPart);
            if (partCompare != 0) {
                return partCompare;
            }
            return installableCompare;
        }
    }

    public static class InstallablePartSummaryComparator
    implements Comparator<BInstallable> {
        @Override
        public int compare(BInstallable lhs, BInstallable rhs) {
            int installableCompare = lhs.getInstallableName().compareTo(rhs.getInstallableName());
            BPart lhsPart = lhs.getPart();
            BPart rhsPart = rhs.getPart();
            if (lhsPart == null && rhsPart == null) {
                return installableCompare;
            }
            if (lhsPart == null) {
                return -1;
            }
            if (rhsPart == null) {
                return 1;
            }
            if (((Object)((Object)lhsPart)).getClass() == ((Object)((Object)rhsPart)).getClass()) {
                return installableCompare;
            }
            int partCompare = BDistribution.comparePart(lhsPart.getType(), rhsPart.getType());
            if (partCompare != 0) {
                return partCompare;
            }
            return installableCompare;
        }
    }

    public static class DistributionPartSummaryComparator
    implements Comparator<BDistribution> {
        @Override
        public int compare(BDistribution lhs, BDistribution rhs) {
            int installableCompare = lhs.getInstallableName().compareTo(rhs.getInstallableName());
            BPart lhsPart = lhs.getPart();
            BPart rhsPart = rhs.getPart();
            if (lhsPart == null && rhsPart == null) {
                return installableCompare;
            }
            if (lhsPart == null) {
                return -1;
            }
            if (rhsPart == null) {
                return 1;
            }
            if (((Object)((Object)lhsPart)).getClass() == ((Object)((Object)rhsPart)).getClass()) {
                return installableCompare;
            }
            int partCompare = BDistribution.comparePart(lhsPart.getType(), rhsPart.getType());
            if (partCompare != 0) {
                return partCompare;
            }
            return installableCompare;
        }
    }

    private class CleanElementsCursor {
        private final Set<FilePath> urisToKeep;
        private final FilePath dirURI;
        private final BDaemonDirectoryStore dir;
        private final ICancelHint cancelHint;
        private final Array<BIFileStore> kids;
        private CleanElementsCursor innerCursor = null;
        private DeleteFileTransferMessageElement current = null;
        private int ixKid = 0;
        private boolean finished = false;
        private boolean emptyWhenDone = true;

        public CleanElementsCursor(Set<FilePath> pURIsToKeep, BDaemonDirectoryStore pDir, ICancelHint pCancelHint) {
            this.urisToKeep = pURIsToKeep;
            this.dir = pDir;
            this.dirURI = pDir.getDaemonSession().getFileSpace().toDaemonUriPath(pDir.getFilePath());
            this.cancelHint = pCancelHint;
            try {
                this.kids = this.dir.getChildren(BCacheAccessPolicy.lazyFetch, true, false, false);
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("platform", "Distribution.exception.dirList", new Object[]{this.dirURI.getBody()}, (Throwable)e);
            }
        }

        public DeleteFileTransferMessageElement get() {
            return this.current;
        }

        public boolean next() {
            if (this.finished) {
                return false;
            }
            if (this.innerCursor != null) {
                if (this.innerCursor.next()) {
                    this.current = this.innerCursor.get();
                    return true;
                }
                this.emptyWhenDone = this.emptyWhenDone && this.innerCursor.emptyWhenDone;
                this.innerCursor = null;
            }
            while (this.ixKid < this.kids.size()) {
                FilePath kidURI = this.dir.getDaemonFileSpace().toDaemonUriPath(((BIFileStore)this.kids.get(this.ixKid)).getFilePath());
                BDistribution.this.checkCanceled(this.cancelHint);
                if (((BIFileStore)this.kids.get(this.ixKid)).isDirectory()) {
                    this.innerCursor = new CleanElementsCursor(this.urisToKeep, (BDaemonDirectoryStore)((Object)this.kids.get(this.ixKid)), this.cancelHint);
                    ++this.ixKid;
                    if (!this.innerCursor.next()) continue;
                    this.current = this.innerCursor.get();
                    return true;
                }
                if (this.urisToKeep.contains(kidURI)) {
                    ++this.ixKid;
                    this.emptyWhenDone = false;
                    continue;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("clean file " + kidURI.getBody());
                }
                this.current = new DeleteFileTransferMessageElement(kidURI, this.dir.getDaemonFileSpace());
                ++this.ixKid;
                return true;
            }
            this.finished = true;
            if (this.emptyWhenDone && !this.urisToKeep.contains(this.dirURI)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("clean dir " + this.dirURI.getBody());
                }
                this.current = new DeleteFileTransferMessageElement(this.dirURI, this.dir.getDaemonFileSpace());
                return true;
            }
            return false;
        }
    }

    private static class ReconciliationResultsFTME
    extends FileTransferMessageElement {
        private final BFileReconciler.ReconciliationResults results;

        public ReconciliationResultsFTME(FilePath pPath, BDaemonFileSpace space, BFileReconciler.ReconciliationResults results) {
            super(pPath, space);
            this.results = results;
        }

        @Override
        public InputStream getStream() throws IOException {
            try {
                return this.results.getInputStream();
            }
            catch (IOException | RuntimeException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        @Override
        public long getSize() {
            try {
                return this.results.getSize();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    private class Reconcile
    implements MessageElementTransform {
        private final BFileReconciler reconciler;

        public Reconcile(BFileReconciler reconciler) {
            this.reconciler = reconciler;
        }

        @Override
        public FileTransferMessageElement getElement(BIFile newFile, FilePath destPath, BDaemonPlatform targetPlatform, StoreCache cache) {
            BDaemonFileStore currentStore = BDistribution.this.getCurrentStore(destPath, targetPlatform, cache);
            if (currentStore == null) {
                return BDistribution.this.ALWAYS_REPLACE.getElement(newFile, destPath, targetPlatform, cache);
            }
            try {
                BFileReconciler.ReconciliationResults results = this.reconciler.reconcile(newFile, DaemonFileUtil.getCrc(newFile), targetPlatform.getDaemonSession().getFileSpace().makeFile((BIFileStore)currentStore), currentStore.getCrc());
                if (results == null || !results.shouldReplaceContents()) {
                    return null;
                }
                return new ReconciliationResultsFTME(destPath, targetPlatform.getDaemonSession().getFileSpace(), results);
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("platform", "Distribution.exception.readContents", new Object[]{BDistribution.this.zipFile.getFilePath().getBody()}, (Throwable)e);
            }
        }
    }

    private static interface MessageElementTransform {
        public FileTransferMessageElement getElement(BIFile var1, FilePath var2, BDaemonPlatform var3, StoreCache var4);
    }

    private class FTMECursor {
        private final BDaemonPlatform target;
        private final StoreCache cache;
        private final DaemonSessionTaskListener taskListener;
        private final ICancelHint cancelHint;
        private final TreeSet<FilePath> urisToKeep = new TreeSet();
        private final boolean licenseReadonly;
        private final TreeMap<FilePath, MessageElementTransform> fileTransformsByURI = new TreeMap();
        private final TreeMap<FilePath, MessageElementTransform> dirTransformsByURI = new TreeMap();
        private boolean cachePrimed = false;
        private Iterator<FilePath> pathsToRemoveIterator = null;
        private FileTransferMessageElement current = null;
        private DirectoryCursor entryDirectoryCursor = null;
        private Iterator<FilePath> dirPathToCleanIterator = null;
        private CleanElementsCursor cleanElementsCursor = null;
        private boolean platformBogChecked = false;

        public FTMECursor(BDaemonPlatform pTarget, StoreCache pCache, ICancelHint pCancelHint, DaemonSessionTaskListener pTaskListener) {
            if (!BDistribution.this.localInstance) {
                throw new IllegalStateException("illegal call on proxy instance of BDistribution");
            }
            this.target = pTarget;
            this.cache = pCache;
            this.cancelHint = pCancelHint;
            this.taskListener = pTaskListener;
            this.licenseReadonly = pTarget.getDaemonSession().getHostProperties().getIsLicenseReadonly();
            this.urisToKeep.add(SystemFilePaths.getPlatformBogPath(pTarget.getIsNiagara4(), pTarget.getIsNiagaraHomeReadonly()));
            if (pTarget.getIsNiagara4()) {
                this.urisToKeep.add(new FilePath("/niagara/etc/platform.bog"));
            } else {
                this.urisToKeep.add(new FilePath("/niagara/lib/platform.bog"));
            }
            if (this.licenseReadonly) {
                boolean isPerpetual = pTarget.getDaemonSession().getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual();
                this.urisToKeep.add(SystemFilePaths.getLicensesDirPath(pTarget.getIsNiagara4(), isPerpetual, pTarget.getIsNiagaraHomeReadonly()));
                this.urisToKeep.add(SystemFilePaths.getCertificatesDirPath(pTarget.getIsNiagara4(), isPerpetual, pTarget.getIsNiagaraHomeReadonly()));
            }
            for (Map.Entry fileEntry : BDistribution.this.fileTransformsByPath.entrySet()) {
                this.fileTransformsByURI.put(pTarget.getDaemonSession().getFileSpace().toDaemonUriPath((FilePath)fileEntry.getKey()), (MessageElementTransform)fileEntry.getValue());
            }
            for (Map.Entry fileEntry : BDistribution.this.dirTransformsByPath.entrySet()) {
                this.dirTransformsByURI.put(pTarget.getDaemonSession().getFileSpace().toDaemonUriPath((FilePath)fileEntry.getKey()), (MessageElementTransform)fileEntry.getValue());
            }
        }

        public FileTransferMessageElement get() {
            return this.current;
        }

        public boolean next() throws AuthenticationException, IOException {
            if (this.nextRemove()) {
                return true;
            }
            if (!this.cachePrimed) {
                for (FilePath cleanPath : BDistribution.this.dirPathsToClean) {
                    BDaemonDirectoryStore.make(this.target.getDaemonSession().getFileSpace(), cleanPath, true, true, false, this.cache);
                }
                this.cachePrimed = true;
            }
            return this.nextZipEntry() || this.nextPlatformBog() || this.nextClean();
        }

        private boolean nextPlatformBog() throws ConnectException, AuthenticationException {
            if (this.platformBogChecked) {
                return false;
            }
            this.platformBogChecked = true;
            XElem rootElement = BDistribution.this.getUpdatedPlatformBog(this.target);
            if (rootElement == null) {
                return false;
            }
            try {
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                XWriter out = new XWriter((OutputStream)bytesOut);
                out.prolog();
                rootElement.write(out);
                out.flush();
                this.current = new ByteArrayFileTransferElement(SystemFilePaths.getPlatformBogPath(this.target.getIsNiagara4(), this.target.getIsNiagaraHomeReadonly()), bytesOut.toByteArray(), this.target.getDaemonSession().getFileSpace());
                return true;
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("platform", "Distribution.exception.platformBog", (Throwable)e);
            }
        }

        private boolean nextRemove() throws AuthenticationException, IOException {
            if (this.pathsToRemoveIterator == null) {
                this.pathsToRemoveIterator = BDistribution.this.pathsToRemove.iterator();
            }
            if (this.pathsToRemoveIterator.hasNext()) {
                BDistribution.this.checkCanceled(this.cancelHint);
                FilePath path = this.pathsToRemoveIterator.next();
                BIFileStore store = this.target.getDaemonSession().getFileSpace().findStore(this.cache, path, false, false);
                if (store != null) {
                    this.current = new DeleteFileTransferMessageElement(path, this.target.getDaemonSession().getFileSpace());
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean nextZipEntry() {
            CancelableDaemonSessionTask task = null;
            try {
                if (this.entryDirectoryCursor == null) {
                    BDistribution.this.checkCanceled(this.cancelHint);
                    this.entryDirectoryCursor = AccessController.doPrivileged(() -> new DirectoryCursor((BIDirectory)((BZipSpace)BDistribution.this.zipFile.open())));
                }
                while (this.entryDirectoryCursor.nextNonDirectory()) {
                    BDistribution.this.checkCanceled(this.cancelHint);
                    FilePath entryURI = this.target.getDaemonSession().getFileSpace().toDaemonUriPath(BDistribution.this.getEntryDestPath(this.entryDirectoryCursor.getFile().getFilePath()));
                    if (entryURI.depth() > 2 && entryURI.nameAt(1).equalsIgnoreCase("meta-inf")) continue;
                    if (this.licenseReadonly && (entryURI.getName().endsWith(".license") || entryURI.getName().endsWith(".certificate"))) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("FTMECursor.nextZipEntry skipping " + entryURI.getBody() + " because target licenses are readonly");
                        continue;
                    }
                    if (entryURI.getName().equals("platform.bog")) continue;
                    BDistribution.this.updateUrisToKeep(this.target, this.urisToKeep, entryURI);
                    task = new CancelableDaemonSessionTask(BDistribution.this.getLexicon(), "Distribution.fileCheck.title", "Distribution.fileCheck.message", new Object[]{entryURI.getBody()}, this.cancelHint);
                    if (this.taskListener != null) {
                        this.taskListener.taskStarted(task);
                    }
                    this.current = this.getTransformForEntryURI(entryURI).getElement(this.entryDirectoryCursor.getFile(), entryURI, this.target, this.cache);
                    if (this.current != null) {
                        boolean bl = true;
                        if (task != null && this.taskListener != null) {
                            this.taskListener.taskFinished(task);
                        }
                        return bl;
                    }
                    if (this.taskListener == null) continue;
                    this.taskListener.taskFinished(task);
                }
                boolean bl = false;
                if (task != null && this.taskListener != null) {
                    this.taskListener.taskFinished(task);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (task != null && this.taskListener != null) {
                    this.taskListener.taskFinished(task);
                }
                throw throwable;
            }
        }

        private MessageElementTransform getTransformForEntryURI(FilePath entryURI) {
            MessageElementTransform result = this.fileTransformsByURI.get(entryURI);
            if (result != null) {
                if (BDistribution.this.alwaysReplace && result != BDistribution.this.DO_NOT_COPY && result != BDistribution.this.REPLACE_HOSTID) {
                    return BDistribution.this.ALWAYS_REPLACE;
                }
                return result;
            }
            result = BDistribution.this.defaultReplaceTransform;
            int matchDepth = 0;
            for (FilePath ruleURI : this.dirTransformsByURI.keySet()) {
                if (ruleURI.depth() <= matchDepth || !DaemonFileUtil.isSubPath(entryURI, ruleURI)) continue;
                result = this.dirTransformsByURI.get(ruleURI);
                matchDepth = ruleURI.depth();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean nextClean() {
            CancelableDaemonSessionTask task = null;
            try {
                if (this.entryDirectoryCursor == null || this.entryDirectoryCursor.nextNonDirectory()) {
                    throw new IllegalStateException("nextClean must be called after nextZipEntry() is completed");
                }
                if (this.cleanElementsCursor != null && this.cleanElementsCursor.next()) {
                    this.current = this.cleanElementsCursor.get();
                    boolean bl = true;
                    if (task != null && this.taskListener != null) {
                        this.taskListener.taskFinished(task);
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                if (task != null && this.taskListener != null) {
                    this.taskListener.taskFinished(task);
                }
                throw throwable;
            }
            {
                this.cleanElementsCursor = null;
                if (this.dirPathToCleanIterator == null) {
                    task = new CancelableDaemonSessionTask(BDistribution.this.getLexicon(), "Distribution.cleanCheck", "Distribution.cleanCheck", this.cancelHint);
                    if (this.taskListener != null) {
                        this.taskListener.taskStarted(task);
                    }
                    this.dirPathToCleanIterator = BDistribution.this.dirPathsToClean.iterator();
                }
                while (this.dirPathToCleanIterator.hasNext()) {
                    BDaemonDirectoryStore dir;
                    BDistribution.this.checkCanceled(this.cancelHint);
                    FilePath dirPath = this.dirPathToCleanIterator.next();
                    try {
                        dir = BDaemonDirectoryStore.make(this.target.getDaemonSession().getFileSpace(), dirPath, true, false, false, this.cache);
                    }
                    catch (IOException ioe) {
                        throw new LocalizableRuntimeException("platform", "Distribution.exception.readContents", new Object[]{BDistribution.this.zipFile.getFilePath().getBody()}, (Throwable)ioe);
                    }
                    if (dir == null) continue;
                    this.cleanElementsCursor = new CleanElementsCursor(this.urisToKeep, dir, this.cancelHint);
                    if (!this.cleanElementsCursor.next()) continue;
                    this.current = this.cleanElementsCursor.get();
                    boolean bl = true;
                    if (task != null && this.taskListener != null) {
                        this.taskListener.taskFinished(task);
                    }
                    return bl;
                }
            }
            {
                if (task != null && this.taskListener != null) {
                    this.taskListener.taskFinished(task);
                }
                boolean bl = false;
                if (task != null && this.taskListener != null) {
                    this.taskListener.taskFinished(task);
                }
                return bl;
            }
        }
    }
}

