/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BVersion;
import com.tridium.install.InstallableCandidates;
import com.tridium.install.InstallableFilter;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.PartSpec;
import com.tridium.install.SignedDistFilter;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.BogFileFileTransferElement;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.GetDhcpdMessage;
import com.tridium.platform.daemon.message.GetLinkCfgMessage;
import com.tridium.platform.daemon.message.StopDialupMessage;
import com.tridium.platform.daemon.message.UpdateModuleContentMessage;
import com.tridium.platform.daemon.message.UpdateRuntimeProfilesEnabledMessage;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.util.MapUtil;
import com.tridium.util.graph.Digraph;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class InstallScenario {
    private final List<BInstallable> toInstall;
    private final Set<String> modulesToUninstall;
    private final BDaemonPlatform targetPlatform;
    private final HostState endStateFixed;
    private final HostState endStateMutable;
    private final InstallableCandidates candidates;
    private final SolutionParameters solutionParams;
    private final List<BInstallable> excludedInstallables;
    private final Map<BModuleInstallable, List<ModuleSignatureStatusEnum>> signatureFailures;
    private final CertificateChainValidator certValidator;
    private final JarSignatureRegistry signatureRegistry;
    private ModuleVerificationMode verificationMode;
    private Map<PartSpec, BPartInstallStatus> statusByPartSpec = null;
    private BModuleContent newModuleContent;
    private Set<RuntimeProfile> newEnabledRuntimeProfiles;
    private BTcpIpHostSettings tcpIpChanges;
    private BTimeZone newOsTimeZone;
    private long processingFlags = 0L;
    private boolean isSolved = false;
    private int nStandalone;
    private final InstallableRegistry registry;
    private boolean ignoreDhcpdTransfer = false;
    private boolean ignoreLinkTransfer = false;
    public static BDependency BAJA_3_5 = new BDependency("baja", new BVersion("3.5"), BModulePart.TYPE.getTypeSpec());
    public static BDependency NRE_3_7 = new BDependency("*", new BVersion("3.7"), BNrePart.TYPE.getTypeSpec());
    public static BDependency PLATDIALUP_3_7 = new BDependency("platDialup", new BVersion("3.7"), BModulePart.TYPE.getTypeSpec());
    private static final Logger LOGGER = Logger.getLogger("platform.install");
    public static final Version VERSION_4 = new Version("4.0");

    public InstallScenario(BDaemonPlatform targetPlatform, DaemonSessionTaskListener listener, String[] modulesToUninstall, BDependency[] dependencies, BInstallable[] toInstall, InstallableRegistry registry, CertificateChainValidator certValidator) throws Exception {
        this(targetPlatform, modulesToUninstall, dependencies, toInstall, BTimeZone.NULL, null, null, null, new SolutionParameters(listener), registry, certValidator);
    }

    public InstallScenario(BDaemonPlatform targetPlatform, String[] modulesToUninstall, BDependency[] dependencies, BInstallable[] toInstall, BTimeZone newOsTimeZone, BTcpIpHostSettings tcpIpChanges, BModuleContent newModuleContent, Set<RuntimeProfile> newEnabledRuntimeProfiles, SolutionParameters solutionParams, InstallableRegistry registry, CertificateChainValidator certValidator) throws Exception {
        int n;
        BModulePart bajaPart;
        BPart part;
        SlotCursor c;
        this.registry = registry;
        this.solutionParams = solutionParams;
        if (solutionParams == null) {
            throw new IllegalArgumentException("solutionParams may not be null");
        }
        this.targetPlatform = targetPlatform;
        this.newOsTimeZone = newOsTimeZone == null ? BTimeZone.NULL : newOsTimeZone;
        this.tcpIpChanges = tcpIpChanges;
        this.newModuleContent = newModuleContent;
        if (targetPlatform == null) {
            this.newEnabledRuntimeProfiles = newEnabledRuntimeProfiles == null ? new TreeSet<RuntimeProfile>(Arrays.asList(RuntimeProfile.values())) : newEnabledRuntimeProfiles;
        } else {
            targetPlatform.checkSession(solutionParams.listener);
            targetPlatform.getModuleList().init(solutionParams.listener);
            this.newEnabledRuntimeProfiles = newEnabledRuntimeProfiles == null ? new TreeSet<RuntimeProfile>(targetPlatform.getEnabledRuntimeProfiles()) : newEnabledRuntimeProfiles;
            if (newModuleContent != null && newModuleContent != targetPlatform.getModuleContent()) {
                this.processingFlags |= 0x100000L;
            }
            if (newEnabledRuntimeProfiles != null && !MapUtil.compare(newEnabledRuntimeProfiles, targetPlatform.getEnabledRuntimeProfiles()).matchesExactly()) {
                this.processingFlags |= 0x400000L;
            }
        }
        this.endStateFixed = new HostState();
        if (targetPlatform != null) {
            if (!targetPlatform.getOsPart().isInstallable()) {
                this.endStateFixed.add(targetPlatform.getOsPart());
            }
            this.endStateFixed.add(targetPlatform.getArchPart());
            this.endStateFixed.add(targetPlatform.getBrandPart());
            this.endStateFixed.add(targetPlatform.getModelPart());
            c = targetPlatform.getOtherParts().getProperties();
            while (c.next(BPart.class)) {
                part = (BPart)c.get();
                if (part.isInstallable()) continue;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Adding uninstallable generic part " + (Object)((Object)part) + " to fixed end state for scenario");
                }
                this.endStateFixed.add((BPart)c.get());
            }
        }
        this.endStateMutable = new HostState();
        if (targetPlatform != null) {
            if (targetPlatform.getOsPart().isInstallable()) {
                this.endStateMutable.add(targetPlatform.getOsPart());
            }
            this.endStateMutable.add(targetPlatform.getNrePart());
            this.endStateMutable.add(targetPlatform.getVmPart());
            c = targetPlatform.getOtherParts().getProperties();
            while (c.next(BPart.class)) {
                part = (BPart)c.get();
                if (!part.isInstallable()) continue;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Adding installable generic part " + (Object)((Object)part) + " to mutable end state for scenario");
                }
                this.endStateMutable.add((BPart)c.get());
            }
            c = targetPlatform.getModuleList().getModules().getProperties();
            while (c.next(BModuleInstallable.class)) {
                this.endStateMutable.add((BModuleInstallable)c.get());
            }
        }
        if (certValidator == null) {
            String[] provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
            CoreCryptoManager cryptoManager = CoreCryptoManager.get((ISecurityInfoProvider)provider);
            certValidator = CertificateChainValidator.make((ICoreCryptoManager)cryptoManager);
        }
        this.certValidator = certValidator;
        this.modulesToUninstall = new TreeSet<String>();
        if (modulesToUninstall != null) {
            for (String aModulesToUninstall : modulesToUninstall) {
                this.processingFlags |= 2L;
                this.endStateMutable.remove(aModulesToUninstall);
                this.modulesToUninstall.add(aModulesToUninstall);
            }
        }
        ArrayList<BDependency> unresolvedDeps = new ArrayList<BDependency>();
        if (dependencies != null) {
            Collections.addAll(unresolvedDeps, dependencies);
        }
        BVersion bajaVersion = BVersion.ZERO;
        if (toInstall != null) {
            for (BInstallable installable : toInstall) {
                if (!(installable instanceof BModuleInstallable) || !((BModuleInstallable)installable).getModulePart().getPartName().equals("baja")) continue;
                bajaVersion = installable.getVersion();
            }
        }
        if (targetPlatform != null && bajaVersion.equivalent((Object)BVersion.ZERO) && (bajaPart = (BModulePart)targetPlatform.getModuleList().getPart("baja")) != null) {
            bajaVersion = bajaPart.getVersion();
        }
        ModuleVerificationMode preferredVerificationMode = targetPlatform != null ? ModuleVerificationMode.valueOf((String)targetPlatform.getPreferredVerificationMode()) : ModuleVerificationMode.noPreference;
        this.verificationMode = bajaVersion.equivalent((Object)BVersion.ZERO) ? ModuleVerificationMode.max((ModuleVerificationMode)preferredVerificationMode, (ModuleVerificationMode)ModuleVerificationMode.DEFAULT) : ModuleVerificationMode.make((ModuleVerificationMode)preferredVerificationMode, (com.tridium.nre.util.Version)new com.tridium.nre.util.Version(bajaVersion.getVendorVersionString()));
        if (AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.commissioning.ignoreVerificationMode")).booleanValue()) {
            this.verificationMode = ModuleVerificationMode.low;
        }
        File propertiesFile = BFileSystem.INSTANCE.pathToLocalFile(SystemFilePaths.getSwSignatures());
        this.signatureRegistry = JarSignatureRegistry.getInstance((File)propertiesFile);
        this.toInstall = new ArrayList<BInstallable>();
        this.excludedInstallables = new ArrayList<BInstallable>();
        this.signatureFailures = new HashMap<BModuleInstallable, List<ModuleSignatureStatusEnum>>();
        this.nStandalone = 0;
        if (toInstall != null) {
            BInstallable[] bInstallableArray = toInstall;
            int n2 = bInstallableArray.length;
            for (n = 0; n < n2; ++n) {
                BInstallable installable = bInstallableArray[n];
                if (this.shouldExclude(installable)) {
                    this.excludedInstallables.add(installable);
                    continue;
                }
                boolean signatureError = false;
                if (installable instanceof BModuleInstallable) {
                    List<ModuleSignatureStatusEnum> statuses = ((BModuleInstallable)installable).getModulePart().getSignatureStatus(certValidator);
                    for (ModuleSignatureStatusEnum status : statuses) {
                        if (status.isAcceptable(this.verificationMode)) continue;
                        signatureError = true;
                        this.signatureFailures.put((BModuleInstallable)installable, statuses);
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.fine(String.format("Unable to install module %s. Signature status %s is not acceptable for verification mode %s.", new Object[]{installable, status, this.verificationMode}));
                        break;
                    }
                }
                if (signatureError) continue;
                if (installable.getIsStandalone()) {
                    ++this.nStandalone;
                }
                this.toInstall.add(installable);
                long flags = installable.getProcessingFlags(targetPlatform, solutionParams.listener);
                if ((flags & 0x100000L) != 0L) {
                    this.newModuleContent = installable.getNewModuleContent();
                }
                if ((flags & 0x400000L) != 0L) {
                    this.newEnabledRuntimeProfiles = Arrays.stream(installable.getEnabledRuntimeProfileNames().split(",")).map(RuntimeProfile::valueOf).collect(Collectors.toSet());
                }
                if ((flags & 0x80000L) != 0L) {
                    BTcpIpHostSettings targetHostSettings = new BTcpIpHostSettings();
                    TcpUtil.loadFromSession(targetHostSettings, targetPlatform.getDaemonSession());
                    if (installable.getTcpIpChanges() != null && !installable.getTcpIpChanges().getIsReadonly() && !targetHostSettings.getIsReadonly()) {
                        this.tcpIpChanges = installable.getTcpIpChanges();
                    }
                }
                if ((flags & 0x200000L) != 0L) {
                    this.newOsTimeZone = installable.getNewOsTimeZone();
                }
                if ((flags & 4L) != 0L && (flags & 2L) == 0L && (this.processingFlags & 2L) == 0L && !targetPlatform.meets(BAJA_3_5)) {
                    flags |= 2L;
                }
                this.processingFlags |= flags;
                this.endStateMutable.add(installable);
                this.registerLocalInstallables(installable);
                Collections.addAll(unresolvedDeps, installable.getAllDependencies());
                if (!(installable instanceof BModuleInstallable)) continue;
                unresolvedDeps.addAll(((BModuleInstallable)installable).getModulePart().dependenciesForRelatedParts(this.newEnabledRuntimeProfiles));
            }
        }
        if ((this.processingFlags & 0x100000L) != 0L) {
            BModulePart[] bModulePartArray = this.endStateMutable.getModules();
            int n3 = bModulePartArray.length;
            for (n = 0; n < n3; ++n) {
                BModulePart module = bModulePartArray[n];
                if (this.newModuleContent.getOrdinal() <= module.getArchiveContent().getOrdinal()) continue;
                unresolvedDeps.add(BDependency.forPart(module));
                this.endStateMutable.remove(module);
            }
        }
        if ((this.processingFlags & 0x400000L) != 0L) {
            for (BModulePart module : this.endStateMutable.getModules()) {
                unresolvedDeps.addAll(module.dependenciesForRelatedParts(this.newEnabledRuntimeProfiles));
            }
        }
        BDependency[] toMerge = unresolvedDeps.toArray(new BDependency[0]);
        unresolvedDeps = new ArrayList();
        Collections.addAll(unresolvedDeps, BDependency.merge(toMerge));
        if (targetPlatform == null || !targetPlatform.getIsNpsdk()) {
            for (BDependency dep : unresolvedDeps) {
                if (!dep.getPartType().is(BOsPart.TYPE) || !dep.getVersion().meetsVersionRequirement(new BVersion("4.4"), BVersionRelation.minimum)) continue;
                solutionParams.addFilter(new SignedDistFilter());
                break;
            }
        }
        this.candidates = new InstallableCandidates();
        for (BDependency dep : unresolvedDeps) {
            if (this.endStateFixed.meets(dep) || this.endStateMutable.meets(dep)) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("No parts in either fixed or mutable end state can meet dependency '" + (Object)((Object)dep) + "', looking for additional candidates");
            }
            this.addCandidates(dep);
        }
        this.traceState("Initial state");
    }

    protected InstallScenario(BDaemonPlatform targetPlatform, List<BInstallable> toInstall, List<BInstallable> excludedInstallables, Map<BModuleInstallable, List<ModuleSignatureStatusEnum>> signatureFailures, Set<String> modulesToUninstall, HostState endStateFixed, HostState endStateMutable, InstallableCandidates candidates, BModuleContent newModuleContent, Set<RuntimeProfile> newEnabledRuntimeProfiles, BTcpIpHostSettings tcpIpChanges, BTimeZone newOsTimeZone, long processingFlags, SolutionParameters solutionParams, InstallableRegistry registry, JarSignatureRegistry signatureRegistry, CertificateChainValidator certValidator, ModuleVerificationMode verificationMode) {
        this.targetPlatform = targetPlatform;
        this.toInstall = toInstall;
        this.excludedInstallables = excludedInstallables;
        this.signatureFailures = signatureFailures;
        this.modulesToUninstall = modulesToUninstall;
        this.endStateFixed = endStateFixed;
        this.endStateMutable = endStateMutable;
        this.candidates = candidates;
        this.registry = registry;
        this.newModuleContent = newModuleContent;
        this.newEnabledRuntimeProfiles = new TreeSet<RuntimeProfile>(newEnabledRuntimeProfiles);
        this.tcpIpChanges = tcpIpChanges;
        this.solutionParams = solutionParams;
        this.newOsTimeZone = newOsTimeZone == null ? BTimeZone.NULL : newOsTimeZone;
        this.processingFlags = processingFlags;
        this.nStandalone = (int)toInstall.stream().filter(BInstallable::getIsStandalone).count();
        this.signatureRegistry = signatureRegistry;
        this.certValidator = certValidator;
        this.verificationMode = verificationMode;
    }

    protected InstallScenario copy() {
        InstallableCandidates newCandidates = this.candidates.newCopy();
        TreeSet<String> newModulesToUninstall = new TreeSet<String>(this.modulesToUninstall);
        return new InstallScenario(this.targetPlatform, new ArrayList<BInstallable>(this.toInstall), new ArrayList<BInstallable>(this.excludedInstallables), new HashMap<BModuleInstallable, List<ModuleSignatureStatusEnum>>(this.signatureFailures), newModulesToUninstall, this.endStateFixed, this.endStateMutable.copy(), newCandidates, this.newModuleContent, this.newEnabledRuntimeProfiles, this.tcpIpChanges, this.newOsTimeZone, this.processingFlags, this.solutionParams, this.registry, this.signatureRegistry, this.certValidator, this.verificationMode);
    }

    public boolean hasChanges() {
        return this.toInstall.size() > 0 || this.modulesToUninstall.size() > 0 || this.newModuleContent != null || this.newEnabledRuntimeProfiles != null || this.tcpIpChanges != null || (this.processingFlags & 0x200000L) != 0L || !this.newOsTimeZone.isNull();
    }

    public BInstallable[] getToInstall() {
        return this.toInstall.toArray(new BInstallable[0]);
    }

    public String[] getModulesToUninstall() {
        return this.modulesToUninstall.toArray(new String[0]);
    }

    public InstallableCandidates getInstallableCandidates() {
        return this.candidates;
    }

    public BDependency[] getUnmetDependencies() {
        return this.candidates.getDependencies();
    }

    public UnmeetableDependency[] getUnmeetableDependencies() {
        return this.candidates.getUnmeetableDependencies(this);
    }

    public BDependency getFailedExclusion(BDependency unmeetableDep) {
        return this.candidates.getFailedExclusion(unmeetableDep, this);
    }

    public InstallableFilter getFailedFilter(BDependency unmeetableDep) {
        return this.candidates.getFailedFilter(unmeetableDep, this);
    }

    public boolean installableNotFound(BDependency unmeetableDep) {
        return this.candidates.installableNotFound(unmeetableDep, this);
    }

    public boolean isDependencyUnsolvable(BDependency unmeetableDep) {
        return this.candidates.isDependencyUnsolvable(unmeetableDep, this);
    }

    public BInstallable[] getExcludedInstallables() {
        return this.excludedInstallables.toArray(new BInstallable[0]);
    }

    public Map<BModuleInstallable, List<ModuleSignatureStatusEnum>> getSignatureFailures() {
        return this.signatureFailures;
    }

    public BPart[] getParts() {
        ArrayList result = new ArrayList();
        Collections.addAll(result, this.endStateFixed.getParts());
        Collections.addAll(result, this.endStateMutable.getParts());
        return result.toArray(new BPart[0]);
    }

    public BModuleContent getNewModuleContent() {
        return this.newModuleContent;
    }

    public Set<RuntimeProfile> getNewEnabledRuntimeProfiles() {
        return this.newEnabledRuntimeProfiles;
    }

    public BTcpIpHostSettings getTcpIpChanges() {
        return this.tcpIpChanges;
    }

    public BTimeZone getNewOsTimeZone() {
        return this.newOsTimeZone;
    }

    public long getProcessingFlags() {
        return this.processingFlags;
    }

    public BDaemonPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public BPartInstallStatus getPartStatus(BPart part) {
        return this.getPartStatus(part.getPartName(), part.getType().getTypeSpec());
    }

    public synchronized BPartInstallStatus getPartStatus(String partName, BTypeSpec partType) {
        BPartInstallStatus result;
        if (this.candidates.size() > 0) {
            throw new IllegalStateException("Attempt to get part status from scenario with unmet dependencies");
        }
        if (this.excludedInstallables.size() > 0) {
            throw new IllegalStateException("Attempt to get part status from scenario with excluded installables");
        }
        PartSpec spec = new PartSpec(partName, partType);
        if (this.statusByPartSpec == null) {
            this.statusByPartSpec = new HashMap<PartSpec, BPartInstallStatus>();
            for (String uninstallPartName : this.modulesToUninstall) {
                this.statusByPartSpec.put(PartSpec.forModule(uninstallPartName), BPartInstallStatus.uninstall);
            }
            for (BInstallable inst : this.toInstall) {
                BPart installPart = inst.getPart();
                if (installPart == null) continue;
                BPart currentPart = this.targetPlatform.getPart(installPart);
                if (currentPart == null) {
                    this.statusByPartSpec.put(installPart.getPartSpec(), BPartInstallStatus.install);
                    continue;
                }
                BVersion currentVersion = currentPart.getVersion();
                BVersion installVersion = installPart.getVersion();
                switch (currentVersion.checkVersionRequirement(installVersion)) {
                    case 2: {
                        if (currentPart instanceof BModulePart) {
                            BModulePart currentModule = (BModulePart)currentPart;
                            BModulePart installModule = (BModulePart)installPart;
                            if (currentModule.getBuildAbsTime() != null && installModule.getBuildAbsTime() != null) {
                                int dateComp = installModule.getBuildAbsTime().compareTo((Object)currentModule.getBuildAbsTime());
                                if (dateComp > 0) {
                                    this.statusByPartSpec.put(installPart.getPartSpec(), BPartInstallStatus.upgrade);
                                    break;
                                }
                                if (dateComp < 0) {
                                    this.statusByPartSpec.put(installPart.getPartSpec(), BPartInstallStatus.downgrade);
                                    break;
                                }
                                this.statusByPartSpec.put(installPart.getPartSpec(), BPartInstallStatus.reinstall);
                                break;
                            }
                            this.statusByPartSpec.put(installPart.getPartSpec(), BPartInstallStatus.reinstall);
                            break;
                        }
                        this.statusByPartSpec.put(installPart.getPartSpec(), BPartInstallStatus.reinstall);
                        break;
                    }
                    case 8: 
                    case 16: {
                        this.statusByPartSpec.put(installPart.getPartSpec(), BPartInstallStatus.reinstall);
                        break;
                    }
                    case 4: {
                        this.statusByPartSpec.put(installPart.getPartSpec(), BPartInstallStatus.upgrade);
                        break;
                    }
                    default: {
                        this.statusByPartSpec.put(installPart.getPartSpec(), BPartInstallStatus.downgrade);
                    }
                }
            }
        }
        if ((result = this.statusByPartSpec.get(spec)) == null) {
            BPart currentPart = this.targetPlatform.getPart(partName, partType);
            result = currentPart == null ? BPartInstallStatus.notFound : BPartInstallStatus.noChange;
            this.statusByPartSpec.put(spec, result);
        }
        return result;
    }

    public static InstallScenario solve(BDaemonPlatform targetPlatform, DaemonSessionTaskListener listener, String[] modulesToUninstall, BDependency[] dependencies, BInstallable[] toInstall, Set<RuntimeProfile> newEnabledRuntimeProfiles, InstallableRegistry registry, CertificateChainValidator certValidator) throws Exception {
        return InstallScenario.solve(targetPlatform, modulesToUninstall, dependencies, toInstall, new SolutionParameters(listener), newEnabledRuntimeProfiles, registry, certValidator);
    }

    public static InstallScenario solve(BDaemonPlatform targetPlatform, String[] modulesToUninstall, BDependency[] dependencies, BInstallable[] toInstall, SolutionParameters solutionParams, Set<RuntimeProfile> newEnabledRuntimeProfiles, InstallableRegistry registry, CertificateChainValidator certValidator) throws Exception {
        return new InstallScenario(targetPlatform, modulesToUninstall, dependencies, toInstall, BTimeZone.NULL, null, null, newEnabledRuntimeProfiles, solutionParams, registry, certValidator).solve();
    }

    public InstallScenario solve() throws Exception {
        if (this.isSolved) {
            this.traceState("Already solved");
            return this;
        }
        if (!MapUtil.compare(this.newEnabledRuntimeProfiles, this.getTargetPlatform().getEnabledRuntimeProfiles()).matchesExactly()) {
            HashSet<BModulePart> removeFromESM = new HashSet<BModulePart>();
            ArrayList<BDependency> newDeps = new ArrayList<BDependency>();
            BModulePart[] bModulePartArray = this.endStateMutable.getModules();
            int n = bModulePartArray.length;
            for (int i = 0; i < n; ++i) {
                BModulePart module = bModulePartArray[i];
                if (module.getRuntimeProfile() == null) {
                    LOGGER.warning(String.format("Unexpected runtime profile '%s' in module '%s'", module.getRuntimeProfileString(), module.getPartName()));
                    continue;
                }
                if (this.newEnabledRuntimeProfiles.contains(module.getRuntimeProfile())) {
                    SlotCursor c = module.getRelatedModulePartNames().getProperties();
                    while (c.next()) {
                        BDependency modulePartDep;
                        if (!this.newEnabledRuntimeProfiles.contains(RuntimeProfile.valueOf((String)c.property().getName())) || this.endStateMutable.meets(modulePartDep = BDependency.forModule(c.get().toString()))) continue;
                        newDeps.add(modulePartDep);
                    }
                    continue;
                }
                boolean removed = false;
                for (BInstallable inst : this.toInstall) {
                    if (!(inst instanceof BModuleInstallable) || !inst.getPart().getName().equals(module.getPartName())) continue;
                    this.toInstall.remove(inst);
                    removed = true;
                    break;
                }
                if (!removed) {
                    this.modulesToUninstall.add(module.getPartName());
                }
                removeFromESM.add(module);
            }
            removeFromESM.forEach(this.endStateMutable::remove);
            this.mergeDeps(newDeps);
        }
        if (this.candidates.size() == 0) {
            if (this.modulesToUninstall.size() == 0) {
                Object result;
                BPart platDialup;
                this.isSolved = true;
                this.traceState("Complete solution");
                if (!this.getTargetPlatform().meets(NRE_3_7) && this.endStateMutable.meets(NRE_3_7) && !this.endStateMutable.meets(PLATDIALUP_3_7) && (platDialup = this.getTargetPlatform().getModuleList().getPart("platDialup")) != null && ((InstallScenario)(result = this.solve(this.solutionParams.listener, null, new BDependency[]{PLATDIALUP_3_7}, null, this.registry))).canCommit()) {
                    return result;
                }
                return this;
            }
            BModulePart[] modules = this.endStateMutable.getModules();
            block3: for (BModulePart module : modules) {
                BInstallable inst = this.registry.findInstallable(BDependency.forPart(module, BVersionRelation.exact), null);
                if (inst == null) {
                    inst = this.registry.findInstallable(BDependency.forModule(module.getPartName()), this.solutionParams.listener);
                }
                if (inst == null) continue;
                for (BDependency instDep : inst.getAllDependencies()) {
                    if (!instDep.getPartTypeSpec().equals((Object)BModulePart.TYPE.getTypeSpec()) || !this.modulesToUninstall.contains(instDep.getPartName())) continue;
                    this.addCandidates(instDep);
                    continue block3;
                }
            }
            if (this.candidates.size() > 0) {
                this.traceState("Uninstalls break dependencies");
            } else {
                this.processingFlags |= 2L;
                this.traceState("Complete solution");
            }
            this.isSolved = true;
            return this;
        }
        Object candidateKey = this.candidates.getFirstKey();
        BInstallable[] installables = this.candidates.getCandidates(candidateKey);
        if (installables.length == 0) {
            this.traceState("Incomplete solution");
            this.isSolved = true;
            return this;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("At least 1 candidate for " + candidateKey);
        }
        InstallScenario bestResult = null;
        for (int ixCandidate = 0; ixCandidate < installables.length; ++ixCandidate) {
            BInstallable candidate = installables[ixCandidate];
            InstallScenario result = this.copy();
            result.install(candidate, candidateKey);
            result = result.solve();
            if (result.candidates.size() == 0) {
                return result;
            }
            if (bestResult == null || result.candidates.size() < bestResult.candidates.size()) {
                if (bestResult == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(candidateKey + " candidate " + ixCandidate + ": " + candidate.getInstallableFileName() + " is first result considered");
                    }
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(candidateKey + " candidate " + ixCandidate + ": " + candidate.getInstallableFileName() + " beats best result");
                }
                bestResult = result;
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine(candidateKey + " candidate " + ixCandidate + ": " + candidate.getInstallableFileName() + " isn't as good as best result, discarding");
        }
        this.isSolved = true;
        return bestResult;
    }

    public boolean isSolved() {
        return this.isSolved;
    }

    public InstallableRegistry getInstallableRegistry() {
        return this.registry;
    }

    public CertificateChainValidator getCertValidator() {
        return this.certValidator;
    }

    public ModuleVerificationMode getVerificationMode() {
        return this.verificationMode;
    }

    public InstallScenario solve(DaemonSessionTaskListener listener, String[] moreModulesToUninstall, BDependency[] moreDependencies, BInstallable[] moreToInstall, InstallableRegistry registry) throws Exception {
        if (this.excludedInstallables.size() > 0) {
            throw new IllegalStateException("Some installables are excluded");
        }
        ArrayList modulesToUninstall = new ArrayList();
        Collections.addAll(modulesToUninstall, this.getModulesToUninstall());
        if (moreModulesToUninstall != null) {
            Collections.addAll(modulesToUninstall, moreModulesToUninstall);
        }
        ArrayList dependencies = new ArrayList();
        Collections.addAll(dependencies, this.getUnmetDependencies());
        if (moreDependencies != null) {
            Collections.addAll(dependencies, moreDependencies);
        }
        ArrayList toInstall = new ArrayList();
        Collections.addAll(toInstall, this.getToInstall());
        if (moreToInstall != null) {
            Collections.addAll(toInstall, moreToInstall);
        }
        return new InstallScenario(this.getTargetPlatform(), modulesToUninstall.toArray(new String[0]), dependencies.toArray(new BDependency[0]), toInstall.toArray(new BInstallable[0]), this.getNewOsTimeZone(), this.getTcpIpChanges(), this.getNewModuleContent(), this.getNewEnabledRuntimeProfiles(), this.solutionParams, registry, this.getCertValidator()).solve();
    }

    public boolean canCommit() {
        return this.candidates.size() == 0 && this.excludedInstallables.size() == 0 && this.targetPlatform != null && (this.nStandalone == 0 || this.nStandalone == 1 && this.toInstall.size() == 1);
    }

    public void commit(DaemonSessionTaskListener taskListener, ICancelHint cancelHint, boolean stripAuthChanges) throws Exception {
        this.commit(taskListener, new StoreCache(), cancelHint, stripAuthChanges, Optional.empty());
    }

    public void commit(DaemonSessionTaskListener taskListener, ICancelHint cancelHint) throws Exception {
        this.commit(taskListener, new StoreCache(), cancelHint, false, Optional.empty());
    }

    public void commit(DaemonSessionTaskListener taskListener, StoreCache cache, ICancelHint cancelHint) throws Exception {
        this.commit(taskListener, cache, cancelHint, false, Optional.empty());
    }

    public void commit(DaemonSessionTaskListener taskListener, StoreCache cache, ICancelHint cancelHint, boolean stripAuthChanges) throws Exception {
        this.commit(taskListener, cache, cancelHint, stripAuthChanges, Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(DaemonSessionTaskListener taskListener, StoreCache cache, ICancelHint cancelHint, boolean stripAuthChanges, Optional<Consumer<FileTransferMessage>> fileTransferInitializer) throws Exception {
        if (this.candidates.size() > 0) {
            throw new IllegalStateException("Cannot commit a scenario having unmet dependencies");
        }
        if (this.excludedInstallables.size() > 0) {
            throw new IllegalStateException("Cannot commit a scenario having excluded installables");
        }
        if (this.targetPlatform == null) {
            throw new IllegalStateException("Cannot commit a scenario having no target platform");
        }
        if (this.nStandalone > 2 || this.nStandalone == 1 && this.toInstall.size() > 1) {
            throw new IllegalStateException("Cannot commit a scenario having a standalone installable with any other installables");
        }
        if (taskListener == null) {
            taskListener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
        }
        if ((this.processingFlags & 0x200000L) != 0L) {
            DaemonSessionTask task = new DaemonSessionTask(Lexicon.make((String)"platform"), "InstallManifest.newOsTimeZone.title", "InstallManifest.newOsTimeZone.message", new Object[]{this.getNewOsTimeZone()});
            taskListener.taskStarted(task);
            try {
                BHostProperties hostProperties = this.targetPlatform.getDaemonSession().getHostProperties();
                boolean isNiagara4 = hostProperties.isNiagara4();
                BDstSupportLevel tzSupport = hostProperties.getTimezoneDayModeSupport();
                BTimeZone compatibleZone = TimeZoneUtil.makeCompatible(this.getNewOsTimeZone(), tzSupport);
                this.targetPlatform.getDaemonSession().sendMessage(new UpdateTimeMessage(null, null, compatibleZone, !isNiagara4));
            }
            finally {
                taskListener.taskFinished(task);
            }
        }
        if (!this.targetPlatform.meets(NRE_3_7) && this.endStateMutable.meets(NRE_3_7) && this.targetPlatform.getDaemonSession().getHostProperties().supportsServlet("dialup")) {
            this.targetPlatform.getDaemonSession().sendMessage(new StopDialupMessage());
        }
        if (cache == null) {
            cache = new StoreCache();
        }
        FileTransferMessage msg = new FileTransferMessage(false, cache, this.targetPlatform.getDaemonSession().getFileSpace());
        fileTransferInitializer.ifPresent(fileTransferMessageConsumer -> fileTransferMessageConsumer.accept(msg));
        if ((this.processingFlags & 0x100000L) != 0L && !this.targetPlatform.getIsNiagara4() && this.getNewModuleContent() != null) {
            DaemonSessionTask task = new DaemonSessionTask(Lexicon.make((String)"platform"), "InstallManifest.newModuleContent.title", "InstallManifest.newModuleContent.message", new Object[]{this.getNewModuleContent()});
            taskListener.taskStarted(task);
            try {
                this.targetPlatform.getDaemonSession().sendMessage(new UpdateModuleContentMessage(this.getNewModuleContent()));
                this.targetPlatform.setModuleContent(this.getNewModuleContent());
            }
            finally {
                taskListener.taskFinished(task);
            }
        }
        if ((this.processingFlags & 0x400000L) != 0L && this.targetPlatform.getIsNiagara4() && this.getNewEnabledRuntimeProfiles() != null) {
            String commaDelimited = this.getNewEnabledRuntimeProfiles().stream().map(Enum::name).collect(Collectors.joining(","));
            DaemonSessionTask task = new DaemonSessionTask(Lexicon.make((String)"platform"), "InstallManifest.newRuntimeProfiles.title", "InstallManifest.newRuntimeProfiles.message", new Object[]{commaDelimited});
            taskListener.taskStarted(task);
            try {
                this.targetPlatform.getDaemonSession().sendMessage(new UpdateRuntimeProfilesEnabledMessage(commaDelimited));
                this.targetPlatform.getDaemonSession().getHostProperties().setEnabledRuntimeProfileNames(commaDelimited);
                this.targetPlatform.setEnabledRuntimeProfileNames(commaDelimited);
            }
            finally {
                taskListener.taskFinished(task);
            }
        }
        BDaemonSession daemonSession = this.targetPlatform.getDaemonSession();
        BHostProperties hostProperties = daemonSession.getHostProperties();
        HashSet<String> filePathsToIgnore = new HashSet<String>();
        if (this.ignoreDhcpdTransfer && hostProperties.supportsServlet("dhcpd")) {
            XElem dhcpdXmlSettingsElem = XParser.make((InputStream)daemonSession.getInputStream(new GetDhcpdMessage())).parse();
            filePathsToIgnore.add(dhcpdXmlSettingsElem.get("conf_file_path", ""));
            filePathsToIgnore.add(dhcpdXmlSettingsElem.get("adapters_list_file_path", ""));
            filePathsToIgnore.add(dhcpdXmlSettingsElem.get("lease_file_path", ""));
        }
        if (this.ignoreLinkTransfer && hostProperties.supportsServlet("linkcfg")) {
            XElem linkXmlSettingsElem = XParser.make((InputStream)daemonSession.getInputStream(new GetLinkCfgMessage())).parse();
            filePathsToIgnore.add(linkXmlSettingsElem.get("link_file_path", ""));
        }
        for (String filePathToIgnore : filePathsToIgnore) {
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Ignoring any transfer elements that match path '" + filePathToIgnore + "'");
        }
        for (BInstallable installable : this.toInstall) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting transfer elements for " + installable.getInstallableName());
            }
            FileTransferMessageElement[] elements = installable.getTransferElements(this.targetPlatform, cache, cancelHint, taskListener);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Adding transfer elements for " + installable.getInstallableName());
            }
            for (FileTransferMessageElement element : elements) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Checking transfer element '" + element + "' for fixed handling conditions");
                }
                if (stripAuthChanges && element.getRequestMethod().equals("POST") && (element.getFilePath().getBody().equals("~daemon/daemon.properties") || element.getFilePath().getBody().equals("/niagara/daemon/daemon.properties"))) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Striping relevant authentication changes from file transfer element '" + element + "'");
                    }
                    msg.addElement(this.revertAuthProperties(element, this.targetPlatform));
                    continue;
                }
                if (element.getRequestMethod().equals("POST") && filePathsToIgnore.contains(element.getFilePath().getBody())) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Explicitly ignoring file transfer element '" + element + "'");
                    continue;
                }
                if (element instanceof BogFileFileTransferElement) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Handling passwords for BOG file transfer element '" + element + "'");
                    }
                    ((BogFileFileTransferElement)element).handlePasswords(msg.getPBEEncodingInfo());
                    msg.addElement(element);
                    continue;
                }
                msg.addElement(element);
            }
        }
        for (String moduleToUninstall : this.modulesToUninstall) {
            BModulePart part = (BModulePart)this.targetPlatform.getPart(moduleToUninstall, BModulePart.TYPE.getTypeSpec(), taskListener);
            if (part == null) continue;
            msg.addElement(new DeleteFileTransferMessageElement(part.getDestinationPath(this.targetPlatform.getIsNiagaraHomeReadonly()), this.targetPlatform.getDaemonSession().getFileSpace()));
        }
        LOGGER.fine("Starting file transfer");
        boolean transferComplete = DaemonFileUtil.transfer(this.targetPlatform.getDaemonSession(), msg, cancelHint, taskListener);
        for (BInstallable inst : this.toInstall) {
            inst.close();
        }
        if (!transferComplete) {
            throw new BajaRuntimeException("transfer failed");
        }
        this.targetPlatform.getModuleList().reset();
    }

    public static InstallScenario upgradeOutOfDate(InstallScenario scenario, InstallableRegistry registry) throws Exception {
        if (scenario.nStandalone > 0) {
            return scenario;
        }
        if (scenario.candidates.size() > 0) {
            throw new IllegalArgumentException("Scenario has unmet dependencies");
        }
        if (scenario.excludedInstallables.size() > 0) {
            throw new IllegalArgumentException("Scenario has excluded installables");
        }
        InstallScenario result = scenario;
        BDaemonPlatform platform = result.getTargetPlatform();
        platform.checkSession(scenario.getSolutionParameters().listener);
        HashMap<String, BModulePart> checkedModules = new HashMap<String, BModulePart>();
        for (String moduleToUninstall : result.getModulesToUninstall()) {
            checkedModules.put(moduleToUninstall, null);
        }
        for (BInstallable inst : result.getToInstall()) {
            BPart part = inst.getPart();
            if (!(part instanceof BModulePart)) continue;
            checkedModules.put(part.getPartName(), (BModulePart)part);
        }
        result = result.solve();
        platform.getModuleList().init(scenario.getSolutionParameters().listener);
        Digraph moduleGraph = new Digraph();
        SlotCursor c = platform.getModuleList().getModules().getProperties();
        while (c.next(BModuleInstallable.class)) {
            BModuleInstallable moduleInstallable = (BModuleInstallable)c.get();
            String partName = moduleInstallable.getModulePart().getPartName();
            if (!moduleGraph.hasVertex((Object)partName)) {
                moduleGraph.addVertex((Object)partName);
            }
            for (BDependency dep : moduleInstallable.getAllDependencies()) {
                if (!dep.getPartType().equals(BModulePart.TYPE)) continue;
                String depPartName = dep.getPartName();
                if (!moduleGraph.hasVertex((Object)depPartName)) {
                    moduleGraph.addVertex((Object)depPartName);
                }
                moduleGraph.addEdge((Object)depPartName, (Object)partName);
            }
        }
        for (Object moduleName : moduleGraph.topologicalSortList()) {
            BModuleInstallable moduleInstallable = platform.getModuleList().getModuleInstallable(moduleName.toString());
            if (moduleInstallable == null) continue;
            result = InstallScenario.checkModuleForUpgrades(result, moduleInstallable.getModulePart(), checkedModules, registry);
        }
        return result;
    }

    public static boolean listModule(InstallScenario scenario, BModuleInstallable moduleInst, Map<String, Set<Version>> rejected) {
        Set<Version> rejectedVersions;
        if (rejected.containsKey(moduleInst.getPart().getPartName()) && rejected.get(moduleInst.getPart().getPartName()).contains(moduleInst.getVersion().getVendorVersion())) {
            return false;
        }
        if (scenario.getTargetPlatform().getIsNiagara4()) {
            if (moduleInst.getModulePart().getRuntimeProfile() == null) {
                return false;
            }
            if (scenario.getNewEnabledRuntimeProfiles().contains(moduleInst.getModulePart().getRuntimeProfile()) && scenario.getNewEnabledRuntimeProfiles().contains(moduleInst.getModulePart().getRuntimeProfile())) {
                if (moduleInst.getModulePart().getPartName().equals("baja")) {
                    if (moduleInst.getVersion().getVendorVersion().compareTo(VERSION_4) >= 0) {
                        return true;
                    }
                } else {
                    for (BDependency dependency : moduleInst.getAllDependencies()) {
                        if (!dependency.getPartName().equals("baja")) continue;
                        if (dependency.getVersion() != null && dependency.getVersion().getVendorVersion() != null && dependency.getVersion().getVendorVersion().compareTo(VERSION_4) >= 0) {
                            return true;
                        }
                        break;
                    }
                }
            }
        } else if (moduleInst.getModulePart().getPartName().equals("baja")) {
            if (moduleInst.getVersion().getVendorVersion().compareTo(VERSION_4) < 0) {
                return true;
            }
        } else {
            boolean bajaFound = false;
            for (BDependency dependency : moduleInst.getAllDependencies()) {
                if (!dependency.getPartName().equals("baja")) continue;
                if (dependency.getVersion() == null || dependency.getVersion().getVendorVersion() == null || dependency.getVersion().getVendorVersion().compareTo(VERSION_4) < 0) {
                    return true;
                }
                bajaFound = true;
                break;
            }
            if (!bajaFound) {
                return true;
            }
        }
        if ((rejectedVersions = rejected.get(moduleInst.getPart().getPartName())) == null) {
            rejectedVersions = new HashSet<Version>();
            rejected.put(moduleInst.getPart().getPartName(), rejectedVersions);
        }
        rejectedVersions.add(moduleInst.getVersion().getVendorVersion());
        return false;
    }

    protected boolean addCandidates(BDependency dep) throws Exception {
        return this.addCandidates(dep, this.candidates);
    }

    protected boolean addCandidates(BDependency dep, InstallableCandidates depCandidates) throws Exception {
        if (depCandidates.containsKey((Object)dep)) {
            return depCandidates.getCandidates((Object)dep).length > 0;
        }
        depCandidates.addAll(this.solutionParams.getAdditionalCandidates(this, dep));
        ArrayList<BInstallable> newCandidates = new ArrayList<BInstallable>();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Install scenario looking for candidates to match dependency '" + (Object)((Object)dep) + "'...");
        }
        if (this.targetPlatform != null && this.targetPlatform.getIsSoftwareReadonly()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Install scenario can not meet dependency '" + (Object)((Object)dep) + "', target host software is readonly");
            }
            depCandidates.set((Object)dep, new BInstallable[0]);
            return false;
        }
        if (dep.canSolveWith(this.solutionParams.solvers) && this.registry != null && this.nStandalone == 0) {
            IterableCursor<BInstallable> cCandidate = this.registry.getInstallables(dep, this.solutionParams.listener);
            while (cCandidate.next()) {
                BModulePart modulePart;
                BInstallable candidate = (BInstallable)cCandidate.get();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Install scenario considering candidate installable '" + candidate + "' as a match for dependency '" + (Object)((Object)dep) + "'...");
                }
                if (dep.getPartTypeSpec().getTypeName().equals("ModulePart") && (modulePart = ((BModuleInstallable)candidate).getModulePart()).getManifestSchemaVersion() >= 4 && !this.getNewEnabledRuntimeProfiles().contains(modulePart.getRuntimeProfile())) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.finest("Install scenario discarding candidate installable '" + candidate + "' for dependency '" + (Object)((Object)dep) + "', runtime profile not supported");
                    continue;
                }
                if (candidate.getPart() == null) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.finest("Install scenario discarding candidate installable '" + candidate + "' for dependency '" + (Object)((Object)dep) + "', candidate contains no parts");
                    continue;
                }
                boolean partMismatch = false;
                if (!candidate.getPart().getType().is(dep.getPartType())) {
                    if (candidate.getPart().getType().is(BGenericPart.TYPE) && "tridium-qnx7-n4-titan-am335x-hs-maint".equals(candidate.getInstallableName()) && dep.getPartType().is(BOsPart.TYPE) && "tridium-qnx7-n4-titan-am335x*".equals(dep.getPartName())) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.finest("Install scenario discarding candidate installable '" + candidate + "' for dependency '" + (Object)((Object)dep) + "', part types do not match");
                        continue;
                    }
                    partMismatch = true;
                }
                if (this.shouldExclude(candidate)) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.finest("Install scenario discarding candidate installable '" + candidate + "' for dependency '" + (Object)((Object)dep) + "', candidate is excluded from scenario");
                    continue;
                }
                boolean wrongPlatform = false;
                for (BDependency candidateDep : candidate.getAllDependencies()) {
                    boolean isInstallable = true;
                    Type candidateDepPartType = candidateDep.getPartType();
                    if (candidateDepPartType == BArchPart.TYPE || candidateDepPartType == BModelPart.TYPE) {
                        isInstallable = false;
                    } else if (candidateDepPartType == BGenericPart.TYPE) {
                        BPart part = this.targetPlatform.getPart(candidateDep);
                        isInstallable = part != null && part.isInstallable();
                    } else if (candidateDepPartType == BOsPart.TYPE) {
                        isInstallable = this.targetPlatform.getOsPart().isInstallable();
                    }
                    if (isInstallable || this.targetPlatform.meets(candidateDep)) continue;
                    wrongPlatform = true;
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.fine(String.format("Install scenario unable to install candidate %s. Target platform %s does not meet requirements of candidate dependency %s", new Object[]{candidate, this.targetPlatform, candidateDep}));
                    break;
                }
                if (wrongPlatform) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.finest("Install scenario discarding candidate installable '" + candidate + "' for dependency '" + (Object)((Object)dep) + "', candidate dependency requires different platform");
                    continue;
                }
                if (!this.solutionParams.acceptInstallable(candidate)) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.finest("Install scenario discarding candidate installable '" + candidate + "' for dependency '" + (Object)((Object)dep) + "', solution parameters reject candidate");
                    continue;
                }
                if (candidate instanceof BModuleInstallable) {
                    List<ModuleSignatureStatusEnum> statuses = ((BModuleInstallable)candidate).getModulePart().getSignatureStatus(this.certValidator);
                    boolean failed = false;
                    for (ModuleSignatureStatusEnum status : statuses) {
                        if (status.isAcceptable(this.verificationMode)) continue;
                        failed = true;
                        this.signatureFailures.put((BModuleInstallable)candidate, statuses);
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.fine(String.format("Install scenario unable to install module %s. Signature status %s is not acceptable for verification mode %s", new Object[]{candidate, status, this.verificationMode}));
                        break;
                    }
                    if (failed) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.finest("Install scenario discarding candidate installable '" + candidate + "' for dependency '" + (Object)((Object)dep) + "', signature verification failed");
                        continue;
                    }
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Install scenario adding candidate installable '" + candidate + "' as a match to resolve dependency '" + (Object)((Object)dep) + "', all tests pass");
                }
                if (partMismatch) {
                    LOGGER.warning("Install scenario accepted candidate installable '" + candidate + "' for dependency '" + (Object)((Object)dep) + "' with mismatched part types (" + candidate.getPart().getType() + " != " + dep.getPartType() + ")");
                }
                newCandidates.add(candidate);
                if (!this.solutionParams.latestOnly) continue;
                if (!LOGGER.isLoggable(Level.FINEST)) break;
                LOGGER.finest("Install scenario solution parameters configured for latestOnly, skipping additional candidates for dependency '" + (Object)((Object)dep) + "'");
                break;
            }
        }
        depCandidates.set((Object)dep, newCandidates.toArray(new BInstallable[0]));
        return newCandidates.size() > 0;
    }

    private FileTransferMessageElement revertAuthProperties(FileTransferMessageElement elementIn, BDaemonPlatform platform) throws Exception {
        BIFile existingFile = platform.getDaemonSession().getFileSpace().findFile(elementIn.getFilePath());
        Properties newProps = new Properties();
        try (InputStream inputStream = elementIn.getStream();){
            newProps.load(inputStream);
        }
        boolean anyChanges = newProps.remove("authtype") != null;
        anyChanges = newProps.remove("user") != null || anyChanges;
        anyChanges = newProps.remove("usergroupid") != null || anyChanges;
        anyChanges = newProps.remove("admingroupid") != null || anyChanges;
        boolean bl = anyChanges = newProps.remove("password") != null || anyChanges;
        if (existingFile != null) {
            Properties existingProps = new Properties();
            try (InputStream inputStream = existingFile.getInputStream();){
                existingProps.load(inputStream);
            }
            if (existingProps.getProperty("authtype") != null) {
                anyChanges = true;
                newProps.setProperty("authtype", existingProps.getProperty("authtype"));
            }
            if (existingProps.getProperty("user") != null) {
                anyChanges = true;
                newProps.setProperty("user", existingProps.getProperty("user"));
            }
            if (existingProps.getProperty("usergroupid") != null) {
                anyChanges = true;
                newProps.setProperty("usergroupid", existingProps.getProperty("usergroupid"));
            }
            if (existingProps.getProperty("admingroupid") != null) {
                anyChanges = true;
                newProps.setProperty("admingroupid", existingProps.getProperty("admingroupid"));
            }
            if (existingProps.getProperty("password") != null) {
                anyChanges = true;
                newProps.setProperty("password", existingProps.getProperty("password"));
            }
        }
        if (anyChanges) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            newProps.store(out, null);
            out.flush();
            out.close();
            return new ByteArrayFileTransferElement(elementIn.getFilePath(), out.toByteArray(), platform.getDaemonSession().getFileSpace());
        }
        return elementIn;
    }

    protected void registerLocalInstallables(BInstallable inst) {
        if (this.registry == LocalInstallableRegistry.getInstance()) {
            try {
                inst.registerInstallableResources(this.solutionParams.listener);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to register local installable '" + inst + "'", e);
            }
        }
    }

    protected void install(BInstallable installable, Object metCandidateKey) throws Exception {
        long t0 = Clock.ticks();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("installing " + installable.getInstallableFileName() + " to meet " + metCandidateKey);
        }
        if (this.toInstall.contains(installable) && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.warning("InstallScenario toInstall already contained installable '" + installable + "', duplicate install detected");
        }
        ArrayList<BDependency> newDeps = new ArrayList<BDependency>();
        this.candidates.removeKey(metCandidateKey);
        this.toInstall.add(installable);
        this.endStateMutable.add(installable);
        this.registerLocalInstallables(installable);
        long flags = installable.getProcessingFlags(this.targetPlatform, this.solutionParams.listener);
        if ((flags & 0x80000L) != 0L && installable.getTcpIpChanges() != null && !installable.getTcpIpChanges().getIsReadonly()) {
            this.tcpIpChanges = installable.getTcpIpChanges();
        }
        if ((flags & 0x200000L) != 0L) {
            this.newOsTimeZone = installable.getNewOsTimeZone();
        }
        if ((flags & 0x400000L) != 0L) {
            this.newEnabledRuntimeProfiles = new HashSet<RuntimeProfile>();
            for (String profileName : installable.getEnabledRuntimeProfileNames().split(",")) {
                if (profileName.equals("")) continue;
                this.newEnabledRuntimeProfiles.add(RuntimeProfile.valueOf((String)profileName));
            }
            HashSet removeFromESM = new HashSet();
            BModulePart[] bModulePartArray = this.endStateMutable.getModules();
            int n = bModulePartArray.length;
            for (int profileName = 0; profileName < n; ++profileName) {
                BModulePart module = bModulePartArray[profileName];
                if (this.newEnabledRuntimeProfiles.contains(module.getRuntimeProfile())) {
                    SlotCursor c = module.getRelatedModulePartNames().getProperties();
                    while (c.next()) {
                        BDependency modulePartDep2;
                        if (!this.newEnabledRuntimeProfiles.contains(RuntimeProfile.valueOf((String)c.property().getName())) || this.endStateMutable.meets(modulePartDep2 = BDependency.forModule(c.get().toString()))) continue;
                        newDeps.add(modulePartDep2);
                    }
                    continue;
                }
                boolean removed = false;
                for (BInstallable inst : this.toInstall) {
                    if (!(inst instanceof BModuleInstallable) || !inst.getPart().getName().equals(module.getPartName())) continue;
                    this.toInstall.remove(inst);
                    removed = true;
                    break;
                }
                if (!removed) {
                    this.modulesToUninstall.add(module.getPartName());
                }
                removeFromESM.add(module);
            }
            removeFromESM.forEach(this.endStateMutable::remove);
        }
        if ((flags & 0x100000L) != 0L) {
            this.newModuleContent = installable.getNewModuleContent();
            for (BModulePart module : this.endStateMutable.getModules()) {
                if (this.newModuleContent.getOrdinal() <= module.getArchiveContent().getOrdinal()) continue;
                newDeps.add(BDependency.forPart(module));
                this.endStateMutable.remove(module);
            }
        }
        if ((flags & 4L) != 0L && (flags & 2L) == 0L && (this.processingFlags & 2L) == 0L && !this.targetPlatform.meets(BAJA_3_5)) {
            flags |= 2L;
        }
        this.processingFlags |= flags;
        if (installable instanceof BModuleInstallable) {
            BModulePart modulePart = ((BModuleInstallable)installable).getModulePart();
            this.modulesToUninstall.remove(modulePart.getPartName());
            Set<RuntimeProfile> checkProfiles = this.newEnabledRuntimeProfiles;
            if (checkProfiles == null) {
                checkProfiles = this.targetPlatform.getEnabledRuntimeProfiles();
            }
            newDeps.addAll(modulePart.dependenciesForRelatedParts(checkProfiles).stream().filter(modulePartDep -> !this.endStateMutable.meets((BDependency)((Object)modulePartDep))).collect(Collectors.toList()));
        }
        Collections.addAll(newDeps, installable.getAllDependencies());
        this.mergeDeps(newDeps);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("install exits " + (Clock.ticks() - t0) + "ms");
        }
    }

    private void mergeDeps(List<BDependency> newDeps) throws Exception {
        HashSet<BDependency> toRemove = new HashSet<BDependency>();
        InstallableCandidates toAdd = new InstallableCandidates();
        for (BDependency newDep : newDeps) {
            if (this.endStateFixed.meets(newDep) || this.endStateMutable.meets(newDep)) continue;
            boolean add = true;
            for (Object oldKey : this.candidates.getKeys()) {
                if (!(oldKey instanceof BDependency)) continue;
                BDependency oldDep = (BDependency)((Object)oldKey);
                BDependency.DependencySync s = BDependency.sync(oldDep, newDep);
                if (s == BDependency.DEP_SYNC_KEEP_SECOND) {
                    toRemove.add(oldDep);
                    break;
                }
                if (s == BDependency.DEP_SYNC_KEEP_FIRST) {
                    add = false;
                    break;
                }
                if (s == BDependency.DEP_SYNC_NO_CHANGE || s == BDependency.DEP_SYNC_CONFLICT) continue;
                toRemove.add(oldDep);
                newDep = s.mergedResult;
                break;
            }
            if (!add) continue;
            this.addCandidates(newDep, toAdd);
        }
        toRemove.forEach(this.candidates::removeKey);
        this.candidates.addAll(toAdd);
    }

    public boolean shouldExclude(BInstallable inst) {
        return this.getFailedExclusion(inst) != null;
    }

    public BDependency getFailedExclusion(BInstallable inst) {
        for (BDependency excl : inst.getAllExclusions()) {
            if (!this.endStateFixed.meets(excl) && !this.endStateMutable.meets(excl)) continue;
            return excl;
        }
        BPart p = inst.getPart();
        if (p != null) {
            for (BInstallable installable : this.toInstall) {
                for (BDependency excl : installable.getAllExclusions()) {
                    if (!p.meets(excl)) continue;
                    return excl;
                }
            }
        }
        return null;
    }

    protected void traceState(String message) {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        LOGGER.fine(message);
        BPart[] parts = this.getParts();
        Arrays.sort(parts, BDistribution.PART_SUMMARY_COMPARATOR);
        if (parts.length == 0) {
            LOGGER.fine("  no parts");
        } else {
            LOGGER.fine("  parts:");
            for (BPart part : parts) {
                LOGGER.fine("    " + (Object)((Object)part));
            }
        }
        if (this.toInstall.isEmpty() && this.modulesToUninstall.isEmpty()) {
            LOGGER.fine("  no actions");
        } else {
            LOGGER.fine("  actions:");
            for (BInstallable installable : this.toInstall) {
                LOGGER.fine("    install " + installable);
            }
            for (String toUninstall : this.modulesToUninstall) {
                LOGGER.fine("    uninstall module " + toUninstall);
            }
        }
        if (this.candidates.size() == 0) {
            LOGGER.fine("  no unresolved dependencies");
        } else {
            LOGGER.fine("  unresolved dependencies:");
            BDependency[] dependencies = this.candidates.getDependencies();
            Arrays.sort(dependencies, BDistribution.DEPENDENCY_SUMMARY_COMPARATOR);
            for (BDependency dep : dependencies) {
                LOGGER.fine("    " + (Object)((Object)dep));
            }
        }
        if (this.excludedInstallables.isEmpty()) {
            LOGGER.fine("  no excluded installables");
        } else {
            LOGGER.fine("  excluded installables:");
            for (BInstallable excluded : this.excludedInstallables) {
                LOGGER.fine("    " + excluded);
            }
        }
    }

    public void dumpState(StringBuilder stringBuilder, String message) {
        stringBuilder.append(message).append("\n");
        BPart[] parts = this.getParts();
        Arrays.sort(parts, BDistribution.PART_SUMMARY_COMPARATOR);
        if (parts.length == 0) {
            stringBuilder.append("  no parts").append("\n");
        } else {
            stringBuilder.append("  parts:").append("\n");
            for (BPart part : parts) {
                stringBuilder.append("    ").append((Object)part).append("\n");
            }
        }
        if (this.toInstall.isEmpty() && this.modulesToUninstall.isEmpty()) {
            stringBuilder.append("  no actions").append("\n");
        } else {
            stringBuilder.append("  actions:").append("\n");
            for (BInstallable installable : this.toInstall) {
                stringBuilder.append("    install ").append(installable).append("\n");
            }
            for (String toUninstall : this.modulesToUninstall) {
                stringBuilder.append("    uninstall module ").append(toUninstall).append("\n");
            }
        }
        if (this.candidates.size() == 0) {
            stringBuilder.append("  no unresolved dependencies").append("\n");
        } else {
            stringBuilder.append("  unresolved dependencies:").append("\n");
            BDependency[] dependencies = this.candidates.getDependencies();
            Arrays.sort(dependencies, BDistribution.DEPENDENCY_SUMMARY_COMPARATOR);
            for (BDependency dep : dependencies) {
                stringBuilder.append("    ").append((Object)dep).append("\n");
            }
        }
        if (this.excludedInstallables.isEmpty()) {
            stringBuilder.append("  no excluded installables").append("\n");
        } else {
            stringBuilder.append("  excluded installables:").append("\n");
            for (BInstallable excluded : this.excludedInstallables) {
                stringBuilder.append("    ").append(excluded).append("\n");
            }
        }
    }

    private static InstallScenario checkModuleForUpgrades(InstallScenario scenario, BModulePart part, Map<String, BModulePart> checkedModules, InstallableRegistry registry) throws Exception {
        if (checkedModules.containsKey(part.getPartName()) || scenario.nStandalone > 0) {
            return scenario;
        }
        BDependency dep = BDependency.forPart(part, BVersionRelation.minimum);
        IterableCursor<BInstallable> instCursor = registry.getInstallables(dep, scenario.getSolutionParameters().listener);
        while (instCursor.next()) {
            BModuleInstallable upgrade = (BModuleInstallable)instCursor.get();
            if (!scenario.getTargetPlatform().getIsNiagara4() && !upgrade.getModulePart().getManifest().isNiagaraAXModule() || !((BModulePart)upgrade.getPart()).isUpgradeFor(part)) continue;
            boolean addUpgrade = true;
            for (BDependency upgradeDep : upgrade.getAllDependencies()) {
                if (checkedModules.containsKey(upgradeDep.getPartName())) {
                    BModulePart checkedPart = checkedModules.get(upgradeDep.getPartName());
                    if (checkedPart != null && checkedPart.meets(upgradeDep)) continue;
                    addUpgrade = false;
                    break;
                }
                if (upgradeDep.canSolveWith(scenario.getSolutionParameters().solvers) || scenario.endStateMutable.meets(upgradeDep) || scenario.endStateFixed.meets(upgradeDep)) continue;
                addUpgrade = false;
                break;
            }
            if (addUpgrade) {
                BInstallable[] oldInstall = scenario.getToInstall();
                BInstallable[] newInstall = new BInstallable[oldInstall.length + 1];
                newInstall[0] = upgrade;
                System.arraycopy(oldInstall, 0, newInstall, 1, oldInstall.length);
                InstallScenario solution = new InstallScenario(scenario.getTargetPlatform(), scenario.getModulesToUninstall(), scenario.getUnmetDependencies(), newInstall, scenario.getNewOsTimeZone(), scenario.getTcpIpChanges(), scenario.getNewModuleContent(), scenario.getNewEnabledRuntimeProfiles(), scenario.getSolutionParameters(), registry, scenario.getCertValidator()).solve();
                if (solution.canCommit()) {
                    checkedModules.put(part.getPartName(), upgrade.getModulePart());
                    return solution;
                }
            }
            if (!scenario.getSolutionParameters().latestOnly) continue;
            break;
        }
        instCursor.close();
        checkedModules.put(part.getPartName(), part);
        return scenario;
    }

    public SolutionParameters getSolutionParameters() {
        return this.solutionParams;
    }

    public void setIgnoreDhcpdTransfer(boolean ignoreDhcpdTransfer) {
        this.ignoreDhcpdTransfer = ignoreDhcpdTransfer;
    }

    public void setIgnoreLinkTransfer(boolean ignoreLinkTransfer) {
        this.ignoreLinkTransfer = ignoreLinkTransfer;
    }

    public static class HostState {
        private final Map<BTypeSpec, Map<String, BPart>> partsByType = new HashMap<BTypeSpec, Map<String, BPart>>();

        public HostState copy() {
            HostState result = new HostState();
            this.partsByType.values().forEach(map -> map.values().forEach(result::add));
            return result;
        }

        public void add(BInstallable inst) {
            BPart part = inst.getPart();
            if (part != null) {
                this.add(part);
            }
        }

        public void add(BPart part) {
            if (part != null) {
                if (this.isUniquePartType(part.getType().getTypeSpec())) {
                    HashMap<String, BPart> value = new HashMap<String, BPart>();
                    value.put(part.getName(), part);
                    this.partsByType.put(part.getType().getTypeSpec(), value);
                } else {
                    Map<String, BPart> parts = this.partsByType.get(part.getType().getTypeSpec());
                    if (parts == null) {
                        parts = new HashMap<String, BPart>();
                        this.partsByType.put(part.getType().getTypeSpec(), parts);
                    }
                    parts.put(part.getPartName(), part);
                }
            }
        }

        public void remove(BInstallable inst) {
            if (inst != null) {
                this.remove(inst.getPart());
            }
        }

        public void remove(BPart part) {
            if (part != null) {
                if (this.isUniquePartType(part.getType().getTypeSpec())) {
                    Optional<BPart> existingPart;
                    if (this.partsByType.containsKey(part.getType().getTypeSpec()) && (existingPart = this.partsByType.get(part.getType().getTypeSpec()).values().stream().findAny()).isPresent() && existingPart.get().equivalent((Object)part)) {
                        this.partsByType.remove(part.getType().getTypeSpec());
                    }
                } else {
                    Map<String, BPart> partMap = this.partsByType.get(part.getType().getTypeSpec());
                    if (partMap != null) {
                        partMap.remove(part.getPartName());
                    }
                }
            }
        }

        public void remove(String partName) {
            for (Map.Entry<BTypeSpec, Map<String, BPart>> entry : this.partsByType.entrySet()) {
                BTypeSpec type = entry.getKey();
                Map<String, BPart> parts = entry.getValue();
                if (this.isUniquePartType(type)) {
                    Optional<BPart> existingPart = parts.values().stream().findAny();
                    if (!existingPart.isPresent() || !existingPart.get().getPartName().equals(partName)) continue;
                    this.partsByType.remove(type);
                    return;
                }
                if (parts.remove(partName) == null) continue;
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean meets(BDependency dep) {
            if (this.isUniquePartType(dep.getPartTypeSpec())) {
                if (!this.partsByType.containsKey(dep.getPartTypeSpec())) return false;
                Optional<BPart> existingPart = this.partsByType.get(dep.getPartTypeSpec()).values().stream().findAny();
                if (!existingPart.isPresent()) return false;
                return existingPart.get().meets(dep);
            }
            Map<String, BPart> parts = this.partsByType.get(dep.getPartTypeSpec());
            if (parts == null) return false;
            if (BPart.isWildcardName(dep.getPartName())) {
                for (BPart part : parts.values()) {
                    if (!part.meets(dep)) continue;
                    return true;
                }
                return false;
            } else {
                BPart part = parts.get(dep.getPartName());
                if (part == null || !part.meets(dep)) return false;
                return true;
            }
        }

        public BModulePart[] getModules() {
            Map<String, BPart> partMap = this.partsByType.get(BModulePart.TYPE.getTypeSpec());
            if (partMap == null) {
                return new BModulePart[0];
            }
            return (BModulePart[])partMap.values().stream().map(part -> (BModulePart)((Object)part)).toArray(BModulePart[]::new);
        }

        private boolean isUniquePartType(BTypeSpec type) {
            return !type.equals((Object)BModulePart.TYPE.getTypeSpec()) && (type.equals((Object)BArchPart.TYPE.getTypeSpec()) || type.equals((Object)BOsPart.TYPE.getTypeSpec()) || type.equals((Object)BNrePart.TYPE.getTypeSpec()) || type.equals((Object)BBrandPart.TYPE.getTypeSpec()) || type.equals((Object)BVmPart.TYPE.getTypeSpec()) || type.equals((Object)BModelPart.TYPE.getTypeSpec()));
        }

        public BPart[] getParts() {
            ArrayList accum = new ArrayList();
            this.partsByType.values().forEach(map -> accum.addAll(map.values()));
            return accum.toArray(new BPart[0]);
        }
    }
}

