/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.InstallScenario;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BFacets;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class DependencyUtil {
    private static final Map<RuntimeProfile, Set<String>> RUNTIME_PROFILE_CORE_MODULE_NAMES = new TreeMap<RuntimeProfile, Set<String>>();
    private static final Set<String> AX_UI_MODULE_NAMES = new TreeSet<String>();
    private static int ANALYSIS_REQ_STATION;
    private static int ANALYSIS_REQ_PLATFORM;
    private static int ANALYSIS_DEP_MISSING;
    private static int ANALYSIS_DEP_UNAVAILABLE;
    private static int ANALYSIS_DEP_UNSOLVABLE;
    private static int ANALYSIS_DEP_READONLY;

    public static BDependency[] getPlatformDependencies(BDaemonPlatform platform) throws ConnectException, AuthenticationException {
        return DependencyUtil.getPlatformDependencies(platform, null);
    }

    public static BDependency[] getPlatformDependencies(BDaemonPlatform platform, Set<RuntimeProfile> enabledRuntimeProfiles) throws ConnectException, AuthenticationException {
        return DependencyUtil.depsForModuleNames(DependencyUtil.accumPlatformModuleNames(DependencyUtil.getRequiredModuleNames(platform, enabledRuntimeProfiles), platform), enabledRuntimeProfiles, platform.getIsNiagara4());
    }

    public static BDependency[] getStationDependencies(BDaemonPlatform platform, FilePath stationDir) throws ConnectException, AuthenticationException {
        try {
            BDaemonFileStore bogStore = new BDaemonFileStore(platform.getDaemonSession().getFileSpace(), stationDir.merge("config.bog"));
            bogStore.setTranscodeBog(false);
            InputStream bogStream = bogStore.getInputStream();
            Set<String> moduleNames = DependencyUtil.accumBogModuleNames(DependencyUtil.getRequiredModuleNames(platform, null), bogStream, "platform", "DependencyUtil.parseConfigBog");
            DependencyUtil.addDefaultThemeDependency(moduleNames);
            DependencyUtil.accumPlatformModuleNames(moduleNames, platform);
            return DependencyUtil.depsForModuleNames(moduleNames, platform.getEnabledRuntimeProfiles(), platform.getIsNiagara4());
        }
        catch (IOException ioe) {
            throw new LocalizableRuntimeException("platform", "DependencyUtil.parseConfigBog", (Throwable)ioe);
        }
    }

    public static BDependency[] getStationDependencies(BDaemonPlatform platform, BDirectory stationDir) throws ConnectException, AuthenticationException {
        try {
            InputStream bogStream;
            if (stationDir == null) {
                bogStream = null;
            } else if (stationDir.getStore() instanceof BDaemonDirectoryStore) {
                BDaemonFileStore bogStore = new BDaemonFileStore(platform.getDaemonSession().getFileSpace(), stationDir.getFilePath().merge("config.bog"));
                bogStore.setTranscodeBog(false);
                bogStream = bogStore.getInputStream();
            } else {
                BIFile bogFile = (BIFile)stationDir.getNavChild("config.bog");
                bogStream = bogFile == null ? null : bogFile.getInputStream();
            }
            Set<String> moduleNames = DependencyUtil.accumBogModuleNames(null, bogStream, "platform", "DependencyUtil.parseConfigBog");
            DependencyUtil.addDefaultThemeDependency(moduleNames);
            DependencyUtil.accumPlatformModuleNames(moduleNames, platform);
            return DependencyUtil.depsForModuleNames(moduleNames, platform.getEnabledRuntimeProfiles(), platform.getIsNiagara4());
        }
        catch (IOException ioe) {
            throw new LocalizableRuntimeException("platform", "DependencyUtil.parseConfigBog", (Throwable)ioe);
        }
    }

    public static BDependency[] getPlatformModuleDependencies(BDaemonPlatform platform, BDistribution dist) throws ConnectException {
        return DependencyUtil.getPlatformModuleDependencies(platform, dist, platform.getEnabledRuntimeProfiles());
    }

    public static BDependency[] getPlatformModuleDependencies(BDaemonPlatform platform, BDistribution dist, Set<RuntimeProfile> enabledProfiles) throws ConnectException {
        XElem platformBog;
        if (enabledProfiles == null) {
            enabledProfiles = platform.getEnabledRuntimeProfiles();
        }
        return (platformBog = dist.getUpdatedPlatformBog(platform)) == null ? null : DependencyUtil.getBogModuleDeps(platformBog, enabledProfiles, platform.getIsNiagara4());
    }

    public static BDependency[] getBogModuleDeps(XElem bogDocument, Set<RuntimeProfile> enabledProfiles, boolean isNiagara4) {
        TreeSet<String> moduleNames = new TreeSet<String>();
        DependencyUtil.accumBogModuleNames(moduleNames, bogDocument);
        return DependencyUtil.depsForModuleNames(moduleNames, enabledProfiles, isNiagara4);
    }

    private static Set<String> getPlatformModuleNames(BDaemonPlatform platform, BDistribution dist) throws ConnectException {
        XElem platformBog = dist.getUpdatedPlatformBog(platform);
        return platformBog == null ? null : DependencyUtil.getBogModuleNames(platformBog);
    }

    private static Set<String> getRequiredModuleNames(BDaemonPlatform platform, Set<RuntimeProfile> enabledRuntimeProfiles) {
        if (platform.getIsNiagara4()) {
            if (enabledRuntimeProfiles == null) {
                enabledRuntimeProfiles = platform.getEnabledRuntimeProfiles();
            }
            TreeSet<String> moduleNames = new TreeSet<String>();
            enabledRuntimeProfiles.stream().filter(RUNTIME_PROFILE_CORE_MODULE_NAMES::containsKey).forEach(profile -> moduleNames.addAll((Collection)RUNTIME_PROFILE_CORE_MODULE_NAMES.get(profile)));
            return moduleNames;
        }
        if (platform.getModuleContent() != BModuleContent.runtime) {
            return AX_UI_MODULE_NAMES;
        }
        return new TreeSet<String>();
    }

    private static Set<String> getBogModuleNames(XElem bogDocument) {
        TreeSet<String> moduleNames = new TreeSet<String>();
        DependencyUtil.accumBogModuleNames(moduleNames, bogDocument);
        return moduleNames;
    }

    private static Set<String> modulePartNamesForModuleNames(Set<String> moduleNames, Set<RuntimeProfile> enabledProfiles) {
        TreeSet<String> result = new TreeSet<String>();
        for (String moduleName : moduleNames) {
            try {
                if (enabledProfiles == null) {
                    enabledProfiles = new HashSet<RuntimeProfile>();
                    enabledProfiles.add(RuntimeProfile.rt);
                }
                for (ModuleInfo moduleInfo : Sys.getRegistry().getModules(moduleName)) {
                    if (!enabledProfiles.contains(moduleInfo.getRuntimeProfile())) continue;
                    result.add(moduleInfo.getModulePartName());
                }
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
            }
        }
        return result;
    }

    private static BDependency[] depsForModuleNames(Set<String> moduleNames, Set<RuntimeProfile> enabledProfiles, boolean isNiagara4) {
        if (isNiagara4) {
            return (BDependency[])DependencyUtil.modulePartNamesForModuleNames(moduleNames, enabledProfiles).stream().map(BDependency::forModule).toArray(BDependency[]::new);
        }
        return (BDependency[])moduleNames.stream().map(BDependency::forModule).toArray(BDependency[]::new);
    }

    private static Set<String> accumBogModuleNames(Set<String> moduleNames, XElem bogElement) {
        TreeSet<String> resultModuleNames;
        TreeSet<String> treeSet = resultModuleNames = moduleNames == null ? new TreeSet<String>() : moduleNames;
        if (bogElement == null) {
            return resultModuleNames;
        }
        if (bogElement.name().equals("p")) {
            String modulePair = bogElement.get("m", null);
            if (modulePair != null) {
                int ixEquals = modulePair.indexOf(61);
                String name = ixEquals < 0 ? modulePair : modulePair.substring(ixEquals + 1);
                resultModuleNames.add(name);
            }
            DependencyUtil.addExplicitModuleDependencies(resultModuleNames, bogElement);
        }
        for (XElem kid : bogElement.elems()) {
            DependencyUtil.accumBogModuleNames(resultModuleNames, kid);
        }
        return resultModuleNames;
    }

    private static Set<String> accumBogModuleNames(Set<String> moduleNames, InputStream bogStream, String errorMsgModule, String errorMsgKey) throws ConnectException, AuthenticationException {
        TreeSet<String> result = moduleNames == null ? new TreeSet<String>() : moduleNames;
        try {
            if (bogStream != null) {
                XParser parser = XParser.make((InputStream)bogStream);
                while (parser.next() != -1) {
                    if (parser.type() != 1 || !parser.elem().name().equals("p")) continue;
                    String modulePair = parser.elem().get("m", null);
                    if (modulePair != null) {
                        int ixEquals = modulePair.indexOf(61);
                        String name = ixEquals < 0 ? modulePair : modulePair.substring(ixEquals + 1);
                        result.add(name);
                    }
                    DependencyUtil.addExplicitModuleDependencies(result, parser.elem());
                }
            }
            return result;
        }
        catch (ConnectException | AuthenticationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException(errorMsgModule, errorMsgKey, (Throwable)e);
        }
    }

    private static void addExplicitModuleDependencies(Set<String> moduleNames, XElem bogElement) {
        try {
            if (bogElement.get("t", "").equals("b:Facets")) {
                BFacets facets = BFacets.make((String)bogElement.get("v", null));
                ObjectUtil.getModuleDependenciesFromFacets((BFacets)facets).forEach(moduleNames::add);
            }
        }
        catch (Throwable facets) {
            // empty catch block
        }
        try {
            String slotFacetsStr = bogElement.get("x", null);
            if (slotFacetsStr != null) {
                BFacets facets = BFacets.make((String)slotFacetsStr);
                ObjectUtil.getModuleDependenciesFromFacets((BFacets)facets).forEach(moduleNames::add);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void addDefaultThemeDependency(Set<String> moduleNames) {
        try {
            Object theme = Sys.newInstance((String)"bajaui", (String)"com.tridium.ui.theme.Theme");
            String themeName = (String)theme.getClass().getMethod("getInstalledThemeName", new Class[0]).invoke(theme, new Object[0]);
            if (themeName != null) {
                moduleNames.add("theme" + themeName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Set<String> accumPlatformModuleNames(Set<String> moduleNames, BDaemonPlatform platform) throws ConnectException, AuthenticationException {
        TreeSet<String> resultModuleNames = moduleNames == null ? new TreeSet<String>() : moduleNames;
        BDaemonFileStore platStore = new BDaemonFileStore(platform.getDaemonSession().getFileSpace(), SystemFilePaths.getPlatformBogPath(platform.getIsNiagara4(), platform.getIsNiagaraHomeReadonly()));
        platStore.setTranscodeBog(false);
        try {
            InputStream platStream = platStore.getInputStream();
            if (platStream == null) {
                return resultModuleNames;
            }
            return DependencyUtil.accumBogModuleNames(resultModuleNames, platStream, "platform", "DependencyUtil.parsePlatformBog");
        }
        catch (IOException ioe) {
            throw new LocalizableRuntimeException("platform", "DependencyUtil.parsePlatformBog", (Throwable)ioe);
        }
    }

    public static AnalysisResults analyzeAllDependencies(BDaemonPlatform platform, BFileSpace stationFileSpace, FilePath stationDirPath, Set<RuntimeProfile> newEnabledRuntimeProfiles, DaemonSessionTaskListener taskListener) throws Exception {
        return DependencyUtil.analyzeAllDependencies(platform, stationFileSpace, stationDirPath, newEnabledRuntimeProfiles, taskListener, null);
    }

    public static AnalysisResults analyzeAllDependencies(BDaemonPlatform platform, BFileSpace stationFileSpace, FilePath stationDirPath, Set<RuntimeProfile> newEnabledRuntimeProfiles, DaemonSessionTaskListener taskListener, CertificateChainValidator certValidator) throws Exception {
        Set<String> stationModuleNames;
        Set<String> platformModuleNames = DependencyUtil.accumPlatformModuleNames(DependencyUtil.getRequiredModuleNames(platform, newEnabledRuntimeProfiles), platform);
        if (stationDirPath == null) {
            stationModuleNames = new TreeSet<String>(platformModuleNames);
        } else {
            Object bogStore;
            if (stationFileSpace instanceof BDaemonFileSpace) {
                bogStore = new BDaemonFileStore((BDaemonFileSpace)stationFileSpace, stationDirPath.merge("config.bog"));
                ((BDaemonFileStore)((Object)bogStore)).setTranscodeBog(false);
            } else {
                bogStore = stationFileSpace.findStore(stationDirPath.merge("config.bog"));
            }
            InputStream bogStream = bogStore.getInputStream();
            stationModuleNames = DependencyUtil.accumBogModuleNames(new TreeSet<String>(platformModuleNames), bogStream, "platform", "DependencyUtil.parseConfigBog");
            DependencyUtil.addDefaultThemeDependency(stationModuleNames);
        }
        return new AnalysisResults(platform, stationModuleNames, platformModuleNames, newEnabledRuntimeProfiles, new SolutionParameters(taskListener), certValidator);
    }

    public static AnalysisResults analyzeAllDependencies(BDaemonPlatform platform, BDirectory[] stationDirs, Set<RuntimeProfile> newEnabledRuntimeProfiles, SolutionParameters solutionParms, CertificateChainValidator certValidator) throws Exception {
        Set<String> platformModuleNames = DependencyUtil.accumPlatformModuleNames(DependencyUtil.getRequiredModuleNames(platform, newEnabledRuntimeProfiles), platform);
        Set<String> stationModuleNames = new TreeSet<String>(platformModuleNames);
        if (stationDirs != null) {
            for (BDirectory dir : stationDirs) {
                BIFile configBog = (BIFile)dir.getNavChild("config.bog");
                if (configBog == null) continue;
                if (configBog.getStore() instanceof BDaemonFileStore) {
                    ((BDaemonFileStore)configBog.getStore()).setTranscodeBog(false);
                }
                InputStream bogStream = configBog.getInputStream();
                stationModuleNames = DependencyUtil.accumBogModuleNames(stationModuleNames, bogStream, "platform", "DependencyUtil.parseConfigBog");
            }
            DependencyUtil.addDefaultThemeDependency(stationModuleNames);
        }
        return new AnalysisResults(platform, stationModuleNames, platformModuleNames, newEnabledRuntimeProfiles, solutionParms, certValidator);
    }

    static {
        TreeSet<String> moduleNames = new TreeSet<String>();
        Collections.addAll(moduleNames, "baja", "platform", "gx", "signingService");
        RUNTIME_PROFILE_CORE_MODULE_NAMES.put(RuntimeProfile.rt, moduleNames);
        moduleNames = new TreeSet();
        Collections.addAll(moduleNames, "converters", "icons", "webChart", "uxBuilder");
        DependencyUtil.addDefaultThemeDependency(moduleNames);
        RUNTIME_PROFILE_CORE_MODULE_NAMES.put(RuntimeProfile.ux, moduleNames);
        moduleNames = new TreeSet();
        Collections.addAll(moduleNames, "chart", "converters", "fonts", "html", "kitPx", "web", "pdf", "wiresheet", "workbench", "jxBrowser");
        RUNTIME_PROFILE_CORE_MODULE_NAMES.put(RuntimeProfile.wb, moduleNames);
        Collections.addAll(AX_UI_MODULE_NAMES, "web", "icons", "converters", "html", "fonts", "chart", "wiresheet", "pdf", "kitPx");
        ANALYSIS_REQ_STATION = 1;
        ANALYSIS_REQ_PLATFORM = 2;
        ANALYSIS_DEP_MISSING = 256;
        ANALYSIS_DEP_UNAVAILABLE = 512;
        ANALYSIS_DEP_UNSOLVABLE = 1024;
        ANALYSIS_DEP_READONLY = 2048;
    }

    public static class AnalysisResults {
        private InstallScenario solution;
        private TreeMap<String, Integer> flagsByPartName = new TreeMap();
        private int status = 0;

        /*
         * WARNING - void declaration
         */
        public AnalysisResults(BDaemonPlatform platform, Set<String> stationModuleNames, Set<String> platformModuleNames, Set<RuntimeProfile> newEnabledRuntimeProfiles, SolutionParameters solutionParms, CertificateChainValidator certValidator) throws Exception {
            if (newEnabledRuntimeProfiles == null) {
                newEnabledRuntimeProfiles = platform.getEnabledRuntimeProfiles();
            }
            this.solution = new InstallScenario(platform, null, DependencyUtil.depsForModuleNames(stationModuleNames, newEnabledRuntimeProfiles, platform.getIsNiagara4()), null, null, null, null, newEnabledRuntimeProfiles, solutionParms, LocalInstallableRegistry.getInstance(), certValidator).solve();
            if (this.solution.canCommit()) {
                void var8_10;
                boolean depsUpdated = false;
                boolean bl = false;
                while (var8_10 < this.solution.getToInstall().length) {
                    Set updatedPlatformNames;
                    if (this.solution.getToInstall()[var8_10] instanceof BDistribution && (updatedPlatformNames = DependencyUtil.getPlatformModuleNames(platform, (BDistribution)this.solution.getToInstall()[var8_10])) != null) {
                        for (String string : updatedPlatformNames) {
                            if (platformModuleNames.add(string)) {
                                depsUpdated = true;
                            }
                            if (!stationModuleNames.add(string)) continue;
                            depsUpdated = true;
                        }
                    }
                    ++var8_10;
                }
                if (depsUpdated) {
                    this.solution = this.solution.solve(null, null, DependencyUtil.depsForModuleNames(stationModuleNames, newEnabledRuntimeProfiles, platform.getIsNiagara4()), null, LocalInstallableRegistry.getInstance());
                }
                if (this.solution.canCommit()) {
                    BModulePart modulePart;
                    HashMap<String, BModulePart> hashMap = new HashMap<String, BModulePart>();
                    SlotCursor c = platform.getModuleList().getModules().getProperties();
                    while (c.next(BModuleInstallable.class)) {
                        modulePart = ((BModuleInstallable)c.get()).getModulePart();
                        hashMap.put(modulePart.getPartName(), modulePart);
                    }
                    for (int i = 0; i < this.solution.getToInstall().length; ++i) {
                        this.setStatusFlag(this.solution.getToInstall()[i].getInstallableName(), ANALYSIS_DEP_MISSING);
                        if (!(this.solution.getToInstall()[i] instanceof BModuleInstallable)) continue;
                        modulePart = ((BModuleInstallable)this.solution.getToInstall()[i]).getModulePart();
                        hashMap.put(modulePart.getPartName(), modulePart);
                    }
                    HashSet<String> partNames = new HashSet<String>();
                    for (String string : DependencyUtil.modulePartNamesForModuleNames(platformModuleNames, newEnabledRuntimeProfiles)) {
                        this.accumModulePartDependencies(string, partNames, hashMap, ANALYSIS_REQ_PLATFORM | ANALYSIS_REQ_STATION);
                    }
                    for (String string : DependencyUtil.modulePartNamesForModuleNames(stationModuleNames, newEnabledRuntimeProfiles)) {
                        this.accumModulePartDependencies(string, partNames, hashMap, ANALYSIS_REQ_STATION);
                    }
                    return;
                }
            }
            TreeSet<String> unmeetablePartNames = new TreeSet<String>();
            for (UnmeetableDependency unmeetableDependency : this.solution.getUnmeetableDependencies()) {
                String partName = unmeetableDependency.dependency.getPartName();
                unmeetablePartNames.add(partName);
                if (unmeetableDependency.isUnsolvable) {
                    this.setStatusFlag(partName, ANALYSIS_DEP_UNSOLVABLE | ANALYSIS_DEP_MISSING);
                    continue;
                }
                if (unmeetableDependency.isSoftwareReadonly) {
                    this.setStatusFlag(partName, ANALYSIS_DEP_READONLY | ANALYSIS_DEP_MISSING);
                    continue;
                }
                this.setStatusFlag(partName, ANALYSIS_DEP_UNAVAILABLE | ANALYSIS_DEP_MISSING);
            }
            if (this.solution.getUnmeetableDependencies().length == 0) {
                for (BDependency bDependency : this.solution.getInstallableCandidates().getDependencies()) {
                    if (unmeetablePartNames.contains(bDependency.getPartName())) continue;
                    BInstallable[] candidates = this.solution.getInstallableCandidates().getCandidates((Object)bDependency);
                    Logger.getLogger("platform").severe(String.format("Unexpected DependencyUtil result: %s unmet but not unmeetable (%d candidates)", bDependency.toString(), candidates == null ? 0 : candidates.length));
                }
            }
        }

        public InstallScenario getSolution() {
            return this.solution;
        }

        public boolean anyUnsolvable() {
            return (this.status & ANALYSIS_DEP_UNSOLVABLE) > 0;
        }

        public boolean anyUnvailable() {
            return (this.status & ANALYSIS_DEP_UNAVAILABLE) > 0;
        }

        public boolean anyToInstall() {
            return (this.status & ANALYSIS_DEP_MISSING) > 0;
        }

        public String[] getPartNames() {
            return this.flagsByPartName.keySet().toArray(new String[0]);
        }

        public boolean isStationModule(String modulePartName) {
            return this.isStatusFlagSet(modulePartName, ANALYSIS_REQ_STATION);
        }

        public boolean isPlatformModule(String modulePartName) {
            return this.isStatusFlagSet(modulePartName, ANALYSIS_REQ_PLATFORM);
        }

        public boolean isMissing(String partName) {
            return this.isStatusFlagSet(partName, ANALYSIS_DEP_MISSING);
        }

        public boolean isUnavailable(String partName) {
            return this.isStatusFlagSet(partName, ANALYSIS_DEP_UNAVAILABLE);
        }

        public boolean isUnsolvable(String partName) {
            return this.isStatusFlagSet(partName, ANALYSIS_DEP_UNSOLVABLE);
        }

        private void accumModulePartDependencies(String modulePartName, Set<String> accumPartName, Map<String, BModulePart> modulePartsByPartName, int flags) {
            if (accumPartName.contains(modulePartName)) {
                return;
            }
            this.setStatusFlag(modulePartName, flags);
            accumPartName.add(modulePartName);
            BModulePart module = modulePartsByPartName.get(modulePartName);
            if (module != null) {
                for (BDependency dep : module.getDependencyArray()) {
                    if (!dep.getPartType().equals(BModulePart.TYPE)) continue;
                    this.accumModulePartDependencies(dep.getPartName(), accumPartName, modulePartsByPartName, flags);
                }
            }
        }

        private void setStatusFlag(String partName, int status) {
            Integer valueObj = this.flagsByPartName.get(partName);
            int result = valueObj == null ? 0 : valueObj;
            this.flagsByPartName.put(partName, result | status);
            this.status |= status;
        }

        private boolean isStatusFlagSet(String partName, int flag) {
            Integer valueObj = this.flagsByPartName.get(partName);
            return valueObj != null && (valueObj & flag) > 0;
        }
    }
}

