/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.EmptyCursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="modules", type="BVector", defaultValue="new BVector()", flags=1)
@NiagaraAction(name="init", flags=4)
public class BModuleList
extends BComponent
implements InstallableRegistry {
    @Generated
    public static final Property modules = BModuleList.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Action init = BModuleList.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModuleList.class);
    private Map<String, List<String>> dependentModuleNames = null;
    private boolean isLocalInstance;

    @Generated
    public BVector getModules() {
        return (BVector)this.get(modules);
    }

    @Generated
    public void setModules(BVector v) {
        this.set(modules, (BValue)v, null);
    }

    @Generated
    public void init() {
        this.invoke(init, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final synchronized void load() {
        this.load(null);
    }

    public final synchronized void load(DaemonSessionTaskListener listener) {
        this.checkLocalInstance();
        this.doReload(listener);
    }

    public final synchronized void reload() {
        this.reload(null);
    }

    public final synchronized void reload(DaemonSessionTaskListener listener) {
        this.reset();
        this.init(listener);
        this.doReload(listener);
    }

    public synchronized void reset() {
        this.checkLocalInstance();
        this.dependentModuleNames = null;
    }

    protected synchronized void doReload(DaemonSessionTaskListener listener) {
    }

    public BPart getPart(String name) {
        BModuleInstallable inst = this.getModuleInstallable(name);
        return inst == null ? null : inst.getModulePart();
    }

    public BModuleInstallable getModuleInstallable(String name) {
        return (BModuleInstallable)this.getModules().get(SlotPath.escape((String)name));
    }

    public List<String> getDependentModuleNames(String requiredModuleName) {
        ArrayList result;
        if (this.dependentModuleNames == null) {
            this.dependentModuleNames = new HashMap<String, List<String>>();
            SlotCursor c = this.getModules().getProperties();
            while (c.next()) {
                BModulePart part = ((BModuleInstallable)c.get()).getModulePart();
                for (BDependency dep : part.getDependencyArray()) {
                    String name = dep.getPartName();
                    List<String> set = this.dependentModuleNames.get(name);
                    if (set == null) {
                        set = new ArrayList<String>();
                        this.dependentModuleNames.put(name, set);
                    }
                    set.add(part.getPartName());
                }
            }
        }
        return (result = this.dependentModuleNames.get(requiredModuleName)) == null ? new ArrayList() : result;
    }

    public boolean meets(BDependency depend) {
        BPart part = this.getPart(depend.getPartName());
        return part != null && part.meets(depend);
    }

    @Override
    public BInstallable findInstallable(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        this.init(listener);
        SlotCursor c = this.getModules().getProperties();
        while (c.next(BModuleInstallable.class)) {
            BModuleInstallable i = (BModuleInstallable)c.get();
            if (!i.meets(depend)) continue;
            return i;
        }
        return null;
    }

    @Override
    public IterableCursor<BInstallable> getInstallables(boolean latestOnly, DaemonSessionTaskListener listener) {
        this.init();
        return new FilterCursor<BValue, BInstallable>((Cursor<BValue>)this.getModules().getProperties(), propValue -> propValue instanceof BInstallable, propValue -> (BInstallable)propValue);
    }

    @Override
    public IterableCursor<BInstallable> getInstallables(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        BInstallable item = this.findInstallable(depend, listener);
        if (item == null) {
            return new EmptyCursor(Context.NULL);
        }
        return new ItemCursor<BInstallable>(item);
    }

    public final void init(DaemonSessionTaskListener listener) {
        this.doInit(listener);
    }

    public final void doInit() {
        this.doInit(null);
    }

    public synchronized void doInit(DaemonSessionTaskListener listener) {
        throw new UnsupportedOperationException();
    }

    protected void setLocalInstance(boolean value) {
        this.isLocalInstance = value;
    }

    protected boolean isLocalInstance() {
        return this.isLocalInstance;
    }

    protected void checkLocalInstance() {
        if (!this.isLocalInstance()) {
            throw new IllegalStateException("operation not supported on remote BModuleList");
        }
    }

    public static class ItemCursor<E>
    implements IterableCursor<E> {
        private E item;
        private int index = -1;

        public ItemCursor(E item) {
            this.item = item;
            this.index = -1;
        }

        public void close() {
        }

        public E get() {
            if (this.index == 0) {
                return this.item;
            }
            throw new IllegalStateException();
        }

        public Context getContext() {
            return null;
        }

        public boolean next() {
            if (this.index < 0) {
                ++this.index;
                return true;
            }
            return false;
        }
    }

    public static class FilterCursor<I extends BValue, E extends BValue>
    implements IterableCursor<E> {
        private final Cursor<I> innerCursor;
        private final Predicate<? super I> filter;
        private final Function<? super I, ? extends E> mapper;

        public FilterCursor(Cursor<I> innerCursor, Predicate<? super I> filter, Function<? super I, ? extends E> mapper) {
            this.innerCursor = innerCursor;
            this.filter = filter;
            this.mapper = mapper;
        }

        public Context getContext() {
            return this.innerCursor.getContext();
        }

        public boolean next() {
            while (this.innerCursor.next()) {
                if (!this.filter.test(this.innerCursor.get())) continue;
                return true;
            }
            return false;
        }

        public E get() {
            return (E)((BValue)this.mapper.apply(this.innerCursor.get()));
        }

        public void close() {
            this.innerCursor.close();
        }
    }
}

