/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDependency;
import com.tridium.install.BModuleList;
import com.tridium.install.BRemoteModuleList;
import com.tridium.install.BVersion;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.util.SupportLevel;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="hostId", type="String", defaultValue="", flags=1), @NiagaraProperty(name="hostName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="port", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="daemonVersion", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="archPart", type="BArchPart", defaultValue="BArchPart.makeNull()", flags=1), @NiagaraProperty(name="osPart", type="BOsPart", defaultValue="BOsPart.makeNull()", flags=1), @NiagaraProperty(name="nrePart", type="BNrePart", defaultValue="BNrePart.makeNull()", flags=1), @NiagaraProperty(name="brandPart", type="BBrandPart", defaultValue="BBrandPart.makeNull()", flags=1), @NiagaraProperty(name="vmPart", type="BVmPart", defaultValue="BVmPart.makeNull()", flags=1), @NiagaraProperty(name="modelPart", type="BModelPart", defaultValue="BModelPart.makeNull()", flags=1), @NiagaraProperty(name="moduleList", type="BModuleList", defaultValue="new BModuleList()", flags=1), @NiagaraProperty(name="otherParts", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="moduleContent", type="BModuleContent", defaultValue="BModuleContent.doc", flags=1), @NiagaraProperty(name="stripLineNumbers", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="maxStations", type="int", defaultValue="1", flags=1), @NiagaraProperty(name="maxSedonaApps", type="int", defaultValue="1", flags=1), @NiagaraProperty(name="osTimeReadonly", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="osTimeZone", type="BTimeZone", defaultValue="BTimeZone.NULL", flags=1), @NiagaraProperty(name="allowStationRestart", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="configDistFileName", type="String", defaultValue="nre-config-*.dist", flags=3), @NiagaraProperty(name="isNpsdk", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sedonaSupported", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sedonaEnabled", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="niagaraStationsEnabled", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="niagaraR2Supported", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="niagaraR2Enabled", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="platformSSLSupported", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="platformSSLSettings", type="BPlatformSSLSettings", defaultValue="new BPlatformSSLSettings()", flags=3), @NiagaraProperty(name="supportedRuntimeProfilesVector", type="BVector", defaultValue="new BVector()", flags=3), @NiagaraProperty(name="enabledRuntimeProfileNames", type="String", defaultValue="rt,ux,wb,se,doc", flags=3), @NiagaraProperty(name="isNiagara4", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="preferredVerificationMode", type="String", defaultValue="ModuleVerificationMode.noPreference.name()", flags=1), @NiagaraProperty(name="allowBrandChange", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="isLicenseReadonly", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="isSoftwareReadonly", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="isNiagaraHomeReadonly", type="boolean", defaultValue="false", flags=1)})
@NiagaraAction(name="checkSession", flags=4)
public abstract class BDaemonPlatform
extends BComponent {
    @Generated
    public static final Property hostId = BDaemonPlatform.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property hostName = BDaemonPlatform.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property port = BDaemonPlatform.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property daemonVersion = BDaemonPlatform.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property archPart = BDaemonPlatform.newProperty((int)1, (BValue)BArchPart.makeNull(), null);
    @Generated
    public static final Property osPart = BDaemonPlatform.newProperty((int)1, (BValue)BOsPart.makeNull(), null);
    @Generated
    public static final Property nrePart = BDaemonPlatform.newProperty((int)1, (BValue)BNrePart.makeNull(), null);
    @Generated
    public static final Property brandPart = BDaemonPlatform.newProperty((int)1, (BValue)BBrandPart.makeNull(), null);
    @Generated
    public static final Property vmPart = BDaemonPlatform.newProperty((int)1, (BValue)BVmPart.makeNull(), null);
    @Generated
    public static final Property modelPart = BDaemonPlatform.newProperty((int)1, (BValue)BModelPart.makeNull(), null);
    @Generated
    public static final Property moduleList = BDaemonPlatform.newProperty((int)1, (BValue)new BModuleList(), null);
    @Generated
    public static final Property otherParts = BDaemonPlatform.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Property moduleContent = BDaemonPlatform.newProperty((int)1, (BValue)BModuleContent.doc, null);
    @Generated
    public static final Property stripLineNumbers = BDaemonPlatform.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property maxStations = BDaemonPlatform.newProperty((int)1, (int)1, null);
    @Generated
    public static final Property maxSedonaApps = BDaemonPlatform.newProperty((int)1, (int)1, null);
    @Generated
    public static final Property osTimeReadonly = BDaemonPlatform.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property osTimeZone = BDaemonPlatform.newProperty((int)1, (BValue)BTimeZone.NULL, null);
    @Generated
    public static final Property allowStationRestart = BDaemonPlatform.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property configDistFileName = BDaemonPlatform.newProperty((int)3, (String)"nre-config-*.dist", null);
    @Generated
    public static final Property isNpsdk = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property sedonaSupported = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property sedonaEnabled = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property niagaraStationsEnabled = BDaemonPlatform.newProperty((int)3, (boolean)true, null);
    @Generated
    public static final Property niagaraR2Supported = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property niagaraR2Enabled = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property platformSSLSupported = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property platformSSLSettings = BDaemonPlatform.newProperty((int)3, (BValue)new BPlatformSSLSettings(), null);
    @Generated
    public static final Property supportedRuntimeProfilesVector = BDaemonPlatform.newProperty((int)3, (BValue)new BVector(), null);
    @Generated
    public static final Property enabledRuntimeProfileNames = BDaemonPlatform.newProperty((int)3, (String)"rt,ux,wb,se,doc", null);
    @Generated
    public static final Property isNiagara4 = BDaemonPlatform.newProperty((int)3, (boolean)true, null);
    @Generated
    public static final Property preferredVerificationMode = BDaemonPlatform.newProperty((int)1, (String)ModuleVerificationMode.noPreference.name(), null);
    @Generated
    public static final Property allowBrandChange = BDaemonPlatform.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property isLicenseReadonly = BDaemonPlatform.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property isSoftwareReadonly = BDaemonPlatform.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property isNiagaraHomeReadonly = BDaemonPlatform.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Action checkSession = BDaemonPlatform.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonPlatform.class);
    private boolean sessionInvalid = false;
    private String daemonTimestamp;
    private BDaemonSession session;
    protected boolean localInstance = false;
    private static BIcon icon;
    private static final Logger LOGGER;

    @Generated
    public String getHostId() {
        return this.getString(hostId);
    }

    @Generated
    public void setHostId(String v) {
        this.setString(hostId, v, null);
    }

    @Generated
    public String getHostName() {
        return this.getString(hostName);
    }

    @Generated
    public void setHostName(String v) {
        this.setString(hostName, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public String getDaemonVersion() {
        return this.getString(daemonVersion);
    }

    @Generated
    public void setDaemonVersion(String v) {
        this.setString(daemonVersion, v, null);
    }

    @Generated
    public BArchPart getArchPart() {
        return (BArchPart)this.get(archPart);
    }

    @Generated
    public void setArchPart(BArchPart v) {
        this.set(archPart, (BValue)v, null);
    }

    @Generated
    public BOsPart getOsPart() {
        return (BOsPart)this.get(osPart);
    }

    @Generated
    public void setOsPart(BOsPart v) {
        this.set(osPart, (BValue)v, null);
    }

    @Generated
    public BNrePart getNrePart() {
        return (BNrePart)this.get(nrePart);
    }

    @Generated
    public void setNrePart(BNrePart v) {
        this.set(nrePart, (BValue)v, null);
    }

    @Generated
    public BBrandPart getBrandPart() {
        return (BBrandPart)this.get(brandPart);
    }

    @Generated
    public void setBrandPart(BBrandPart v) {
        this.set(brandPart, (BValue)v, null);
    }

    @Generated
    public BVmPart getVmPart() {
        return (BVmPart)this.get(vmPart);
    }

    @Generated
    public void setVmPart(BVmPart v) {
        this.set(vmPart, (BValue)v, null);
    }

    @Generated
    public BModelPart getModelPart() {
        return (BModelPart)this.get(modelPart);
    }

    @Generated
    public void setModelPart(BModelPart v) {
        this.set(modelPart, (BValue)v, null);
    }

    @Generated
    public BModuleList getModuleList() {
        return (BModuleList)this.get(moduleList);
    }

    @Generated
    public void setModuleList(BModuleList v) {
        this.set(moduleList, (BValue)v, null);
    }

    @Generated
    public BVector getOtherParts() {
        return (BVector)this.get(otherParts);
    }

    @Generated
    public void setOtherParts(BVector v) {
        this.set(otherParts, (BValue)v, null);
    }

    @Generated
    public BModuleContent getModuleContent() {
        return (BModuleContent)this.get(moduleContent);
    }

    @Generated
    public void setModuleContent(BModuleContent v) {
        this.set(moduleContent, (BValue)v, null);
    }

    @Generated
    public boolean getStripLineNumbers() {
        return this.getBoolean(stripLineNumbers);
    }

    @Generated
    public void setStripLineNumbers(boolean v) {
        this.setBoolean(stripLineNumbers, v, null);
    }

    @Generated
    public int getMaxStations() {
        return this.getInt(maxStations);
    }

    @Generated
    public void setMaxStations(int v) {
        this.setInt(maxStations, v, null);
    }

    @Generated
    public int getMaxSedonaApps() {
        return this.getInt(maxSedonaApps);
    }

    @Generated
    public void setMaxSedonaApps(int v) {
        this.setInt(maxSedonaApps, v, null);
    }

    @Generated
    public boolean getOsTimeReadonly() {
        return this.getBoolean(osTimeReadonly);
    }

    @Generated
    public void setOsTimeReadonly(boolean v) {
        this.setBoolean(osTimeReadonly, v, null);
    }

    @Generated
    public BTimeZone getOsTimeZone() {
        return (BTimeZone)this.get(osTimeZone);
    }

    @Generated
    public void setOsTimeZone(BTimeZone v) {
        this.set(osTimeZone, (BValue)v, null);
    }

    @Generated
    public boolean getAllowStationRestart() {
        return this.getBoolean(allowStationRestart);
    }

    @Generated
    public void setAllowStationRestart(boolean v) {
        this.setBoolean(allowStationRestart, v, null);
    }

    @Generated
    public String getConfigDistFileName() {
        return this.getString(configDistFileName);
    }

    @Generated
    public void setConfigDistFileName(String v) {
        this.setString(configDistFileName, v, null);
    }

    @Generated
    public boolean getIsNpsdk() {
        return this.getBoolean(isNpsdk);
    }

    @Generated
    public void setIsNpsdk(boolean v) {
        this.setBoolean(isNpsdk, v, null);
    }

    @Generated
    public boolean getSedonaSupported() {
        return this.getBoolean(sedonaSupported);
    }

    @Generated
    public void setSedonaSupported(boolean v) {
        this.setBoolean(sedonaSupported, v, null);
    }

    @Generated
    public boolean getSedonaEnabled() {
        return this.getBoolean(sedonaEnabled);
    }

    @Generated
    public void setSedonaEnabled(boolean v) {
        this.setBoolean(sedonaEnabled, v, null);
    }

    @Generated
    public boolean getNiagaraStationsEnabled() {
        return this.getBoolean(niagaraStationsEnabled);
    }

    @Generated
    public void setNiagaraStationsEnabled(boolean v) {
        this.setBoolean(niagaraStationsEnabled, v, null);
    }

    @Generated
    public boolean getNiagaraR2Supported() {
        return this.getBoolean(niagaraR2Supported);
    }

    @Generated
    public void setNiagaraR2Supported(boolean v) {
        this.setBoolean(niagaraR2Supported, v, null);
    }

    @Generated
    public boolean getNiagaraR2Enabled() {
        return this.getBoolean(niagaraR2Enabled);
    }

    @Generated
    public void setNiagaraR2Enabled(boolean v) {
        this.setBoolean(niagaraR2Enabled, v, null);
    }

    @Generated
    public boolean getPlatformSSLSupported() {
        return this.getBoolean(platformSSLSupported);
    }

    @Generated
    public void setPlatformSSLSupported(boolean v) {
        this.setBoolean(platformSSLSupported, v, null);
    }

    @Generated
    public BPlatformSSLSettings getPlatformSSLSettings() {
        return (BPlatformSSLSettings)this.get(platformSSLSettings);
    }

    @Generated
    public void setPlatformSSLSettings(BPlatformSSLSettings v) {
        this.set(platformSSLSettings, (BValue)v, null);
    }

    @Generated
    public BVector getSupportedRuntimeProfilesVector() {
        return (BVector)this.get(supportedRuntimeProfilesVector);
    }

    @Generated
    public void setSupportedRuntimeProfilesVector(BVector v) {
        this.set(supportedRuntimeProfilesVector, (BValue)v, null);
    }

    @Generated
    public String getEnabledRuntimeProfileNames() {
        return this.getString(enabledRuntimeProfileNames);
    }

    @Generated
    public void setEnabledRuntimeProfileNames(String v) {
        this.setString(enabledRuntimeProfileNames, v, null);
    }

    @Generated
    public boolean getIsNiagara4() {
        return this.getBoolean(isNiagara4);
    }

    @Generated
    public void setIsNiagara4(boolean v) {
        this.setBoolean(isNiagara4, v, null);
    }

    @Generated
    public String getPreferredVerificationMode() {
        return this.getString(preferredVerificationMode);
    }

    @Generated
    public void setPreferredVerificationMode(String v) {
        this.setString(preferredVerificationMode, v, null);
    }

    @Generated
    public boolean getAllowBrandChange() {
        return this.getBoolean(allowBrandChange);
    }

    @Generated
    public void setAllowBrandChange(boolean v) {
        this.setBoolean(allowBrandChange, v, null);
    }

    @Generated
    public boolean getIsLicenseReadonly() {
        return this.getBoolean(isLicenseReadonly);
    }

    @Generated
    public void setIsLicenseReadonly(boolean v) {
        this.setBoolean(isLicenseReadonly, v, null);
    }

    @Generated
    public boolean getIsSoftwareReadonly() {
        return this.getBoolean(isSoftwareReadonly);
    }

    @Generated
    public void setIsSoftwareReadonly(boolean v) {
        this.setBoolean(isSoftwareReadonly, v, null);
    }

    @Generated
    public boolean getIsNiagaraHomeReadonly() {
        return this.getBoolean(isNiagaraHomeReadonly);
    }

    @Generated
    public void setIsNiagaraHomeReadonly(boolean v) {
        this.setBoolean(isNiagaraHomeReadonly, v, null);
    }

    @Generated
    public void checkSession() {
        this.invoke(checkSession, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDaemonPlatform() {
    }

    public BDaemonPlatform(BDaemonSession session) {
        this.session = session;
        this.localInstance = true;
    }

    public final BPart getPart(String partName, BTypeSpec partType) {
        try {
            return this.getPart(partName, partType, null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public final BPart getPart(BPart part) {
        return this.getPart(part.getPartName(), part.getType().getTypeSpec());
    }

    public final BPart getPart(BDependency depend) {
        return this.getPart(depend.getPartName(), depend.getPartTypeSpec());
    }

    public Set<RuntimeProfile> getEnabledRuntimeProfiles() {
        TreeSet<RuntimeProfile> allowedRuntimeProfiles = new TreeSet<RuntimeProfile>();
        for (String profileName : this.getEnabledRuntimeProfileNames().split(",")) {
            allowedRuntimeProfiles.add(RuntimeProfile.valueOf((String)profileName));
        }
        return allowedRuntimeProfiles;
    }

    public final boolean allowsProfile(RuntimeProfile profile) {
        return !this.getIsNiagara4() || this.getEnabledRuntimeProfiles().contains(profile);
    }

    public final SupportLevel getSupportForRuntimeProfile(RuntimeProfile profile) {
        Property prop = this.getSupportedRuntimeProfilesVector().getProperty(SlotPath.escape((String)profile.name()));
        if (prop == null) {
            return SupportLevel.unsupported;
        }
        return SupportLevel.valueOf((String)this.getSupportedRuntimeProfilesVector().get(prop).toString());
    }

    public final BDaemonSession getDaemonSession() {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BDaemonPlatform");
        }
        return this.session;
    }

    public boolean meets(BDependency depend) {
        BPart candidate = this.getPart(depend);
        return candidate != null && candidate.meets(depend);
    }

    protected final void init() throws ConnectException, AuthenticationException {
        this.init(null);
    }

    protected void init(DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        BDaemonSession session = this.getDaemonSession();
        if (session == null) {
            return;
        }
        if (session.getHostProperties().getHostId().trim().length() == 0) {
            session.reloadHostProperties();
        }
        try {
            XElem currentTimeElem = DaemonTimeUtil.getCurrentTimeElem(session);
            BTimeZone tz = DaemonTimeUtil.getOsTimeZone(currentTimeElem);
            if (tz != null) {
                this.setOsTimeZone(tz);
            }
            this.setOsTimeReadonly(DaemonTimeUtil.isSystemTimeReadonly(session, currentTimeElem));
        }
        catch (RuntimeException | ConnectException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        this.daemonTimestamp = session.getHostProperties().getSessionTimestamp();
        this.setModuleContent(session.getHostProperties().getModuleContent());
        this.setEnabledRuntimeProfileNames(session.getHostProperties().getEnabledRuntimeProfileNames());
        this.setSupportedRuntimeProfilesVector((BVector)session.getHostProperties().getSupportedRuntimeProfilesVector().newCopy(true));
        this.setStripLineNumbers(session.getHostProperties().getStripLineNumbers());
        this.setMaxStations(session.getHostProperties().getMaxStations());
        this.setMaxSedonaApps(session.getHostProperties().getMaxSedonaApps());
        this.setIsNiagara4(session.getHostProperties().isNiagara4());
        this.setSedonaSupported(session.getHostProperties().getSedonaSupported());
        this.setSedonaEnabled(session.getHostProperties().getSedonaEnabled());
        this.setNiagaraStationsEnabled(session.getHostProperties().getNiagaraStationsEnabled());
        this.setAllowStationRestart(session.getHostProperties().getAllowStationRestart());
        this.setAllowBrandChange(session.getHostProperties().getAllowBrandChange());
        this.setIsLicenseReadonly(session.getHostProperties().getIsLicenseReadonly());
        this.setIsSoftwareReadonly(session.getHostProperties().getIsSoftwareReadonly());
        this.setIsNiagaraHomeReadonly(session.getHostProperties().getIsNiagaraHomeReadonly());
        this.setNiagaraR2Supported(session.getHostProperties().getNiagaraR2Supported());
        boolean niagaraR2EnabledAndFound = false;
        if (session.getHostProperties().getNiagaraR2Supported() && BDaemonDirectoryStore.make(session.getFileSpace(), new FilePath("/niagara/niagaraR2")) != null && session.getHostProperties().getNiagaraR2Enabled()) {
            niagaraR2EnabledAndFound = true;
        }
        this.setNiagaraR2Enabled(niagaraR2EnabledAndFound);
        this.setPlatformSSLSupported(session.getHostProperties().getSslSupported());
        if (session.getHostProperties().getSslSupported()) {
            BPlatformSSLSettings remoteSettings = session.getHostProperties().getSslSettings();
            this.setPlatformSSLSettings(new BPlatformSSLSettings(remoteSettings));
        }
        this.setHostName(session.getRemoteHost().getHostname());
        if (session.getHostProperties().getHttpPort() != -1) {
            this.setPort(session.getHostProperties().getHttpPort());
        } else {
            this.setPort(session.getRemotePort());
        }
        this.setDaemonVersion(session.getHostProperties().getDaemonVersion());
        this.setHostId(session.getHostProperties().getHostId());
        this.setArchPart(new BArchPart(session.getHostProperties().getHostArch(), null));
        if (session.getHostProperties().getIsVmUnspecified()) {
            this.setVmPart(new BVmPart());
        } else if (session.getHostProperties().getVmName().equals("unknown")) {
            this.setVmPart(BVmPart.makeNull());
        } else {
            this.setVmPart(new BVmPart(session.getHostProperties().getVmName(), new BVersion(session.getHostProperties().getVmVendor(), session.getHostProperties().getVmVersion()), null));
        }
        this.setModelPart(new BModelPart(session.getHostProperties().getModelName(), session.getHostProperties().getProductName(), new BVersion(null, session.getHostProperties().getModelVersion()), null));
        this.setOsPart(new BOsPart(session.getHostProperties().getOsName(), session.getHostProperties().getOsDesc(), new BVersion(null, session.getHostProperties().getOsVersion()), null, session.getHostProperties().getOsInstallable()));
        if (session.getHostProperties().getNrePartDesc().equals("unknown") || session.getHostProperties().getNrePartName().contains("-???")) {
            this.setNrePart(BNrePart.makeNull());
        } else {
            this.setNrePart(new BNrePart(session.getHostProperties().getNrePartName(), session.getHostProperties().getNrePartDesc(), new BVersion(null, session.getHostProperties().getNrePartVersion()), null));
        }
        this.setBrandPart(new BBrandPart(session.getHostProperties().getBrandId(), null));
        this.getOtherParts().removeAll();
        SlotCursor c = session.getHostProperties().getParts().getProperties();
        while (c.next()) {
            BPart originalPart = (BPart)c.get();
            BPart newPart = (BPart)originalPart.newCopy();
            if (originalPart instanceof BGenericPart) {
                ((BGenericPart)newPart).setIsInstallable(originalPart.isInstallable());
            }
            this.getOtherParts().add(c.property().getName(), (BValue)newPart);
        }
        this.setConfigDistFileName(session.getHostProperties().getConfigDistFileName());
        this.setIsNpsdk(session.getHostProperties().getIsNpsdk());
        this.sessionInvalid = false;
    }

    public void loadPreferredVerificationMode() {
        BDaemonSession session = this.getDaemonSession();
        if (session == null) {
            return;
        }
        ModuleVerificationMode sysPropertiesPref = ModuleVerificationMode.noPreference;
        BIFile file = session.getFileSpace().findFile(SystemFilePaths.getSystemPropertiesPath(session.getHostProperties().getIsNiagaraHomeReadonly()));
        if (file != null) {
            try (InputStream inputStream = file.getInputStream();){
                Properties properties = new Properties();
                properties.load(inputStream);
                String verificationProp = properties.getProperty("niagara.moduleVerificationMode");
                if (verificationProp != null) {
                    try {
                        sysPropertiesPref = ModuleVerificationMode.valueOf((String)verificationProp);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warning("Invalid argument provided for niagara.moduleVerificationMode property: " + verificationProp);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warning("Error checking system.properties for module verification mode: " + e.getMessage());
            }
        }
        this.setPreferredVerificationMode(sysPropertiesPref.name());
    }

    public final void checkSession(DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        this.doCheckSession(listener);
    }

    public final void doCheckSession() throws ConnectException, AuthenticationException {
        this.doCheckSession(null);
    }

    public void doCheckSession(DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        if (this.shouldInitialize()) {
            this.init(listener);
        }
    }

    protected boolean shouldInitialize() {
        return this.localInstance && (this.getDaemonSession() == null || !this.getDaemonSession().getHostProperties().getSessionTimestamp().equals(this.daemonTimestamp) || this.sessionInvalid);
    }

    public void requestReload() {
        this.sessionInvalid = true;
    }

    public BPart getPart(String name, BTypeSpec partType, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        BPart candidate;
        this.checkSession(listener);
        if (partType == null) {
            return this.getPartCompat(name, listener);
        }
        if (partType.equals((Object)BArchPart.TYPE.getTypeSpec())) {
            candidate = this.getArchPart();
        } else if (partType.equals((Object)BOsPart.TYPE.getTypeSpec())) {
            candidate = this.getOsPart();
        } else if (partType.equals((Object)BBrandPart.TYPE.getTypeSpec())) {
            candidate = this.getBrandPart();
        } else if (partType.equals((Object)BModelPart.TYPE.getTypeSpec())) {
            candidate = this.getModelPart();
        } else if (partType.equals((Object)BNrePart.TYPE.getTypeSpec())) {
            candidate = this.getNrePart();
        } else if (partType.equals((Object)BVmPart.TYPE.getTypeSpec())) {
            candidate = this.getVmPart();
        } else {
            if (partType.equals((Object)BModulePart.TYPE.getTypeSpec())) {
                BModuleList moduleList = this.getModuleList();
                moduleList.init(listener);
                return moduleList.getPart(name);
            }
            candidate = (BPart)this.getOtherParts().get(SlotPath.escape((String)name));
        }
        if (candidate != null && candidate.matchesName(name)) {
            return candidate;
        }
        return null;
    }

    public BPart getSingleModulePart(String name, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        BModuleList moduleList = this.getModuleList();
        if (name != null && name.equalsIgnoreCase("baja") && moduleList instanceof BRemoteModuleList) {
            BRemoteModuleList remoteList = (BRemoteModuleList)moduleList;
            try {
                String moduleName;
                XElem module;
                XElem[] modules = remoteList.fetchModules(name, null);
                if (modules.length == 1 && (module = modules[0]) != null && (module = module.elem("module")) != null && (moduleName = module.get("name", null)) != null && moduleName.equalsIgnoreCase("baja")) {
                    return BModulePart.make(moduleName, module);
                }
                remoteList.setModuleElems(modules);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        moduleList.init(listener);
        return moduleList.getPart(name);
    }

    protected BPart getPartCompat(String name, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        if (!this.getArchPart().isNull() && this.getArchPart().matchesName(name)) {
            return this.getArchPart();
        }
        if (!this.getOsPart().isNull() && this.getOsPart().matchesName(name)) {
            return this.getOsPart();
        }
        if (!this.getBrandPart().isNull() && this.getBrandPart().matchesName(name)) {
            return this.getBrandPart();
        }
        if (!this.getModelPart().isNull() && this.getModelPart().matchesName(name)) {
            return this.getModelPart();
        }
        if (!this.getNrePart().isNull() && this.getNrePart().matchesName(name)) {
            return this.getNrePart();
        }
        BPart part = (BPart)this.getOtherParts().get(SlotPath.escape((String)name));
        if (part != null) {
            return part;
        }
        if (this.getVmPart().matchesName(name)) {
            return this.getVmPart();
        }
        this.getModuleList().init(listener);
        return this.getModuleList().getPart(name);
    }

    public BIcon getIcon() {
        if (icon == null) {
            icon = BIcon.std((String)"daemon.png");
        }
        return icon;
    }

    public String getNavDescription(Context cx) {
        return this.getLexicon().getText("DaemonPlatform.navDescription", new Object[]{this.getHostName()});
    }

    static {
        LOGGER = Logger.getLogger("platform");
    }
}

