/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.wb;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.bacnet.ui.point.BBacnetPointManager;
import com.tridium.bacnetEde.BEdeConfig;
import com.tridium.bacnetEde.BEdeRecord;
import com.tridium.bacnetEde.jobs.BPointDiscoveryJob;
import com.tridium.bacnetEde.util.EDEUtil;
import com.tridium.bacnetEde.wb.BEdeConfigSelector;
import com.tridium.bacnetEde.wb.BWbEdeService;
import com.tridium.bacnetEde.wb.EdePointLearn;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.point.BBacnetBooleanProxyExt;
import javax.baja.bacnet.point.BBacnetEnumProxyExt;
import javax.baja.bacnet.point.BBacnetNumericProxyExt;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.point.BBacnetStringProxyExt;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.tool.WbServiceManager;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetPointDeviceExt", "bacnet:BacnetPointFolder"}, defaultAgent=AgentOn.Preference.NOT_PREFERRED)})
public class BEdeBacnetPointManager
extends BPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BEdeBacnetPointManager.class);
    public static final Logger logger = Logger.getLogger("bacnet.ede.bacnetPointManager");
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BBacnetPointManager.class);
    static BImage bacnetObjectIcon = BImage.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
    static BImage numericIcon = BImage.make((String)"module://icons/x16/control/numericPoint.png");
    static BImage booleanIcon = BImage.make((String)"module://icons/x16/control/booleanPoint.png");
    static BImage enumIcon = BImage.make((String)"module://icons/x16/control/enumPoint.png");
    static BImage stringIcon = BImage.make((String)"module://icons/x16/control/stringPoint.png");
    static BImage logIcon = BImage.make((String)"module://icons/x16/history.png");
    static BImage scheduleIcon = BImage.make((String)"module://icons/x16/schedule.png");
    static BImage calendarIcon = BImage.make((String)"module://icons/x16/calendar.png");
    static Lexicon driverLex = Lexicon.make((String)"driver");
    static String lexOut = driverLex.getText("out");
    private static final Lexicon lex = Lexicon.make(BEdeBacnetPointManager.class);
    private static final String LBL_CONFIG_TITLE = lex.getText("edeconfig.labels.filechooser.title");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colValue = new MgrColumn.ToString(lexOut, 0);
    MgrColumn colOid = new MgrColumn.PropPath(lexicon.getText("learn.objectId"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.objectId}, 1);
    MgrColumn colProperty = new MgrColumn.PropPath(lexicon.getText("pointManager.property"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.propertyId}, 1);
    MgrColumn colIndex = new MgrColumn.PropPath(lexicon.getText("pointManager.index"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.propertyArrayIndex}, 1);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn colAsnType = new MgrColumn.PropPath(lexicon.getText("pointManager.dataType"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.dataType}, 7);
    MgrColumn colReadStatus = new MgrColumn.PropPath(lexicon.getText("pointManager.read"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.readStatus}, 5);
    MgrColumn colWriteStatus = new MgrColumn.PropPath(lexicon.getText("pointManager.write"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.writeStatus}, 5);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.deviceFacets}, 7);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.conversion}, 3);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colEnabled, this.colOid, this.colProperty, this.colIndex, this.colTuning, this.colAsnType, this.colReadStatus, this.colWriteStatus, this.colDeviceFacets, this.colFacets, this.colConversion, this.colReadValue, this.colWriteValue, this.colFaultCause};
    private BBacnetPointDeviceExt deviceExt;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    public void started() throws Exception {
        super.started();
        WbServiceManager manager = BWbEdeService.getManager();
        if (!manager.isRunning(BWbEdeService.TYPE.getTypeInfo())) {
            manager.start(BWbEdeService.TYPE.getTypeInfo());
        }
    }

    public void doLoadValue(BObject obj, Context cx) {
        try {
            this.deviceExt = (BBacnetPointDeviceExt)((BIPointFolder)obj).getDeviceExt();
            super.doLoadValue(obj, cx);
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        BJob lrnJob = this.getLearn().getJob();
        if (event.getId() == 1 && lrnJob != null && lrnJob instanceof BPointDiscoveryJob && event.getSourceComponent() == lrnJob) {
            try {
                this.getLearn().updateRoots(lrnJob.getChildren(BDiscoveryPoint.class));
            }
            catch (Exception e) {
                EDEUtil.logThrowableIfFine(logger, Level.WARNING, "Error to update the root point discovery objects", e);
            }
        }
    }

    public BBacnetPointDeviceExt getDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BBacnetPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
        }
        return this.deviceExt;
    }

    public BBacnetDevice getDevice() {
        return (BBacnetDevice)this.getDeviceExt().getDevice();
    }

    class Learn
    extends EdePointLearn {
        Learn(BEdeBacnetPointManager mgr) {
            super(mgr);
        }

        public BImage getIcon(Object dis) {
            BDiscoveryPoint plr = this.lr(dis);
            try {
                int propertyId = plr.getPropertyId();
                int asnType = -1;
                PropertyInfo info = BEdeBacnetPointManager.this.getDevice().getPropertyInfo(plr.getObjectId().getObjectType(), propertyId);
                asnType = info != null ? info.getAsnType() : AsnUtil.getAsnType((Type)plr.getValue().getType());
                switch (asnType) {
                    case 0: {
                        return stringIcon;
                    }
                    case 1: {
                        return booleanIcon;
                    }
                    case 2: 
                    case 3: {
                        return enumIcon;
                    }
                    case 4: 
                    case 5: {
                        return numericIcon;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return stringIcon;
                    }
                    case 9: {
                        if (info != null && info.getType().equals("bacnet:BacnetBinaryPv")) {
                            return booleanIcon;
                        }
                        return enumIcon;
                    }
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 10: 
                    case 11: 
                    case 12: {
                        return stringIcon;
                    }
                }
            }
            catch (Exception e) {
                EDEUtil.logThrowableIfFine(logger, Level.WARNING, "Error getting icon for discovery point:" + plr, e);
            }
            return bacnetObjectIcon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BWbShell shell = this.getManager().getWbShell();
            shell.enterBusy();
            try {
                BDiscoveryPoint lr = this.lr(dis);
                BControlPoint pt = (BControlPoint)row.getTarget();
                int propertyId = lr.getPropertyId();
                PropertyInfo info = BEdeBacnetPointManager.this.getDevice().getPropertyInfo(lr.getObjectId().getObjectType(), propertyId);
                String ptName = lr.getObjectName();
                if (ptName == null || ptName.length() == 0) {
                    ptName = lr.getObjectId().toString();
                }
                if (lr.getPropertyId() != 85) {
                    ptName = ptName + "-" + lr.getPropertyIdentifier();
                }
                if (lr.getIndex().length() > 0) {
                    ptName = ptName + "_" + lr.getIndex();
                }
                ptName = SlotPath.escape((String)TextUtil.replace((String)ptName, (String)"/", (String)"."));
                row.setDefaultName(ptName);
                row.setCell(BEdeBacnetPointManager.this.colOid, (BValue)lr.getObjectId());
                row.setCell(BEdeBacnetPointManager.this.colProperty, (BValue)BDynamicEnum.make((int)propertyId, (BEnumRange)BEnumRange.make((Type)BBacnetPropertyIdentifier.TYPE)));
                if (lr.getIndex().length() > 0) {
                    row.setCell(BEdeBacnetPointManager.this.colIndex, (BValue)BInteger.make((String)lr.getIndex()));
                }
                if (info != null) {
                    row.setCell(BEdeBacnetPointManager.this.colAsnType, (BValue)BString.make((String)info.getDataType()));
                }
                String writeSts = "readonly";
                if (pt.isWritablePoint()) {
                    writeSts = "writable";
                }
                row.setCell(BEdeBacnetPointManager.this.colWriteStatus, (BValue)BString.make((String)writeSts));
                row.setCell(BEdeBacnetPointManager.this.colReadStatus, (BValue)BString.make((String)"unsubscribed"));
                BFacets lrFacets = lr.getFacets();
                BObject bObject = lrFacets.get(BEdeRecord.settable.getName());
                boolean writablePrioritized = false;
                if (pt.isWritablePoint()) {
                    int objectType = lr.getObjectId().getObjectType();
                    if (objectType == 1 || objectType == 4 || objectType == 14) {
                        writablePrioritized = true;
                    }
                    if (objectType == 2 || objectType == 5 || objectType == 19) {
                        boolean bl = writablePrioritized = null != bObject && bObject.getType().is(BBoolean.TYPE) && bObject.toString().equals(BBoolean.TRUE.toString());
                    }
                    if (writablePrioritized) {
                        row.setCell(BEdeBacnetPointManager.this.colEnabled, (BValue)BBoolean.make((boolean)false));
                    }
                }
                BFacets facets = pt.getFacets();
                if (info != null) {
                    if (info.isEnum()) {
                        BEnum en = (BEnum)BTypeSpec.make((String)info.getType()).getInstance();
                        BEnumRange r = en.getRange();
                        if (info.isExtensible()) {
                            r = BEdeBacnetPointManager.this.getDevice().getEnumerationList().getEnumRange(info.getType());
                        }
                        lrFacets = BFacets.make((BFacets)lrFacets, (String)"range", (BIDataValue)r);
                    }
                    if (info.getFacetControl().equals("all")) {
                        facets = lrFacets;
                    } else if (info.getFacetControl().equals("units")) {
                        facets = BFacets.make((String)"units", (BIDataValue)((BUnit)lrFacets.getFacet("units")));
                    } else if (!info.getFacetControl().equals("no") && lrFacets != null && !lrFacets.isNull()) {
                        facets = lrFacets;
                    }
                }
                try {
                    this.setFallback(pt, lrFacets);
                }
                catch (Exception e) {
                    EDEUtil.logThrowableIfFine(logger, Level.WARNING, "Error attempting to upgrade key material", e);
                }
                row.setCell(BEdeBacnetPointManager.this.colDeviceFacets, (BValue)facets);
                facets = BFacets.makeRemove((BFacets)facets, (String)"priPV");
                row.setCell(BEdeBacnetPointManager.this.colFacets, (BValue)facets);
            }
            finally {
                shell.exitBusy();
            }
        }

        private void setFallback(BControlPoint pt, BFacets lrFacets) throws Exception {
            BObject presentValDef = lrFacets.get(BEdeRecord.presentValueDefault.getName());
            if (null != presentValDef) {
                if (pt.getType().is(BNumericWritable.TYPE)) {
                    ((BNumericWritable)pt).setFallback(new BStatusNumeric(Double.parseDouble(presentValDef.toString())));
                } else if (pt.getType().is(BBooleanWritable.TYPE)) {
                    String strVal = presentValDef.toString();
                    boolean defVal = false;
                    if (strVal.toLowerCase().startsWith("y") || strVal.toLowerCase().startsWith("true")) {
                        defVal = true;
                    }
                    ((BBooleanWritable)pt).setFallback(new BStatusBoolean(defVal));
                } else if (pt.getType().is(BStringWritable.TYPE)) {
                    ((BStringWritable)pt).setFallback(new BStatusString(presentValDef.toString()));
                } else if (pt.getType().is(BEnumWritable.TYPE)) {
                    String strVal = presentValDef.toString();
                    int ordinal = Integer.parseInt(strVal);
                    ((BEnumWritable)pt).setFallback(new BStatusEnum((BEnum)BDynamicEnum.make((int)ordinal)));
                }
            }
        }
    }

    private class Controller
    extends PointController {
        public Controller(BPointManager manager) {
            super(manager);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BEdeConfigSelector content = new BEdeConfigSelector();
            int open = BDialog.open((BWidget)this.getManager(), (String)LBL_CONFIG_TITLE, (Object)((Object)content), (int)3);
            if (open == 1) {
                try {
                    BEdeConfig config = content.getSelectedConfig();
                    BBacnetDevice device = BEdeBacnetPointManager.this.getDevice();
                    device.lease();
                    BBacnetConfigDeviceExt deviceConfig = device.getConfig();
                    deviceConfig.lease();
                    BBacnetDeviceObject deviceObject = deviceConfig.getDeviceObject();
                    deviceObject.lease();
                    int id = deviceObject.getObjectId().getInstanceNumber();
                    config.setDeviceObjInstance(id);
                    config.setDeviceObjInstance(BEdeBacnetPointManager.this.getDevice().getConfig().getDeviceObject().getObjectId().getInstanceNumber());
                    BWbEdeService service = BWbEdeService.getService();
                    BOrd jobOrd = service.submitPointDiscovery(config, device, cx);
                    BJob job = (BJob)jobOrd.get();
                    job.lease();
                    BEdeBacnetPointManager.this.registerForComponentEvents((BComponent)job);
                    BEdeBacnetPointManager.this.getLearn().setJob(job);
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            return null;
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.allDescendants, this.edit, this.learnMode, this.discover, this.cancel, this.add};
        }
    }

    class Model
    extends PointModel {
        Model(BEdeBacnetPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BEdeBacnetPointManager.this.cols;
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            CommandArtifact artifact = super.addInstances(rows, cx);
            if (rows.length > 0) {
                BComponent parent = (BComponent)this.getManager().getCurrentValue();
                parent.lease();
                for (int i = 0; i < rows.length; ++i) {
                    MgrEditRow row = rows[i];
                    BDiscoveryPoint disc = (BDiscoveryPoint)row.getDiscovery();
                    BEdeRecord record = (BEdeRecord)disc.get("EDERecord");
                    String objectName = record.getObjectName();
                    String slotName = SlotPath.escape((String)objectName);
                    BValue bValue = parent.get(slotName);
                    if (null == bValue || !bValue.getType().is(BComponent.TYPE)) continue;
                    BComponent point = (BComponent)bValue;
                    Property propertyInParent = point.getPropertyInParent();
                    String keyName = record.getKeyName();
                    parent.setDisplayName(propertyInParent, BFormat.make((String)keyName), cx);
                }
            }
            return artifact;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            BNullProxyExt ext = new BNullProxyExt();
            if (pt instanceof BBooleanPoint) {
                ext = new BBacnetBooleanProxyExt();
            } else if (pt instanceof BNumericPoint) {
                ext = new BBacnetNumericProxyExt();
            } else if (pt instanceof BEnumPoint) {
                ext = new BBacnetEnumProxyExt();
            } else if (pt instanceof BStringPoint) {
                ext = new BBacnetStringProxyExt();
            }
            if (ext instanceof BProxyExt) {
                BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
                ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            }
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }
    }
}

