/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.jobs;

import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.bacnetEde.BEdeConfig;
import com.tridium.bacnetEde.BEdeReader;
import com.tridium.bacnetEde.BEdeRecord;
import com.tridium.bacnetEde.EdeCursor;
import com.tridium.bacnetEde.util.EDEUtil;
import com.tridium.bacnetEde.wb.BWbEdeService;
import java.util.HashMap;
import java.util.Map;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.data.BIDataValue;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BPointDiscoveryJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BPointDiscoveryJob.class);
    private BEdeConfig config;
    private int deviceId = -1;
    private BBacnetDevice device;
    private static final Lexicon lex = Lexicon.make(BPointDiscoveryJob.class);
    private static Map<Property, String> facetNamingMap;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPointDiscoveryJob() {
    }

    public BPointDiscoveryJob(BEdeConfig config, BBacnetDevice device) {
        this.config = config;
        this.device = device;
        this.deviceId = config.getDeviceObjInstance();
    }

    public BBacnetDevice device() {
        return this.device;
    }

    public void run(Context cx) throws Exception {
        if (null == this.config || null == this.config.getEdePath()) {
            this.failed((Throwable)new BajaRuntimeException("EDE files not specified"));
        }
        BWbEdeService service = BWbEdeService.getService();
        BEdeReader reader = service.getReader(this.config);
        try (EdeCursor cursor = (EdeCursor)reader.cursor();){
            cursor.setJobLog(this.log());
            this.log().message(lex.getText("edeimport.discover.point.job.iterateThroughEDE"));
            while (cursor.next()) {
                BEdeRecord record = (BEdeRecord)((Object)cursor.get());
                if (!EDEUtil.isPoint(record.getObjectType().getOrdinal()) || record.getDeviceObjInstant() != this.deviceId) continue;
                BBacnetObjectType objectType = record.getObjectType();
                int objInstance = record.getObjInstance();
                BBacnetObjectIdentifier pointId = BBacnetObjectIdentifier.make((int)objectType.getOrdinal(), (int)objInstance);
                String name = record.getObjectName();
                BFacets facetsMap = this.makeFacetMap(record, objectType);
                String primaryPropId = this.getPrimaryPropertyID(pointId);
                BDiscoveryPoint dp = new BDiscoveryPoint(name, pointId, primaryPropId, (BValue)BString.make((String)lex.getText("edeimport.discover.point.value.offline")), facetsMap, false);
                dp.add("EDERecord", record.newCopy());
                this.add(null, (BValue)dp);
            }
            if (cursor.isParseFailure()) {
                throw new BajaRuntimeException(lex.getText("edeimport.edeCursor.discover.failDiscovery"));
            }
            this.log().message(lex.getText("edeimport.edeCursor.discover.point.successDiscoverPoints", new Object[]{this.deviceId}));
        }
    }

    private String getPrimaryPropertyID(BBacnetObjectIdentifier objectId) {
        int objectType = objectId.getObjectType();
        switch (objectType) {
            case 8: {
                return BBacnetPropertyIdentifier.systemStatus.getTag();
            }
            case 29: {
                return BBacnetPropertyIdentifier.nodeType.getTag();
            }
            case 18: {
                return BBacnetPropertyIdentifier.averageValue.getTag();
            }
            case 9: {
                return BBacnetPropertyIdentifier.eventState.getTag();
            }
            case 10: {
                return BBacnetPropertyIdentifier.fileSize.getTag();
            }
            case 15: {
                return BBacnetPropertyIdentifier.notificationClass.getTag();
            }
            case 16: {
                return BBacnetPropertyIdentifier.programState.getTag();
            }
            case 20: 
            case 25: 
            case 27: {
                return BBacnetPropertyIdentifier.recordCount.getTag();
            }
        }
        return BBacnetPropertyIdentifier.presentValue.getTag();
    }

    private BFacets makeFacetMap(BEdeRecord record, BBacnetObjectType objectType) {
        boolean isNumericPoint = EDEUtil.isNumericPoint(objectType.getOrdinal());
        boolean isBooleanPoint = EDEUtil.isBooleanPoint(objectType.getOrdinal());
        boolean isMultiStatePoint = EDEUtil.isMultiStatePoint(objectType.getOrdinal());
        BFacets facets = BFacets.DEFAULT;
        try (SlotCursor properties = record.getProperties();){
            while (properties.next()) {
                String facetName;
                Property p = properties.property();
                if (!isNumericPoint && (p.equals(BEdeRecord.minPresentValue) || p.equals(BEdeRecord.maxPresentValue) || p == BEdeRecord.hiLimit || p == BEdeRecord.lowLimit || p == BEdeRecord.units) || !isBooleanPoint && !isMultiStatePoint && p.equals(BEdeRecord.stateTextRange) || null == (facetName = facetNamingMap.get(p))) continue;
                BValue defaultValue = p.getDefaultValue();
                BValue bValue = record.get(p);
                if (bValue.equals((Object)defaultValue)) continue;
                if (bValue instanceof BIDataValue) {
                    facets = BFacets.make((BFacets)facets, (String)facetName, (BIDataValue)((BIDataValue)bValue));
                    continue;
                }
                if (!(bValue instanceof BFacets)) continue;
                facets = BFacets.make((BFacets)facets, (BFacets)((BFacets)bValue));
            }
        }
        return facets;
    }

    static {
        HashMap<Property, String> temp = new HashMap<Property, String>();
        temp.put(BEdeRecord.description, BEdeRecord.description.getName());
        temp.put(BEdeRecord.hiLimit, BEdeRecord.hiLimit.getName());
        temp.put(BEdeRecord.lowLimit, BEdeRecord.lowLimit.getName());
        temp.put(BEdeRecord.maxPresentValue, "max");
        temp.put(BEdeRecord.minPresentValue, "min");
        temp.put(BEdeRecord.presentValueDefault, BEdeRecord.presentValueDefault.getName());
        temp.put(BEdeRecord.units, "units");
        temp.put(BEdeRecord.stateTextRange, BEdeRecord.stateTextRange.getName());
        temp.put(BEdeRecord.settable, BEdeRecord.settable.getName());
        temp.put(BEdeRecord.cov, BEdeRecord.cov.getName());
        temp.put(BEdeRecord.notificationClass, BEdeRecord.notificationClass.getName());
        facetNamingMap = temp;
    }
}

