/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.visual;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.co.westhawk.visual.BareGraph;
import uk.co.westhawk.visual.GraphDataSet;

public class Graph
extends JPanel
implements PropertyChangeListener {
    private static final String version_id = "@(#)$Id: Graph.java,v 1.8 2006/11/29 16:12:51 birgit Exp $ Copyright Westhawk Ltd";
    static final Color WHEAT = new Color(234, 234, 222);
    private static final String base = "graph";
    private static int nameCounter = 0;
    private GraphDataSet dataSet;
    private BareGraph gra;
    private boolean doAxes = true;
    private GridBagLayout lay;
    private JLabel name;
    private JLabel value;
    private JLabel max;
    private JLabel min;
    private JLabel xrange;
    private JLabel units;

    public Graph() {
        this((GraphDataSet)null);
    }

    public Graph(GraphDataSet d) {
        super.setName(base + nameCounter++);
        this.setBackground(WHEAT);
        this.makeGraph();
        this.setDataSet(d);
    }

    public void setLog(boolean b) {
        this.gra.setLog(b);
    }

    public boolean isLog() {
        return this.gra.isLog();
    }

    public void setAxes(boolean b) {
        if (b != this.doAxes) {
            this.doAxes = b;
            this.gra.setAxes(b);
            this.changeAxes();
        }
    }

    public boolean isAxes() {
        return this.doAxes;
    }

    public int getMin() {
        return this.gra.getMin();
    }

    public void setMin(int m) {
        this.gra.setMin(m);
        this.min.setText(String.valueOf(m));
    }

    public int getMax() {
        return this.gra.getMax();
    }

    public void setMax(int m) {
        this.gra.setMax(m);
        this.max.setText(String.valueOf(m));
    }

    public void setXRange(String x) {
        this.xrange.setText(x);
    }

    public void setUnit(String u) {
        this.units.setText(u);
    }

    @Override
    public void setName(String n) {
        this.name.setText(n);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.max != null) {
            this.max.setFont(f);
            this.value.setFont(f);
            this.min.setFont(f);
            this.name.setFont(f);
            this.units.setFont(f);
            this.xrange.setFont(f);
            this.repaint();
        }
    }

    @Override
    public Font getFont() {
        return super.getFont();
    }

    public Color getAxisColour() {
        return this.gra.getAxisColour();
    }

    public void setAxisColour(Color c) {
        this.gra.setAxisColour(c);
    }

    public Color getGraphColour() {
        return this.gra.getGraphColour();
    }

    public void setGraphColour(Color c) {
        this.gra.setGraphColour(c);
    }

    public float getAxisPercent() {
        return this.gra.getAxisPercent();
    }

    public void setAxisPercent(float x) {
        this.gra.setAxisPercent(x);
    }

    public void setDataSet(GraphDataSet d) {
        if (this.dataSet != null) {
            this.dataSet.removePropertyChangeListener(this);
        }
        this.dataSet = d;
        if (this.dataSet != null) {
            this.dataSet.addPropertyChangeListener(this);
        }
        this.gra.setDataSet(d);
    }

    public GraphDataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Integer newV = (Integer)evt.getNewValue();
        this.value.setText(newV.toString());
    }

    private void makeGraph() {
        this.lay = new GridBagLayout();
        this.max = new JLabel("Maximum", 2);
        this.value = new JLabel("0", 2);
        this.min = new JLabel("Minimum", 2);
        this.name = new JLabel("The name goes here", 2);
        this.units = new JLabel("(b/s)", 2);
        this.xrange = new JLabel("Time", 4);
        this.gra = new BareGraph();
        this.setLayout(this.lay);
        this.changeAxes();
        this.setBackgroundColour(this.name);
        this.setBackgroundColour(this.max);
        this.setBackgroundColour(this.min);
        this.setBackgroundColour(this.value);
        this.setBackgroundColour(this.xrange);
        this.setBackgroundColour(this.units);
    }

    private void changeAxes() {
        this.removeAll();
        int x = 0;
        if (this.doAxes) {
            this.addToGridBag(this.lay, this, this.max, x, 1, 0.1, 0.0, 2, 11);
            this.addToGridBag(this.lay, this, this.min, x, 2, 0.1, 0.0, 2, 15);
            this.addToGridBag(this.lay, this, this.xrange, x + 1, 3, 1.0, 0.0, 3, 1, 2, 13);
            ++x;
        }
        this.addToGridBag(this.lay, this, this.gra, x, 1, 0.9, 1.0, 3, 2, 1, 10);
        this.addToGridBag(this.lay, this, this.name, x, 0, 0.0, 0.0, 0);
        this.addToGridBag(this.lay, this, this.value, x + 1, 0, 0.1, 0.0, 2);
        this.addToGridBag(this.lay, this, this.units, x + 2, 0, 0.0, 0.0, 0);
    }

    void setBackgroundColour(Component j) {
        j.setBackground(WHEAT);
    }

    protected void addToGridBag(GridBagLayout grid, Container cont, Component comp, int x, int y, double wx, double wy) {
        this.addToGridBag(grid, cont, comp, x, y, wx, wy, 1);
    }

    protected void addToGridBag(GridBagLayout grid, Container cont, Component comp, int x, int y, double wx, double wy, int fill) {
        this.addToGridBag(grid, cont, comp, x, y, wx, wy, fill, 10);
    }

    protected void addToGridBag(GridBagLayout grid, Container cont, Component comp, int x, int y, double wx, double wy, int fill, int anchor) {
        this.addToGridBag(grid, cont, comp, x, y, wx, wy, 1, 1, fill, anchor);
    }

    protected void addToGridBag(GridBagLayout grid, Container cont, Component comp, int x, int y, double wx, double wy, int gw, int gh, int fill, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.fill = fill;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.anchor = anchor;
        cont.add(comp);
        grid.setConstraints(comp, gbc);
    }
}

