/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.visual;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import uk.co.westhawk.visual.GraphDataSet;

public class BareGraph
extends Component
implements PropertyChangeListener {
    private static final String version_id = "@(#)$Id: BareGraph.java,v 1.9 2006/11/29 16:12:50 birgit Exp $ Copyright Westhawk Ltd";
    GraphDataSet dataSet;
    boolean doLog = false;
    boolean doAxes = true;
    Color graphColour = Color.blue;
    Color axisColour = Color.red;
    float axispercent = 5.0f;
    double dmax = 5.0E7;
    double dmin = 0.0;
    int min = 0;
    int max = 50000000;
    int numYTicks = 11;
    int numXTicks = 11;
    int[] xline = new int[200];
    int[] yline = new int[200];
    private static final String base = "bareGraph";
    private static int nameCounter = 0;
    Image buffer = null;

    public BareGraph() {
        this(null);
    }

    public BareGraph(GraphDataSet d) {
        super.setName(base + nameCounter++);
        this.setMin(0);
        this.setMax(1000000);
        this.setDataSet(d);
    }

    public void setLog(boolean b) {
        if (b != this.doLog) {
            this.doLog = b;
            this.setMax(this.max);
            this.setMin(this.min);
            this.allDone();
        }
    }

    public boolean isLog() {
        return this.doLog;
    }

    public void setAxes(boolean b) {
        if (b != this.doAxes) {
            this.doAxes = b;
            this.allDone();
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int m) {
        this.max = m;
        this.dmax = this.max;
        if (this.doLog) {
            this.dmax = BareGraph.log10(this.max);
        }
        this.setNumYTicks();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int m) {
        this.min = m;
        this.dmin = this.min;
        if (this.doLog) {
            this.dmin = BareGraph.log10(this.min);
        }
        this.setNumYTicks();
    }

    public Color getAxisColour() {
        return this.axisColour;
    }

    public void setAxisColour(Color c) {
        if (c != this.axisColour) {
            this.axisColour = c;
            this.allDone();
        }
    }

    public Color getGraphColour() {
        return this.graphColour;
    }

    public void setGraphColour(Color c) {
        if (c != this.graphColour) {
            this.graphColour = c;
            this.allDone();
        }
    }

    public float getAxisPercent() {
        return this.axispercent;
    }

    public void setAxisPercent(float x) {
        this.axispercent = x;
    }

    @Override
    public Dimension getPreferredSize() {
        int cap = 100;
        if (this.dataSet != null) {
            cap = this.dataSet.getCapacity();
        }
        int w = cap * 2 + 5;
        int h = this.numYTicks * 5 + 5;
        return new Dimension(w, h);
    }

    @Override
    public Dimension getMinimumSize() {
        int cap = 100;
        if (this.dataSet != null) {
            cap = this.dataSet.getCapacity();
        }
        int w = cap * 1 + 2;
        int h = this.numYTicks * 2 + 2;
        return new Dimension(w, h);
    }

    public void setDataSet(GraphDataSet d) {
        if (this.dataSet != null) {
            this.dataSet.removePropertyChangeListener(this);
        }
        this.dataSet = d;
        if (this.dataSet != null) {
            this.dataSet.addPropertyChangeListener(this);
        }
    }

    public GraphDataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.allDone();
    }

    void allDone() {
        this.repaint(250L);
    }

    @Override
    public void paint(Graphics g) {
        Dimension osize = this.getSize();
        if (this.buffer == null || osize.height != this.buffer.getHeight(null) || osize.width != this.buffer.getWidth(null)) {
            if (this.buffer != null) {
                this.buffer.flush();
            }
            this.buffer = this.createImage(osize.width, osize.height);
        }
        Graphics gc = this.buffer.getGraphics();
        this.drawAll(gc);
        g.drawImage(this.buffer, 0, 0, this);
        gc.dispose();
    }

    void drawAll(Graphics gc) {
        Dimension osize = this.getSize();
        gc.setColor(this.getBackground());
        gc.fillRect(0, 0, osize.width, osize.height);
        gc.clipRect(0, 0, osize.width, osize.height);
        if (this.doAxes) {
            gc.setColor(this.axisColour);
            gc = this.paintAxis(gc);
        }
        gc.setColor(this.getBackground());
        gc.fillRect(0, 0, osize.width, osize.height);
        if (this.dataSet != null) {
            gc.setColor(this.graphColour);
            this.paintLine(gc);
        }
    }

    Graphics paintAxis(Graphics gc) {
        int originx = 0;
        int originy = 0;
        Rectangle space = gc.getClipBounds();
        int yTickLen = (int)((double)((float)space.width * this.axispercent) / 100.0);
        if (yTickLen < 2) {
            yTickLen = 2;
        } else if (yTickLen > 5) {
            yTickLen = 5;
        }
        int xTickLen = (int)((double)((float)space.height * this.axispercent) / 100.0);
        if (xTickLen < 2) {
            xTickLen = 2;
        } else if (xTickLen > 5) {
            xTickLen = 5;
        }
        originx = yTickLen;
        originy = space.height - xTickLen;
        int tickoff = space.height / (this.numYTicks - 1);
        int x1 = 0;
        int x2 = originx;
        int y1 = originy;
        for (int tick = 0; tick < this.numYTicks; ++tick) {
            gc.drawLine(x1, y1, x2, y1);
            y1 -= tickoff;
        }
        gc.drawLine(originx, originy, originx, y1 + tickoff);
        tickoff = space.width / (this.numXTicks - 1);
        x1 = originx;
        y1 = space.height;
        int y2 = originy;
        for (int tick = 0; tick < this.numXTicks; ++tick) {
            gc.drawLine(x1, y1, x1, y2);
            x1 += tickoff;
        }
        gc.drawLine(originx, originy, space.width, originy);
        gc = gc.create(originx + 1, 0, space.width - originx - 1, originy);
        return gc;
    }

    void paintLine(Graphics g) {
        int x;
        int totx;
        int[] values = this.dataSet.getValues();
        if (this.dataSet == null || this.dataSet.getSize() < 1) {
            return;
        }
        int capacity = this.dataSet.getCapacity();
        int nr = this.dataSet.getSize();
        Rectangle space = g.getClipBounds();
        int width = space.width;
        int xscale = width / capacity;
        if (xscale < 1) {
            xscale = 1;
        }
        if ((width = xscale * capacity) > space.width) {
            width = space.width;
        }
        float yscale = (float)space.height / (float)(this.dmax - this.dmin);
        int xstart = 0;
        if (width < nr * xscale) {
            xstart = nr - width / xscale;
        }
        if (this.xline.length < (totx = nr - xstart + 1)) {
            this.xline = new int[totx + 100];
            this.yline = new int[totx + 100];
        }
        if ((x = width - (nr - xstart - 1) * xscale) < 0) {
            x = 0;
            System.out.println("negative start point in graph.");
        }
        int ox = x;
        x += xscale;
        double dvalue = values[xstart];
        if (this.doLog) {
            dvalue = BareGraph.log10(values[xstart]);
        }
        int oy = space.height - (int)((dvalue - this.dmin) * (double)yscale);
        int pt = 0;
        for (int i = ++xstart; i < nr; ++i) {
            dvalue = values[i];
            if (this.doLog) {
                dvalue = BareGraph.log10(values[i]);
            }
            int y = space.height - (int)((dvalue - this.dmin) * (double)yscale);
            this.xline[pt] = x;
            this.yline[pt] = y;
            ++pt;
            ox = x;
            oy = y;
            x += xscale;
        }
        g.drawPolyline(this.xline, this.yline, pt);
    }

    private void setNumYTicks() {
        this.numYTicks = 11;
        if (this.doLog) {
            this.numYTicks = (int)(this.dmax - this.dmin + 1.0);
            if (this.numYTicks < 5) {
                this.numYTicks *= 2;
            }
            ++this.numYTicks;
        }
    }

    static double log10(int v) {
        double dl = 0.0;
        if ((double)v != 0.0) {
            dl = Math.log(v) / Math.log(10.0);
        }
        return dl;
    }
}

