/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.AsnTrapPduv1Sequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextPool;
import uk.co.westhawk.snmp.stack.varbind;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public class TrapPduv1
extends Pdu {
    private static final String version_id = "@(#)$Id: TrapPduv1.java,v 3.14 2007/10/17 10:44:09 birgita Exp $ Copyright Westhawk Ltd";
    private String enterprise;
    private byte[] IpAddress;
    private int generic_trap;
    private int specific_trap;
    private long timeTicks;
    private static final String[] genericTrapStrings = new String[]{"Cold Start", "Warm Start", "Link Down", "Link Up", "Authentication Failure", "EGP Neighbor Loss", "Enterprise Specific"};

    public TrapPduv1(SnmpContext con) {
        super(con);
        this.setMsgType((byte)-92);
        this.generic_trap = 1;
    }

    public TrapPduv1(SnmpContextPool con) {
        super(con);
        this.setMsgType((byte)-92);
        this.generic_trap = 1;
    }

    public void setEnterprise(String var) {
        this.enterprise = var;
    }

    public String getEnterprise() {
        return this.enterprise;
    }

    public void setIpAddress(byte[] var) {
        this.IpAddress = var;
    }

    public byte[] getIpAddress() {
        return this.IpAddress;
    }

    public void setGenericTrap(int var) {
        this.generic_trap = var;
    }

    public int getGenericTrap() {
        return this.generic_trap;
    }

    public String getGenericTrapString() {
        String trapStr = "";
        if (this.generic_trap > -1 && this.generic_trap < genericTrapStrings.length) {
            trapStr = genericTrapStrings[this.generic_trap];
        }
        return trapStr;
    }

    public void setSpecificTrap(int var) {
        this.specific_trap = var;
    }

    public int getSpecificTrap() {
        return this.specific_trap;
    }

    public void setTimeTicks(long var) {
        this.timeTicks = var;
    }

    public long getTimeTicks() {
        return this.timeTicks;
    }

    @Override
    public boolean send() throws IOException, PduException {
        if (!this.added) {
            this.added = this.context.addPdu(this);
        }
        Enumeration vbs = this.reqVarbinds.elements();
        this.encodedPacket = ((SnmpContext)this.context).encodePacket(this.msg_type, this.enterprise, this.IpAddress, this.generic_trap, this.specific_trap, this.timeTicks, vbs);
        this.addToTrans();
        return this.added;
    }

    @Override
    void transmit() {
        this.transmit(false);
    }

    @Override
    public String toString() {
        varbind var;
        int i;
        int sz;
        String iPAddressStr = "null";
        if (this.IpAddress != null) {
            iPAddressStr = new AsnOctets(this.IpAddress).toIpAddress();
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[");
        buffer.append("context=").append(this.context);
        buffer.append(", reqId=").append(this.getReqId());
        buffer.append(", msgType=0x").append(SnmpUtilities.toHex(this.msg_type));
        buffer.append(", enterprise=").append(this.enterprise);
        buffer.append(", IpAddress=").append(iPAddressStr);
        buffer.append(", generic_trap=").append(this.getGenericTrapString());
        buffer.append(", specific_trap=").append(this.specific_trap);
        buffer.append(", timeTicks=").append(this.timeTicks);
        buffer.append(", reqVarbinds=");
        if (this.reqVarbinds != null) {
            sz = this.reqVarbinds.size();
            buffer.append("[");
            for (i = 0; i < sz; ++i) {
                var = (varbind)this.reqVarbinds.elementAt(i);
                buffer.append(var.toString()).append(", ");
            }
            buffer.append("]");
        } else {
            buffer.append("null");
        }
        buffer.append(", respVarbinds=");
        if (this.respVarbinds != null) {
            sz = this.respVarbinds.size();
            buffer.append("[");
            for (i = 0; i < sz; ++i) {
                var = (varbind)this.respVarbinds.elementAt(i);
                buffer.append(var.toString()).append(", ");
            }
            buffer.append("]");
        } else {
            buffer.append("null");
        }
        buffer.append("]");
        return buffer.toString();
    }

    void fillin(AsnTrapPduv1Sequence seq) {
        if (seq != null) {
            try {
                AsnSequence varBind = seq.getVarBind();
                int size = varBind.getObjCount();
                this.respVarbinds = new Vector(size, 1);
                for (int n = 0; n < size; ++n) {
                    AsnObject obj = varBind.getObj(n);
                    if (!(obj instanceof AsnSequence)) continue;
                    AsnSequence varSeq = (AsnSequence)obj;
                    try {
                        varbind vb = new varbind(varSeq);
                        this.respVarbinds.addElement(vb);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                this.setEnterprise(seq.getEnterprise());
                this.setIpAddress(seq.getIPAddress());
                this.setGenericTrap(seq.getGenericTrap());
                this.setSpecificTrap(seq.getSpecificTrap());
                this.setTimeTicks(seq.getTimeTicks());
            }
            catch (DecodingException exc) {
                this.setErrorStatus(20, exc);
            }
        }
    }

    @Override
    protected void new_value(int n, varbind res) {
    }

    @Override
    protected void tell_them() {
    }

    @Override
    protected boolean isExpectingResponse() {
        return false;
    }
}

