/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.co.westhawk.snmp.event.RequestPduListener;
import uk.co.westhawk.snmp.event.TrapListener;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.ListeningContextPool;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.SnmpContextFace;
import uk.co.westhawk.snmp.stack.SnmpContextPoolItem;

public class SnmpContextPool
implements SnmpContextFace {
    private static final String version_id = "@(#)$Id: SnmpContextPool.java,v 3.22 2009/03/05 13:27:41 birgita Exp $ Copyright Westhawk Ltd";
    protected static Hashtable contextPool;
    protected SnmpContext context = null;
    protected String hostname;
    protected String socketType;
    protected String bindAddr;
    protected int hostPort;
    protected String community = "public";

    public SnmpContextPool(String host, int port) throws IOException {
        this(host, port, "public", null, "Standard");
    }

    public SnmpContextPool(String host, int port, String typeSocket) throws IOException {
        this(host, port, "public", null, typeSocket);
    }

    public SnmpContextPool(String host, int port, String comm, String typeSocket) throws IOException {
        this(host, port, comm, null, typeSocket);
    }

    public SnmpContextPool(String host, int port, String comm, String bindAddress, String typeSocket) throws IOException {
        SnmpContextPool.initPools();
        this.hostname = host;
        this.hostPort = port;
        this.community = comm;
        this.bindAddr = bindAddress;
        this.socketType = typeSocket;
        this.context = this.getMatchingContext();
    }

    private static synchronized void initPools() {
        if (contextPool == null) {
            contextPool = new Hashtable(5);
        }
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public String getHost() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.hostPort;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddr;
    }

    @Override
    public String getTypeSocket() {
        return this.socketType;
    }

    @Override
    public String getSendToHostAddress() {
        String res = null;
        if (this.context != null) {
            res = this.context.getSendToHostAddress();
        }
        return res;
    }

    @Override
    public String getReceivedFromHostAddress() {
        String res = null;
        if (this.context != null) {
            res = this.context.getReceivedFromHostAddress();
        }
        return res;
    }

    @Override
    public String getCommunity() {
        return this.community;
    }

    @Override
    public void setCommunity(String newCommunity) {
        if (newCommunity != null && !newCommunity.equals(this.community)) {
            this.community = newCommunity;
            try {
                this.context = this.getMatchingContext();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean addPdu(Pdu pdu) throws IOException, PduException {
        if (this.context == null) {
            this.context = this.getMatchingContext();
        }
        return this.context.addPdu(pdu);
    }

    @Override
    public boolean removePdu(int requestId) {
        boolean res = false;
        if (this.context != null) {
            res = this.context.removePdu(requestId);
        }
        return res;
    }

    @Override
    public byte[] encodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve, Object obj) throws IOException, EncodingException {
        byte[] res = null;
        if (this.context != null) {
            res = this.context.encodePacket(msg_type, rId, errstat, errind, ve, obj);
        }
        return res;
    }

    @Override
    public void sendPacket(byte[] packet) {
        if (this.context != null) {
            this.context.sendPacket(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            if (this.context != null) {
                String hashKey = this.context.getHashKey();
                int count = 0;
                SnmpContextPoolItem item = (SnmpContextPoolItem)contextPool.get(hashKey);
                if (item != null) {
                    count = item.getCounter();
                    item.setCounter(--count);
                }
                if (count <= 0) {
                    contextPool.remove(hashKey);
                    this.context.destroy();
                }
                this.context = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPool() {
        Hashtable copyOfPool = null;
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            Hashtable hashtable2 = contextPool;
            synchronized (hashtable2) {
                copyOfPool = (Hashtable)contextPool.clone();
            }
            contextPool.clear();
        }
        this.context = null;
        Enumeration keys = copyOfPool.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            SnmpContextPoolItem item = (SnmpContextPoolItem)copyOfPool.get(key);
            if (item == null) continue;
            SnmpContextBasisFace cntxt = item.getContext();
            cntxt.destroy();
        }
        copyOfPool.clear();
    }

    @Override
    public boolean isDestroyed() {
        boolean isDestroyed = true;
        if (this.context != null) {
            isDestroyed = this.context.isDestroyed();
        }
        return isDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpContext getMatchingContext() throws IOException {
        SnmpContextPoolItem item = null;
        SnmpContext newContext = null;
        String hashKey = this.getHashKey();
        this.destroy();
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            int count = 0;
            if (contextPool.containsKey(hashKey)) {
                item = (SnmpContextPoolItem)contextPool.get(hashKey);
                newContext = (SnmpContext)item.getContext();
                count = item.getCounter();
            } else {
                newContext = new SnmpContext(this.hostname, this.hostPort, this.bindAddr, this.socketType);
                newContext.setCommunity(this.community);
                item = new SnmpContextPoolItem(newContext);
                contextPool.put(hashKey, item);
            }
            item.setCounter(++count);
        }
        return newContext;
    }

    public void dumpContexts(String title) {
        System.out.println(title + " " + contextPool.size() + " context(s)");
        Enumeration keys = contextPool.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            SnmpContextPoolItem item = (SnmpContextPoolItem)contextPool.get(key);
            if (item == null) continue;
            int count = item.getCounter();
            SnmpContext cntxt = (SnmpContext)item.getContext();
            if (cntxt == this.context) {
                System.out.println("\tcurrent context: ");
            }
            System.out.println("\tcontext " + i + ": " + key + ", count: " + count + ", " + cntxt.toString() + "\n, " + cntxt.getDebugString());
            ++i;
        }
    }

    @Override
    public String getHashKey() {
        String str = this.hostname + "_" + this.hostPort + "_" + this.bindAddr + "_" + this.socketType + "_" + this.community + "_v" + this.getVersion();
        return str;
    }

    @Override
    public void addTrapListener(TrapListener l) throws IOException {
        if (this.context != null) {
            this.context.addTrapListener(l);
        }
    }

    @Override
    public void removeTrapListener(TrapListener l) throws IOException {
        if (this.context != null) {
            this.context.removeTrapListener(l);
        }
    }

    @Override
    public void addTrapListener(TrapListener l, int port) throws IOException {
        if (this.context != null) {
            this.context.addTrapListener(l, port);
        }
    }

    @Override
    public void removeTrapListener(TrapListener l, int port) throws IOException {
        if (this.context != null) {
            this.context.removeTrapListener(l, port);
        }
    }

    @Override
    public void addTrapListener(TrapListener l, ListeningContextPool lcontext) throws IOException {
        if (this.context != null) {
            this.context.addTrapListener(l, lcontext);
        }
    }

    @Override
    public void removeTrapListener(TrapListener l, ListeningContextPool lcontext) throws IOException {
        if (this.context != null) {
            this.context.removeTrapListener(l, lcontext);
        }
    }

    @Override
    public void addRequestPduListener(RequestPduListener l) throws IOException {
        if (this.context != null) {
            this.context.addRequestPduListener(l);
        }
    }

    @Override
    public void removeRequestPduListener(RequestPduListener l) throws IOException {
        if (this.context != null) {
            this.context.removeRequestPduListener(l);
        }
    }

    @Override
    public void addRequestPduListener(RequestPduListener l, int port) throws IOException {
        if (this.context != null) {
            this.context.addRequestPduListener(l, port);
        }
    }

    @Override
    public void removeRequestPduListener(RequestPduListener l, int port) throws IOException {
        if (this.context != null) {
            this.context.removeRequestPduListener(l, port);
        }
    }

    @Override
    public void addRequestPduListener(RequestPduListener l, ListeningContextPool lcontext) throws IOException {
        if (this.context != null) {
            this.context.addRequestPduListener(l, lcontext);
        }
    }

    @Override
    public void removeRequestPduListener(RequestPduListener l, ListeningContextPool lcontext) throws IOException {
        if (this.context != null) {
            this.context.removeRequestPduListener(l, lcontext);
        }
    }

    @Override
    public Pdu processIncomingPdu(byte[] message) throws DecodingException, IOException {
        Pdu pdu = null;
        if (this.context != null) {
            pdu = this.context.processIncomingPdu(message);
        }
        return pdu;
    }

    public String toString() {
        String res = "";
        if (this.context != null) {
            res = this.context.toString();
        }
        return res;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

