/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.westhawk.snmp.stack.AsnObject;

public class AsnUnsInteger
extends AsnObject {
    private static final String version_id = "@(#)$Id: AsnUnsInteger.java,v 3.16 2006/01/17 17:43:54 birgit Exp $ Copyright Westhawk Ltd";
    protected long value;

    public AsnUnsInteger(long v) {
        this(v, 67);
    }

    public AsnUnsInteger(long v, byte t) {
        this.value = v;
        this.type = t;
    }

    public AsnUnsInteger(InputStream in, int len) throws IOException {
        long val;
        byte[] data = new byte[len];
        if (len != in.read(data, 0, len)) {
            throw new IOException("AsnUnsInteger(): Not enough data");
        }
        this.value = val = this.bytesToLong(data);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    int size() {
        int count;
        int empty = 0;
        int sign = 0;
        if (this.value < 0L) {
            empty = 255;
            sign = 128;
        }
        for (count = 24; count > 0 && (this.value >> count & 0xFFL) == (long)empty; count -= 8) {
        }
        if ((this.value >> count & 0x80L) != (long)sign) {
            count += 8;
        }
        return (count >> 3) + 1;
    }

    @Override
    void write(OutputStream out, int pos) throws IOException {
        int count;
        int empty = 0;
        int sign = 0;
        if (this.value < 0L) {
            empty = 255;
            sign = 128;
        }
        for (count = 24; count > 0 && (this.value >> count & 0xFFL) == (long)empty; count -= 8) {
        }
        if ((this.value >> count & 0x80L) != (long)sign) {
            count += 8;
        }
        this.AsnBuildHeader(out, this.type, (count >> 3) + 1);
        if (debug > 10) {
            System.out.println("\tAsnUnsInteger(): value = " + this.value + ", pos = " + pos);
        }
        while (count >= 0) {
            out.write((byte)(this.value >> count & 0xFFL));
            count -= 8;
        }
    }

    protected long bytesToLong(byte[] data) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        long val = 0L;
        int size = data.length;
        for (int n = 0; n < size; ++n) {
            val = (val << 8) + (long)dis.readUnsignedByte();
        }
        return val;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AsnUnsInteger) {
            return this.value == ((AsnUnsInteger)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

