/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.pdu;

import java.io.IOException;
import java.util.Observer;
import uk.co.westhawk.snmp.pdu.OneIntPdu;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.GetPdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.varbind;

public class InterfacePdu
extends GetPdu {
    private static final String version_id = "@(#)$Id: InterfacePdu.java,v 3.19 2006/11/29 16:12:50 birgit Exp $ Copyright Westhawk Ltd";
    static final String IFNUMBER = "1.3.6.1.2.1.2.1.0";
    static final String SYS_UPTIME = "1.3.6.1.2.1.1.3";
    static final String DESCR = "1.3.6.1.2.1.2.2.1.2";
    static final String OPR_STATUS = "1.3.6.1.2.1.2.2.1.8";
    static final String IN_OCTETS = "1.3.6.1.2.1.2.2.1.10";
    static final String OUT_OCTETS = "1.3.6.1.2.1.2.2.1.16";
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String TESTING = "testing";
    public static final String UNKNOWN = "unknown";
    long sysUpTime;
    int operStatus;
    long inOctet;
    long outOctet;
    long speed;
    int index;
    String descr;
    boolean valid = false;

    InterfacePdu(SnmpContextBasisFace con) {
        super(con);
    }

    public InterfacePdu(SnmpContextBasisFace con, Observer o, int interf) throws PduException, IOException {
        super(con);
        this.addOids(interf);
        if (o != null) {
            this.addObserver(o);
        }
        this.index = interf;
        this.send();
    }

    public int getIndex() {
        return this.index;
    }

    public long getSysUpTime() {
        return this.sysUpTime;
    }

    public String getDescription() {
        return this.descr;
    }

    public int getOperStatus() {
        return this.operStatus;
    }

    public String getOperStatusString() {
        return this.getOperStatusString(this.operStatus);
    }

    public String getOperStatusString(int status) {
        String str = null;
        switch (status) {
            case 1: {
                str = UP;
                break;
            }
            case 2: {
                str = DOWN;
                break;
            }
            case 3: {
                str = TESTING;
                break;
            }
            default: {
                str = UNKNOWN;
            }
        }
        return str;
    }

    public long getInOctet() {
        return this.inOctet;
    }

    public long getOutOctet() {
        return this.outOctet;
    }

    public long getSpeed(InterfacePdu old) {
        long speed = -1L;
        if (this.operStatus < 1 || old.operStatus < 1 || !this.valid || !old.valid) {
            return -1L;
        }
        long tdif = this.sysUpTime - old.sysUpTime;
        if (tdif != 0L) {
            speed = 100L * (this.inOctet - old.inOctet + (this.outOctet - old.outOctet)) / tdif;
        }
        return speed;
    }

    void addOids(int interf) {
        this.addOid("1.3.6.1.2.1.1.3.0");
        this.addOid("1.3.6.1.2.1.2.2.1.2." + interf);
        this.addOid("1.3.6.1.2.1.2.2.1.8." + interf);
        this.addOid("1.3.6.1.2.1.2.2.1.10." + interf);
        this.addOid("1.3.6.1.2.1.2.2.1.16." + interf);
    }

    @Override
    protected void new_value(int n, varbind res) {
        AsnObject obj = res.getValue();
        if (this.getErrorStatus() == 0) {
            try {
                switch (n) {
                    case 0: {
                        this.sysUpTime = ((AsnUnsInteger)obj).getValue();
                        break;
                    }
                    case 1: {
                        this.descr = ((AsnOctets)obj).getValue();
                        break;
                    }
                    case 2: {
                        this.operStatus = ((AsnInteger)obj).getValue();
                        break;
                    }
                    case 3: {
                        this.inOctet = ((AsnUnsInteger)obj).getValue();
                        break;
                    }
                    case 4: {
                        this.outOctet = ((AsnUnsInteger)obj).getValue();
                        this.valid = true;
                        break;
                    }
                    default: {
                        this.valid = false;
                        break;
                    }
                }
            }
            catch (ClassCastException exc) {
                this.sysUpTime = 0L;
                this.descr = null;
                this.operStatus = 0;
                this.inOctet = 0L;
                this.outOctet = 0L;
                this.valid = false;
            }
        } else {
            this.valid = false;
        }
    }

    @Override
    protected void tell_them() {
        this.notifyObservers(this);
    }

    public static int getNumIfs(SnmpContextBasisFace con) throws PduException, IOException {
        int ifCount = 0;
        if (con != null) {
            OneIntPdu numIfs = new OneIntPdu(con, IFNUMBER);
            boolean answered = numIfs.waitForSelf();
            boolean timedOut = numIfs.isTimedOut();
            if (answered && !timedOut) {
                ifCount = numIfs.getValue();
            }
        }
        return ifCount;
    }
}

