/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.event;

import java.util.Vector;
import uk.co.westhawk.snmp.event.RawPduEvent;
import uk.co.westhawk.snmp.event.RawPduListener;

public class RawPduReceivedSupport {
    public static final String version_id = "@(#)$Id: RawPduReceivedSupport.java,v 1.5 2006/02/09 14:30:18 birgit Exp $ Copyright Westhawk Ltd";
    private Object source;
    private transient Vector pduListeners;

    public RawPduReceivedSupport(Object src) {
        this.source = src;
    }

    public synchronized void empty() {
        if (this.pduListeners != null) {
            this.pduListeners.removeAllElements();
        }
    }

    public synchronized int getListenerCount() {
        int c = 0;
        if (this.pduListeners != null) {
            c = this.pduListeners.size();
        }
        return c;
    }

    public synchronized void addRawPduListener(RawPduListener listener) {
        if (this.pduListeners == null) {
            this.pduListeners = new Vector(5);
        }
        if (!this.pduListeners.contains(listener)) {
            this.pduListeners.addElement(listener);
        }
    }

    public synchronized void removeRawPduListener(RawPduListener listener) {
        if (this.pduListeners != null) {
            this.pduListeners.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireRawPduReceived(int version, String hostAddress, int hostPort, byte[] message) {
        boolean isConsumed = false;
        Vector copyOfListeners = null;
        if (this.pduListeners != null) {
            Vector vector = this.pduListeners;
            synchronized (vector) {
                copyOfListeners = (Vector)this.pduListeners.clone();
            }
        }
        if (copyOfListeners != null) {
            int l = message.length;
            int sz = copyOfListeners.size();
            for (int i = sz - 1; i >= 0 && !isConsumed; --i) {
                RawPduListener listener = (RawPduListener)copyOfListeners.elementAt(i);
                byte[] copyOfMessage = new byte[l];
                System.arraycopy(message, 0, copyOfMessage, 0, l);
                RawPduEvent evt = new RawPduEvent(this.source, version, hostAddress, copyOfMessage, hostPort);
                listener.rawPduReceived(evt);
                isConsumed = evt.isConsumed();
            }
        }
        return isConsumed;
    }
}

