/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.GetNextPdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.varbind;

public class NTUserNamesBean
extends SNMPRunBean
implements Observer {
    private static final String version_id = "@(#)$Id: NTUserNamesBean.java,v 1.13 2006/01/25 18:08:56 birgit Exp $ Copyright Westhawk Ltd";
    public static final String svUserName = "1.3.6.1.4.1.77.1.2.25.1.1";
    private int svUserName_len;
    private GetNextPdu pdu;
    private Hashtable userHash = new Hashtable();
    private boolean isGetNextInFlight;
    private Date lastUpdateDate = null;

    public NTUserNamesBean() {
        this.svUserName_len = svUserName.length();
    }

    public NTUserNamesBean(String h, int p) {
        this(h, p, null);
    }

    public NTUserNamesBean(String h, int p, String b) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Enumeration getIndices() {
        return this.userHash.elements();
    }

    public String getIndex(String name) {
        return (String)this.userHash.get(name);
    }

    public Enumeration getNames() {
        return this.userHash.keys();
    }

    public synchronized int getCount() {
        return this.userHash.size();
    }

    @Override
    public void action() {
        if (this.isHostPortReachable()) {
            this.userHash.clear();
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.setRunning(true);
        }
    }

    @Override
    public void run() {
        while (this.context != null && this.isRunning()) {
            if (!this.isGetNextInFlight) {
                this.isGetNextInFlight = true;
                this.pdu = new GetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOid(svUserName);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void update(Observable obs, Object ov) {
        this.pdu = (GetNextPdu)obs;
        if (this.pdu.getErrorStatus() == 0) {
            varbind var = (varbind)ov;
            String oid = var.getOid().toString();
            if (oid.startsWith(svUserName)) {
                String index = oid.substring(this.svUserName_len + 1);
                String name = ((AsnOctets)var.getValue()).getValue();
                this.userHash.put(name, index);
                this.pdu = new GetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOid(oid);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            } else {
                this.lastUpdateDate = new Date();
                this.isGetNextInFlight = false;
                this.firePropertyChange("userNames", null, null);
            }
        } else {
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.firePropertyChange("userNames", null, null);
        }
    }
}

