/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.pdu.InterfaceGetNextPdu;
import uk.co.westhawk.snmp.stack.PduException;

public class InterfaceIndexesBean
extends SNMPRunBean
implements Observer {
    private static final String version_id = "@(#)$Id: InterfaceIndexesBean.java,v 1.13 2006/01/25 18:08:55 birgit Exp $ Copyright Westhawk Ltd";
    private InterfaceGetNextPdu pdu;
    private Hashtable interfaceHash = new Hashtable();
    private boolean isGetNextInFlight;
    private Date lastUpdateDate = null;

    public InterfaceIndexesBean() {
    }

    public InterfaceIndexesBean(String h, int p) {
        this(h, p, null);
    }

    public InterfaceIndexesBean(String h, int p, String b) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Enumeration getInterfaceIndexes() {
        return this.interfaceHash.keys();
    }

    public Set getInterfaceIndexSet() {
        return this.interfaceHash.keySet();
    }

    public synchronized int getInterfaceCount() {
        return this.interfaceHash.size();
    }

    @Override
    public void action() {
        if (this.isHostPortReachable()) {
            this.interfaceHash.clear();
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.setRunning(true);
        }
    }

    @Override
    public void run() {
        while (this.context != null && this.isRunning()) {
            if (!this.isGetNextInFlight) {
                this.isGetNextInFlight = true;
                this.pdu = new InterfaceGetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOids(null);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void update(Observable obs, Object ov) {
        this.pdu = (InterfaceGetNextPdu)obs;
        if (this.pdu.getErrorStatus() == 0) {
            String hashKey = String.valueOf(this.pdu.getIfIndex());
            InterfaceGetNextPdu prev = (InterfaceGetNextPdu)this.interfaceHash.get(hashKey);
            if (prev != null) {
                this.pdu.getSpeed(prev);
            }
            this.interfaceHash.put(hashKey, this.pdu);
            prev = this.pdu;
            this.pdu = new InterfaceGetNextPdu(this.context);
            this.pdu.addObserver(this);
            this.pdu.addOids(prev);
            try {
                this.pdu.send();
            }
            catch (PduException exc) {
                System.out.println("PduException " + exc.getMessage());
            }
            catch (IOException exc) {
                System.out.println("IOException " + exc.getMessage());
            }
        } else {
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.firePropertyChange("InterfaceIndexes", null, null);
        }
    }
}

