/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.pdu.GetNextPdu_vec;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.GetPdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.varbind;

public class AnnexModemStatusBean
extends SNMPRunBean
implements Observer,
TreeNode {
    private static final String version_id = "@(#)$Id: AnnexModemStatusBean.java,v 1.22 2006/03/23 14:54:09 birgit Exp $ Copyright Westhawk Ltd";
    public static final String charPortIndex = "1.3.6.1.2.1.19.2.1.1";
    public static final String charPortName = "1.3.6.1.2.1.19.2.1.2";
    public static final String charPortOperStatus = "1.3.6.1.2.1.19.2.1.7";
    public static final String rs232InSigState = "1.3.6.1.2.1.10.33.5.1.3";
    private static final int NR_PORT_OID = 3;
    public static final int portUP = 1;
    public static final int portDOWN = 2;
    public static final int portMAINTENANCE = 3;
    public static final int portABSENT = 4;
    public static final int portACTIVE = 5;
    public static final int DCD = 6;
    public static final int sigNONE = 1;
    public static final int sigON = 2;
    public static final int sigOFF = 3;
    public static final String[] sig_state = new String[]{"unknown", "none", "in use", "not in use"};
    private GetNextPdu_vec pduGetNext;
    private Hashtable modemIndexStatusHash = new Hashtable();
    private Hashtable modemHash = new Hashtable();
    private TreeNode parent;
    private DefaultTreeModel treeModel;
    private boolean isGetNextInFlight;
    private Date lastUpdateDate = null;
    private int deviceType = 0;
    private int openCount = 0;
    private int modemStatus = 0;

    public AnnexModemStatusBean() {
    }

    public AnnexModemStatusBean(String h, int p) {
        this(h, p, null);
    }

    public AnnexModemStatusBean(String h, int p, String b) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Enumeration getModemIndexes() {
        return this.modemIndexStatusHash.keys();
    }

    public synchronized int getModemCount() {
        return this.modemIndexStatusHash.size();
    }

    public String getPortName(Long index) {
        String name = "";
        Object obj = this.modemHash.get(index);
        if (obj != null) {
            PortInfo pInfo = (PortInfo)obj;
            name = pInfo.getName();
        }
        return name;
    }

    public int getPortStatus(Long index) {
        int status = 0;
        Object obj = this.modemIndexStatusHash.get(index);
        if (obj != null) {
            status = (Integer)obj;
        }
        return status;
    }

    public String getPortStatusString(Long index) {
        int status = this.getPortStatus(index);
        String str = sig_state[status];
        return str;
    }

    public Enumeration children() {
        return this.modemHash.elements();
    }

    @Override
    public int getChildCount() {
        int sz = this.modemHash.size();
        return sz;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        TreeNode node = null;
        if (childIndex < this.modemHash.size()) {
            Enumeration e = this.modemHash.elements();
            for (int i = 0; i <= childIndex; ++i) {
                node = (TreeNode)e.nextElement();
            }
        }
        return node;
    }

    @Override
    public int getIndex(TreeNode node) {
        int ret = -1;
        if (this.modemHash.contains(node)) {
            boolean found = false;
            Enumeration e = this.modemHash.elements();
            while (e.hasMoreElements() && !found) {
                TreeNode n = (TreeNode)e.nextElement();
                found = n == node;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void action() {
        if (this.isHostPortReachable()) {
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.setRunning(true);
        }
    }

    @Override
    public void run() {
        while (this.context != null && this.isRunning()) {
            if (!this.isGetNextInFlight) {
                this.isGetNextInFlight = true;
                this.pduGetNext = new GetNextPdu_vec(this.context, 3);
                this.pduGetNext.addObserver(this);
                this.pduGetNext.addOid(charPortIndex);
                this.pduGetNext.addOid(charPortName);
                this.pduGetNext.addOid(charPortOperStatus);
                try {
                    this.pduGetNext.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void update(Observable obs, Object ov) {
        GetPdu pduGet;
        boolean loopHasEnded = false;
        if (obs instanceof GetNextPdu_vec) {
            this.pduGetNext = (GetNextPdu_vec)obs;
            if (!this.pduGetNext.isTimedOut()) {
                if (this.pduGetNext.getErrorStatus() == 0) {
                    varbind[] var = (varbind[])ov;
                    if (var[0].getOid().toString().startsWith(charPortIndex)) {
                        int portIndex = ((AsnInteger)var[0].getValue()).getValue();
                        String portName = ((AsnOctets)var[1].getValue()).getValue();
                        int portStatus = ((AsnInteger)var[2].getValue()).getValue();
                        Long indexInt = new Long(portIndex);
                        if (portStatus == 1) {
                            PortInfo pStatus = (PortInfo)this.modemHash.get(indexInt);
                            if (pStatus == null) {
                                pStatus = new PortInfo(portIndex, portName, this);
                                this.modemHash.put(indexInt, pStatus);
                            }
                            String oid = "1.3.6.1.2.1.10.33.5.1.3." + String.valueOf(portIndex) + "." + String.valueOf(6);
                            try {
                                GetPdu pduGet2 = new GetPdu(this.context);
                                pduGet2.addOid(oid);
                                pduGet2.addObserver(this);
                                pduGet2.send();
                            }
                            catch (PduException exc) {
                                System.out.println("PduException " + exc.getMessage());
                            }
                            catch (IOException exc) {
                                System.out.println("IOException " + exc.getMessage());
                            }
                        } else {
                            this.modemIndexStatusHash.remove(indexInt);
                            this.modemHash.remove(indexInt);
                        }
                        this.pduGetNext = new GetNextPdu_vec(this.context, 3);
                        this.pduGetNext.addObserver(this);
                        this.pduGetNext.addOid(var[0].getOid().toString());
                        this.pduGetNext.addOid(var[1].getOid().toString());
                        this.pduGetNext.addOid(var[2].getOid().toString());
                        try {
                            this.pduGetNext.send();
                        }
                        catch (PduException exc) {
                            System.out.println("PduException " + exc.getMessage());
                        }
                        catch (IOException exc) {
                            System.out.println("IOException " + exc.getMessage());
                        }
                    } else {
                        loopHasEnded = true;
                    }
                } else {
                    loopHasEnded = true;
                }
            } else {
                this.modemIndexStatusHash.clear();
                this.modemHash.clear();
                loopHasEnded = true;
            }
        } else if (obs instanceof GetPdu && (pduGet = (GetPdu)obs).getErrorStatus() == 0) {
            varbind var = (varbind)ov;
            AsnObjectId oid = var.getOid();
            int sigStatus = ((AsnInteger)var.getValue()).getValue();
            int len = oid.getSize();
            long portIndex = oid.getElementAt(len - 2);
            Long indexInt = new Long(portIndex);
            this.modemIndexStatusHash.put(indexInt, new Integer(sigStatus));
            PortInfo pStatus = (PortInfo)this.modemHash.get(indexInt);
            if (pStatus != null) {
                pStatus.setStatus(sigStatus);
            }
        }
        if (loopHasEnded) {
            this.lastUpdateDate = new Date();
            SwingUtilities.invokeLater(new TreeUpdate());
            this.isGetNextInFlight = false;
        }
    }

    public void setParent(TreeNode p) {
        this.parent = p;
    }

    public void setDefaultTreeModel(DefaultTreeModel model) {
        this.treeModel = model;
    }

    protected void fireTreeModelChanged() {
        if (this.treeModel != null) {
            this.treeModel.nodeStructureChanged(this);
        }
    }

    class TreeUpdate
    implements Runnable {
        TreeUpdate() {
        }

        @Override
        public void run() {
            AnnexModemStatusBean.this.fireTreeModelChanged();
            AnnexModemStatusBean.this.firePropertyChange("modems", null, null);
        }
    }

    class PortInfo
    implements TreeNode {
        private TreeNode parent;
        private int portIndex;
        private int sigStatus;
        private String portName;

        public PortInfo(int ind, String nm, TreeNode par) {
            this(ind, 0, nm, par);
        }

        public PortInfo(int ind, int st, String nm, TreeNode par) {
            this.portIndex = ind;
            this.sigStatus = st;
            this.portName = nm;
            this.parent = par;
        }

        public int getIndex() {
            return this.portIndex;
        }

        public int getStatus() {
            return this.sigStatus;
        }

        public void setStatus(int st) {
            this.sigStatus = st;
        }

        public String getName() {
            return this.portName;
        }

        public String toString() {
            return "" + this.portIndex + " " + this.portName + " " + sig_state[this.sigStatus];
        }

        public Enumeration children() {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        @Override
        public int getIndex(TreeNode node) {
            return -1;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }
}

