/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.co.westhawk.snmp.beans.IsHostReachableBean;
import uk.co.westhawk.snmp.stack.PduException;

public class ReachHostServlet
extends HttpServlet {
    private static final String version_id = "@(#)$Id: ReachHostServlet.java,v 3.9 2006/01/17 17:43:53 birgit Exp $ Copyright Westhawk Ltd";
    private IsHostReachableBean bean;
    private Date lastUpdateDate;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.bean = new IsHostReachableBean();
        this.lastUpdateDate = new Date();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String localhost;
        if (this.bean == null) {
            this.bean = new IsHostReachableBean();
        }
        if ((localhost = req.getRemoteHost()) == null) {
            localhost = "localhost";
        }
        String host = this.getStringParameter(req, "host", localhost);
        String port = this.getStringParameter(req, "port", "161");
        String community = this.getStringParameter(req, "comm", "public");
        this.bean.setHost(host);
        this.bean.setPort(port);
        this.bean.setCommunityName(community);
        try {
            this.bean.waitForSelfAction();
        }
        catch (PduException exc) {
            throw new IOException("PduException " + exc.getMessage());
        }
        this.lastUpdateDate = new Date();
        try {
            PrintWriter out = res.getWriter();
            res.setStatus(200);
            res.setContentType("text/html");
            out.println("<html>");
            out.println("<head><title>Output of ReachHostServlet</title></head>");
            out.println("<body>");
            out.println("<p>");
            out.println(this.bean.getMessage());
            out.println("</p><hr>");
            String URL2 = req.getRequestURI().toString();
            this.print_submit(out, URL2);
            this.print_text(out, host, port, community);
            out.println("</form></body></html>");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            res.setStatus(500);
        }
    }

    private void print_submit(PrintWriter o, String URL2) throws IOException {
        o.println("<form method=GET action=\"" + URL2 + "\">");
        o.println("<input type=submit value=\"Try host\"><br>");
    }

    private void print_text(PrintWriter o, String h, String p, String c) throws IOException {
        o.println("<input type=text name=host size=30 maxlength=100 value=" + h + "> Host <br>");
        o.println("<input type=text name=port size=30 maxlength=100 value=" + p + "> Port <br>");
        o.println("<input type=text name=comm size=30 maxlength=100 value=" + c + "> Community <br>");
    }

    protected long getLastModified(HttpServletRequest req) {
        return this.lastUpdateDate.getTime();
    }

    public String getServletInfo() {
        return "Requests the uptime of a host";
    }

    private String getStringParameter(HttpServletRequest req, String str, String def) {
        String value = req.getParameter(str);
        if (value == null) {
            value = def;
        }
        return value;
    }

    private int getIntParameter(HttpServletRequest req, String str, int def) {
        String val = req.getParameter(str);
        int value = def;
        try {
            value = Integer.valueOf(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }
}

