/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.co.westhawk.snmp.pdu.UpSincePdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;

public class JeevesUpSince
extends HttpServlet {
    private static final String version_id = "@(#)$Id: JeevesUpSince.java,v 3.10 2006/02/09 14:20:07 birgit Exp $ Copyright Westhawk Ltd";

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int port = 161;
        String reps = "is not replying to snmp";
        String host = req.getParameter("host");
        if (host == null && (host = req.getRemoteHost()) == null) {
            host = "localhost";
        }
        try {
            Date when;
            SnmpContext context = new SnmpContext(host, 161);
            UpSincePdu since = new UpSincePdu(context, null);
            reps = since.waitForSelf() ? ((when = since.getDate()) != null ? "up since " + when.toString() : "no date") : "waited in vain";
        }
        catch (IOException exc) {
            reps = "IO exception: " + exc.getMessage();
        }
        catch (PduException exc) {
            reps = "Pdu exception: " + exc.getMessage();
        }
        try {
            res.setStatus(200);
            res.setContentType("text/html");
            PrintWriter out = res.getWriter();
            out.println("<html><head><title>" + this.getServletInfo() + "</title>");
            out.println("</head><body>");
            out.println("<h2>" + this.getServletInfo() + "</h2>");
            out.println("<p> Host " + host + " " + reps + "</p>");
            out.println("</body></html>");
            out.flush();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getServletInfo() {
        return "Snmp uptime checker";
    }
}

