/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.co.westhawk.snmp.pdu.InterfaceGetNextPdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;

public class JeevesInterfaces
extends HttpServlet {
    private static final String version_id = "@(#)$Id: JeevesInterfaces.java,v 3.10 2006/02/09 14:20:07 birgit Exp $ Copyright Westhawk Ltd";

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int i;
        int port = 161;
        String comm = "public";
        int numIfs = 0;
        String[] answers = null;
        String error = null;
        String host = req.getParameter("host");
        if (host == null && (host = req.getRemoteHost()) == null) {
            host = "localhost";
        }
        try {
            SnmpContext context = new SnmpContext(host, 161);
            context.setCommunity("public");
            numIfs = InterfaceGetNextPdu.getIfNumber(context);
            answers = new String[numIfs];
            int index = 0;
            for (i = 0; i < numIfs; ++i) {
                InterfaceGetNextPdu intef = new InterfaceGetNextPdu(context);
                intef.addOids(index);
                intef.send();
                if (intef.waitForSelf()) {
                    index = intef.getIfIndex();
                    answers[i] = "no " + index + " - " + intef.getIfDescr() + " - " + intef.getIfOperStatusStr();
                    continue;
                }
                answers[i] = index + " - waited in vain";
            }
        }
        catch (IOException exc) {
            error = "IOException " + exc.getMessage();
        }
        catch (PduException exc) {
            error = "PduException " + exc.getMessage();
        }
        res.setStatus(200);
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        out.println("<html>");
        out.println("<head><title>" + this.getServletInfo() + "</title>");
        out.println("</head><body>");
        out.println("<h2>" + this.getServletInfo() + "</h2>");
        if (error != null) {
            out.println("<p> Error " + error + "</p>");
        } else {
            out.println("<p> Host " + host + ", " + numIfs + " interfaces: ");
            out.println("<ul>");
            if (answers != null) {
                for (i = 0; i < answers.length; ++i) {
                    out.println("<li>" + answers[i] + "</li>");
                }
            }
            out.println("</ul></p>");
        }
        out.println("</body></html>");
        out.flush();
        out.close();
    }

    public String getServletInfo() {
        return "Snmp Interface status checker";
    }
}

