/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.co.westhawk.snmp.pdu.InterfaceGetNextPdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;

public class Interfaces
extends HttpServlet
implements Observer,
Runnable {
    private static final String version_id = "@(#)$Id: Interfaces.java,v 3.14 2006/02/02 15:49:39 birgit Exp $ Copyright Westhawk Ltd";
    private InterfaceGetNextPdu pdu;
    private Hashtable allInt;
    private SnmpContext context = null;
    private String hashKeyPart;
    private boolean mayLoopStart;
    private Date lastUpdateDate;
    private SimpleDateFormat dateFormat;
    private Thread me;
    private String host;
    private int port;
    private int sleep_time;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.letItBegin(config);
    }

    public synchronized void destroy() {
        super.destroy();
        this.mayLoopStart = false;
        this.context.destroy();
        this.context = null;
        this.allInt.clear();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.context != null) {
            this.showAllInterface(res);
        } else {
            this.letItBegin(null);
        }
    }

    public void setHost(String h) {
        this.host = h;
    }

    public void setPort(String p) {
        this.port = this.convertInt(p, 161);
    }

    public void setInterval(String s) {
        this.sleep_time = this.convertInt(s, 10);
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return "" + this.port;
    }

    public String getInterval() {
        return "" + this.sleep_time;
    }

    protected void letItBegin(ServletConfig config) throws ServletException {
        String tmp = this.getStringParameter(config, "HOST", "localhost");
        this.setHost(tmp);
        tmp = this.getStringParameter(config, "PORT", "161");
        this.setPort(tmp);
        tmp = this.getStringParameter(config, "INTERVAL", "10");
        this.setInterval(tmp);
        this.hashKeyPart = new String(this.host + String.valueOf(this.port));
        try {
            this.context = new SnmpContext(this.host, this.port);
            this.context.setCommunity("public");
            this.allInt = new Hashtable();
            this.mayLoopStart = true;
            this.me = new Thread(this);
            this.me.setPriority(1);
            this.me.start();
        }
        catch (IOException exc) {
            throw new ServletException("IOException: " + exc.getMessage());
        }
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.lastUpdateDate = new Date();
    }

    protected long getLastModified(HttpServletRequest req) {
        return this.lastUpdateDate.getTime();
    }

    @Override
    public void run() {
        while (this.context != null) {
            if (this.mayLoopStart) {
                this.mayLoopStart = false;
                this.pdu = new InterfaceGetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOids(null);
                try {
                    this.pdu.send();
                }
                catch (IOException exc) {
                    System.out.println("run(): IOException " + exc.getMessage());
                }
                catch (PduException exc) {
                    System.out.println("run(): PduException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.sleep_time * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void update(Observable obs, Object ov) {
        if (this.pdu.getErrorStatus() == 0) {
            this.lastUpdateDate = new Date();
            String hashKey = this.hashKeyPart + this.pdu.getIfIndex();
            InterfaceGetNextPdu prev = (InterfaceGetNextPdu)this.allInt.get(hashKey);
            if (prev != null) {
                this.pdu.getSpeed(prev);
            }
            this.allInt.put(hashKey, this.pdu);
            prev = this.pdu;
            this.pdu = new InterfaceGetNextPdu(this.context);
            this.pdu.addObserver(this);
            this.pdu.addOids(prev);
            try {
                this.pdu.send();
            }
            catch (IOException exc) {
                System.out.println("update(): IOException " + exc.getMessage());
            }
            catch (PduException exc) {
                System.out.println("update(): PduException " + exc.getMessage());
            }
        } else {
            this.mayLoopStart = true;
        }
    }

    protected synchronized void showAllInterface(HttpServletResponse res) {
        res.setStatus(200);
        res.setContentType("text/plain");
        Enumeration e = this.allInt.elements();
        try {
            PrintWriter out = res.getWriter();
            out.println(this.allInt.size());
            while (e.hasMoreElements()) {
                InterfaceGetNextPdu tpdu = (InterfaceGetNextPdu)e.nextElement();
                this.printInterface(tpdu, out);
            }
            out.println(this.dateFormat.format(this.lastUpdateDate));
            out.flush();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected synchronized void showAllInterface(HttpServletResponse res, int index) {
        res.setStatus(200);
        res.setContentType("text/plain");
        String hashKey = this.hashKeyPart + index;
        try {
            PrintWriter out = res.getWriter();
            InterfaceGetNextPdu tpdu = (InterfaceGetNextPdu)this.allInt.get(hashKey);
            if (tpdu != null) {
                this.printInterface(tpdu, out);
            } else {
                out.println(index);
            }
            out.flush();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getServletInfo() {
        return "Returns all the interfaces of host " + this.host + " on port " + this.port;
    }

    private void printInterface(InterfaceGetNextPdu tpdu, PrintWriter out) {
        int index = tpdu.getIfIndex();
        long speed = tpdu.getSpeed();
        int opr = tpdu.getIfOperStatus();
        String descr = tpdu.getIfDescr();
        out.println(index + ", " + speed + ", " + opr + ", " + descr);
    }

    private String getStringParameter(ServletConfig config, String str, String def) {
        String value = config != null ? config.getInitParameter(str) : this.getInitParameter(str);
        if (value == null) {
            value = def;
        }
        return value;
    }

    private int convertInt(String val, int def) {
        int value = def;
        try {
            value = Integer.valueOf(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }
}

