/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.util.ArrayList;
import java.util.BitSet;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ValueReference;

public class BitSetValue
extends MibValue {
    private BitSet value;
    private ArrayList<ValueReference> references;

    public BitSetValue(BitSet value) {
        this(value, null);
    }

    public BitSetValue(BitSet value, ArrayList<ValueReference> references) {
        super("BIT STRING");
        this.value = value;
        this.references = references;
    }

    @Override
    public MibValue initialize(MibLoaderLog log, MibType type) throws MibException {
        if (this.references != null) {
            for (ValueReference ref : this.references) {
                this.initialize(log, type, ref);
            }
            this.references = null;
        }
        return this;
    }

    @Override
    public MibValue createReference() {
        return new BitSetValue(this.value, this.references);
    }

    private void initialize(MibLoaderLog log, MibType type, ValueReference ref) throws MibException {
        MibValue value = ref.initialize(log, type);
        if (!(value instanceof NumberValue)) {
            throw new MibException(ref.getFileRef(), "referenced value is not a number");
        }
        this.value.set(((Number)value.toObject()).intValue());
    }

    @Override
    protected void clear() {
        super.clear();
        this.value = null;
        this.references = null;
    }

    public ArrayList<NumberValue> getBits() {
        ArrayList<NumberValue> components = new ArrayList<NumberValue>(this.value.size());
        for (int i = 0; i < this.value.size(); ++i) {
            if (!this.value.get(i)) continue;
            components.add(new NumberValue(new Integer(i)));
        }
        return components;
    }

    @Override
    public int compareTo(Object obj) {
        return this.toString().compareTo(obj.toString());
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public String toAsn1String(MibValueSymbol[] values) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.value.size(); ++i) {
            if (!this.value.get(i)) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.toAsn1String(new Integer(i), values));
        }
        if (buffer.length() > 0) {
            return "{ " + buffer.toString() + " }";
        }
        return "{}";
    }

    private String toAsn1String(Integer bit, MibValueSymbol[] values) {
        for (MibValueSymbol sym : values) {
            if (!sym.getValue().equals(bit)) continue;
            return sym.getName();
        }
        return bit.toString();
    }
}

