/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.StringValue;

public class ValueConstraint
implements Constraint {
    private MibFileRef fileRef;
    private MibValue value;

    public ValueConstraint(MibFileRef fileRef, MibValue value) {
        this.fileRef = fileRef;
        this.value = value;
    }

    @Override
    public void initialize(MibType type, MibLoaderLog log) throws MibException {
        this.value = this.value.initialize(log, type);
        if (this.fileRef != null && !this.isCompatible(type)) {
            String message = "value constraint not compatible with this type";
            log.addWarning(this.fileRef, message);
        }
        this.fileRef = null;
    }

    @Override
    public boolean isCompatible(MibType type) {
        return type == null || this.value == null || type.isCompatible(this.value);
    }

    @Override
    public boolean isCompatible(MibValue value) {
        String str1 = this.value.toString();
        String str2 = value.toString();
        if (this.value instanceof NumberValue && value instanceof NumberValue) {
            return str1.equals(str2);
        }
        if (this.value instanceof StringValue && value instanceof StringValue) {
            return str1.equals(str2);
        }
        return false;
    }

    public MibValue getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }
}

