/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;

public class TypeReference
extends MibType
implements MibContext {
    private MibFileRef fileRef;
    private MibContext context;
    private String name;
    private MibType type = null;
    private Constraint constraint = null;
    private ArrayList<?> values = null;
    private MibTypeTag tag = null;
    private boolean implicitTag = true;

    public TypeReference(MibFileRef fileRef, MibContext context, String name) {
        super("ReferenceToType(" + name + ")", false);
        this.fileRef = fileRef;
        this.context = context;
        this.name = name;
    }

    public TypeReference(MibFileRef fileRef, MibContext context, String name, Constraint constraint) {
        this(fileRef, context, name);
        this.constraint = constraint;
    }

    public TypeReference(MibFileRef fileRef, MibContext context, String name, ArrayList<?> values) {
        this(fileRef, context, name);
        this.values = values;
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        MibSymbol sym = this.getSymbol(log);
        if (sym instanceof MibTypeSymbol) {
            this.type = this.initializeReference(symbol, log, (MibTypeSymbol)sym);
            if (this.type == null) {
                String msg = "referenced symbol '" + sym.getName() + "' contains undefined type";
                throw new MibException(this.fileRef, msg);
            }
            return this.type;
        }
        if (sym == null) {
            String msg = "undefined symbol '" + this.name + "'";
            throw new MibException(this.fileRef, msg);
        }
        String msg = "referenced symbol '" + this.name + "' is not a type";
        throw new MibException(this.fileRef, msg);
    }

    private MibType initializeReference(MibSymbol symbol, MibLoaderLog log, MibTypeSymbol ref) throws MibException {
        MibType type = ref.getType();
        if (type != null) {
            type = type.initialize(symbol, log);
        }
        if (type == null) {
            return null;
        }
        try {
            type = this.constraint != null ? type.createReference(this.constraint) : (this.values != null ? type.createReference(this.values) : type.createReference());
            type = type.initialize(symbol, log);
        }
        catch (UnsupportedOperationException e) {
            throw new MibException(this.fileRef, e.getMessage());
        }
        type.setReferenceSymbol(ref);
        this.initializeTypeTag(type, this.tag);
        return type;
    }

    private void initializeTypeTag(MibType type, MibTypeTag tag) {
        if (tag != null) {
            if (tag.getNext() == null) {
                type.setTag(this.implicitTag, tag);
            } else {
                this.initializeTypeTag(type, tag.getNext());
                type.setTag(false, tag);
            }
        }
    }

    public MibFileRef getFileRef() {
        return this.fileRef;
    }

    public MibSymbol getSymbol() {
        return this.getSymbol(null);
    }

    private MibSymbol getSymbol(MibLoaderLog log) {
        MibSymbol sym = this.context.findSymbol(this.name, false);
        if (sym == null && (sym = this.context.findSymbol(this.name, true)) != null && log != null) {
            String message = "missing import for '" + this.name + "', using " + sym.getMib().getName();
            log.addWarning(this.fileRef, message);
        }
        return sym;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return false;
    }

    @Override
    public MibSymbol findSymbol(String name, boolean expanded) {
        if (this.type instanceof MibContext) {
            return ((MibContext)((Object)this.type)).findSymbol(name, expanded);
        }
        return null;
    }

    @Override
    public void setTag(boolean implicit, MibTypeTag tag) {
        if (this.tag == null) {
            this.tag = tag;
            this.implicitTag = implicit;
        } else if (implicit) {
            tag.setNext(this.tag.getNext());
            this.tag = tag;
        } else {
            tag.setNext(this.tag);
            this.tag = tag;
        }
    }
}

