/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;

public class SequenceOfType
extends MibType {
    private MibType base;
    private Constraint constraint = null;

    public SequenceOfType(MibType base) {
        this(true, base, null);
    }

    public SequenceOfType(MibType base, Constraint constraint) {
        this(true, base, constraint);
    }

    private SequenceOfType(boolean primitive, MibType base, Constraint constraint) {
        super("SEQUENCE", primitive);
        this.base = base;
        this.constraint = constraint;
        this.setTag(true, MibTypeTag.SEQUENCE);
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        this.base = this.base.initialize(symbol, log);
        if (this.base != null && this.constraint != null) {
            this.constraint.initialize(this, log);
        }
        return this;
    }

    @Override
    public MibType createReference() {
        SequenceOfType type = new SequenceOfType(false, this.base, this.constraint);
        type.setTag(true, this.getTag());
        return type;
    }

    @Override
    public MibType createReference(Constraint constraint) {
        SequenceOfType type = new SequenceOfType(false, this.base, constraint);
        type.setTag(true, this.getTag());
        return type;
    }

    public boolean hasConstraint() {
        return this.constraint != null;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return false;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public MibType getElementType() {
        return this.base;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append(" ");
        if (this.constraint != null) {
            buffer.append("(");
            buffer.append(this.constraint.toString());
            buffer.append(") ");
        }
        buffer.append("OF ");
        buffer.append(this.base);
        return buffer.toString();
    }
}

