/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.MibbleBrowser;
import net.percederberg.mibble.browser.AboutDialog;
import net.percederberg.mibble.browser.LicenseDialog;
import net.percederberg.mibble.browser.MacUIHelper;
import net.percederberg.mibble.browser.MibTree;
import net.percederberg.mibble.browser.MibTreeNode;
import net.percederberg.mibble.browser.OpenDialog;
import net.percederberg.mibble.browser.SnmpPanel;

public class BrowserFrame
extends JFrame {
    private MibbleBrowser browser;
    private MenuBar menuBar = new MenuBar();
    private CheckboxMenuItem snmpV1Item = new CheckboxMenuItem("SNMP version 1");
    private CheckboxMenuItem snmpV2Item = new CheckboxMenuItem("SNMP version 2c");
    private CheckboxMenuItem snmpV3Item = new CheckboxMenuItem("SNMP version 3");
    private JTextArea descriptionArea = new JTextArea();
    private JLabel statusLabel = new JLabel("Ready");
    private MibTree mibTree = null;
    private SnmpPanel snmpPanel = null;

    public BrowserFrame(MibbleBrowser browser) {
        this.browser = browser;
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Mibble MIB Browser");
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = new Rectangle();
        bounds.width = (int)((double)size.width * 0.75);
        bounds.height = (int)((double)size.height * 0.75);
        bounds.x = (size.width - bounds.width) / 2;
        bounds.y = (size.height - bounds.height) / 2;
        this.setBounds(bounds);
        this.setMenuBar(this.menuBar);
        this.initializeMenu();
        this.getContentPane().setLayout(new GridBagLayout());
        JSplitPane horizontalSplitPane = new JSplitPane();
        horizontalSplitPane.setDividerLocation((int)((double)bounds.width * 0.35));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getContentPane().add((Component)horizontalSplitPane, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.fill = 1;
        c.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.statusLabel, c);
        this.mibTree = new MibTree();
        this.mibTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BrowserFrame.this.updateTreeSelection();
            }
        });
        horizontalSplitPane.setLeftComponent(new JScrollPane(this.mibTree));
        JSplitPane verticalSplitPane = new JSplitPane();
        verticalSplitPane.setOrientation(0);
        verticalSplitPane.setDividerLocation((int)((double)bounds.height * 0.4));
        verticalSplitPane.setOneTouchExpandable(true);
        this.descriptionArea.setEditable(false);
        verticalSplitPane.setLeftComponent(new JScrollPane(this.descriptionArea));
        this.snmpPanel = new SnmpPanel(this);
        verticalSplitPane.setRightComponent(this.snmpPanel);
        horizontalSplitPane.setRightComponent(verticalSplitPane);
    }

    private void initializeMenu() {
        Menu menu = new Menu("File");
        MenuItem item = new MenuItem("Load/Import MIB...", new MenuShortcut(79));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.loadMib();
            }
        });
        menu.add(item);
        item = new MenuItem("Unload MIB", new MenuShortcut(87));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.unloadMib();
            }
        });
        menu.add(item);
        item = new MenuItem("Unload All");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.unloadAllMibs();
            }
        });
        menu.add(item);
        if (!MacUIHelper.IS_MAC_OS) {
            menu.addSeparator();
            item = new MenuItem("Exit", new MenuShortcut(81));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowserFrame.this.quit();
                }
            });
            menu.add(item);
        }
        this.menuBar.add(menu);
        menu = new Menu("Edit");
        item = new MenuItem("Cut", new MenuShortcut(88));
        item.addActionListener(new DefaultEditorKit.CutAction());
        menu.add(item);
        item = new MenuItem("Copy", new MenuShortcut(67));
        item.addActionListener(new DefaultEditorKit.CopyAction());
        menu.add(item);
        item = new MenuItem("Paste", new MenuShortcut(86));
        item.addActionListener(new DefaultEditorKit.PasteAction());
        menu.add(item);
        item = new MenuItem("Select All", new MenuShortcut(65));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component comp = kfm.getFocusOwner();
                if (comp instanceof TextComponent) {
                    ((TextComponent)comp).selectAll();
                } else if (comp instanceof JTextComponent) {
                    ((JTextComponent)comp).selectAll();
                }
            }
        });
        menu.add(item);
        this.menuBar.add(menu);
        menu = new Menu("SNMP");
        this.snmpV1Item.setState(true);
        this.snmpV1Item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BrowserFrame.this.setSnmpVersion(1);
            }
        });
        menu.add(this.snmpV1Item);
        this.snmpV2Item.setState(false);
        this.snmpV2Item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BrowserFrame.this.setSnmpVersion(2);
            }
        });
        menu.add(this.snmpV2Item);
        this.snmpV3Item.setState(false);
        this.snmpV3Item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BrowserFrame.this.setSnmpVersion(3);
            }
        });
        menu.add(this.snmpV3Item);
        menu.addSeparator();
        CheckboxMenuItem checkBox = new CheckboxMenuItem("Show result in tree");
        checkBox.setState(true);
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BrowserFrame.this.setSnmpFeedback(e.getStateChange() == 1);
            }
        });
        menu.add(checkBox);
        this.menuBar.add(menu);
        menu = new Menu("Help");
        item = new MenuItem("License...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.showLicense();
            }
        });
        menu.add(item);
        if (!MacUIHelper.IS_MAC_OS) {
            item = new MenuItem("About...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowserFrame.this.showAbout();
                }
            });
            menu.add(item);
        }
        this.menuBar.add(menu);
        if (MacUIHelper.IS_MAC_OS) {
            MacUIHelper macUIHelper = new MacUIHelper(this);
        }
    }

    public void setBlocked(boolean blocked) {
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            this.menuBar.getMenu(i).setEnabled(!blocked);
        }
        this.snmpPanel.setBlocked(blocked);
    }

    protected void loadMib() {
        OpenDialog dialog = new OpenDialog(this, this.browser);
        dialog.setVisible(true);
        this.loadMibsAsync(dialog.mibs);
    }

    protected boolean loadMib(String src) {
        String message = null;
        this.setStatus("Loading " + src + "...");
        try {
            for (Mib mib : this.browser.loadMib(src)) {
                if (this.mibTree.getRootNode().findChildByValue(mib) != null) continue;
                this.mibTree.addTreeNodes(mib);
            }
        }
        catch (FileNotFoundException e) {
            message = "Failed to load " + e.getMessage();
        }
        catch (IOException e) {
            message = "Failed to load " + src + ": " + e.getMessage();
        }
        catch (MibLoaderException e) {
            message = "Failed to load " + src;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            e.getLog().printTo(new PrintStream(output));
            this.descriptionArea.append(output.toString());
        }
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "MIB Loading Error", 0);
        }
        this.setStatus(null);
        return message == null;
    }

    public void loadMibsAsync(String[] srcs) {
        if (srcs != null && srcs.length > 0) {
            this.descriptionArea.setText("");
            new Loader(srcs).start();
        }
    }

    protected void unloadMib() {
        Mib mib;
        MibTreeNode node = this.getSelectedNode();
        Mib mib2 = mib = node != null ? node.getMib() : null;
        if (mib != null) {
            this.browser.unloadMib(mib);
            this.mibTree.removeTreeNodes(mib);
            this.refreshTree(false);
        }
    }

    protected void unloadAllMibs() {
        this.browser.unloadAllMibs();
        this.mibTree.removeAllTreeNodes();
        this.refreshTree(false);
    }

    protected void refreshTree(boolean selectAdded) {
        for (int i = this.mibTree.getRowCount() - 1; i >= 0; --i) {
            this.mibTree.collapseRow(i);
        }
        int rows = this.mibTree.getRowCount();
        ((DefaultTreeModel)this.mibTree.getModel()).reload();
        this.mibTree.repaint();
        if (selectAdded && this.mibTree.getRowCount() > rows) {
            this.mibTree.setSelectionRow(rows);
        }
    }

    public void setSnmpVersion(int version) {
        this.snmpV1Item.setState(false);
        this.snmpV2Item.setState(false);
        this.snmpV3Item.setState(false);
        if (version == 1) {
            this.snmpV1Item.setState(true);
        } else if (version == 2) {
            this.snmpV2Item.setState(true);
        } else if (version == 3) {
            this.snmpV3Item.setState(true);
        }
        this.snmpPanel.setVersion(version);
    }

    public void setSnmpFeedback(boolean feedback) {
        this.snmpPanel.setFeedback(feedback);
    }

    public MibTreeNode getSelectedNode() {
        return (MibTreeNode)this.mibTree.getLastSelectedPathComponent();
    }

    public void setSelectedNode(String oid) {
        MibValueSymbol symbol = this.browser.findMibSymbol(oid);
        MibTreeNode node = this.mibTree.getTreeNode(symbol);
        if (node == null) {
            this.mibTree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.mibTree.expandPath(path);
        this.mibTree.scrollPathToVisible(path);
        this.mibTree.setSelectionPath(path);
        this.mibTree.repaint();
    }

    public void setStatus(String text) {
        if (text != null) {
            this.statusLabel.setText(text);
        } else {
            this.statusLabel.setText("Ready");
        }
    }

    protected void showAbout() {
        AboutDialog dialog = new AboutDialog(this, this.browser.getBuildInfo());
        dialog.setVisible(true);
    }

    protected void showLicense() {
        LicenseDialog dialog = new LicenseDialog(this);
        dialog.setVisible(true);
    }

    protected void quit() {
        System.exit(0);
    }

    protected void updateTreeSelection() {
        MibTreeNode node = this.getSelectedNode();
        if (node == null) {
            this.descriptionArea.setText("");
        } else {
            this.descriptionArea.setText(node.getDescription());
            this.descriptionArea.setCaretPosition(0);
        }
        this.snmpPanel.updateOid();
    }

    private class Loader
    implements Runnable {
        private String[] mibs;

        public Loader(String[] mibs) {
            this.mibs = mibs;
        }

        public void start() {
            if (this.mibs.length > 0) {
                new Thread(this).start();
            }
        }

        @Override
        public void run() {
            boolean success = true;
            BrowserFrame.this.setBlocked(true);
            for (int i = 0; i < this.mibs.length; ++i) {
                success = success && BrowserFrame.this.loadMib(this.mibs[i]);
            }
            BrowserFrame.this.refreshTree(success);
            BrowserFrame.this.setBlocked(false);
        }
    }
}

